/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.automapupdater.Config;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MapUpdateHandler {
    private int tickCounter = 0;
    private int mapsUpdatedThisCycle = 0;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!(event.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)event.player;
        if (!((Boolean)Config.ENABLED.get()).booleanValue()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= (Integer)Config.UPDATE_INTERVAL.get()) {
            this.tickCounter = 0;
            this.mapsUpdatedThisCycle = 0;
            if (serverPlayer.m_150109_() == null) {
                return;
            }
            ServerLevel level = serverPlayer.m_9236_();
            for (ItemStack stack : serverPlayer.m_150109_().f_35974_) {
                MapItemSavedData mapData;
                Integer mapId;
                if (this.mapsUpdatedThisCycle >= (Integer)Config.MAX_MAPS_PER_UPDATE.get()) break;
                if (!stack.m_150930_(Items.f_42573_) || (mapId = MapItem.m_151131_((ItemStack)stack)) == null || (mapData = MapItem.m_42853_((ItemStack)stack, (Level)level)) == null) continue;
                mapData.m_77918_((Player)serverPlayer, stack);
                ++this.mapsUpdatedThisCycle;
                if (!((Boolean)Config.DEBUG_MODE.get()).booleanValue()) continue;
                AutoMapUpdater.LOGGER.info("Updated map " + mapId + " for player " + serverPlayer.m_7755_().getString());
            }
            if (((Boolean)Config.DEBUG_MODE.get()).booleanValue() && this.mapsUpdatedThisCycle > 0) {
                AutoMapUpdater.LOGGER.info("Updated " + this.mapsUpdatedThisCycle + " maps this cycle");
            }
        }
    }
}

