/*
 * Decompiled with CFR 0.152.
 */
package com.automapupdater;

import com.automapupdater.AutoMapUpdater;
import com.automapupdater.Config;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MapUpdateHandler {
    private int tickCounter = 0;
    private int mapsUpdatedThisCycle = 0;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (serverPlayer.m_9236_() == null || serverPlayer.m_213877_()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < (Integer)Config.UPDATE_INTERVAL.get()) {
            return;
        }
        this.tickCounter = 0;
        this.mapsUpdatedThisCycle = 0;
        try {
            this.updatePlayerMaps(serverPlayer);
        }
        catch (Exception e) {
            AutoMapUpdater.LOGGER.error("Error updating maps for player " + serverPlayer.m_7755_().getString(), (Throwable)e);
        }
    }

    private void updatePlayerMaps(ServerPlayer player) {
        ServerLevel level = player.m_284548_();
        if (level == null || player.m_150109_() == null) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (this.mapsUpdatedThisCycle >= (Integer)Config.MAX_MAPS_PER_UPDATE.get()) break;
            this.updateMapIfNeeded(stack, player, level);
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            if (this.mapsUpdatedThisCycle >= (Integer)Config.MAX_MAPS_PER_UPDATE.get()) break;
            this.updateMapIfNeeded(stack, player, level);
        }
    }

    private void updateMapIfNeeded(ItemStack stack, ServerPlayer player, ServerLevel level) {
        block8: {
            if (stack == null || stack.m_41619_()) {
                return;
            }
            if (!stack.m_150930_(Items.f_42573_)) {
                return;
            }
            try {
                Integer mapId = MapItem.m_151131_((ItemStack)stack);
                if (mapId == null) {
                    return;
                }
                MapItemSavedData mapData = level.m_7489_(MapItem.m_42848_((int)mapId));
                if (mapData == null) {
                    return;
                }
                if (mapData.f_77892_) {
                    return;
                }
                if (mapData.f_77887_ != level.m_46472_()) {
                    return;
                }
                mapData.m_77918_((Player)player, stack);
                ++this.mapsUpdatedThisCycle;
            }
            catch (Exception e) {
                if (!((Boolean)Config.DEBUG_MODE.get()).booleanValue()) break block8;
                AutoMapUpdater.LOGGER.warn("Failed to update map item", (Throwable)e);
            }
        }
    }
}

