/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axwhitelist;

import dev.akatriggered.g1axwhitelist.commands.CheckTierCommand;
import dev.akatriggered.g1axwhitelist.commands.ReloadCommand;
import dev.akatriggered.g1axwhitelist.database.DatabaseManager;
import dev.akatriggered.g1axwhitelist.features.TierPlaceholder;
import dev.akatriggered.g1axwhitelist.listeners.PlayerJoinListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class G1axWhitelistPlugin
extends JavaPlugin {
    private DatabaseManager databaseManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.databaseManager = new DatabaseManager(this.getDataFolder());
        try {
            this.databaseManager.connect();
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to connect to database: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getCommand("checktier").setExecutor((CommandExecutor)new CheckTierCommand(this));
        this.getCommand("g1axreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new TierPlaceholder().register();
            this.getLogger().info("PlaceholderAPI integration enabled!");
        }
        this.getLogger().info("\u00a7a  \u2588\u2588\u2588\u2588\u2588\u2588\u2557  \u2588\u2588\u2557 \u2588\u2588\u2588\u2588\u2588\u2557 \u2588\u2588\u2557  \u2588\u2588\u2557");
        this.getLogger().info("\u00a7a \u2588\u2588\u2554\u2550\u2550\u2550\u2550\u255d \u2588\u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2557\u255a\u2588\u2588\u2557\u2588\u2588\u2554\u255d");
        this.getLogger().info("\u00a7a \u2588\u2588\u2551  \u2588\u2588\u2588\u2557\u255a\u2588\u2588\u2551\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2551 \u255a\u2588\u2588\u2588\u2554\u255d ");
        this.getLogger().info("\u00a7a \u2588\u2588\u2551   \u2588\u2588\u2551 \u2588\u2588\u2551\u2588\u2588\u2554\u2550\u2550\u2588\u2588\u2551 \u2588\u2588\u2554\u2588\u2588\u2557 ");
        this.getLogger().info("\u00a7a \u255a\u2588\u2588\u2588\u2588\u2588\u2588\u2554\u255d \u2588\u2588\u2551\u2588\u2588\u2551  \u2588\u2588\u2551\u2588\u2588\u2554\u255d \u2588\u2588\u2557");
        this.getLogger().info("\u00a7a  \u255a\u2550\u2550\u2550\u2550\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d  \u255a\u2550\u255d");
        this.getLogger().info("\u00a7b    G1ax Auto-Whitelist v1.0.0 - MCTiers + PVPTiers");
        this.getLogger().info("\u00a72    Plugin loaded successfully!");
    }

    public void onDisable() {
        if (this.databaseManager != null) {
            try {
                this.databaseManager.disconnect();
            }
            catch (Exception e) {
                this.getLogger().warning("Error disconnecting from database: " + e.getMessage());
            }
        }
        this.getLogger().info("G1axWhitelist has been disabled!");
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }
}

