/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axwhitelist.commands;

import dev.akatriggered.g1axwhitelist.G1axWhitelistPlugin;
import dev.akatriggered.g1axwhitelist.utils.EligibilityChecker;
import dev.akatriggered.g1axwhitelist.utils.TierUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CheckTierCommand
implements CommandExecutor {
    private final G1axWhitelistPlugin plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public CheckTierCommand(G1axWhitelistPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("g1axwhitelist.check")) {
            Component message = this.miniMessage.deserialize((Object)"<red>You don't have permission to use this command!");
            sender.sendMessage(message);
            return true;
        }
        if (args.length != 1) {
            Component message = this.miniMessage.deserialize((Object)"<red>Usage: /checktier <username>");
            sender.sendMessage(message);
            return true;
        }
        String username = args[0];
        Component loadingMessage = this.miniMessage.deserialize((Object)("<yellow>Checking tier for " + username + "..."));
        sender.sendMessage(loadingMessage);
        TierUtils.requestFromBothAPIs(username).thenAccept(result -> this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            boolean eligible = EligibilityChecker.isEligible(result, this.plugin.getConfig());
            String statusColor = eligible ? "#00ff00" : "#ff0000";
            String statusText = eligible ? "ELIGIBLE" : "NOT ELIGIBLE";
            Component mcTierMsg = this.miniMessage.deserialize((Object)("<gradient:#00ff00:#00aa00>[G1ax]</gradient> <yellow>MCTiers:</yellow> <color:" + result.getMcTier().getColor() + ">" + result.getMcTier().getName() + "</color>"));
            Component pvpTierMsg = this.miniMessage.deserialize((Object)("<gradient:#00ff00:#00aa00>[G1ax]</gradient> <yellow>PVPTiers:</yellow> <color:" + result.getPvpTier().getColor() + ">" + result.getPvpTier().getName() + "</color>"));
            Component statusMsg = this.miniMessage.deserialize((Object)("<gradient:#00ff00:#00aa00>[G1ax]</gradient> <white>Best: <color:" + result.getBestTier().getColor() + ">" + result.getBestTier().getName() + "</color> | Status: <color:" + statusColor + ">" + statusText + "</color>"));
            sender.sendMessage(mcTierMsg);
            sender.sendMessage(pvpTierMsg);
            sender.sendMessage(statusMsg);
        }));
        return true;
    }
}

