/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axwhitelist.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseManager {
    private Connection connection;
    private final File dbFile;

    public DatabaseManager(File dataFolder) {
        this.dbFile = new File(dataFolder, "autowhitelisted.db");
    }

    public void connect() throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
        this.createTable();
    }

    public void disconnect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    private void createTable() throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS autowhitelisted (uuid TEXT PRIMARY KEY, username TEXT NOT NULL, tier TEXT NOT NULL, whitelisted_at INTEGER NOT NULL)";
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(sql);
        }
    }

    public void addPlayer(String uuid, String username, String tier) throws SQLException {
        String sql = "INSERT OR REPLACE INTO autowhitelisted (uuid, username, tier, whitelisted_at) VALUES (?, ?, ?, ?)";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            stmt.setString(1, uuid);
            stmt.setString(2, username);
            stmt.setString(3, tier);
            stmt.setLong(4, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
    }

    public boolean isAutoWhitelisted(String uuid) throws SQLException {
        String sql = "SELECT 1 FROM autowhitelisted WHERE uuid = ?";
        try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
            boolean bl;
            block12: {
                stmt.setString(1, uuid);
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

