/*
 * Decompiled with CFR 0.152.
 */
package dev.akatriggered.g1axwhitelist.utils;

import dev.akatriggered.g1axwhitelist.utils.TierUtils;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class EligibilityChecker {
    public static EligibilityResult checkEligibility(TierUtils.TierResult result, FileConfiguration config) {
        boolean pvpEligible;
        List allowedTiers = config.getStringList("eligibility.allowed-tiers");
        if (result.getMcTier() == TierUtils.Tier.UNRANKED && result.getPvpTier() == TierUtils.Tier.UNRANKED) {
            return new EligibilityResult(false, "NO_DATA");
        }
        if (!allowedTiers.isEmpty()) {
            boolean mcAllowed = allowedTiers.contains(result.getMcTier().getName());
            boolean pvpAllowed = allowedTiers.contains(result.getPvpTier().getName());
            if (!mcAllowed && !pvpAllowed) {
                return new EligibilityResult(false, "NOT_ALLOWED");
            }
            return new EligibilityResult(true, "ALLOWED");
        }
        int mcMin = config.getInt("eligibility.mctiers-minimum", 0);
        int pvpMin = config.getInt("eligibility.pvptiers-minimum", 0);
        boolean requireBoth = config.getBoolean("eligibility.require-both", false);
        boolean mcEligible = mcMin == 0 || result.getMcTier().getValue() >= mcMin;
        boolean bl = pvpEligible = pvpMin == 0 || result.getPvpTier().getValue() >= pvpMin;
        if (requireBoth) {
            if (mcEligible && pvpEligible) {
                return new EligibilityResult(true, "BOTH_MET");
            }
            return new EligibilityResult(false, "REQUIRE_BOTH");
        }
        if (mcEligible || pvpEligible) {
            return new EligibilityResult(true, "MINIMUM_MET");
        }
        return new EligibilityResult(false, "INSUFFICIENT");
    }

    public static boolean isEligible(TierUtils.TierResult result, FileConfiguration config) {
        return EligibilityChecker.checkEligibility(result, config).isEligible();
    }

    public static class EligibilityResult {
        private final boolean eligible;
        private final String reason;

        public EligibilityResult(boolean eligible, String reason) {
            this.eligible = eligible;
            this.reason = reason;
        }

        public boolean isEligible() {
            return this.eligible;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

