/*
 * Decompiled with CFR 0.152.
 */
package me.felisteam.hide;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.felisteam.hide.HidePlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class HideCommand
implements CommandExecutor,
TabCompleter {
    private final HidePlugin plugin;

    public HideCommand(HidePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String message;
        String seePermission;
        boolean isHideLive = command.getName().equalsIgnoreCase("hideLive");
        String permission = isHideLive ? "hideLive.use" : "hide.use";
        String string = seePermission = isHideLive ? "hideLive.see" : "hide.see";
        if (!sender.hasPermission(permission)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u0423 \u0442\u0435\u0431\u044f \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!");
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /" + label + " <\u0438\u0433\u0440\u043e\u043a>");
            return true;
        }
        String playerName = args[0];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        UUID targetUUID = target.getUniqueId();
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "\u0418\u0433\u0440\u043e\u043a " + playerName + " \u043d\u0438\u043a\u043e\u0433\u0434\u0430 \u043d\u0435 \u0438\u0433\u0440\u0430\u043b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435!");
            return true;
        }
        Set<UUID> targetList = isHideLive ? this.plugin.getHiddenLivePlayers() : this.plugin.getHiddenPlayers();
        String action = targetList.contains(targetUUID) ? "\u0442\u0435\u043f\u0435\u0440\u044c \u0432\u0438\u0434\u0435\u043d" : "\u0441\u043a\u0440\u044b\u0442";
        String string2 = message = isHideLive ? "\u0432\u043a\u043b\u044e\u0447\u0430\u044f nametag" : "\u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445 \u0438 \u0447\u0430\u0442\u0435";
        if (targetList.contains(targetUUID)) {
            targetList.remove(targetUUID);
            this.plugin.saveHiddenPlayers();
            if (target.isOnline()) {
                Scoreboard scoreboard;
                Team team;
                Player targetPlayer = target.getPlayer();
                if (!isHideLive) {
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (online.hasPermission(seePermission)) continue;
                        online.showPlayer((Plugin)this.plugin, targetPlayer);
                    }
                }
                if (isHideLive && (team = (scoreboard = Bukkit.getScoreboardManager().getMainScoreboard()).getEntryTeam(targetPlayer.getName())) != null && team.getName().equals("hideLiveTeam")) {
                    team.removeEntry(targetPlayer.getName());
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u0418\u0433\u0440\u043e\u043a " + playerName + " " + action + " " + message + ".");
            if (target.isOnline()) {
                target.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "\u0422\u0432\u043e\u0439 \u043d\u0438\u043a " + action + " " + message + ".");
            }
        } else {
            targetList.add(targetUUID);
            this.plugin.saveHiddenPlayers();
            if (target.isOnline()) {
                Player targetPlayer = target.getPlayer();
                if (!isHideLive) {
                    for (Player online : Bukkit.getOnlinePlayers()) {
                        if (online.hasPermission(seePermission)) continue;
                        online.hidePlayer((Plugin)this.plugin, targetPlayer);
                    }
                }
                if (isHideLive) {
                    Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                    Team team = scoreboard.getTeam("hideLiveTeam");
                    if (team == null) {
                        team = scoreboard.registerNewTeam("hideLiveTeam");
                        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                    }
                    team.addEntry(targetPlayer.getName());
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "\u0418\u0433\u0440\u043e\u043a " + playerName + " " + action + " " + message + ".");
            if (target.isOnline()) {
                target.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "\u0422\u0432\u043e\u0439 \u043d\u0438\u043a " + action + " " + message + ".");
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        boolean isHideLive = command.getName().equalsIgnoreCase("hideLive");
        String permission = isHideLive ? "hideLive.see" : "hide.see";
        if (!sender.hasPermission(isHideLive ? "hideLive.use" : "hide.use")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                if (player.getName() == null || !player.getName().toLowerCase().startsWith(args[0].toLowerCase()) || !sender.hasPermission(permission) && (isHideLive ? this.plugin.getHiddenLivePlayers() : this.plugin.getHiddenPlayers()).contains(player.getUniqueId())) continue;
                completions.add(player.getName());
            }
            return completions;
        }
        return new ArrayList<String>();
    }
}

