/*
 * Decompiled with CFR 0.152.
 */
package me.felisteam.hide;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.felisteam.hide.HideCommand;
import me.felisteam.hide.PlayerHideListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HidePlugin
extends JavaPlugin {
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final Set<UUID> hiddenLivePlayers = new HashSet<UUID>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadHiddenPlayers();
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") == null) {
            this.getLogger().severe("ProtocolLib \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u041a\u043e\u043c\u0430\u043d\u0434\u0430 /hideLive \u0442\u0440\u0435\u0431\u0443\u0435\u0442 ProtocolLib \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Hide \u0432\u043a\u043b\u044e\u0447\u0451\u043d! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 /hide \u0438\u043b\u0438 /hideLive <\u0438\u0433\u0440\u043e\u043a> \u0434\u043b\u044f \u0441\u043a\u0440\u044b\u0442\u0438\u044f \u043d\u0438\u043a\u0430.");
        HideCommand command = new HideCommand(this);
        this.getCommand("hide").setExecutor((CommandExecutor)command);
        this.getCommand("hide").setTabCompleter((TabCompleter)command);
        this.getCommand("hideLive").setExecutor((CommandExecutor)command);
        this.getCommand("hideLive").setTabCompleter((TabCompleter)command);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerHideListener(this), (Plugin)this);
        this.setupProtocolLib();
    }

    public void onDisable() {
        this.saveHiddenPlayers();
        this.getLogger().info("Hide \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d.");
    }

    public Set<UUID> getHiddenPlayers() {
        return this.hiddenPlayers;
    }

    public Set<UUID> getHiddenLivePlayers() {
        return this.hiddenLivePlayers;
    }

    private void loadHiddenPlayers() {
        FileConfiguration config = this.getConfig();
        List hiddenList = config.getStringList("hidden-players");
        for (String uuid : hiddenList) {
            try {
                this.hiddenPlayers.add(UUID.fromString(uuid));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 UUID \u0432 config.yml (hidden-players): " + uuid);
            }
        }
        List hiddenLiveList = config.getStringList("hidden-live-players");
        for (String uuid : hiddenLiveList) {
            try {
                this.hiddenLivePlayers.add(UUID.fromString(uuid));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 UUID \u0432 config.yml (hidden-live-players): " + uuid);
            }
        }
    }

    public void saveHiddenPlayers() {
        FileConfiguration config = this.getConfig();
        config.set("hidden-players", this.hiddenPlayers.stream().map(UUID::toString).toList());
        config.set("hidden-live-players", this.hiddenLivePlayers.stream().map(UUID::toString).toList());
        this.saveConfig();
    }

    private void setupProtocolLib() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this, new PacketType[]{PacketType.Play.Server.PLAYER_INFO}){

            public void onPacketSending(PacketEvent event) {
                Player receiver = event.getPlayer();
                if (receiver.hasPermission("hideLive.see")) {
                    HidePlugin.this.getLogger().log(Level.FINE, "Player {0} has hideLive.see, skipping TabList filter", receiver.getName());
                    return;
                }
                List playerInfoDataList = (List)event.getPacket().getPlayerInfoDataLists().read(0);
                playerInfoDataList.removeIf(data -> {
                    UUID uuid = data.getProfile().getUUID();
                    boolean isHidden = HidePlugin.this.hiddenLivePlayers.contains(uuid);
                    if (isHidden) {
                        HidePlugin.this.getLogger().log(Level.FINE, "Removing player {0} from TabList for {1}", new Object[]{uuid, receiver.getName()});
                    }
                    return isHidden;
                });
                event.getPacket().getPlayerInfoDataLists().write(0, (Object)playerInfoDataList);
            }
        });
    }
}

