/*
 * Decompiled with CFR 0.152.
 */
package me.felisteam.hide;

import me.felisteam.hide.HidePlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PlayerHideListener
implements Listener {
    private final HidePlugin plugin;

    public PlayerHideListener(HidePlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        boolean isHidden = this.plugin.getHiddenPlayers().contains(player.getUniqueId());
        boolean isHiddenLive = this.plugin.getHiddenLivePlayers().contains(player.getUniqueId());
        if (isHidden || isHiddenLive) {
            event.setJoinMessage(null);
            if (isHidden) {
                for (Player online : Bukkit.getOnlinePlayers()) {
                    if (online.hasPermission("hide.see")) continue;
                    online.hidePlayer((Plugin)this.plugin, player);
                }
            }
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!this.plugin.getHiddenPlayers().contains(online.getUniqueId()) || player.hasPermission("hide.see")) continue;
            player.hidePlayer((Plugin)this.plugin, online);
        }
        if (isHiddenLive) {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team team = scoreboard.getTeam("hideLiveTeam");
            if (team == null) {
                team = scoreboard.registerNewTeam("hideLiveTeam");
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            }
            team.addEntry(player.getName());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.getHiddenPlayers().contains(event.getPlayer().getUniqueId()) || this.plugin.getHiddenLivePlayers().contains(event.getPlayer().getUniqueId())) {
            event.setQuitMessage(null);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getHiddenPlayers().contains(player.getUniqueId())) {
            event.getRecipients().removeIf(p -> !p.hasPermission("hide.see"));
        }
        if (this.plugin.getHiddenLivePlayers().contains(player.getUniqueId())) {
            event.getRecipients().removeIf(p -> !p.hasPermission("hideLive.see"));
            event.setFormat("%1$s: %2$s");
            for (Player recipient : event.getRecipients()) {
                if (recipient.hasPermission("hideLive.see")) continue;
                String message = event.getMessage();
                String formatted = String.format("%s: %s", "???", message);
                recipient.sendMessage(formatted);
                event.getRecipients().remove(recipient);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTabComplete(TabCompleteEvent event) {
        CommandSender commandSender = event.getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (!player.hasPermission("hide.see")) {
                event.getCompletions().removeIf(completion -> {
                    OfflinePlayer target = Bukkit.getOfflinePlayer((String)completion);
                    return this.plugin.getHiddenPlayers().contains(target.getUniqueId());
                });
            }
            if (!player.hasPermission("hideLive.see")) {
                event.getCompletions().removeIf(completion -> {
                    OfflinePlayer target = Bukkit.getOfflinePlayer((String)completion);
                    return this.plugin.getHiddenLivePlayers().contains(target.getUniqueId());
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage().toLowerCase();
        if (message.startsWith("/list") || message.startsWith("/who") || message.startsWith("/online")) {
            StringBuilder hiddenList = new StringBuilder();
            int visibleCount = 0;
            for (Player online : Bukkit.getOnlinePlayers()) {
                boolean isHiddenLive;
                boolean isHidden = this.plugin.getHiddenPlayers().contains(online.getUniqueId()) && !player.hasPermission("hide.see");
                boolean bl = isHiddenLive = this.plugin.getHiddenLivePlayers().contains(online.getUniqueId()) && !player.hasPermission("hideLive.see");
                if (isHidden || isHiddenLive) continue;
                if (hiddenList.length() > 0) {
                    hiddenList.append(", ");
                }
                hiddenList.append(online.getName());
                ++visibleCount;
            }
            if (visibleCount == 0) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u041e\u043d\u043b\u0430\u0439\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u0432: 0");
            } else {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "\u041e\u043d\u043b\u0430\u0439\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u0432: " + visibleCount + ": " + String.valueOf(hiddenList));
            }
            event.setCancelled(true);
        }
    }
}

