/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.shieldstun.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.libreh.shieldstun.ShieldStun;
import me.libreh.shieldstun.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_NAME = "shieldstun.json";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("shieldstun.json");
    private static Config CONFIG;

    public static boolean loadConfig() {
        boolean success;
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            File configFile = CONFIG_PATH.toFile();
            Config config = configFile.exists() ? (Config)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8), Config.class) : new Config();
            CONFIG = config;
            ConfigManager.saveConfig();
            success = true;
        }
        catch (Exception e) {
            success = false;
            CONFIG = oldConfig;
            ShieldStun.LOGGER.error("Failed to read config shieldstun.json", (Throwable)e);
        }
        return success;
    }

    public static void saveConfig() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)CONFIG), new OpenOption[0]);
        }
        catch (Exception exception) {
            ShieldStun.LOGGER.error("Failed to save config shieldstun.json", (Throwable)exception);
        }
    }

    public static Config getConfig() {
        if (CONFIG == null) {
            return new Config();
        }
        return CONFIG;
    }
}

