/*
 * Decompiled with CFR 0.152.
 */
package org.cristal.cmmeadditions.data;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import org.cristal.cmmeadditions.api.CmmeMaterialFlags;
import org.cristal.cmmeadditions.api.CmmeTagPrefix;
import org.jetbrains.annotations.NotNull;

public final class CmmeRecipes {
    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        CmmeRecipes.processPlateDoubleAddition(provider, material);
        CmmeRecipes.processPlateTriple(provider, material);
        CmmeRecipes.processPlateQuadruple(provider, material);
        CmmeRecipes.processPlateQuintuple(provider, material);
        CmmeRecipes.processPlateSuperdense(provider, material);
        CmmeRecipes.processIngotDouble(provider, material);
        CmmeRecipes.processIngotTriple(provider, material);
        CmmeRecipes.processIngotQuadruple(provider, material);
        CmmeRecipes.processIngotQuintuple(provider, material);
    }

    private static void processPlateDoubleAddition(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.plateDouble) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(CmmeMaterialFlags.GENERATE_DOUBLE_INGOT)) {
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_double_ingot_to_double_plate").EUt(96L).duration((int)material.getMass() * 2).inputItems(CmmeTagPrefix.doubleIngot, material).outputItems(TagPrefix.plateDouble, magMaterial).circuitMeta(1).save(provider);
        }
    }

    private static void processPlateTriple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.triplePlate) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("plate_triple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.triplePlate, (Material)magMaterial), (Object[])new Object[]{"h", "P", "D", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('D'), new MaterialEntry(TagPrefix.plateDouble, material)});
            }
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_triple_plate").EUt(96L).duration((int)material.getMass() * 3).inputItems(TagPrefix.plate, material, 3).outputItems(CmmeTagPrefix.triplePlate, magMaterial).circuitMeta(3).save(provider);
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_triple_plate").inputItems(TagPrefix.ingot, material, 3).circuitMeta(3).outputItems(CmmeTagPrefix.triplePlate, magMaterial).duration((int)material.getMass() * 3).EUt(96L).save(provider);
            if (material.hasFlag(CmmeMaterialFlags.GENERATE_TRIPLE_INGOT)) {
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_triple_ingot_to_triple_plate").EUt(96L).duration((int)material.getMass() * 3).inputItems(CmmeTagPrefix.tripleIngot, material).outputItems(CmmeTagPrefix.triplePlate, magMaterial).circuitMeta(1).save(provider);
            }
        }
    }

    private static void processPlateQuadruple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.quadruplePlate) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("plates_quadruple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quadruplePlate, (Material)magMaterial), (Object[])new Object[]{"h", "P", "D", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.triplePlate, material)});
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("double_plates_quadruple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quadruplePlate, (Material)magMaterial), (Object[])new Object[]{"h", "P", "P", Character.valueOf('P'), new MaterialEntry(TagPrefix.plateDouble, material)});
            }
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_quadruple_plate").EUt(96L).duration((int)material.getMass() * 4).inputItems(TagPrefix.plate, material, 4).outputItems(CmmeTagPrefix.quadruplePlate, magMaterial).circuitMeta(4).save(provider);
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_quadruple_plate").inputItems(TagPrefix.ingot, material, 4).circuitMeta(4).outputItems(CmmeTagPrefix.quadruplePlate, magMaterial).duration((int)material.getMass() * 4).EUt(96L).save(provider);
            if (material.hasFlag(CmmeMaterialFlags.GENERATE_QUADRUPLE_PLATE)) {
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_quadruple_ingot_to_quadruple_plate").EUt(96L).duration((int)material.getMass() * 4).inputItems(CmmeTagPrefix.quadrupleIngot, material).outputItems(CmmeTagPrefix.quadruplePlate, magMaterial).circuitMeta(1).save(provider);
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_double_ingots_to_quadruple_plate").EUt(96L).duration((int)material.getMass() * 4).inputItems(CmmeTagPrefix.doubleIngot, material, 2).outputItems(CmmeTagPrefix.quadruplePlate, magMaterial).circuitMeta(2).save(provider);
            }
        }
    }

    private static void processPlateQuintuple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.quintuplePlate) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("plates_quintuple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quintuplePlate, (Material)magMaterial), (Object[])new Object[]{"h", "P", "D", Character.valueOf('P'), new MaterialEntry(TagPrefix.plate, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.quadruplePlate, material)});
                VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("double_plates_quintuple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quintuplePlate, (Material)magMaterial), (Object[])new Object[]{"h", "P", "D", Character.valueOf('P'), new MaterialEntry(TagPrefix.plateDouble, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.triplePlate, material)});
            }
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_quintuple_plate").EUt(96L).duration((int)material.getMass() * 5).inputItems(TagPrefix.plate, material, 5).outputItems(CmmeTagPrefix.quintuplePlate, magMaterial).circuitMeta(5).save(provider);
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_quintuple_plate").inputItems(TagPrefix.ingot, material, 5).circuitMeta(5).outputItems(CmmeTagPrefix.quintuplePlate, magMaterial).duration((int)material.getMass() * 5).EUt(96L).save(provider);
            if (material.hasFlag(CmmeMaterialFlags.GENERATE_QUINTUPLE_PLATE)) {
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_quintuple_ingot_to_quintuple_plate").EUt(96L).duration((int)material.getMass() * 5).inputItems(CmmeTagPrefix.quintupleIngot, material).outputItems(CmmeTagPrefix.quintuplePlate, magMaterial).circuitMeta(1).save(provider);
            }
        }
    }

    private static void processPlateSuperdense(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.superdensePlate) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        Material magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) && material.hasProperty(PropertyKey.INGOT) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_plate_to_superdense_plate").inputItems(TagPrefix.plate, material, 64).circuitMeta(6).outputItems(CmmeTagPrefix.superdensePlate, magMaterial).duration((int)Math.max(material.getMass() * 64L, 1L)).EUt(96L).save(provider);
        if (material.hasProperty(PropertyKey.INGOT)) {
            GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_superdense_plate").inputItems(TagPrefix.ingot, material, 64).circuitMeta(6).outputItems(CmmeTagPrefix.superdensePlate, magMaterial).duration((int)Math.max(material.getMass() * 64L, 1L)).EUt(96L).save(provider);
        }
    }

    private static void processIngotDouble(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.doubleIngot) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("ingot_double_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.doubleIngot, (Material)magMaterial), (Object[])new Object[]{"P", "P", "h", Character.valueOf('P'), new MaterialEntry(TagPrefix.ingot, material)});
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_double_ingot").inputItems(TagPrefix.ingot, material, 2).circuitMeta(16).outputItems(CmmeTagPrefix.doubleIngot, magMaterial).duration((int)material.getMass() * 2).EUt(96L).save(provider);
    }

    private static void processIngotTriple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.tripleIngot) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("ingot_triple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.tripleIngot, (Material)magMaterial), (Object[])new Object[]{"D", "P", "h", Character.valueOf('P'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.doubleIngot, material)});
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_triple_ingot").inputItems(TagPrefix.ingot, material, 3).circuitMeta(17).outputItems(CmmeTagPrefix.tripleIngot, magMaterial).duration((int)material.getMass() * 3).EUt(96L).save(provider);
    }

    private static void processIngotQuadruple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.quadrupleIngot) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("ingot_quadruple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quadrupleIngot, (Material)magMaterial), (Object[])new Object[]{"D", "P", "h", Character.valueOf('P'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.tripleIngot, material)});
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("double_ingots_quadruple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quadrupleIngot, (Material)magMaterial), (Object[])new Object[]{"P", "P", "h", Character.valueOf('P'), new MaterialEntry(CmmeTagPrefix.doubleIngot, material)});
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_quadruple_ingot").inputItems(TagPrefix.ingot, material, 4).circuitMeta(18).outputItems(CmmeTagPrefix.quadrupleIngot, magMaterial).duration((int)material.getMass() * 4).EUt(96L).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_double_ingots_to_quadruple_ingot").inputItems(CmmeTagPrefix.doubleIngot, material, 2).circuitMeta(16).outputItems(CmmeTagPrefix.quadrupleIngot, magMaterial).duration((int)material.getMass() * 4).EUt(96L).save(provider);
    }

    private static void processIngotQuintuple(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(CmmeTagPrefix.quintupleIngot) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? ((IngotProperty)material.getProperty(PropertyKey.INGOT)).getMacerateInto() : material;
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("ingot_quintuple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quintupleIngot, (Material)magMaterial), (Object[])new Object[]{"D", "P", "h", Character.valueOf('P'), new MaterialEntry(TagPrefix.ingot, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.quadrupleIngot, material)});
            VanillaRecipeHelper.addShapedRecipe(provider, (String)String.format("double_ingots_quintuple_%s", material.getName()), (ItemStack)ChemicalHelper.get((TagPrefix)CmmeTagPrefix.quintupleIngot, (Material)magMaterial), (Object[])new Object[]{"D", "P", "h", Character.valueOf('P'), new MaterialEntry(CmmeTagPrefix.doubleIngot, material), Character.valueOf('D'), new MaterialEntry(CmmeTagPrefix.tripleIngot, material)});
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_ingot_to_quintuple_ingot").inputItems(TagPrefix.ingot, material, 5).circuitMeta(19).outputItems(CmmeTagPrefix.quintupleIngot, magMaterial).duration((int)material.getMass() * 5).EUt(96L).save(provider);
    }
}

