/*
 * Decompiled with CFR 0.152.
 */
package me.felixsoftwind.usebuttonharvest;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UseButtonHarvestPlugin
extends JavaPlugin
implements Listener {
    private boolean requireSneak;
    private boolean allFarmlandCrops;
    private final Map<Material, CropRule> extraRules = new EnumMap<Material, CropRule>(Material.class);
    private static final Set<Material> VERTICAL_BASE_TYPES = EnumSet.of(Material.SUGAR_CANE);

    private static Material normalize(Material material) {
        if (material == Material.KELP_PLANT) {
            return Material.KELP;
        }
        return material;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("\ud83c\udf3e UseButtonHarvest enabled. require_sneak=" + this.requireSneak + ", all_farmland_crops=" + this.allFarmlandCrops + ", other_crops=" + String.valueOf(this.extraRules));
    }

    private void loadConfigValues() {
        this.requireSneak = this.getConfig().getBoolean("require_sneak", false);
        this.allFarmlandCrops = this.getConfig().getBoolean("all_farmland_crops", true);
        this.extraRules.clear();
        List list = this.getConfig().getMapList("other_crops");
        for (Map map : list) {
            Object object;
            Object v = map.get("type");
            if (!(v instanceof String)) {
                this.getLogger().warning("Skipped an 'other_crops' entry: missing 'type'");
                continue;
            }
            String string = (String)v;
            Material material = null;
            try {
                material = Material.valueOf((String)string.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    object = NamespacedKey.fromString((String)string.toLowerCase(Locale.ROOT));
                    if (object != null) {
                        material = Material.matchMaterial((String)object.getKey());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (material == null) {
                this.getLogger().warning("Unknown material in 'other_crops': " + string);
                continue;
            }
            boolean bl = false;
            object = map.get("leave_base");
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
            CropRule cropRule = new CropRule(material, bl);
            this.extraRules.put(UseButtonHarvestPlugin.normalize(material), cropRule);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onUse(PlayerInteractEvent playerInteractEvent) {
        ItemStack itemStack;
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (playerInteractEvent.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (this.requireSneak && !player.isSneaking()) {
            return;
        }
        if (UseButtonHarvestPlugin.normalize(block.getType()) == Material.SUGAR_CANE && (itemStack = player.getInventory().getItemInMainHand()) != null && itemStack.getType() == Material.SUGAR_CANE) {
            return;
        }
        if (this.allFarmlandCrops && this.isMatureAgeable(block) && (itemStack = block.getRelative(0, -1, 0)).getType() == Material.FARMLAND) {
            playerInteractEvent.setCancelled(true);
            this.breakOneBlockAsPlayer(player, block);
            return;
        }
        itemStack = UseButtonHarvestPlugin.normalize(block.getType());
        CropRule cropRule = this.extraRules.get(itemStack);
        if (cropRule == null) {
            return;
        }
        playerInteractEvent.setCancelled(true);
        if (VERTICAL_BASE_TYPES.contains(itemStack)) {
            this.breakVerticalColumn(player, block, (Material)itemStack, cropRule.leaveBase());
            return;
        }
        if (this.isMatureAgeable(block)) {
            Block block2;
            if (itemStack == Material.NETHER_WART && (block2 = block.getRelative(0, -1, 0)).getType() != Material.SOUL_SAND) {
                return;
            }
            this.breakOneBlockAsPlayer(player, block);
        }
    }

    private boolean isMatureAgeable(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Ageable)) {
            return false;
        }
        Ageable ageable = (Ageable)blockData;
        return ageable.getAge() >= ageable.getMaximumAge();
    }

    private void breakOneBlockAsPlayer(Player player, Block block) {
        boolean bl = false;
        try {
            if (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
                bl = player.breakBlock(block);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bl) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            try {
                block.breakNaturally(itemStack, true);
            }
            catch (Throwable throwable) {
                block.breakNaturally(itemStack);
            }
        }
    }

    private void breakVerticalColumn(Player player, Block block, Material material, boolean bl) {
        Material material2 = UseButtonHarvestPlugin.normalize(block.getType());
        boolean bl2 = block.getRelative(0, -1, 0).getType() != block.getType();
        Block block2 = block;
        if (bl && bl2) {
            block2 = block.getRelative(0, 1, 0);
        }
        while (this.isSameVerticalType(block2.getType(), material2)) {
            this.breakOneBlockAsPlayer(player, block2);
            block2 = block2.getRelative(0, 1, 0);
        }
    }

    private boolean isSameVerticalType(Material material, Material material2) {
        if (material2 == Material.KELP) {
            return material == Material.KELP || material == Material.KELP_PLANT;
        }
        return UseButtonHarvestPlugin.normalize(material) == material2;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!command.getName().equalsIgnoreCase("ubh")) {
            return false;
        }
        this.reloadConfig();
        try {
            this.loadConfigValues();
            commandSender.sendMessage("\u00a7aUseButtonHarvest: config reloaded.");
        }
        catch (Exception exception) {
            this.getLogger().log(Level.SEVERE, "Error while parsing config", exception);
            commandSender.sendMessage("\u00a7cUseButtonHarvest: config parse error, see console.");
        }
        return true;
    }

    private record CropRule(Material type, boolean leaveBase) {
        @Override
        public String toString() {
            return String.valueOf(this.type) + (this.leaveBase ? "(leave_base)" : "");
        }
    }
}

