/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.block;

import com.TBF.cattlestrophic.block.ModBlocks;
import com.TBF.cattlestrophic.block.entity.FeedingTroughBlockEntity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FeedingTroughBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");
    public static final MapCodec<FeedingTroughBlock> CODEC = FeedingTroughBlock.simpleCodec(FeedingTroughBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)16.0), Block.box((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)8.0, (double)2.0), Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)8.0, (double)16.0)});

    public FeedingTroughBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FILLED});
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new FeedingTroughBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof FeedingTroughBlockEntity) {
            FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
            player.openMenu((MenuProvider)feedingTrough);
        }
        return ItemInteractionResult.CONSUME;
    }

    public void playerDestroy(@Nonnull Level world, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity blockEntity, @Nonnull ItemStack stack) {
        if (blockEntity instanceof FeedingTroughBlockEntity) {
            FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, feedingTrough.getInventory());
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.playerDestroy(world, player, pos, state, blockEntity, stack);
    }

    public BlockState playerWillDestroy(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FeedingTroughBlockEntity) {
            FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
            if (!world.isClientSide && player.isCreative()) {
                Containers.dropContents((Level)world, (BlockPos)pos, feedingTrough.getInventory());
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return type == ModBlocks.FEEDING_TROUGH_BLOCK_ENTITY.get() ? (level, pos, blockState, blockEntity) -> {
            if (blockEntity instanceof FeedingTroughBlockEntity) {
                FeedingTroughBlockEntity feedingTrough = (FeedingTroughBlockEntity)blockEntity;
                FeedingTroughBlockEntity.tick(level, pos, blockState, feedingTrough);
            }
        } : null;
    }
}

