/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.capability;

import com.TBF.cattlestrophic.CattlestrophicMod;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;

public class AnimalDataCapability {
    public static final ResourceLocation IDENTIFIER = ResourceLocation.fromNamespaceAndPath((String)"cattlestrophic", (String)"animal_data");
    private static final Map<Entity, IAnimalData> DATA = new WeakHashMap<Entity, IAnimalData>();

    public static void register(Object event) {
    }

    public static void attachCapability(Object event) {
    }

    @Nullable
    public static IAnimalData getAnimalData(Entity entity) {
        if (entity == null) {
            CattlestrophicMod.LOGGER.error("Cannot get animal data from null entity");
            return null;
        }
        return DATA.computeIfAbsent(entity, e -> new AnimalData());
    }

    public static class AnimalData
    implements IAnimalData {
        private boolean domesticated = false;
        private int hungerLevel = 0;
        private int ageCounter = 0;

        @Override
        public boolean isDomesticated() {
            return this.domesticated;
        }

        @Override
        public int getMaxAgeLimit(Animal animal) {
            return this.domesticated ? ModConfig.getInstance().getAnimalSettings(animal.getType()).getDomesticatedMaxAge(ModConfig.getInstance().getDomesticatedMaxAge()) : ModConfig.getInstance().getAnimalSettings(animal.getType()).getWildMaxAge(ModConfig.getInstance().getWildMaxAge());
        }

        @Override
        public void setDomesticated(boolean domesticated) {
            this.domesticated = domesticated;
        }

        @Override
        public int getHungerLevel() {
            return this.hungerLevel;
        }

        @Override
        public void setHungerLevel(int level) {
            this.hungerLevel = Math.max(0, Math.min(this.getMaxHungerLevel(), level));
        }

        @Override
        public int getMaxHungerLevel() {
            return 100;
        }

        @Override
        public void decreaseHunger(int amount) {
            this.setHungerLevel(Math.max(0, this.hungerLevel - amount));
        }

        @Override
        public boolean feed(int amount) {
            if (this.hungerLevel < this.getMaxHungerLevel()) {
                this.setHungerLevel(Math.min(this.getMaxHungerLevel(), this.hungerLevel + amount));
                return true;
            }
            return false;
        }

        @Override
        public boolean isHungry() {
            return (double)this.hungerLevel < (double)this.getMaxHungerLevel() * 0.2;
        }

        @Override
        public boolean isStarving() {
            return this.hungerLevel <= 0;
        }

        @Override
        public int getAgeCounter() {
            return this.ageCounter;
        }

        @Override
        public void setAgeCounter(int age) {
            this.ageCounter = Math.max(0, age);
        }

        @Override
        public void increaseAge(int amount) {
            this.setAgeCounter(this.ageCounter + amount);
        }

        @Override
        public boolean hasReachedMaxAge(Animal animal) {
            return this.ageCounter >= this.getMaxAgeLimit(animal);
        }

        @Override
        public boolean isOld(Animal animal) {
            return (double)this.ageCounter > (double)this.getMaxAgeLimit(animal) * 0.75;
        }

        @Override
        public boolean isVeryOld(Animal animal) {
            return (double)this.ageCounter > (double)this.getMaxAgeLimit(animal) * 0.9;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putBoolean("domesticated", this.domesticated);
            tag.putInt("hungerLevel", this.hungerLevel);
            tag.putInt("ageCounter", this.ageCounter);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            if (nbt.contains("domesticated")) {
                this.domesticated = nbt.getBoolean("domesticated");
            }
            if (nbt.contains("hungerLevel")) {
                this.hungerLevel = nbt.getInt("hungerLevel");
            }
            if (nbt.contains("ageCounter")) {
                this.ageCounter = nbt.getInt("ageCounter");
            }
        }
    }

    public static class Provider {
        private final IAnimalData animalData = new AnimalData();

        public IAnimalData getAnimalData() {
            return this.animalData;
        }

        public CompoundTag serializeNBT() {
            return this.animalData.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.animalData.deserializeNBT(nbt);
        }
    }
}

