/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.command;

import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;

public class AnimalDebugCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        AnimalDebugCommand.registerDomesticationCommand(dispatcher);
        AnimalDebugCommand.registerHungerCommand(dispatcher);
        AnimalDebugCommand.registerAgeCommand(dispatcher);
        AnimalDebugCommand.registerStatsCommand(dispatcher);
    }

    private static void registerDomesticationCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animal").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"domesticate").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"domesticated", (ArgumentType)BoolArgumentType.bool()).executes(context -> AnimalDebugCommand.executeDomesticateCommand((CommandContext<CommandSourceStack>)context, EntityArgument.getEntities((CommandContext)context, (String)"targets"), BoolArgumentType.getBool((CommandContext)context, (String)"domesticated")))))));
    }

    private static void registerHungerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animal").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"hunger").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> AnimalDebugCommand.executeHungerCommand((CommandContext<CommandSourceStack>)context, EntityArgument.getEntities((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static void registerAgeCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animal").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"age").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.argument((String)"age", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> AnimalDebugCommand.executeAgeCommand((CommandContext<CommandSourceStack>)context, EntityArgument.getEntities((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"age")))))));
    }

    private static void registerStatsCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"animal").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"stats").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(context -> AnimalDebugCommand.executeStatsCommand((CommandContext<CommandSourceStack>)context, EntityArgument.getEntities((CommandContext)context, (String)"targets"))))));
    }

    private static int executeDomesticateCommand(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, boolean domesticated) {
        int[] count = new int[]{0};
        for (Entity entity : entities) {
            Animal animal;
            IAnimalData animalData;
            if (!(entity instanceof Animal) || (animalData = AnimalDataCapability.getAnimalData((Entity)(animal = (Animal)entity))) == null) continue;
            animalData.setDomesticated(domesticated);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            String status = domesticated ? "domesticated" : "wild";
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set " + count[0] + " animals to " + status)).withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No valid animals found").withStyle(ChatFormatting.RED));
        }
        return count[0];
    }

    private static int executeHungerCommand(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, int level) {
        int[] count = new int[]{0};
        for (Entity entity : entities) {
            Animal animal;
            IAnimalData animalData;
            if (!(entity instanceof Animal) || (animalData = AnimalDataCapability.getAnimalData((Entity)(animal = (Animal)entity))) == null) continue;
            animalData.setHungerLevel(level);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set hunger level of " + count[0] + " animals to " + level)).withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No valid animals found").withStyle(ChatFormatting.RED));
        }
        return count[0];
    }

    private static int executeAgeCommand(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities, int age) {
        int[] count = new int[]{0};
        for (Entity entity : entities) {
            Animal animal;
            IAnimalData animalData;
            if (!(entity instanceof Animal) || (animalData = AnimalDataCapability.getAnimalData((Entity)(animal = (Animal)entity))) == null) continue;
            animalData.setAgeCounter(age);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set age of " + count[0] + " animals to " + age)).withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No valid animals found").withStyle(ChatFormatting.RED));
        }
        return count[0];
    }

    private static int executeStatsCommand(CommandContext<CommandSourceStack> context, Collection<? extends Entity> entities) {
        int[] count = new int[]{0};
        for (Entity entity : entities) {
            Animal animal;
            IAnimalData animalData;
            if (!(entity instanceof Animal) || (animalData = AnimalDataCapability.getAnimalData((Entity)(animal = (Animal)entity))) == null) continue;
            String entityTypeName = entity.getType().getDescriptionId();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("=== Animal Stats: " + entityTypeName + " ===")).withStyle(ChatFormatting.GOLD), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Domesticated: " + animalData.isDomesticated())).withStyle(animalData.isDomesticated() ? ChatFormatting.GREEN : ChatFormatting.RED), false);
            int hungerLevel = animalData.getHungerLevel();
            int maxHunger = animalData.getMaxHungerLevel();
            ChatFormatting hungerColor = AnimalDebugCommand.getColorForPercentage((float)hungerLevel / (float)maxHunger);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Hunger: " + hungerLevel + "/" + maxHunger)).withStyle(hungerColor), false);
            int ageCounter = animalData.getAgeCounter();
            int maxAge = animalData.getMaxAgeLimit(animal);
            float agePercentage = (float)ageCounter / (float)maxAge;
            ChatFormatting ageColor = AnimalDebugCommand.getColorForPercentage(1.0f - agePercentage);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Age: " + ageCounter + "/" + maxAge)).withStyle(ageColor), false);
            int breedingAge = ((Animal)entity).getAge();
            if (breedingAge > 0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Breeding Cooldown: " + breedingAge + " ticks")).withStyle(ChatFormatting.YELLOW), false);
            } else if (breedingAge < 0) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Growth Time: " + Math.abs(breedingAge) + " ticks")).withStyle(ChatFormatting.AQUA), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Ready to Breed").withStyle(ChatFormatting.GREEN), false);
            }
            count[0] = count[0] + 1;
        }
        if (count[0] == 0) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No valid animals found").withStyle(ChatFormatting.RED));
        }
        return count[0];
    }

    private static ChatFormatting getColorForPercentage(float percentage) {
        if (percentage < 0.25f) {
            return ChatFormatting.RED;
        }
        if (percentage < 0.5f) {
            return ChatFormatting.GOLD;
        }
        if (percentage < 0.75f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }
}

