/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.event;

import com.TBF.cattlestrophic.CattlestrophicMod;
import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import java.util.Iterator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

@EventBusSubscriber(modid="cattlestrophic")
public class LootModifierHandler {
    private static final ThreadLocal<Boolean> PROCESSING_DROP = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Boolean processing = PROCESSING_DROP.get();
        if (processing != null && processing.booleanValue()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (!ModConfig.getInstance().shouldAffectEntity(animal.getType())) {
            return;
        }
        IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
        if (animalData == null) {
            CattlestrophicMod.LOGGER.error("Failed to get animal data for loot modification: {}", (Object)animal.getType().getDescriptionId());
            return;
        }
        try {
            PROCESSING_DROP.set(true);
            float multiplier = animalData.isDomesticated() ? ModConfig.getInstance().getDomesticatedAnimalLootBonusMultiplier() : ModConfig.getInstance().getWildAnimalLootPenaltyMultiplier();
            Iterator iterator = event.getDrops().iterator();
            while (iterator.hasNext()) {
                ItemEntity itemEntity = (ItemEntity)iterator.next();
                ItemStack stack = itemEntity.getItem();
                if (stack.isEmpty()) continue;
                int originalCount = stack.getCount();
                float newCountFloat = (float)originalCount * multiplier;
                int newCountBase = (int)newCountFloat;
                float fraction = newCountFloat - (float)newCountBase;
                int newCount = newCountBase;
                if (Math.random() <= (double)fraction) {
                    ++newCount;
                }
                if (newCount <= 0) {
                    iterator.remove();
                    continue;
                }
                stack.setCount(newCount);
            }
        }
        finally {
            PROCESSING_DROP.remove();
        }
    }
}

