/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.item;

import com.TBF.cattlestrophic.capability.AnimalDataCapability;
import com.TBF.cattlestrophic.capability.IAnimalData;
import com.TBF.cattlestrophic.config.ModConfig;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AnimalInspectorItem
extends Item {
    public AnimalInspectorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        if (entity instanceof Animal) {
            String[] parts;
            Animal animal = (Animal)entity;
            if (player.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!ModConfig.getInstance().shouldAffectEntity(animal.getType())) {
                player.sendSystemMessage((Component)Component.literal((String)"This animal type is not affected by the mod.").withStyle(ChatFormatting.RED));
                return InteractionResult.SUCCESS;
            }
            IAnimalData animalData = AnimalDataCapability.getAnimalData((Entity)animal);
            if (animalData == null) {
                player.sendSystemMessage((Component)Component.literal((String)"No valid animals found").withStyle(ChatFormatting.RED));
                return InteractionResult.SUCCESS;
            }
            Object entityTypeName = animal.getType().getDescriptionId();
            if (((String)entityTypeName).startsWith("entity.") && (parts = ((String)entityTypeName).split("\\.")).length > 0) {
                entityTypeName = parts[parts.length - 1];
            }
            if (!((String)entityTypeName).isEmpty()) {
                entityTypeName = ((String)entityTypeName).substring(0, 1).toUpperCase() + ((String)entityTypeName).substring(1);
            }
            player.sendSystemMessage((Component)Component.literal((String)"=== Animal Inspector ===").withStyle(ChatFormatting.GOLD));
            player.sendSystemMessage((Component)Component.literal((String)("Type: " + (String)entityTypeName)).withStyle(ChatFormatting.WHITE));
            player.sendSystemMessage((Component)Component.literal((String)("Status: " + (animalData.isDomesticated() ? "Domesticated" : "Wild"))).withStyle(animalData.isDomesticated() ? ChatFormatting.GREEN : ChatFormatting.RED));
            if (animalData.isDomesticated()) {
                int hungerLevel = animalData.getHungerLevel();
                int maxHunger = animalData.getMaxHungerLevel();
                ChatFormatting hungerColor = this.getColorForPercentage((float)hungerLevel / (float)maxHunger);
                player.sendSystemMessage((Component)Component.literal((String)("Hunger: " + hungerLevel + "/" + maxHunger)).withStyle(hungerColor));
            }
            int ageCounter = animalData.getAgeCounter();
            int maxAge = animalData.getMaxAgeLimit(animal);
            float agePercentage = (float)ageCounter / (float)maxAge;
            ChatFormatting ageColor = this.getColorForPercentage(1.0f - agePercentage);
            player.sendSystemMessage((Component)Component.literal((String)("Age: " + ageCounter + "/" + maxAge)).withStyle(ageColor));
            if (!animal.isBaby()) {
                int breedingAge = animal.getAge();
                if (breedingAge > 0) {
                    player.sendSystemMessage((Component)Component.literal((String)("Breeding Cooldown: " + breedingAge + " ticks")).withStyle(ChatFormatting.YELLOW));
                } else if (breedingAge == 0) {
                    player.sendSystemMessage((Component)Component.literal((String)"Ready to Breed").withStyle(ChatFormatting.GREEN));
                }
            } else {
                int breedingAge = animal.getAge();
                player.sendSystemMessage((Component)Component.literal((String)("Growth Time Remaining: " + Math.abs(breedingAge) + " ticks")).withStyle(ChatFormatting.AQUA));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!level.isClientSide) {
            player.sendSystemMessage((Component)Component.literal((String)"Right-click on an animal to inspect it.").withStyle(ChatFormatting.ITALIC));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    private ChatFormatting getColorForPercentage(float percentage) {
        if (percentage < 0.2f) {
            return ChatFormatting.RED;
        }
        if (percentage < 0.5f) {
            return ChatFormatting.GOLD;
        }
        if (percentage < 0.75f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }
}

