/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.api;

public interface TrackableAnimal {
    public boolean isDomesticated();

    public void setDomesticated(boolean var1);

    public int getHungerLevel();

    public void setHungerLevel(int var1);

    public int getMaxHungerLevel();

    public int getAgeCounter();

    public void setAgeCounter(int var1);

    public int getMaxAgeLimit();

    public void increaseAge(int var1);

    public boolean hasReachedMaxAge();

    default public boolean isHungry() {
        return (double)this.getHungerLevel() < (double)this.getMaxHungerLevel() * 0.25;
    }

    default public boolean isStarving() {
        return this.getHungerLevel() <= 0;
    }

    default public boolean isOld() {
        return (double)this.getAgeCounter() > (double)this.getMaxAgeLimit() * 0.75;
    }

    default public boolean feed(int amount) {
        if (this.getHungerLevel() < this.getMaxHungerLevel()) {
            this.setHungerLevel(Math.min(this.getHungerLevel() + amount, this.getMaxHungerLevel()));
            return true;
        }
        return false;
    }

    default public void decreaseHunger(int amount) {
        this.setHungerLevel(Math.max(0, this.getHungerLevel() - amount));
    }
}

