/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.block.entity;

import com.TBF.cattlestrophic.api.TrackableAnimal;
import com.TBF.cattlestrophic.block.FeedingTroughBlock;
import com.TBF.cattlestrophic.block.ModBlocks;
import com.TBF.cattlestrophic.config.ModConfig;
import com.TBF.cattlestrophic.screen.FeedingTroughScreenHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class FeedingTroughBlockEntity
extends class_2586
implements class_3908,
class_1263 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    private int feedingCooldown = 0;
    private int registrationCooldown = 0;
    private int animalsInRange = 0;
    private List<class_1429> registeredAnimals = new ArrayList<class_1429>();

    public int getFeedingCooldown() {
        return this.feedingCooldown;
    }

    public void setFeedingCooldown(int value) {
        this.feedingCooldown = value;
    }

    public List<class_1429> getRegisteredAnimals() {
        if (this.registeredAnimals == null) {
            this.registeredAnimals = new ArrayList<class_1429>();
        }
        return this.registeredAnimals;
    }

    public FeedingTroughBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.FEEDING_TROUGH_BLOCK_ENTITY, pos, state);
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public class_1277 getSimpleInventory() {
        class_1277 simpleInventory = new class_1277(this.inventory.size()){

            public void method_5431() {
                super.method_5431();
                FeedingTroughBlockEntity.this.method_5431();
            }
        };
        for (int i = 0; i < this.inventory.size(); ++i) {
            simpleInventory.method_5447(i, ((class_1799)this.inventory.get(i)).method_7972());
        }
        return simpleInventory;
    }

    private boolean isValidFoodForAnimal(class_1792 item, class_1429 animal) {
        String itemId = class_7923.field_41178.method_10221((Object)item).toString();
        String[] acceptedFoods = ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getAcceptedFoodItems();
        return Arrays.asList(acceptedFoods).contains(itemId);
    }

    private int findFoodForAnimal(class_1429 animal) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 stack = (class_1799)this.inventory.get(i);
            if (stack.method_7960() || !this.isValidFoodForAnimal(stack.method_7909(), animal)) continue;
            return i;
        }
        return -1;
    }

    private boolean feedAnimal(class_1429 animal) {
        if (!(animal instanceof TrackableAnimal)) {
            return false;
        }
        TrackableAnimal trackableAnimal = (TrackableAnimal)animal;
        if (!trackableAnimal.isDomesticated()) {
            return false;
        }
        int feedingAmount = ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getFeedingAmount(ModConfig.getInstance().getFeedingAmount());
        if (trackableAnimal.getHungerLevel() >= 100 - feedingAmount) {
            return false;
        }
        int foodSlot = this.findFoodForAnimal(animal);
        if (foodSlot >= 0) {
            class_1799 foodStack = (class_1799)this.inventory.get(foodSlot);
            trackableAnimal.feed(feedingAmount);
            foodStack.method_7934(1);
            if (foodStack.method_7960()) {
                this.inventory.set(foodSlot, (Object)class_1799.field_8037);
            }
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.inventory) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems() {
        return !this.method_5442();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FeedingTroughBlockEntity blockEntity) {
        if (world.field_9236 || !ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (blockEntity.registrationCooldown > 0) {
            --blockEntity.registrationCooldown;
        }
        if (blockEntity.feedingCooldown > 0) {
            --blockEntity.feedingCooldown;
        }
        if (!blockEntity.hasItems()) {
            if (blockEntity.registeredAnimals != null && !blockEntity.registeredAnimals.isEmpty()) {
                blockEntity.registeredAnimals.clear();
                blockEntity.method_5431();
            }
            return;
        }
        int range = ModConfig.getInstance().getFeedingTroughRange();
        int maxAnimalsPerTrough = ModConfig.getInstance().getMaxAnimalsPerTrough();
        class_238 box = new class_238(pos).method_1014((double)range);
        List domesticatedAnimals = world.method_8390(class_1429.class, box, entity -> {
            TrackableAnimal trackable;
            return entity instanceof TrackableAnimal && (trackable = (TrackableAnimal)entity).isDomesticated();
        });
        blockEntity.animalsInRange = domesticatedAnimals.size();
        if (domesticatedAnimals.isEmpty()) {
            return;
        }
        if (blockEntity.registrationCooldown <= 0) {
            FeedingTroughBlockEntity.updateRegisteredAnimals(blockEntity, domesticatedAnimals, maxAnimalsPerTrough);
            FeedingTroughBlockEntity.calculateRegistrationRefreshInterval(blockEntity);
        }
        if (blockEntity.feedingCooldown <= 0) {
            boolean anyFed = false;
            for (class_1429 animal : blockEntity.getRegisteredAnimals()) {
                TrackableAnimal trackable;
                if (!(animal instanceof TrackableAnimal) || (trackable = (TrackableAnimal)animal).getHungerLevel() >= 100 - ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getFeedingAmount(ModConfig.getInstance().getFeedingAmount()) || !blockEntity.feedAnimal(animal)) continue;
                anyFed = true;
            }
            if (anyFed) {
                blockEntity.method_5431();
            }
            FeedingTroughBlockEntity.calculateNextFeedingTime(blockEntity);
        }
        blockEntity.updateFilledState();
    }

    private static void updateRegisteredAnimals(FeedingTroughBlockEntity blockEntity, List<class_1429> nearbyAnimals, int maxAnimals) {
        if (blockEntity.registeredAnimals == null) {
            blockEntity.registeredAnimals = new ArrayList<class_1429>();
        }
        blockEntity.registeredAnimals.removeIf(animal -> animal == null || animal.method_31481() || animal.method_37908() != blockEntity.method_10997() || animal.method_5649((double)blockEntity.method_11016().method_10263() + 0.5, (double)blockEntity.method_11016().method_10264() + 0.5, (double)blockEntity.method_11016().method_10260() + 0.5) > Math.pow(ModConfig.getInstance().getFeedingTroughRange(), 2.0));
        if (blockEntity.registeredAnimals.size() < maxAnimals) {
            ArrayList<class_1429> unregisteredAnimals = new ArrayList<class_1429>(nearbyAnimals);
            unregisteredAnimals.removeAll(blockEntity.registeredAnimals);
            if (!unregisteredAnimals.isEmpty()) {
                unregisteredAnimals.sort(Comparator.comparingDouble(animal -> animal.method_5649((double)blockEntity.method_11016().method_10263() + 0.5, (double)blockEntity.method_11016().method_10264() + 0.5, (double)blockEntity.method_11016().method_10260() + 0.5)));
                for (class_1429 animal2 : unregisteredAnimals) {
                    if (blockEntity.registeredAnimals.size() >= maxAnimals) break;
                    blockEntity.registeredAnimals.add(animal2);
                }
            }
        }
    }

    private static void calculateRegistrationRefreshInterval(FeedingTroughBlockEntity blockEntity) {
        int baseDepletionRate = ModConfig.getInstance().getHungerDepletionRate();
        int baseFeedingAmount = ModConfig.getInstance().getFeedingAmount();
        int totalDepletionRate = 0;
        int totalFeedingAmount = 0;
        int animalCount = 0;
        for (class_1429 animal : blockEntity.getRegisteredAnimals()) {
            if (!(animal instanceof TrackableAnimal)) continue;
            int animalDepletionRate = ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getHungerDepletionRate(baseDepletionRate);
            int animalFeedingAmount = ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getFeedingAmount(baseFeedingAmount);
            totalDepletionRate += animalDepletionRate;
            totalFeedingAmount += animalFeedingAmount;
            ++animalCount;
        }
        int avgDepletionRate = animalCount > 0 ? totalDepletionRate / animalCount : baseDepletionRate;
        int avgFeedingAmount = animalCount > 0 ? totalFeedingAmount / animalCount : baseFeedingAmount;
        double starvationTime = (double)avgDepletionRate * ((double)avgFeedingAmount / 100.0);
        int registrationInterval = (int)(starvationTime * 0.75);
        blockEntity.registrationCooldown = registrationInterval = Math.max(100, registrationInterval);
    }

    private static void calculateNextFeedingTime(FeedingTroughBlockEntity blockEntity) {
        int baseDepletionRate = ModConfig.getInstance().getHungerDepletionRate();
        int feedingInterval = baseDepletionRate / 4;
        if (blockEntity.registeredAnimals != null && !blockEntity.registeredAnimals.isEmpty()) {
            int totalDepletionRate = 0;
            int animalCount = 0;
            for (class_1429 animal : blockEntity.registeredAnimals) {
                if (!(animal instanceof TrackableAnimal)) continue;
                int animalDepletionRate = ModConfig.getInstance().getAnimalSettings(animal.method_5864()).getHungerDepletionRate(baseDepletionRate);
                totalDepletionRate += animalDepletionRate;
                ++animalCount;
            }
            int avgDepletionRate = animalCount > 0 ? totalDepletionRate / animalCount : baseDepletionRate;
            feedingInterval = Math.max(20, avgDepletionRate / 4);
        }
        blockEntity.feedingCooldown = feedingInterval;
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.feedingCooldown = nbt.method_10550("FeedingCooldown");
        this.registrationCooldown = nbt.method_10550("RegistrationCooldown");
        this.animalsInRange = nbt.method_10550("AnimalsInRange");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("FeedingCooldown", this.feedingCooldown);
        nbt.method_10569("RegistrationCooldown", this.registrationCooldown);
        nbt.method_10569("AnimalsInRange", this.animalsInRange);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.cattlestrophic.feeding_trough");
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new FeedingTroughScreenHandler(syncId, playerInventory, this);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 stack = class_1262.method_5428(this.inventory, (int)slot);
        this.method_5431();
        return stack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        this.method_5431();
    }

    private void updateFilledState() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            boolean hasItems = this.hasItems();
            class_2680 currentState = this.field_11863.method_8320(this.field_11867);
            boolean currentlyFilled = (Boolean)currentState.method_11654((class_2769)FeedingTroughBlock.FILLED);
            if (currentlyFilled != hasItems) {
                this.field_11863.method_8652(this.field_11867, (class_2680)currentState.method_11657((class_2769)FeedingTroughBlock.FILLED, (Comparable)Boolean.valueOf(hasItems)), 3);
                this.field_11863.method_8452(this.field_11867, currentState.method_26204());
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
        this.method_5431();
    }

    public void method_5431() {
        super.method_5431();
        this.updateFilledState();
    }
}

