/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.command;

import com.TBF.cattlestrophic.api.TrackableAnimal;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class AnimalDebugCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        AnimalDebugCommand.registerDomesticationCommand(dispatcher);
        AnimalDebugCommand.registerHungerCommand(dispatcher);
        AnimalDebugCommand.registerAgeCommand(dispatcher);
        AnimalDebugCommand.registerStatsCommand(dispatcher);
    }

    private static void registerDomesticationCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"animal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"domesticate").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"domesticated", (ArgumentType)BoolArgumentType.bool()).executes(context -> AnimalDebugCommand.executeDomesticateCommand((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"targets"), BoolArgumentType.getBool((CommandContext)context, (String)"domesticated")))))));
    }

    private static void registerHungerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"animal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"hunger").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> AnimalDebugCommand.executeHungerCommand((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))));
    }

    private static void registerAgeCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"animal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"age").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"age", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> AnimalDebugCommand.executeAgeCommand((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"age")))))));
    }

    private static void registerStatsCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"animal").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"stats").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(context -> AnimalDebugCommand.executeStatsCommand((CommandContext<class_2168>)context, class_2186.method_9317((CommandContext)context, (String)"targets"))))));
    }

    private static int executeDomesticateCommand(CommandContext<class_2168> context, Collection<? extends class_1297> entities, boolean domesticated) {
        int[] count = new int[]{0};
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1429) || !(class_12972 instanceof TrackableAnimal)) continue;
            TrackableAnimal trackable = (TrackableAnimal)class_12972;
            trackable.setDomesticated(domesticated);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            String status = domesticated ? "domesticated" : "wild";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set " + count[0] + " animals to " + status)).method_27692(class_124.field_1060), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No valid animals found").method_27692(class_124.field_1061), true);
        }
        return count[0];
    }

    private static int executeHungerCommand(CommandContext<class_2168> context, Collection<? extends class_1297> entities, int level) {
        int[] count = new int[]{0};
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1429) || !(class_12972 instanceof TrackableAnimal)) continue;
            TrackableAnimal trackable = (TrackableAnimal)class_12972;
            trackable.setHungerLevel(level);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set hunger level of " + count[0] + " animals to " + level)).method_27692(class_124.field_1060), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No valid animals found").method_27692(class_124.field_1061), true);
        }
        return count[0];
    }

    private static int executeAgeCommand(CommandContext<class_2168> context, Collection<? extends class_1297> entities, int age) {
        int[] count = new int[]{0};
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1429) || !(class_12972 instanceof TrackableAnimal)) continue;
            TrackableAnimal trackable = (TrackableAnimal)class_12972;
            trackable.setAgeCounter(age);
            count[0] = count[0] + 1;
        }
        if (count[0] > 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Set age of " + count[0] + " animals to " + age)).method_27692(class_124.field_1060), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No valid animals found").method_27692(class_124.field_1061), true);
        }
        return count[0];
    }

    private static int executeStatsCommand(CommandContext<class_2168> context, Collection<? extends class_1297> entities) {
        int[] count = new int[]{0};
        for (class_1297 class_12972 : entities) {
            if (!(class_12972 instanceof class_1429) || !(class_12972 instanceof TrackableAnimal)) continue;
            TrackableAnimal trackable = (TrackableAnimal)class_12972;
            class_1429 animal = (class_1429)class_12972;
            boolean isDomesticated = trackable.isDomesticated();
            int hungerLevel = trackable.getHungerLevel();
            int maxHunger = trackable.getMaxHungerLevel();
            int ageCounter = trackable.getAgeCounter();
            int maxAge = trackable.getMaxAgeLimit();
            class_5250 message = class_2561.method_43470((String)("Stats for " + class_12972.method_5864().method_5897().getString() + ":")).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"\n- Status: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(isDomesticated ? "Domesticated" : "Wild")).method_27692(isDomesticated ? class_124.field_1060 : class_124.field_1061))).method_10852((class_2561)class_2561.method_43470((String)"\n- Hunger: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(hungerLevel + "/" + maxHunger)).method_27692(AnimalDebugCommand.getHungerFormatting(hungerLevel, maxHunger)))).method_10852((class_2561)class_2561.method_43470((String)"\n- Age: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(ageCounter + "/" + maxAge)).method_27692(AnimalDebugCommand.getAgeFormatting(ageCounter, maxAge)))).method_10852((class_2561)class_2561.method_43470((String)"\n- Is Baby: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(animal.method_6109() ? "Yes" : "No")).method_27692(animal.method_6109() ? class_124.field_1075 : class_124.field_1080)));
            ((class_2168)context.getSource()).method_9226(() -> AnimalDebugCommand.lambda$executeStatsCommand$14((class_2561)message), false);
            count[0] = count[0] + 1;
        }
        if (count[0] == 0) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No valid animals found").method_27692(class_124.field_1061), true);
        }
        return count[0];
    }

    private static class_124 getHungerFormatting(int hunger, int maxHunger) {
        float percent = (float)hunger / (float)maxHunger;
        if (percent < 0.25f) {
            return class_124.field_1061;
        }
        if (percent < 0.5f) {
            return class_124.field_1065;
        }
        if (percent < 0.75f) {
            return class_124.field_1054;
        }
        return class_124.field_1060;
    }

    private static class_124 getAgeFormatting(int age, int maxAge) {
        float percent = (float)age / (float)maxAge;
        if (percent > 0.9f) {
            return class_124.field_1079;
        }
        if (percent > 0.75f) {
            return class_124.field_1061;
        }
        if (percent > 0.5f) {
            return class_124.field_1065;
        }
        if (percent > 0.25f) {
            return class_124.field_1054;
        }
        return class_124.field_1060;
    }

    private static /* synthetic */ class_2561 lambda$executeStatsCommand$14(class_2561 message) {
        return message;
    }
}

