/*
 * Decompiled with CFR 0.152.
 */
package com.TBF.cattlestrophic.mixin;

import com.TBF.cattlestrophic.CattlestrophicMod;
import com.TBF.cattlestrophic.api.TrackableAnimal;
import com.TBF.cattlestrophic.config.ModConfig;
import com.TBF.cattlestrophic.network.SyncAnimalDataS2CPacket;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1429.class})
public abstract class AnimalEntityMixin
implements TrackableAnimal {
    private static final String DOMESTICATED_KEY = "Domesticated";
    private static final String HUNGER_LEVEL_KEY = "HungerLevel";
    private static final String AGE_COUNTER_KEY = "AgeCounter";
    private boolean cattlestrophic$domesticated;
    private int cattlestrophic$hungerLevel = 100;
    private int cattlestrophic$ageCounter;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(class_1299<? extends class_1429> entityType, class_1937 world, CallbackInfo ci) {
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (!ModConfig.getInstance().shouldAffectEntity(entityType)) {
            return;
        }
        try {
            class_1429 self = (class_1429)this;
            this.cattlestrophic$domesticated = false;
            this.cattlestrophic$hungerLevel = 100;
            this.cattlestrophic$ageCounter = 0;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error initializing animal in constructor", (Throwable)e);
        }
    }

    @Inject(method={"breed"}, at={@At(value="HEAD")}, cancellable=true)
    private void atBreed(class_3218 serverWorld, class_1429 mate, CallbackInfo ci) {
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        class_1429 self = (class_1429)this;
        if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
            return;
        }
        boolean selfIsWild = false;
        boolean mateIsWild = false;
        if (self instanceof TrackableAnimal) {
            TrackableAnimal trackableSelf = (TrackableAnimal)self;
            boolean bl = selfIsWild = !trackableSelf.isDomesticated();
        }
        if (mate instanceof TrackableAnimal) {
            TrackableAnimal trackableMate = (TrackableAnimal)mate;
            boolean bl = mateIsWild = !trackableMate.isDomesticated();
        }
        if ((selfIsWild || mateIsWild) && Math.random() > (double)ModConfig.getInstance().getWildAnimalBreedChance()) {
            ci.cancel();
            if (selfIsWild) {
                self.method_5614(ModConfig.getInstance().getAnimalSettings(self.method_5864()).getBreedingCooldownTicks(ModConfig.getInstance().getBreedingCooldownTicks()) + ModConfig.getInstance().getWildBreedingExtraCooldownTicks());
            }
            if (mateIsWild && mate != null) {
                mate.method_5614(ModConfig.getInstance().getAnimalSettings(mate.method_5864()).getBreedingCooldownTicks(ModConfig.getInstance().getBreedingCooldownTicks()) + ModConfig.getInstance().getWildBreedingExtraCooldownTicks());
            }
        }
    }

    @Inject(method={"breed"}, at={@At(value="TAIL")}, cancellable=true)
    private void onBreed(class_3218 serverWorld, class_1429 mate, CallbackInfo ci) {
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        class_1429 self = (class_1429)this;
        class_238 searchBox = self.method_5829().method_1014(2.0);
        if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
            return;
        }
        serverWorld.method_8390(class_1429.class, searchBox, entity -> entity.method_6109()).forEach(baby -> {
            if (baby instanceof TrackableAnimal) {
                TrackableAnimal trackable = (TrackableAnimal)baby;
                try {
                    trackable.setDomesticated(true);
                }
                catch (Exception e) {
                    CattlestrophicMod.LOGGER.error("Error setting domesticated status for baby animal", (Throwable)e);
                }
            }
        });
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    private void onTickMovement(CallbackInfo ci) {
        class_1429 self = (class_1429)this;
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (self.method_37908().field_9236) {
            return;
        }
        if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
            return;
        }
        try {
            if (this.isDomesticated()) {
                ModConfig.AnimalSettings settings = ModConfig.getInstance().getAnimalSettings(self.method_5864());
                int wildHungerRate = settings.getHungerDepletionRate(ModConfig.getInstance().getHungerDepletionRate());
                if (self.method_37908().method_8510() % (long)wildHungerRate == 0L) {
                    this.decreaseHunger(1);
                }
                if (this.isStarving() && (double)self.method_37908().method_8510() % Math.max(1.0, (double)ModConfig.getInstance().getAnimalSettings(self.method_5864()).getHungerDepletionRate(ModConfig.getInstance().getHungerDepletionRate()) * Math.random()) == 0.0) {
                    self.method_5643(self.method_48923().method_48825(), 1.0f);
                }
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error processing hunger for domesticated animal", (Throwable)e);
        }
        try {
            if (self.method_37908().method_8510() % (long)ModConfig.getInstance().getAgingRate() == 0L) {
                this.increaseAge(1);
            }
            if (this.hasReachedMaxAge() && (double)self.method_37908().method_8510() % Math.max(1.0, (double)ModConfig.getInstance().getAgingRate() * Math.random()) == 0.0) {
                self.method_5768();
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error processing age for animal", (Throwable)e);
        }
    }

    @Inject(method={"mobTick"}, at={@At(value="TAIL")})
    private void onMobTickVisualIndicators(CallbackInfo ci) {
        int particleCount;
        double offsetZ;
        double offsetY;
        double offsetX;
        TrackableAnimal trackable;
        class_1429 self = (class_1429)this;
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
            return;
        }
        if (!(self instanceof TrackableAnimal) || !(trackable = (TrackableAnimal)self).isDomesticated()) {
            return;
        }
        if (ModConfig.getInstance().shouldShowHungerIndicators() && (double)self.method_37908().method_8510() % Math.max(40.0, (double)ModConfig.getInstance().getAnimalSettings(self.method_5864()).getHungerDepletionRate(ModConfig.getInstance().getHungerDepletionRate()) * Math.random()) == 0.0) {
            try {
                int currentHunger = this.getHungerLevel();
                float hungerPercent = (float)currentHunger / (float)this.getMaxHungerLevel();
                offsetX = (double)self.method_59922().method_43057() * 0.4 - 0.2;
                offsetY = (double)self.method_59922().method_43057() * 0.2;
                offsetZ = (double)self.method_59922().method_43057() * 0.4 - 0.2;
                particleCount = 1;
                if ((double)self.method_59922().method_43057() < 0.3) {
                    particleCount = 2;
                }
                if (hungerPercent < 0.2f) {
                    double x = self.method_23317() + offsetX;
                    double y = self.method_23318() + (double)self.method_17682() + 0.3 + offsetY;
                    double z = self.method_23321() + offsetZ;
                    if (self.method_37908() instanceof class_3218) {
                        ((class_3218)self.method_37908()).method_14199((class_2394)class_2398.field_11231, x, y, z, particleCount, 0.1, 0.1, 0.1, 0.0);
                    }
                    return;
                }
            }
            catch (Exception e) {
                CattlestrophicMod.LOGGER.error("Error checking hunger level for visual indicators", (Throwable)e);
            }
        }
        if (ModConfig.getInstance().shouldShowAgeIndicators() && (double)self.method_37908().method_8510() % Math.max(40.0, (double)ModConfig.getInstance().getAgingRate() * Math.random()) == 0.0) {
            try {
                int currentAge = this.getAgeCounter();
                float agePercent = (float)currentAge / (float)this.getMaxAgeLimit();
                offsetX = (double)self.method_59922().method_43057() * 0.4 - 0.2;
                offsetY = (double)self.method_59922().method_43057() * 0.2;
                offsetZ = (double)self.method_59922().method_43057() * 0.4 - 0.2;
                particleCount = 1;
                if ((double)self.method_59922().method_43057() < 0.3) {
                    particleCount = 2;
                }
                if (agePercent > 0.9f) {
                    double x = self.method_23317() + offsetX;
                    double y = self.method_23318() + (double)self.method_17682() + 0.3 + offsetY;
                    double z = self.method_23321() + offsetZ;
                    if (self.method_37908() instanceof class_3218) {
                        ((class_3218)self.method_37908()).method_14199((class_2394)class_2398.field_23114, x, y, z, particleCount, 0.1, 0.1, 0.1, 0.0);
                    }
                } else if (agePercent > 0.75f) {
                    double x = self.method_23317() + offsetX;
                    double y = self.method_23318() + (double)self.method_17682() + 0.3 + offsetY;
                    double z = self.method_23321() + offsetZ;
                    if (self.method_37908() instanceof class_3218) {
                        ((class_3218)self.method_37908()).method_14199((class_2394)class_2398.field_11219, x, y, z, particleCount, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
            catch (Exception e) {
                CattlestrophicMod.LOGGER.error("Error checking age for visual indicators", (Throwable)e);
            }
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void onWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        try {
            if (!ModConfig.getInstance().isModEnabled()) {
                return;
            }
            class_1429 self = (class_1429)this;
            if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
                return;
            }
            if (self.method_5841() != null) {
                nbt.method_10556(DOMESTICATED_KEY, this.isDomesticated());
                nbt.method_10569(HUNGER_LEVEL_KEY, this.getHungerLevel());
                nbt.method_10569(AGE_COUNTER_KEY, this.getAgeCounter());
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error saving animal data to NBT", (Throwable)e);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void onReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (!ModConfig.getInstance().isModEnabled()) {
            return;
        }
        try {
            class_1429 self = (class_1429)this;
            if (!ModConfig.getInstance().shouldAffectEntity(self.method_5864())) {
                return;
            }
            this.cattlestrophic$domesticated = false;
            this.cattlestrophic$hungerLevel = 100;
            this.cattlestrophic$ageCounter = 0;
            if (nbt.method_10545(DOMESTICATED_KEY)) {
                this.setDomesticated(nbt.method_10577(DOMESTICATED_KEY));
            }
            if (nbt.method_10545(HUNGER_LEVEL_KEY)) {
                this.setHungerLevel(nbt.method_10550(HUNGER_LEVEL_KEY));
            }
            if (nbt.method_10545(AGE_COUNTER_KEY)) {
                this.setAgeCounter(nbt.method_10550(AGE_COUNTER_KEY));
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error loading animal data from NBT", (Throwable)e);
        }
    }

    @Override
    public boolean isDomesticated() {
        try {
            return this.cattlestrophic$domesticated;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error getting domesticated status", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setDomesticated(boolean domesticated) {
        try {
            class_1429 self = (class_1429)this;
            this.cattlestrophic$domesticated = domesticated;
            if (!self.method_37908().method_8608()) {
                SyncAnimalDataS2CPacket.sendToAll(self);
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error setting domesticated status", (Throwable)e);
        }
    }

    @Override
    public int getHungerLevel() {
        try {
            return this.cattlestrophic$hungerLevel;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error getting hunger level", (Throwable)e);
            return 100;
        }
    }

    @Override
    public void setHungerLevel(int hungerLevel) {
        try {
            class_1429 self = (class_1429)this;
            this.cattlestrophic$hungerLevel = hungerLevel;
            if (!self.method_37908().method_8608() && hungerLevel % 10 == 0) {
                SyncAnimalDataS2CPacket.sendToAll(self);
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error setting hunger level", (Throwable)e);
        }
    }

    @Override
    public int getMaxHungerLevel() {
        return 100;
    }

    @Override
    public int getAgeCounter() {
        try {
            return this.cattlestrophic$ageCounter;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error getting age counter", (Throwable)e);
            return 0;
        }
    }

    @Override
    public void setAgeCounter(int ageCounter) {
        try {
            class_1429 self = (class_1429)this;
            this.cattlestrophic$ageCounter = ageCounter;
            if (!self.method_37908().method_8608() && ageCounter % 10 == 0) {
                SyncAnimalDataS2CPacket.sendToAll(self);
            }
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error setting age counter", (Throwable)e);
        }
    }

    @Override
    public int getMaxAgeLimit() {
        class_1429 self = (class_1429)this;
        class_1299 entityType = self.method_5864();
        if (this.isDomesticated()) {
            return ModConfig.getInstance().getDomesticatedMaxAge(entityType);
        }
        ModConfig.AnimalSettings settings = ModConfig.getInstance().getAnimalSettings(entityType);
        if (settings != null) {
            return settings.getWildMaxAge(ModConfig.getInstance().getWildMaxAge(entityType));
        }
        return ModConfig.getInstance().getWildMaxAge();
    }

    @Override
    public void increaseAge(int amount) {
        try {
            class_1429 self = (class_1429)this;
            this.setAgeCounter(this.getAgeCounter() + amount);
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error increasing age", (Throwable)e);
        }
    }

    @Override
    public boolean hasReachedMaxAge() {
        try {
            class_1429 self = (class_1429)this;
            return this.getAgeCounter() >= this.getMaxAgeLimit();
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error checking max age", (Throwable)e);
            return false;
        }
    }

    @Override
    public void decreaseHunger(int amount) {
        try {
            class_1429 self = (class_1429)this;
            int newHungerLevel = Math.max(0, this.getHungerLevel() - amount);
            this.setHungerLevel(newHungerLevel);
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error decreasing hunger", (Throwable)e);
        }
    }

    @Override
    public boolean isStarving() {
        try {
            return this.getHungerLevel() <= 0;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error checking starving status", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isOld() {
        try {
            return (double)this.getAgeCounter() > (double)this.getMaxAgeLimit() * 0.75;
        }
        catch (Exception e) {
            CattlestrophicMod.LOGGER.error("Error checking old age", (Throwable)e);
            return false;
        }
    }
}

