/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import me.alex4386.plugin.typhon.TyphonCache;
import org.bukkit.block.Block;

public class TyphonQueuedHashMap<K, V> {
    private final int maxSize;
    private final HashMap<K, TyphonCache<V>> map;
    private final Queue<K> queue;
    private Function<K, K> keyPreprocessor;
    private Function<Map.Entry<K, TyphonCache<V>>, Object> onRemove;
    private boolean useCache = true;

    public TyphonQueuedHashMap(int maxSize) {
        this(maxSize, null);
    }

    public TyphonQueuedHashMap(int maxSize, Function<K, K> keyPreprocessor) {
        this(maxSize, keyPreprocessor, null);
    }

    public TyphonQueuedHashMap(int maxSize, Function<K, K> keyPreprocessor, Function<Map.Entry<K, TyphonCache<V>>, Object> onRemove) {
        this(maxSize, keyPreprocessor, onRemove, true);
    }

    public TyphonQueuedHashMap(int maxSize, Function<K, K> keyPreprocessor, Function<Map.Entry<K, TyphonCache<V>>, Object> onRemove, boolean useCache) {
        this.maxSize = maxSize;
        this.map = new HashMap();
        this.queue = new LinkedList<K>();
        this.keyPreprocessor = keyPreprocessor;
        this.onRemove = onRemove;
        this.useCache = useCache;
    }

    public static Block getTwoDimensionalBlock(Block block) {
        return block.getRelative(0, -block.getY(), 0);
    }

    public boolean isUsingCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    private void removeQueueUntil(K key) {
        K oldestKey;
        K realKey = this.getRealKey(key);
        while (!this.queue.isEmpty() && !(oldestKey = this.queue.poll()).equals(realKey)) {
            this.map.remove(oldestKey);
        }
    }

    public K getRealKey(K key) {
        return this.getKeyPreprocessor().apply(key);
    }

    public void put(K key, V value) {
        K realKey = this.getRealKey(key);
        if (this.map.containsKey(realKey)) {
            this.queue.remove(realKey);
        } else if (this.map.size() >= this.maxSize) {
            K oldestKey = this.queue.poll();
            this.removeByRealKey(oldestKey);
        }
        this.map.put(realKey, new TyphonCache<V>(value));
        this.queue.offer(realKey);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
        this.queue.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (TyphonCache<V> cache : this.valueCaches()) {
            values.add(cache.getTarget());
        }
        return values;
    }

    public Collection<TyphonCache<V>> valueCaches() {
        return this.map.values();
    }

    private Function<K, K> getKeyPreprocessor() {
        if (this.keyPreprocessor == null) {
            return key -> key;
        }
        return this.keyPreprocessor;
    }

    public TyphonCache<V> getCacheIncludingExpired(K key) {
        return this.map.get(this.getRealKey(key));
    }

    public TyphonCache<V> getCache(K key) {
        TyphonCache<V> cache = this.getCacheIncludingExpired(key);
        if (cache == null) {
            return null;
        }
        if (this.useCache && cache.isExpired()) {
            this.removeQueueUntil(key);
            return null;
        }
        return cache;
    }

    public V getIncludingExpired(K key) {
        TyphonCache<V> cache = this.getCacheIncludingExpired(key);
        if (cache == null) {
            return null;
        }
        return cache.getTarget();
    }

    public V get(K key) {
        TyphonCache<V> cache = this.getCache(key);
        if (cache == null) {
            return null;
        }
        return cache.getTarget();
    }

    public V remove(K key) {
        return this.removeByRealKey(this.getRealKey(key));
    }

    private V removeByRealKey(K key) {
        this.queue.remove(key);
        TyphonCache<V> cache = this.map.remove(key);
        if (cache == null) {
            return null;
        }
        AbstractMap.SimpleEntry<K, TyphonCache<V>> entry = new AbstractMap.SimpleEntry<K, TyphonCache<V>>(key, cache);
        if (this.onRemove != null) {
            try {
                this.onRemove.apply(entry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cache.getTarget();
    }
}

