/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonMultithreading;
import me.alex4386.plugin.typhon.TyphonPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;

public class TyphonScheduler {
    public static Map<Integer, Object> tasks = new HashMap<Integer, Object>();
    private static int taskId = 1;

    private static synchronized int getNewTaskId() {
        while (tasks.containsKey(taskId)) {
            ++taskId;
        }
        return taskId;
    }

    public static int registerGlobalTask(Runnable task, long interval) {
        return TyphonScheduler.registerTask(null, task, interval);
    }

    public static int registerTask(Chunk chunk, Runnable task, long interval) {
        if (interval < 1L) {
            interval = 1L;
        }
        if (TyphonMultithreading.isPaperMultithread) {
            ScheduledTask scheduledTask = chunk == null ? Bukkit.getGlobalRegionScheduler().runAtFixedRate(TyphonPlugin.plugin, _a -> task.run(), 1L, interval) : Bukkit.getRegionScheduler().runAtFixedRate(TyphonPlugin.plugin, chunk.getWorld(), chunk.getX(), chunk.getZ(), _a -> task.run(), 1L, interval);
            int targetId = TyphonScheduler.getNewTaskId();
            tasks.put(targetId, scheduledTask);
        } else {
            int targetId = Bukkit.getScheduler().scheduleSyncRepeatingTask(TyphonPlugin.plugin, task, 0L, interval);
            if (targetId > taskId) {
                taskId = targetId;
            }
            tasks.put(taskId, task);
        }
        return taskId;
    }

    public static void unregisterTask(int taskId) {
        if (tasks.containsKey(taskId)) {
            if (tasks.get(taskId) instanceof ScheduledTask) {
                ((ScheduledTask)tasks.get(taskId)).cancel();
            } else {
                Bukkit.getScheduler().cancelTask(taskId);
            }
            tasks.remove(taskId);
        }
    }

    public static void runDelayed(Chunk chunk, Runnable task, long delay) {
        if (delay <= 0L) {
            TyphonScheduler.run(chunk, task);
        }
        if (TyphonMultithreading.isPaperMultithread) {
            if (chunk == null) {
                Bukkit.getGlobalRegionScheduler().runDelayed(TyphonPlugin.plugin, (T _a) -> task.run(), delay);
            } else {
                Bukkit.getRegionScheduler().runDelayed(TyphonPlugin.plugin, chunk.getWorld(), chunk.getX(), chunk.getZ(), _a -> task.run(), delay);
            }
        } else {
            Bukkit.getScheduler().runTaskLater(TyphonPlugin.plugin, task, delay);
        }
    }

    public static void run(Chunk chunk, Runnable task) {
        if (TyphonMultithreading.isPaperMultithread) {
            if (chunk == null) {
                Bukkit.getGlobalRegionScheduler().run(TyphonPlugin.plugin, (T _a) -> task.run());
            } else {
                Bukkit.getRegionScheduler().run(TyphonPlugin.plugin, chunk.getWorld(), chunk.getX(), chunk.getZ(), _a -> task.run());
            }
        } else {
            Bukkit.getScheduler().runTask(TyphonPlugin.plugin, task);
        }
    }
}

