/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonQueuedHashMap;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Orientable;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.WaterMob;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class TyphonUtils {
    private static TyphonQueuedHashMap<Block, Block> highestRocklikesBlockCacheMap = new TyphonQueuedHashMap(Integer.MAX_VALUE, TyphonQueuedHashMap::getTwoDimensionalBlock);

    public static boolean isMaterialPlant(Material material) {
        String materialType = TyphonUtils.toLowerCaseDumbEdition(material.name());
        return materialType.contains("flower") || materialType.contains("sapling") || materialType.contains("_grass") || material == Material.BUSH || materialType.contains("_bush") || materialType.endsWith("_litter") || materialType.contains("mushroom") || material == Material.CACTUS || material == Material.LEAF_LITTER || material == Material.SUGAR_CANE || material == Material.BAMBOO || material == Material.KELP || materialType.contains("_leaves") || materialType.contains("mangrove") || materialType.contains("azalea") || materialType.contains("_mushroom") || materialType.contains("_tulip") || material == Material.POPPY || material == Material.DANDELION || material == Material.LILAC || material == Material.ROSE_BUSH || material == Material.PEONY || material == Material.SUNFLOWER || material == Material.LILY_OF_THE_VALLEY || material == Material.WITHER_ROSE || material == Material.PINK_PETALS || material == Material.SPORE_BLOSSOM || materialType.contains("vine") || materialType.contains("pitcher_") || materialType.contains("_dripleaf") || materialType.contains("fern") || materialType.contains("_berries");
    }

    public static boolean isBlockFlowable(Block block) {
        BlockFace[] flowableFaces;
        for (BlockFace face : flowableFaces = new BlockFace[]{BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            Block target = block.getRelative(face);
            Material targetMaterial = target.getType();
            if (!targetMaterial.isAir() && targetMaterial != Material.WATER) continue;
            return true;
        }
        return false;
    }

    public static List<Chunk> getChunksInRadius(Chunk src, double radius) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int chunkRadius = (int)Math.ceil(radius / 16.0);
        int srcX = src.getX();
        int srcZ = src.getZ();
        for (int x = -chunkRadius; x <= chunkRadius; ++x) {
            for (int z = -chunkRadius; z <= chunkRadius; ++z) {
                chunks.add(src.getWorld().getChunkAt(srcX + x, srcZ + z));
            }
        }
        return chunks;
    }

    public static Consumer<Block> getBlockFaceUpdater(Block fromBlock, Block block) {
        return TyphonUtils.getBlockFaceUpdater(block.getLocation().subtract(fromBlock.getLocation()).toVector());
    }

    public static Consumer<Block> getBlockFaceUpdater(Vector vector) {
        return block -> {
            BlockFace face = TyphonUtils.getAdequateBlockFace(vector);
            TyphonUtils.getBlockFaceUpdater(face).accept((Block)block);
        };
    }

    public static Consumer<Block> getBlockFaceUpdater(BlockFace face) {
        return block -> {
            BlockData blockData = block.getBlockData();
            if (blockData instanceof Directional) {
                Directional directional = (Directional)blockData;
                directional.setFacing(face);
                block.setBlockData((BlockData)directional);
            }
            if (blockData instanceof Orientable) {
                Orientable orientable = (Orientable)blockData;
                orientable.setAxis(TyphonUtils.getAdequateAxis(face));
                block.setBlockData((BlockData)orientable);
            }
        };
    }

    public static BlockFace getAdequateBlockFace(Block fromBlock, Block toBlock) {
        Vector diff = toBlock.getLocation().toVector().subtract(fromBlock.getLocation().toVector());
        return TyphonUtils.getAdequateBlockFace(diff);
    }

    public static Axis getAdequateAxis(BlockFace face) {
        if (Math.abs(face.getModX()) > 0) {
            return Axis.X;
        }
        if (Math.abs(face.getModZ()) > 0) {
            return Axis.Z;
        }
        return Axis.Y;
    }

    public static BlockFace getAdequateBlockFace(Vector vector) {
        double x = vector.getX();
        double z = vector.getZ();
        BlockFace face = BlockFace.DOWN;
        if (x == 0.0 && z == 0.0) {
            return face;
        }
        face = Math.abs(x) > Math.abs(z) ? (x > 0.0 ? BlockFace.EAST : BlockFace.WEST) : (z > 0.0 ? BlockFace.SOUTH : BlockFace.NORTH);
        return face;
    }

    public static int getMinimumY(World world) {
        return world.getMinHeight();
    }

    public static int getMaximumY(World world) {
        return world.getMaxHeight();
    }

    public static Location getHighestLocation(Location loc) {
        int y = loc.getWorld().getHighestBlockYAt(loc);
        return new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
    }

    public static Location getHighestOceanFloor(Location loc) {
        int y = loc.getWorld().getHighestBlockYAt(loc, HeightMap.OCEAN_FLOOR);
        return new Location(loc.getWorld(), loc.getX(), (double)y, loc.getZ());
    }

    public static List<Block> getNearByBlocks(Block baseBlock) {
        return TyphonUtils.getNearByBlocks(baseBlock, 1);
    }

    public static Location getHighestBedrock(Location loc) {
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int MAX_BEDROCK_HEIGHT = 10;
        Block block = loc.getWorld().getBlockAt(x, 1, z);
        for (int i = TyphonUtils.getMinimumY(loc.getWorld()); i <= MAX_BEDROCK_HEIGHT; ++i) {
            if (block.getType() != Material.BEDROCK) {
                return new Location(loc.getWorld(), (double)x, (double)(i - 1), (double)z);
            }
            block = block.getRelative(BlockFace.UP);
        }
        return new Location(loc.getWorld(), (double)x, (double)TyphonUtils.getMinimumY(loc.getWorld()), (double)z);
    }

    public static List<Block> getNearByBlocks(Block baseBlock, int radius) {
        ArrayList<Block> nearByBlocks = new ArrayList<Block>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if (i == 0 && j == 0 && k == 0 || Math.pow(i, 2.0) + Math.pow(j, 2.0) + Math.pow(k, 2.0) > Math.pow(radius, 2.0)) continue;
                    nearByBlocks.add(baseBlock.getRelative(i, j, k));
                }
            }
        }
        return nearByBlocks;
    }

    public static int getLavaLevel(Block block) {
        Levelled levelled = (Levelled)block.getBlockData();
        return levelled.getLevel();
    }

    public static void setLavaLevel(Block block, int level) {
        Levelled levelled = (Levelled)block.getBlockData();
        levelled.setLevel(level);
        block.setBlockData((BlockData)levelled);
    }

    public static double getTwoDimensionalDistance(Location loc1, Location loc2) {
        double x = loc1.getX() - loc2.getX();
        double z = loc1.getZ() - loc2.getZ();
        return Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
    }

    public static double getTwoDimensionalDistance(Vector vec1, Vector vec2) {
        double x = vec1.getX() - vec2.getX();
        double z = vec1.getZ() - vec2.getZ();
        return Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
    }

    public static String blockLocationTostring(Block block) {
        if (block == null) {
            return "NULL";
        }
        return block.getX() + "," + block.getY() + "," + block.getZ() + " @ " + block.getWorld().getName();
    }

    public static String readFile(File file) throws FileNotFoundException, IOException {
        String tmp;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        Object str = "";
        while ((tmp = bufferedReader.readLine()) != null) {
            str = (String)str + tmp + "\n";
        }
        return str;
    }

    public static JSONObject parseJSON(File file) throws ParseException, IOException {
        return TyphonUtils.parseJSON(TyphonUtils.readFile(file));
    }

    public static JSONObject parseJSON(String string) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject object = (JSONObject)parser.parse(string);
        return object;
    }

    public static JSONObject serializeLocationForJSON(Location loc) {
        JSONObject object = new JSONObject();
        String world = loc.getWorld().getName();
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        object.put("world", world);
        object.put("x", x);
        object.put("y", y);
        object.put("z", z);
        return object;
    }

    public static Location deserializeLocationForJSON(JSONObject locationJSON) {
        String world = (String)locationJSON.get("world");
        double x = (Double)locationJSON.get("x");
        double y = (Double)locationJSON.get("y");
        double z = (Double)locationJSON.get("z");
        return new Location(Bukkit.getWorld((String)world), x, y, z);
    }

    public static TreeType getAdequateTreeTypeForBiome(Biome biome) {
        if (biome.equals((Object)Biome.FOREST) || biome.equals((Object)Biome.FLOWER_FOREST) || biome.equals((Object)Biome.PLAINS)) {
            return TreeType.TREE;
        }
        if (biome.equals((Object)Biome.BIRCH_FOREST) || biome.equals((Object)Biome.STONY_PEAKS)) {
            return TreeType.BIRCH;
        }
        if (biome.equals((Object)Biome.DARK_FOREST)) {
            return TreeType.DARK_OAK;
        }
        if (biome.equals((Object)Biome.JUNGLE)) {
            return TreeType.JUNGLE;
        }
        if (biome.equals((Object)Biome.SWAMP)) {
            return TreeType.SWAMP;
        }
        if (biome.equals((Object)Biome.SAVANNA) || biome.equals((Object)Biome.SAVANNA_PLATEAU)) {
            return TreeType.ACACIA;
        }
        if (biome.equals((Object)Biome.TAIGA) || biome.equals((Object)Biome.SNOWY_TAIGA)) {
            return TreeType.REDWOOD;
        }
        if (biome.equals((Object)Biome.PALE_GARDEN)) {
            return TreeType.PALE_OAK;
        }
        return null;
    }

    public static void writeJSON(File file, JSONObject jsonObject) throws IOException {
        TyphonUtils.writeString(file, jsonObject.toJSONString());
    }

    public static void writeString(File file, String string) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter writer = new FileWriter(file);
        writer.write(string);
        writer.close();
    }

    public static String toLowerCaseDumbEdition(String pString) {
        if (pString != null) {
            char[] retChar = pString.toCharArray();
            for (int idx = 0; idx < pString.length(); ++idx) {
                char c = retChar[idx];
                if (c < 'A' || c > 'Z') continue;
                retChar[idx] = (char)(c | 0x20);
            }
            return new String(retChar);
        }
        return null;
    }

    public static Block getHighestNonTreeSolid(Block block) {
        return TyphonUtils.getHighestNonTreeSolid(block.getLocation());
    }

    public static Block getHighestNonTreeSolid(Location loc) {
        Block highestBlock = TyphonUtils.getHighestLocation(loc).getBlock();
        while (TyphonUtils.isMaterialTree(highestBlock.getType()) || highestBlock.isPassable()) {
            highestBlock = highestBlock.getRelative(0, -1, 0);
        }
        return highestBlock;
    }

    public static Block getRandomBlockInRange(Block block, int minRange, int maxRange) {
        Random random = new Random();
        int range = maxRange - minRange;
        if (range < 0) {
            range = 0;
        }
        int offsetRadius = (range > 0 ? random.nextInt(range) : 0) + minRange;
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int offsetX = (int)(Math.sin(angle) * (double)offsetRadius);
        int offsetZ = (int)(Math.cos(angle) * (double)offsetRadius);
        return block.getRelative(offsetX, 0, offsetZ);
    }

    public static Block getFairRandomBlockInRange(Block block, int minRange, int maxRange) {
        Random random = new Random();
        int range = maxRange - minRange;
        if (range < 0) {
            range = 0;
        }
        double offset = (double)range * (1.0 - Math.pow(Math.random(), 2.0)) + (double)minRange;
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int offsetX = (int)(Math.sin(angle) * offset);
        int offsetZ = (int)(Math.cos(angle) * offset);
        return block.getRelative(offsetX, 0, offsetZ);
    }

    public static Block getRandomBlockInRange(Block block, int range) {
        Random random = new Random();
        int offsetRadius = random.nextInt(range);
        double angle = random.nextDouble() * 2.0 * Math.PI;
        int offsetX = (int)(Math.sin(angle) * (double)offsetRadius);
        int offsetZ = (int)(Math.cos(angle) * (double)offsetRadius);
        return block.getRelative(offsetX, 0, offsetZ);
    }

    public static void stackTraceMe() {
        try {
            throw new Exception("manually triggered stacktrace");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static long getBlockUpdatesPerSecond() {
        World world = (World)Bukkit.getWorlds().get(0);
        Location spawnLoc = world.getSpawnLocation();
        Location baseLocation = new Location(world, spawnLoc.getX(), (double)world.getMinHeight(), spawnLoc.getZ());
        Block baseBlock = baseLocation.getBlock();
        Material baseBlockMaterial = baseBlock.getType();
        long blockUpdateStartTime = System.nanoTime();
        baseLocation.getBlock().setType(Material.LAVA);
        long blockUpdateEndTime = System.nanoTime();
        long elapsedNanoSecondPerBlockUpdate = blockUpdateEndTime - blockUpdateStartTime;
        baseBlock.setType(baseBlockMaterial);
        long blockUpdatesPerMilliSecond = 1000000L / elapsedNanoSecondPerBlockUpdate;
        long blockUpdatesPerSecond = blockUpdatesPerMilliSecond * 1000L;
        TyphonPlugin.logger.debug(VolcanoLogClass.CONSTRUCTION, "block update took:" + elapsedNanoSecondPerBlockUpdate + "ns.");
        TyphonPlugin.logger.debug(VolcanoLogClass.CONSTRUCTION, blockUpdatesPerSecond + " block updates per second");
        return blockUpdatesPerSecond;
    }

    public static boolean isMaterialTree(Material material) {
        if (material == Material.BEEHIVE || material == Material.SCAFFOLDING || material == Material.CREAKING_HEART) {
            return true;
        }
        String materialType = TyphonUtils.toLowerCaseDumbEdition(material.name());
        return materialType.contains("leaves") || materialType.contains("log") || materialType.contains("plank") || materialType.contains("wood") || materialType.contains("sapling") || materialType.contains("moss") || materialType.contains("eyeblossom") || materialType.contains("resin") || materialType.contains("bush") || materialType.contains("cactus") || materialType.contains("leaf") || materialType.contains("vine") || TyphonUtils.isMaterialNameContainsTreeName(materialType);
    }

    public static boolean isMaterialTreeLeaves(Material material) {
        String materialType = TyphonUtils.toLowerCaseDumbEdition(material.name());
        return materialType.contains("leaves") || materialType.contains("sapling");
    }

    private static boolean isMaterialNameContainsTreeName(String materialType) {
        return materialType.contains("oak") || materialType.contains("spruce") || materialType.contains("birch") || materialType.contains("jungle") || materialType.contains("acacia") || materialType.contains("dark_oak") || materialType.contains("crimson") || materialType.contains("warped") || materialType.contains("mangrove") || materialType.contains("cherry") || materialType.equals("creaking_heart") || materialType.contains("bamboo");
    }

    public static Block getHighestRocklikes(Block block) {
        return TyphonUtils.getHighestRocklikes(block, true);
    }

    public static Block getHighestRocklikes(Block block, boolean useCache) {
        return TyphonUtils.getHighestRocklikes(block.getLocation(), useCache);
    }

    public static Block getHighestRocklikes(Location location) {
        return TyphonUtils.getHighestRocklikes(location, true);
    }

    public static Block getHighestRocklikes(Location loc, boolean useCache) {
        Block t;
        Block block = loc.getBlock();
        if (useCache && (t = highestRocklikesBlockCacheMap.get(block)) != null) {
            return t;
        }
        Block highestBlock = TyphonUtils.getHighestLocation(loc).getBlock();
        while (!TyphonUtils.isMaterialRocklikes(highestBlock.getType()) && (highestBlock = highestBlock.getRelative(0, -1, 0)).getY() > highestBlock.getWorld().getMinHeight()) {
        }
        highestRocklikesBlockCacheMap.put(block, highestBlock);
        return highestBlock;
    }

    public static boolean isMaterialRocklikes(Material material) {
        String materialType = TyphonUtils.toLowerCaseDumbEdition(material.name());
        return materialType.contains("stone") || materialType.contains("deepslate") || materialType.contains("netherrack") || materialType.contains("granite") || materialType.contains("diorite") || materialType.contains("andesite") || materialType.contains("grass_block") || materialType.contains("dirt") || materialType.contains("rock") || materialType.contains("sand") || materialType.contains("gravel") || materialType.contains("ore") || materialType.contains("iron") || materialType.contains("gold") || materialType.contains("copper") || materialType.contains("quartz") || materialType.contains("magma") || materialType.contains("obsidian") || materialType.contains("basalt") || materialType.contains("debris") || materialType.contains("amethyst") || materialType.contains("clay") || materialType.contains("terracotta") || materialType.contains("tuff");
    }

    public static boolean containsWater(Block block) {
        return TyphonUtils.containsLiquidWater(block) || TyphonUtils.containsIce(block) || TyphonUtils.containsSnow(block);
    }

    public static void smoothBlockHeights(Block centerBlock, int radius, Material smoothMaterial) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Block b;
                int y;
                if (x * x + z * z > radius * radius) continue;
                Block targetBlock = centerBlock.getRelative(x, 0, z);
                ArrayList<Block> neighbors = new ArrayList<Block>();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dz == 0) continue;
                        Block neighbor = targetBlock.getRelative(dx, 0, dz);
                        neighbors.add(neighbor);
                    }
                }
                if (neighbors.isEmpty()) continue;
                int totalHeight = 0;
                for (Block n : neighbors) {
                    totalHeight += TyphonUtils.getHighestRocklikes(n).getY();
                }
                int averageHeight = totalHeight / neighbors.size();
                Block current = TyphonUtils.getHighestRocklikes(targetBlock);
                int currentHeight = current.getY();
                if (currentHeight > averageHeight + 1) {
                    for (y = currentHeight; y > averageHeight; --y) {
                        b = targetBlock.getWorld().getBlockAt(targetBlock.getX(), y, targetBlock.getZ());
                        b.setType(Material.AIR);
                    }
                }
                if (smoothMaterial == null || currentHeight >= averageHeight - 1) continue;
                for (y = currentHeight + 1; y <= averageHeight; ++y) {
                    b = targetBlock.getWorld().getBlockAt(targetBlock.getX(), y, targetBlock.getZ());
                    b.setType(smoothMaterial);
                }
            }
        }
    }

    public static boolean containsIce(Block block) {
        switch (block.getType()) {
            case ICE: 
            case FROSTED_ICE: 
            case PACKED_ICE: 
            case BLUE_ICE: {
                return true;
            }
        }
        return false;
    }

    public static boolean containsSnow(Block block) {
        switch (block.getType()) {
            case SNOW: 
            case SNOWBALL: 
            case SNOW_BLOCK: 
            case POWDER_SNOW: 
            case POWDER_SNOW_BUCKET: 
            case POWDER_SNOW_CAULDRON: {
                return true;
            }
        }
        return false;
    }

    public static void removeSeaGrass(Block baseBlock) {
        boolean isSeaGrass = false;
        switch (baseBlock.getType()) {
            case KELP: 
            case KELP_PLANT: 
            case SEAGRASS: 
            case TALL_SEAGRASS: {
                isSeaGrass = true;
            }
        }
        if (isSeaGrass) {
            Block upperBlock = baseBlock.getRelative(BlockFace.UP);
            TyphonUtils.removeSeaGrass(upperBlock);
            baseBlock.setType(Material.WATER);
        }
    }

    public static boolean containsLiquidWater(Block block) {
        Waterlogged wlData;
        switch (block.getType()) {
            case KELP: 
            case KELP_PLANT: 
            case SEAGRASS: 
            case TALL_SEAGRASS: 
            case WATER: 
            case WATER_CAULDRON: 
            case WATER_BUCKET: 
            case BUBBLE_COLUMN: {
                return true;
            }
        }
        BlockData data = block.getBlockData();
        return data instanceof Waterlogged && (wlData = (Waterlogged)data).isWaterlogged();
    }

    public static void spawnParticleWithVelocity(Particle particle, Location loc, double radius, int count, double offsetX, double offsetY, double offsetZ) {
        World world = loc.getWorld();
        double baseX = loc.getX();
        double baseY = loc.getY();
        double baseZ = loc.getZ();
        if (radius == 0.0) {
            Location tmpLoc = loc;
            Vector vector = new Vector(offsetX, offsetY, offsetZ);
            Vector normalized = vector.normalize().multiply(-0.25);
            for (int i = 0; i < count; ++i) {
                world.spawnParticle(particle, tmpLoc, 0, offsetX, offsetY, offsetZ);
                tmpLoc.add(normalized.getX(), normalized.getY(), normalized.getZ());
            }
            return;
        }
        double radiusSquared = Math.pow(radius, 2.0);
        double referenceSphereVolume = count;
        double referenceSphereRadiusCubed = 0.238732414637843 * referenceSphereVolume;
        double referenceSphereRadius = Math.cbrt(referenceSphereRadiusCubed);
        double offset = radius / referenceSphereRadius;
        int axisRepeat = (int)(2.0 * referenceSphereRadius);
        for (int xIdx = 0; xIdx < axisRepeat; ++xIdx) {
            for (int yIdx = 0; yIdx < axisRepeat; ++yIdx) {
                for (int zIdx = 0; zIdx < axisRepeat; ++zIdx) {
                    double offsetXLoc = -radius + (double)xIdx * offset;
                    double offsetYLoc = -radius + (double)yIdx * offset;
                    double offsetZLoc = -radius + (double)zIdx * offset;
                    double x = baseX + offsetXLoc;
                    double y = baseY + offsetYLoc;
                    double z = baseZ + offsetZLoc;
                    if (!(Math.pow(offsetXLoc, 2.0) + Math.pow(offsetYLoc, 2.0) + Math.pow(offsetZLoc, 2.0) < radiusSquared)) continue;
                    Location tmpLoc = new Location(world, x, y, z);
                    world.spawnParticle(particle, tmpLoc, 0, offsetX, offsetY, offsetZ);
                }
            }
        }
    }

    public static boolean fireTicksDontDealDamageOn(LivingEntity entity) {
        if (entity instanceof WaterMob) {
            return true;
        }
        return entity instanceof Drowned;
    }

    public static boolean hasFireProtection(LivingEntity entity) {
        if (entity.hasPotionEffect(PotionEffectType.FIRE_RESISTANCE)) {
            return true;
        }
        for (ItemStack stack : entity.getEquipment().getArmorContents()) {
            if (stack == null || !stack.containsEnchantment(Enchantment.FIRE_PROTECTION)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotAffectedByPoisonEffect(EntityType entityType) {
        switch (entityType) {
            case ZOMBIE: 
            case ZOMBIE_HORSE: 
            case ZOMBIE_VILLAGER: 
            case CREEPER: 
            case SKELETON: 
            case WITHER: 
            case WITHER_SKELETON: 
            case ZOMBIFIED_PIGLIN: 
            case HUSK: 
            case STRAY: 
            case DROWNED: 
            case PHANTOM: 
            case SKELETON_HORSE: 
            case SPIDER: 
            case CAVE_SPIDER: {
                return true;
            }
        }
        return false;
    }

    public static void createRisingSteam(Location location, int radius, int count) {
        TyphonUtils.createRisingSteam(location, radius, count, false);
    }

    public static void createRisingSteam(Location location, int radius, int count, boolean mute) {
        Particle type = Particle.CLOUD;
        Block upBlock = location.getBlock().getRelative(BlockFace.UP);
        Block upperUpBlock = upBlock.getRelative(BlockFace.UP);
        if (location.getBlock().getType() == Material.WATER || location.getBlock().getType() == Material.BUBBLE_COLUMN || upBlock.getType() == Material.WATER || upBlock.getType() == Material.BUBBLE_COLUMN || upperUpBlock.getType() == Material.WATER || upperUpBlock.getType() == Material.BUBBLE_COLUMN) {
            type = Particle.BUBBLE_COLUMN_UP;
            Location waterLevel = location.getWorld().getHighestBlockAt(location).getLocation().add(0.0, 1.0, 0.0);
            if (waterLevel.getY() - location.getY() < 10.0) {
                TyphonUtils.createRisingSteam(waterLevel, radius, count, mute);
            }
        }
        Location cloudSpawnTarget = TyphonUtils.getHighestRocklikes(location).getLocation().add(0.0, 0.5, 0.0);
        TyphonUtils.spawnParticleWithVelocity(type, cloudSpawnTarget, 0.0, 10, 0.0, 0.4, 0.0);
        if (!mute) {
            location.getWorld().playSound(location, Sound.BLOCK_LAVA_AMBIENT, 0.15f * (float)count, 0.0f);
            location.getWorld().playSound(location, Sound.ENTITY_WIND_CHARGE_WIND_BURST, 0.2f * (float)count, 0.0f);
        }
    }

    public static int getVEIScale(long data) {
        if ((double)data < Math.pow(10.0, 4.0)) {
            return 0;
        }
        if ((double)data <= Math.pow(10.0, 6.0)) {
            return 1;
        }
        if ((double)data <= Math.pow(10.0, 7.0)) {
            return 2;
        }
        if ((double)data <= Math.pow(10.0, 8.0)) {
            return 3;
        }
        if ((double)data <= Math.pow(10.0, 9.0)) {
            return 4;
        }
        if ((double)data <= Math.pow(10.0, 10.0)) {
            return 5;
        }
        if ((double)data <= Math.pow(10.0, 11.0)) {
            return 6;
        }
        if ((double)data <= Math.pow(10.0, 12.0)) {
            return 7;
        }
        return 8;
    }

    public static Vector calculateVelocity(Vector from, Vector to, int heightGain) {
        double maxGain;
        double gravity = 0.115;
        int endGain = to.getBlockY() - from.getBlockY();
        double horizDist = TyphonUtils.getTwoDimensionalDistance(from, to);
        int gain = heightGain;
        double d = maxGain = gain > endGain + gain ? (double)gain : (double)(endGain + gain);
        if (maxGain < 0.0) {
            maxGain = 0.0;
        }
        double a = -horizDist * horizDist / (4.0 * maxGain);
        double b = horizDist;
        double c = -endGain;
        double slope = -b / (2.0 * a) - Math.sqrt(b * b - 4.0 * a * c) / (2.0 * a);
        double vy = Math.sqrt(maxGain * gravity);
        double vh = vy / slope;
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        double mag = Math.sqrt(dx * dx + dz * dz);
        double dirx = (double)dx / mag;
        double dirz = (double)dz / mag;
        if (mag == 0.0) {
            dirx = 0.0;
            dirz = 0.0;
        }
        double vx = vh * dirx;
        double vz = vh * dirz;
        return new Vector(vx, vy, vz);
    }

    public static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static List<File> getAllChunkFiles(World world) {
        File regionDirectory = new File(world.getWorldFolder(), "region");
        File[] regions = regionDirectory.listFiles();
        List<File> regionFiles = Arrays.stream(regions).filter(file -> !file.isDirectory() && file.getName().endsWith(".mca")).collect(Collectors.toList());
        return regionFiles;
    }

    public static long getChunkCount(World world) {
        List<File> regionFiles = TyphonUtils.getAllChunkFiles(world);
        return regionFiles.size();
    }

    public static long getWorldArea(World world) {
        return TyphonUtils.getChunkCount(world) * 16L * 16L;
    }
}

