/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TyphonWorldGuardUtils {
    private static TyphonWorldGuardUtils instance;
    private final Plugin plugin;
    private boolean worldGuardEnabled = false;
    private boolean respectRegions = true;
    private StateFlag BUILD_FLAG;
    private WorldGuardPlugin worldGuardPlugin;

    private TyphonWorldGuardUtils(Plugin plugin) {
        this.plugin = plugin;
        try {
            Class.forName("com.sk89q.worldguard.WorldGuard");
            this.BUILD_FLAG = (StateFlag)WorldGuard.getInstance().getFlagRegistry().get("build");
            this.worldGuardPlugin = WorldGuardPlugin.inst();
            this.worldGuardEnabled = this.worldGuardPlugin != null && plugin.getConfig().getBoolean("worldGuard.enable", true);
            this.respectRegions = plugin.getConfig().getBoolean("worldGuard.respectRegions", true);
            if (this.worldGuardEnabled) {
                plugin.getLogger().info("WorldGuard support enabled" + (this.respectRegions ? " (respecting regions)" : " (not respecting regions)"));
            }
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().info("WorldGuard not found - region protection disabled");
        }
    }

    public static TyphonWorldGuardUtils getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new TyphonWorldGuardUtils(plugin);
        }
        return instance;
    }

    public boolean isAllowedAt(Location location) {
        if (!this.worldGuardEnabled || !this.respectRegions) {
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
        return set.size() == 0 || this.BUILD_FLAG != null && set.testState(null, new StateFlag[]{this.BUILD_FLAG});
    }

    public boolean isAllowedAt(Player player, Location location) {
        if (!this.worldGuardEnabled || !this.respectRegions || this.worldGuardPlugin == null) {
            return true;
        }
        if (player.hasPermission(this.plugin.getConfig().getString("worldGuard.bypassPermission", "typhon.worldguard.bypass"))) {
            return true;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
        return set.size() == 0 || this.BUILD_FLAG != null && set.testState((RegionAssociable)this.worldGuardPlugin.wrapPlayer(player), new StateFlag[]{this.BUILD_FLAG});
    }

    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }
}

