/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.bomb;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBomb;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombListener;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBombsDefault;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;

public class VolcanoBombs {
    public VolcanoVent vent;
    public Map<FallingBlock, VolcanoBomb> bombMap = new HashMap<FallingBlock, VolcanoBomb>();
    public int exploderJob = -1;
    public float minBombPower = VolcanoBombsDefault.minBombPower;
    public float maxBombPower = VolcanoBombsDefault.maxBombPower;
    public int minBombRadius = VolcanoBombsDefault.minBombRadius;
    public int maxBombRadius = VolcanoBombsDefault.maxBombRadius;
    public int bombDelay = VolcanoBombsDefault.bombDelay;
    public double maxDistance = 0.0;
    public int maximumFallingBlocks = 1000;
    public int baseY = Integer.MIN_VALUE;
    boolean isBaseYConfigured = true;
    static Team bombGlowRed = null;
    static Team bombGlowGold = null;
    static Team bombGlowYellow = null;

    public static void registerBombGlowTeams() {
        if (bombGlowRed == null) {
            bombGlowRed = VolcanoBombs.getColoredTeam("bombGlowRed", NamedTextColor.RED, ChatColor.RED);
        }
        if (bombGlowGold == null) {
            bombGlowGold = VolcanoBombs.getColoredTeam("bombGlowGold", NamedTextColor.GOLD, ChatColor.GOLD);
        }
        if (bombGlowYellow == null) {
            bombGlowYellow = VolcanoBombs.getColoredTeam("bombGlowYellow", NamedTextColor.YELLOW, ChatColor.YELLOW);
        }
    }

    public static void unregisterBombGlowTeams() {
        if (bombGlowRed != null) {
            bombGlowRed.unregister();
            bombGlowRed = null;
        }
        if (bombGlowGold != null) {
            bombGlowGold.unregister();
            bombGlowGold = null;
        }
        if (bombGlowYellow != null) {
            bombGlowYellow.unregister();
            bombGlowYellow = null;
        }
    }

    public static Team getColoredTeam(String name, NamedTextColor color, ChatColor fallbackColor) {
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = scoreboardManager.getMainScoreboard();
        Team team = scoreboard.getTeam(name) != null ? scoreboard.getTeam(name) : scoreboard.registerNewTeam(name);
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        team.setCanSeeFriendlyInvisibles(true);
        team.setAllowFriendlyFire(true);
        try {
            team.color(color);
        }
        catch (Exception e) {
            team.setColor(fallbackColor);
        }
        return team;
    }

    public int getBaseY() {
        if (this.baseY == Integer.MIN_VALUE) {
            this.baseY = (int)this.vent.averageVentHeight();
        } else if (!this.isBaseYConfigured) {
            int average = (int)this.vent.averageVentHeight();
            if (average < this.baseY) {
                this.baseY = average;
            }
            this.isBaseYConfigured = true;
        }
        return this.baseY;
    }

    public void resetBaseY() {
        this.baseY = Integer.MIN_VALUE;
    }

    public VolcanoBombs(VolcanoVent vent) {
        this.vent = vent;
        Vector vector = TyphonUtils.calculateVelocity(new Vector(0, 0, 0), new Vector(0, 0, vent.craterRadius), 4);
    }

    public void initialize() {
        VolcanoBombs.registerBombGlowTeams();
        this.registerTask();
    }

    public void shutdown() {
        this.unregisterTask();
        this.cleanupAllBombs();
    }

    public void reset() {
        this.resetBaseY();
    }

    public void registerTask() {
        if (this.exploderJob < 0) {
            this.exploderJob = TyphonScheduler.registerGlobalTask(() -> this.processExploderTimer(), this.vent.getVolcano().updateRate);
        }
    }

    public void unregisterTask() {
        if (this.exploderJob >= 0) {
            TyphonScheduler.unregisterTask(this.exploderJob);
            this.exploderJob = -1;
        }
    }

    public void processExploderTimer() {
        for (VolcanoBomb bomb : this.bombMap.values()) {
            if (bomb.explodeTimer < 0) continue;
            if (bomb.explodeTimer > 0) {
                bomb.explodeTimer -= (int)this.vent.getVolcano().updateRate;
                if (bomb.explodeTimer >= 0) continue;
                bomb.explodeTimer = 0;
                continue;
            }
            bomb.explode();
            bomb.explodeTimer = -1;
        }
    }

    public void cleanupAllBombs() {
        Iterator<Map.Entry<FallingBlock, VolcanoBomb>> iterator = this.bombMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FallingBlock, VolcanoBomb> entry = iterator.next();
            FallingBlock block = entry.getKey();
            VolcanoBomb bomb = entry.getValue();
            if (!bomb.isLanded) {
                bomb.emergencyLand();
            }
            iterator.remove();
            block.remove();
        }
    }

    public Location getLaunchLocation() {
        Location hostLocation;
        if (this.vent.getType() == VolcanoVentType.FISSURE) {
            hostLocation = TyphonUtils.getHighestLocation(this.vent.selectCoreBlock().getLocation());
        } else {
            int theY = Math.max(this.vent.getSummitBlock().getY(), this.vent.location.getBlockY());
            theY = Math.max(theY, TyphonUtils.getHighestRocklikes(this.vent.location.getBlock()).getY() + 2);
            hostLocation = new Location(this.vent.location.getWorld(), this.vent.location.getX(), (double)theY, this.vent.location.getZ());
        }
        return hostLocation;
    }

    public VolcanoBomb generateBomb() {
        Location hostLocation = this.getLaunchLocation();
        return this.generateBomb(hostLocation);
    }

    public VolcanoBomb generateBomb(Location hostLocation) {
        if (Math.random() < 0.95) {
            VolcanoBomb bomb = this.tryConeBuildingBomb();
            if (bomb == null) {
                bomb = this.generateRandomBomb(hostLocation);
            }
            return bomb;
        }
        return this.generateRandomBomb(hostLocation);
    }

    public VolcanoBomb generateRandomBomb(Location hostLocation) {
        double multiplier = this.vent.erupt.getStyle().bombMultiplier;
        if (multiplier < 0.0) {
            return null;
        }
        double maxRadius = (1.25 + Math.random()) * (double)hostLocation.getWorld().getHighestBlockYAt(hostLocation) * Math.pow(1.1, multiplier);
        double minRadius = Math.max(this.vent.craterRadius, 20);
        Block destination = TyphonUtils.getHighestRocklikes(TyphonUtils.getFairRandomBlockInRange(hostLocation.getBlock(), (int)minRadius, (int)maxRadius));
        float bombPower = (float)VolcanoMath.getZeroFocusedRandom(0.0) * (this.maxBombPower - this.minBombPower) + this.minBombPower;
        int bombRadius = (int)(Math.floor(VolcanoMath.getZeroFocusedRandom() * (double)(this.maxBombRadius - this.minBombRadius)) + (double)this.minBombRadius);
        return this.generateBombToDestination(hostLocation, destination.getLocation(), bombPower, bombRadius, this.bombDelay);
    }

    public VolcanoBomb generateBombToDestination(Location destination, int bombRadius) {
        Location hostLocation = this.getLaunchLocation();
        float bombPower = (float)VolcanoMath.getZeroFocusedRandom() * (this.maxBombPower - this.minBombPower) + this.minBombPower;
        return this.generateBombToDestination(hostLocation, destination, bombPower, bombRadius, this.bombDelay);
    }

    public VolcanoBomb generateBombToDestination(Location destination) {
        Random random = new Random();
        int bombRadius = (int)(Math.floor(random.nextDouble() * (double)(this.maxBombRadius - this.minBombRadius)) + (double)this.minBombRadius);
        return this.generateBombToDestination(destination, bombRadius);
    }

    public double distanceHeightRatio() {
        double silicateLevel = this.vent.lavaFlow.settings.silicateLevel;
        double ratio = Math.min(Math.max(0.0, (silicateLevel - 0.45) / 0.24999999999999994), 1.0);
        return (Math.sqrt(3.0) - 1.0) * (1.0 - ratio) + 1.0;
    }

    public double getEffectiveConeY() {
        int baseY = this.getBaseY();
        int minimumScaffoldBombRadius = this.vent.getRadius() * 2;
        double minimumScaffoldConeHeight = (double)minimumScaffoldBombRadius / this.distanceHeightRatio();
        double minimumRequiredSummitHeight = (double)baseY + minimumScaffoldConeHeight;
        double fakeConeHeight = (double)this.vent.getRadius() / this.distanceHeightRatio();
        double summitBlockTargetHeight = (double)this.vent.getSummitBlock().getY() + fakeConeHeight;
        return Math.max(minimumRequiredSummitHeight, summitBlockTargetHeight);
    }

    public int getEffectiveConeHeight() {
        return (int)(this.getEffectiveConeY() - (double)this.getBaseY());
    }

    public double getAdequateHeightFromDistance(double distance) {
        return this.getEffectiveConeY() - distance / this.distanceHeightRatio();
    }

    public VolcanoBomb tryConeBuildingBomb() {
        int maxCount = 100;
        for (int i = 0; i < maxCount; ++i) {
            VolcanoBomb bomb = this.generateConeBuildingBomb();
            if (bomb == null) continue;
            return bomb;
        }
        this.vent.getVolcano().logger.debug(VolcanoLogClass.BOMB, "Failed to generate cone building bomb!");
        return null;
    }

    public VolcanoBomb generateConeBuildingBomb() {
        Block randomBlock;
        double distanceFromCore;
        double adequateHeight;
        double diff;
        int maxRadius;
        int minRadius = 3;
        int baseYHeight = this.getEffectiveConeHeight();
        double coneRadius = (double)baseYHeight * this.distanceHeightRatio();
        int defaultRadius = maxRadius = (int)Math.max(coneRadius * 1.5, (double)minRadius);
        boolean outsideCinderCone = false;
        if (Math.random() < 0.001) {
            maxRadius = (int)Math.max(this.vent.getVolcanicRadius(), (double)maxRadius);
            outsideCinderCone = true;
        }
        int distance = (int)((1.0 - Math.pow(Math.random(), 2.0)) * (double)(maxRadius - minRadius) + (double)minRadius);
        if (outsideCinderCone) {
            distance = (int)(Math.pow(Math.random(), 2.0) * (double)(maxRadius - defaultRadius) + (double)defaultRadius);
        }
        if ((diff = (adequateHeight = this.getAdequateHeightFromDistance(distanceFromCore = (double)distance)) - (double)(randomBlock = TyphonUtils.getHighestRocklikes(TyphonUtils.getFairRandomBlockInRange(this.vent.getCoreBlock(), (int)distanceFromCore, (int)distanceFromCore))).getY()) > 0.0) {
            int willGrowUpTo;
            int maxCraterRadius = Math.min(25, this.vent.craterRadius);
            int maxBombRadius = 2;
            maxBombRadius = distanceFromCore < (double)maxCraterRadius ? 2 : (int)Math.min(5.0, distanceFromCore / (double)maxCraterRadius + 1.0);
            if (distanceFromCore < diff && distanceFromCore < (double)(maxCraterRadius * 5)) {
                double targetMax = Math.pow(Math.max(0.0, distanceFromCore - (double)maxCraterRadius) / (double)maxCraterRadius * 4.0, 2.0);
                maxBombRadius = (int)Math.max(Math.min(8.0 * targetMax, diff / 2.0), (double)maxBombRadius);
            }
            int radius = 0;
            radius = diff < 1.0 ? 0 : (diff <= 3.0 ? 1 : 2);
            double height = this.vent.averageVentHeight() - (double)this.vent.location.getBlockY();
            if (height / 3.0 < (double)radius) {
                radius = Math.max(1, Math.min((int)(height / 3.0), radius));
            }
            if ((double)(willGrowUpTo = randomBlock.getY() + radius) > this.vent.averageVentHeight() + 2.0) {
                radius -= willGrowUpTo - (int)(this.vent.averageVentHeight() + 2.0);
            }
            if (radius < 0) {
                return null;
            }
            return this.generateBombToDestination(randomBlock.getLocation(), radius);
        }
        if (diff < 0.0 && randomBlock.getY() > this.getBaseY() && Math.random() < 0.1 && diff < -3.0 && randomBlock.getY() > randomBlock.getWorld().getSeaLevel()) {
            randomBlock.getWorld().createExplosion(randomBlock.getLocation(), (float)(2.0 + Math.random() * 2.0));
        }
        return null;
    }

    public VolcanoBomb generateBombToDestination(Location location, Location destination, float bombPower, int bombRadius, int bombDelay) {
        VolcanoBomb bomb = new VolcanoBomb(this.vent, location, destination, bombPower, bombRadius, bombDelay);
        return bomb;
    }

    public void requestBombLaunch() {
        if (this.bombMap.size() > this.maximumFallingBlocks) {
            VolcanoBomb bomb = this.generateBomb();
            bomb.land();
        } else {
            this.launchBomb();
        }
    }

    public void launchBomb() {
        VolcanoBomb bomb = this.generateBomb();
        this.launchSpecifiedBomb(bomb);
    }

    public void launchBombToDestination(Location location) {
        VolcanoBomb bomb = this.generateBomb(location);
    }

    public void launchSpecifiedBomb(VolcanoBomb bomb) {
        bomb.launch();
        if (bomb.block != null) {
            this.bombMap.put(bomb.block, bomb);
        }
    }

    public void customLaunchSpecifiedBomb(VolcanoBomb bomb, Consumer<VolcanoBomb> launcher) {
        launcher.accept(bomb);
        if (bomb.block != null) {
            this.bombMap.put(bomb.block, bomb);
        }
    }

    public void trackAll() {
        Iterator<Map.Entry<FallingBlock, VolcanoBomb>> iterator = this.bombMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FallingBlock, VolcanoBomb> entry = iterator.next();
            FallingBlock block = entry.getKey();
            VolcanoBomb bomb = entry.getValue();
            if (block == null) continue;
            if (!block.getLocation().getChunk().isLoaded()) {
                block.getLocation().getChunk().load();
            }
            block.setTicksLived(1);
            bomb.updateTeam();
            if (bomb.isLanded) {
                bomb.coolDownFallingBlock();
                bomb.stopTrail();
                iterator.remove();
                continue;
            }
            Location bombLocation = block.getLocation();
            bomb.handleHeat();
            if (bomb.prevLocation == null) {
                bomb.prevLocation = bombLocation;
            } else {
                if (bomb.prevLocation.equals((Object)bombLocation) && VolcanoBombListener.groundChecker(bombLocation, bomb.bombRadius) || block.isOnGround()) {
                    bomb.coolDownFallingBlock();
                    bomb.land();
                    bomb.stopTrail();
                    iterator.remove();
                    continue;
                }
                bomb.prevLocation = bomb.block.getLocation();
            }
            if (bomb.lifeTime >= 60) {
                bomb.coolDownFallingBlock();
                bomb.stopTrail();
                if (bomb.block != null) {
                    TyphonBlocks.setBlockType(bomb.block.getLocation().getBlock(), Material.AIR);
                    bomb.emergencyLand();
                } else {
                    bomb.land();
                }
                iterator.remove();
                continue;
            }
            ++bomb.lifeTime;
        }
    }

    public void importConfig(JSONObject configData) {
        JSONObject bombPower = (JSONObject)configData.get("explosionPower");
        JSONObject bombRadius = (JSONObject)configData.get("radius");
        this.minBombPower = (float)((Double)bombPower.get("min")).doubleValue();
        this.maxBombPower = (float)((Double)bombPower.get("max")).doubleValue();
        this.minBombRadius = (int)((Long)bombRadius.get("min")).longValue();
        this.maxBombRadius = (int)((Long)bombRadius.get("max")).longValue();
        this.bombDelay = (int)((Long)configData.get("delay")).longValue();
        this.maxDistance = (Double)((Object)configData.getOrDefault("maxDistance", 0));
        this.baseY = (int)((Long)configData.get("baseY")).longValue();
        this.isBaseYConfigured = false;
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        JSONObject bombPower = new JSONObject();
        bombPower.put("min", Float.valueOf(this.minBombPower));
        bombPower.put("max", Float.valueOf(this.maxBombPower));
        JSONObject bombRadius = new JSONObject();
        bombRadius.put("min", this.minBombRadius);
        bombRadius.put("max", this.maxBombRadius);
        configData.put("explosionPower", bombPower);
        configData.put("radius", bombRadius);
        configData.put("delay", this.bombDelay);
        configData.put("maxDistance", this.maxDistance);
        configData.put("baseY", this.baseY);
        return configData;
    }
}

