/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonCommand;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoPyroclasticFlow;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoCommandUtils;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoMessage;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoVentCommandAction;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentBuilderType;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentGenesis;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VolcanoVentCommand {
    VolcanoVent vent;
    boolean isMainVent;
    String[] configNodes = new String[]{"lavaflow:delay", "lavaflow:flowed", "lavaflow:silicateLevel", "lavaflow:gasContent", "lavaflow:usePouredLava", "lavaflow:allowPickUp", "bombs:explosionPower:min", "bombs:explosionPower:max", "bombs:radius:min", "bombs:radius:max", "bombs:delay", "bombs:baseY", "erupt:style", "erupt:autoconfig", "explosion:bombs:min", "explosion:bombs:max", "explosion:scheduler:size", "explosion:scheduler:damagingSize", "vent:craterRadius", "vent:type", "vent:fissureLength", "vent:fissureAngle", "succession:enable", "succession:probability", "succession:treeProbability", "ash:fullPyroclasticFlowProbability"};

    public VolcanoVentCommand(VolcanoVent vent) {
        this.vent = vent;
        this.isMainVent = vent.equals(vent.volcano.mainVent);
    }

    public VolcanoVentCommand(VolcanoVent vent, boolean isMainVent) {
        this.vent = vent;
        this.isMainVent = isMainVent;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        int baseOffset = 2 + (this.isMainVent ? 0 : 1);
        if (args.length > baseOffset) {
            VolcanoVentCommandAction action;
            String operationName = args[baseOffset];
            if (args.length == baseOffset + 1) {
                return TyphonCommand.search(operationName, VolcanoVentCommandAction.listAll(sender));
            }
            if (args.length >= baseOffset + 2 && (action = VolcanoVentCommandAction.getAction(operationName)) != null) {
                if (action == VolcanoVentCommandAction.CONFIG) {
                    if (args.length == baseOffset + 2) {
                        return TyphonCommand.search(args[baseOffset + 1], Arrays.asList(this.configNodes));
                    }
                    if (args.length == baseOffset + 3) {
                        String[] res = new String[]{"<? value>"};
                        return Arrays.asList(res);
                    }
                } else if (action == VolcanoVentCommandAction.TREMOR) {
                    if (args.length == baseOffset + 2) {
                        String[] res = new String[]{"<? power>"};
                        return Arrays.asList(res);
                    }
                } else if (action == VolcanoVentCommandAction.STATUS) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> searchResults = new ArrayList<String>();
                        for (VolcanoVentStatus status : VolcanoVentStatus.values()) {
                            if (!status.name().startsWith(searchQuery)) continue;
                            searchResults.add(status.name());
                        }
                        return searchResults;
                    }
                } else if (action == VolcanoVentCommandAction.PYROCLAST) {
                    ArrayList<String> options = new ArrayList<String>();
                    if (args.length >= baseOffset + 2) {
                        String value;
                        String option = args[baseOffset + 1];
                        if (args.length == baseOffset + 2) {
                            if ("full".startsWith(option)) {
                                options.add("full");
                            }
                            if (option.matches("-?\\d+(\\.\\d+)?") || option.isEmpty()) {
                                options.add("<? count>");
                            }
                        } else if (args.length == baseOffset + 3 && ((value = args[baseOffset + 2]).matches("-?\\d+(\\.\\d+)?") || value.isEmpty())) {
                            options.add("<? count>");
                        }
                        return options;
                    }
                } else if (action == VolcanoVentCommandAction.STYLE) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> searchResults = new ArrayList<String>();
                        ArrayList<String> options = new ArrayList<String>();
                        options.add("crater");
                        options.add("fissure");
                        for (VolcanoEruptStyle style : VolcanoEruptStyle.values()) {
                            String name = TyphonUtils.toLowerCaseDumbEdition(style.name());
                            options.add(name);
                        }
                        for (String option : options) {
                            if (!option.startsWith(searchQuery)) continue;
                            searchResults.add(option);
                        }
                        return searchResults;
                    }
                } else if (action == VolcanoVentCommandAction.SUMMIT) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> results = new ArrayList<String>();
                        if ("reset".startsWith(searchQuery)) {
                            results.add("reset");
                        }
                        return results;
                    }
                } else if (action == VolcanoVentCommandAction.LANDSLIDE) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> results = new ArrayList<String>();
                        if ("start".startsWith(searchQuery)) {
                            results.add("start");
                        }
                        if ("setAngle".startsWith(searchQuery)) {
                            results.add("setAngle");
                        }
                        if ("config".startsWith(searchQuery)) {
                            results.add("config");
                        }
                        if ("clear".startsWith(searchQuery)) {
                            results.add("clear");
                        }
                        return results;
                    }
                } else if (action == VolcanoVentCommandAction.CALDERA) {
                    ArrayList<String> results = new ArrayList<String>();
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        if ("start".startsWith(searchQuery)) {
                            results.add("start");
                        }
                        if ("skip".startsWith(searchQuery)) {
                            results.add("skip");
                        }
                        if ("clear".startsWith(searchQuery)) {
                            results.add("clear");
                        }
                        if (searchQuery.matches("-?\\d+(\\.\\d+)?") || searchQuery.isEmpty()) {
                            results.add("<? radius>");
                        }
                        return results;
                    }
                    String radius = args[baseOffset + 1];
                    if (radius.matches("-?\\d+(\\.\\d+)?") || radius.isEmpty()) {
                        if (args.length == baseOffset + 3) {
                            results.add("<? deep>");
                        } else if (args.length == baseOffset + 4) {
                            results.add("<? oceanY>");
                        }
                        return results;
                    }
                } else if (action == VolcanoVentCommandAction.GENESIS) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> results = new ArrayList<String>();
                        if ("polygenetic".startsWith(searchQuery)) {
                            results.add("polygenetic");
                        }
                        if ("monogenetic".startsWith(searchQuery)) {
                            results.add("monogenetic");
                        }
                        return results;
                    }
                } else if (action == VolcanoVentCommandAction.LAVA_DOME) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> results = new ArrayList<String>();
                        if ("start".startsWith(searchQuery)) {
                            results.add("start");
                        }
                        if ("stop".startsWith(searchQuery)) {
                            results.add("stop");
                        }
                        if ("reset".startsWith(searchQuery)) {
                            results.add("reset");
                        }
                        if ("explode".startsWith(searchQuery)) {
                            results.add("explode");
                        }
                        return results;
                    }
                } else if (action == VolcanoVentCommandAction.BUILDER) {
                    if (args.length == baseOffset + 2) {
                        String searchQuery = args[baseOffset + 1];
                        ArrayList<String> results = new ArrayList<String>();
                        for (VolcanoVentBuilderType type : VolcanoVentBuilderType.values()) {
                            results.add(type.getName());
                        }
                        results.add("enable");
                        results.add("disable");
                        return results.stream().filter(str -> str.startsWith(searchQuery)).toList();
                    }
                    if (args.length >= baseOffset + 3) {
                        ArrayList<String> results = new ArrayList<String>();
                        results.add("<? args" + (args.length - (baseOffset + 3)) + ">");
                        return results;
                    }
                }
            }
        }
        return null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String[] newArgs = VolcanoCommandUtils.parseSubmenuCommand("subVent", args);
        String operationName = "";
        operationName = newArgs.length > 0 ? newArgs[0] : "info";
        VolcanoVentCommandAction action = VolcanoVentCommandAction.getAction(operationName);
        VolcanoMessage msg = new VolcanoMessage(this.vent.volcano, sender);
        if (action == null) {
            msg.error("Invalid Operation: " + operationName);
            return true;
        }
        if (!action.hasPermission(sender)) {
            msg.error("You don't have enough permission to run " + action.getCommand());
            return true;
        }
        switch (action) {
            case START: {
                this.vent.start();
                msg.ok("Vent " + this.vent.getName() + " is now started!");
                break;
            }
            case STOP: {
                this.vent.stop();
                msg.ok("Vent " + this.vent.getName() + " is now stopped!");
                break;
            }
            case TREMOR: {
                if (newArgs.length == 1) {
                    msg.ok("Creating tremor at " + this.vent.name);
                    this.vent.tremor.runTremorCycle();
                    break;
                }
                if (newArgs.length != 2) break;
                double power = Double.parseDouble(newArgs[1]);
                this.vent.tremor.showTremorActivity(TyphonUtils.getHighestRocklikes(this.vent.location.getBlock()), power);
                msg.ok("Creating tremor at " + this.vent.name + " with power: " + power);
                break;
            }
            case RESET: {
                this.vent.reset();
                msg.ok("Vent " + this.vent.getName() + " has been reset!");
                break;
            }
            case BUILDER: {
                if (newArgs.length < 1) break;
                if (newArgs.length == 1) {
                    Map<String, String> argsMap;
                    String type = this.vent.builder.getType() == null ? "Not configured" : this.vent.builder.getType().getName();
                    msg.info("Builder type: " + type);
                    msg.info("Enabled: " + (this.vent.builder.isRunning() ? "enabled" : "disabled"));
                    if (this.vent.builder.getType() == null || (argsMap = this.vent.builder.getArgumentMap()) == null) break;
                    msg.info("Arguments: ");
                    for (String key : argsMap.keySet()) {
                        msg.info(" - " + key + ": " + argsMap.get(key));
                    }
                    break;
                }
                String typeString = newArgs[1];
                if (typeString.equalsIgnoreCase("enable")) {
                    if (this.vent.builder.getType() == null) {
                        msg.error("Builder type is not set! Please set the builder type first.");
                        return true;
                    }
                    this.vent.builder.setEnabled(true);
                    msg.ok("Builder has been enabled");
                    return true;
                }
                if (typeString.equalsIgnoreCase("disable")) {
                    this.vent.builder.setEnabled(false);
                    msg.ok("Builder has been disabled");
                    return true;
                }
                VolcanoVentBuilderType type = VolcanoVentBuilderType.fromName(typeString);
                if (type == null) {
                    msg.error("Invalid builder type: " + typeString);
                    return true;
                }
                this.vent.builder.setType(type);
                if (newArgs.length < 3) break;
                String[] builderArgs = Arrays.copyOfRange(newArgs, 2, newArgs.length);
                if (this.vent.builder.setArguments(builderArgs)) {
                    msg.ok("Builder type has been set to " + type.getName() + " and has been enabled");
                    this.vent.builder.setEnabled(true);
                    break;
                }
                msg.error("Failed to set arguments for builder type " + type.getName());
                break;
            }
            case SUMMIT: {
                if (newArgs.length < 1) break;
                if (newArgs.length == 2 && newArgs[1].equalsIgnoreCase("reset")) {
                    this.vent.flushSummitCache();
                    sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Vent Summit] " + String.valueOf(ChatColor.GOLD) + "Summit of vent " + this.vent.name + " has been reset.");
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Vent Summit] " + String.valueOf(ChatColor.GOLD) + "Summit of vent " + this.vent.name);
                VolcanoCommandUtils.findSummitAndSendToSender(sender, this.vent);
                break;
            }
            case HELP: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Vent Command Manual");
                sender.sendMessage(VolcanoVentCommandAction.getAllManual(sender, label, this.vent.volcano.name, this.vent.name));
                break;
            }
            case CALDERA: {
                List<String> clearActions = Arrays.asList("clear", "reset");
                if (!(newArgs.length == 1 || newArgs.length >= 2 && clearActions.contains(newArgs[1].toLowerCase()))) {
                    if (this.vent.isCaldera()) {
                        msg.error("This vent already has caldera. If this is an error, run clear subcommand");
                        break;
                    }
                    if (!this.vent.caldera.canCreateCaldera()) {
                        msg.error("This vent is too small to create caldera.");
                        break;
                    }
                }
                if (newArgs.length == 1) {
                    long current = this.vent.caldera.currentRadius;
                    long total = this.vent.caldera.radius;
                    sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Caldera");
                    msg.info("Current Cycle #" + current + " - (" + current + "/" + total + ") " + String.format("%.2f", this.vent.caldera.getProgress() * 100.0) + "% Complete");
                    break;
                }
                if (newArgs.length < 2) break;
                if (newArgs[1].equalsIgnoreCase("start")) {
                    if (!this.vent.caldera.isSettedUp()) {
                        msg.error("The caldera creation settings are not configured.");
                        break;
                    }
                    this.vent.caldera.startErupt();
                    msg.ok("Plinian eruption has started.");
                    break;
                }
                if (newArgs[1].equalsIgnoreCase("skip")) {
                    if (!this.vent.caldera.isSettedUp()) {
                        msg.error("The caldera creation settings are not configured.");
                        break;
                    }
                    msg.ok("Plinian eruption has skipped.");
                    break;
                }
                if (clearActions.contains(newArgs[1].toLowerCase())) {
                    this.vent.calderaRadius = -1.0;
                    this.vent.getVolcano().trySave();
                    msg.ok("current caldera data has been cleared");
                    break;
                }
                try {
                    int radius = Integer.parseInt(newArgs[1]);
                    msg.info("caldera settings:");
                    msg.info("radius = " + radius);
                    if (newArgs.length == 2) {
                        this.vent.caldera.autoSetup(radius);
                        break;
                    }
                    int deep = Integer.parseInt(newArgs[2]);
                    msg.info("depth = " + deep);
                    if (newArgs.length == 3) {
                        this.vent.caldera.autoSetup(radius, deep);
                        break;
                    }
                    int oceanY = Integer.parseInt(newArgs[3]);
                    msg.info("oceanY = " + oceanY);
                    if (newArgs.length < 4) break;
                    this.vent.caldera.autoSetup(radius, deep, oceanY);
                }
                catch (Exception e) {
                    msg.error("Failed to parse user input.");
                }
                break;
            }
            case DELETE: {
                if (this.vent.isMainVent()) {
                    msg.error("Since this vent is main vent, you should delete the entire volcano. instead of deleting this.");
                    break;
                }
                this.vent.delete();
                msg.ok("Vent " + this.vent.name + " has been deleted!");
                break;
            }
            case QUICK_COOL: {
                this.vent.lavaFlow.cooldownAll();
                this.vent.bombs.shutdown();
                msg.ok("Cooled down all lava from vent " + this.vent.getName());
                break;
            }
            case STATUS: {
                if (newArgs.length == 2) {
                    VolcanoVentStatus prevStatus = this.vent.getStatus();
                    VolcanoVentStatus status = VolcanoVentStatus.getStatus(newArgs[1]);
                    if (status != null) {
                        this.vent.setStatus(status);
                        if (prevStatus == VolcanoVentStatus.ERUPTING && status != VolcanoVentStatus.ERUPTING) {
                            this.vent.stop();
                        } else if (prevStatus != VolcanoVentStatus.ERUPTING && status == VolcanoVentStatus.ERUPTING) {
                            this.vent.start();
                        }
                    }
                }
                msg.info("Vent Status: " + String.valueOf(this.vent.volcano.manager.getVentChatColor(this.vent)) + this.vent.getStatus().toString());
                break;
            }
            case GENESIS: {
                if (newArgs.length <= 1) {
                    msg.info("Vent Genesis Type: " + this.vent.genesis.getName());
                    if (this.vent.genesis == VolcanoVentGenesis.MONOGENETIC) {
                        msg.info(" - This vent will erupt only once.");
                        break;
                    }
                    if (this.vent.genesis != VolcanoVentGenesis.POLYGENETIC) break;
                    msg.info(" - This vent can erupt multiple time");
                    break;
                }
                String genesisTypeRaw = newArgs[1];
                VolcanoVentGenesis genesisType = VolcanoVentGenesis.getGenesisType(genesisTypeRaw);
                if (genesisType == null) {
                    msg.error("Specified genesis type does not exist!");
                    break;
                }
                this.vent.genesis = genesisType;
                msg.info("Vent Genesis Type: " + this.vent.genesis.getName());
                break;
            }
            case LANDSLIDE: {
                if (newArgs.length <= 1) {
                    msg.info("Landslide configuration");
                    msg.info(" - Angle: " + this.vent.landslide.landslideAngle);
                    msg.info(" - Configured: " + this.vent.landslide.isConfigured());
                    return true;
                }
                String landslideAction = newArgs[1];
                if (landslideAction.equalsIgnoreCase("start")) {
                    if (!this.vent.landslide.isConfigured()) {
                        msg.error("Landslide is not configured yet!");
                        return true;
                    }
                    msg.ok("Starting landslide...");
                    this.vent.landslide.start();
                    break;
                }
                if (landslideAction.equalsIgnoreCase("setAngle")) {
                    if (newArgs.length >= 3) {
                        this.vent.landslide.landslideAngle = newArgs[2].equalsIgnoreCase("auto") ? Math.random() * Math.PI * 2.0 : Double.parseDouble(newArgs[2]);
                    } else if (sender instanceof Player) {
                        Player player = (Player)sender;
                        float yaw = -1.0f * player.getLocation().getYaw();
                        yaw = (yaw % 360.0f + 360.0f) % 360.0f;
                        this.vent.landslide.landslideAngle = Math.toRadians(yaw) - 1.5707963267948966;
                    } else {
                        msg.error("This command can not be used by console without specifying angle");
                        return true;
                    }
                    msg.ok("Landslide angle has been set: " + this.vent.landslide.landslideAngle);
                    break;
                }
                if (landslideAction.equalsIgnoreCase("config")) {
                    this.vent.landslide.configure();
                    msg.ok("Landslide data has been configured.");
                    break;
                }
                if (!landslideAction.equalsIgnoreCase("clear")) break;
                this.vent.landslide.clear();
                msg.ok("Landslide data has been cleared.");
                break;
            }
            case LAVA_DOME: {
                if (newArgs.length <= 1) {
                    msg.info("Lava Dome configuration");
                    Location location = this.vent.lavadome.getBaseLocation();
                    msg.info(" - baseY: " + this.vent.lavadome.baseY);
                    msg.info(" - plumbedLava: " + this.vent.lavadome.getPlumbedLava());
                    if (location == null) {
                        msg.info("Lava Dome eruption was not configured");
                    } else {
                        double targetHeight = this.vent.lavadome.getTargetDomeHeight();
                        msg.info(" - TargetHeight: " + String.format("%.2f", targetHeight) + " (y: " + String.format("%.2f", (double)this.vent.lavadome.baseY + targetHeight) + ")");
                        msg.info(" - Basin Width : " + String.format("%.2f", this.vent.lavadome.getTargetBasin()));
                        msg.info(" - baseLocation: " + TyphonUtils.blockLocationTostring(location.getBlock()));
                    }
                    msg.info(" - ActiveFlows : " + this.vent.lavadome.domeFlowCounts());
                    return true;
                }
                String domeAction = newArgs[1];
                if (domeAction.equalsIgnoreCase("start")) {
                    msg.ok("The lavadome eruption has started.");
                    this.vent.erupt.setStyle(VolcanoEruptStyle.LAVA_DOME);
                    this.vent.start();
                    break;
                }
                if (domeAction.equalsIgnoreCase("stop")) {
                    msg.ok("The lavadome eruption has stopped.");
                    this.vent.stop();
                    break;
                }
                if (domeAction.equalsIgnoreCase("reset")) {
                    this.vent.lavadome.resetAll();
                    msg.ok("Lavadome build args have been reset.");
                    break;
                }
                if (!domeAction.equalsIgnoreCase("explode")) break;
                this.vent.lavadome.explode();
                msg.ok("Lavadome just have fractured and released pyrocalstic flows");
                break;
            }
            case SWITCH: {
                if (this.vent.isMainVent()) {
                    msg.error("This vent is already a main vent.");
                    return true;
                }
                String thisVentName = this.vent.name;
                VolcanoVent mainVent = this.vent.volcano.mainVent;
                mainVent.name = thisVentName;
                this.vent.volcano.subVents.put(thisVentName, mainVent);
                this.vent.volcano.mainVent = this.vent;
                this.vent.name = null;
                msg.info("Vent " + thisVentName + " has been switched to main vent.");
                this.vent.volcano.trySave(true);
            }
            case STYLE: {
                if (newArgs.length < 2) {
                    String isSurtsey = "";
                    if (this.vent.surtseyan.isSurtseyan()) {
                        isSurtsey = " (Surtseyan)";
                    }
                    msg.info("Vent Type: " + String.valueOf((Object)this.vent.getType()));
                    msg.info("Eruption Style: " + String.valueOf((Object)this.vent.erupt.getStyle()) + isSurtsey);
                    return true;
                }
                if (newArgs[1] == null) break;
                String type = newArgs[1];
                VolcanoEruptStyle style = VolcanoEruptStyle.getVolcanoEruptStyle(type);
                if (style != null) {
                    this.vent.erupt.setStyle(style);
                    msg.ok("Eruption Style of Vent " + this.vent.getName() + " was updated to: " + style.toString());
                    this.vent.erupt.autoConfig();
                    return true;
                }
                VolcanoVentType ventType = VolcanoVentType.fromString(type);
                if (ventType != null) {
                    this.vent.setType(ventType);
                    msg.ok("Type of Vent " + this.vent.getName() + " was updated to: " + ventType.toString());
                    return true;
                }
                msg.error("Invalid Type: " + type);
                break;
            }
            case CONFIG: {
                if (newArgs.length < 2) {
                    msg.error("Invalid usage");
                    return true;
                }
                if (newArgs[1].equalsIgnoreCase("lavaflow:delay")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.delayFlowed = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("lavaflow:delay - " + this.vent.lavaFlow.settings.delayFlowed + " ticks");
                    }
                } else if (newArgs[1].equalsIgnoreCase("lavaflow:silicateLevel")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.silicateLevel = Math.min(0.9, Math.max(0.3, Double.parseDouble(newArgs[2])));
                        }
                        msg.info("lavaflow:silicateLevel - " + this.vent.lavaFlow.settings.silicateLevel + " (" + String.format("%.2f", this.vent.lavaFlow.settings.silicateLevel * 100.0) + "%)");
                    }
                } else if (newArgs[1].equalsIgnoreCase("lavaflow:gasContent")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.gasContent = Math.min(1.0, Math.max(0.0, Double.parseDouble(newArgs[2])));
                        }
                        msg.info("lavaflow:gasContent - " + this.vent.lavaFlow.settings.gasContent + " (" + String.format("%.2f", this.vent.lavaFlow.settings.gasContent * 100.0) + "%)");
                    }
                } else if (newArgs[1].equalsIgnoreCase("lavaflow:flowed")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.flowed = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("lavaflow:flowed - " + this.vent.lavaFlow.settings.flowed + " ticks");
                    }
                } else if (newArgs[1].equalsIgnoreCase("lavaflow:usePouredLava")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.usePouredLava = Boolean.parseBoolean(newArgs[2]);
                        }
                        msg.info("lavaflow:usePouredLava - " + this.vent.lavaFlow.settings.usePouredLava);
                    }
                } else if (newArgs[1].equalsIgnoreCase("lavaflow:allowPickUp")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.allowPickUp = Boolean.parseBoolean(newArgs[2]);
                        }
                        msg.info("lavaflow:allowPickUp - " + this.vent.lavaFlow.settings.allowPickUp);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:explosionPower:min")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.bombs.minBombPower = Float.parseFloat(newArgs[2]);
                        }
                        msg.info("bombs:explosionPower:min - " + this.vent.bombs.minBombPower);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:explosionPower:max")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.bombs.maxBombPower = Float.parseFloat(newArgs[2]);
                        }
                        msg.info("bombs:explosionPower:max - " + this.vent.bombs.maxBombPower);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:radius:min")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.bombs.minBombRadius = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("bombs:radius:min - " + this.vent.bombs.minBombRadius);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:radius:max")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.bombs.maxBombRadius = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("bombs:radius:max - " + this.vent.bombs.maxBombRadius);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:delay")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.bombs.bombDelay = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("bombs:delay - " + this.vent.bombs.bombDelay);
                    }
                } else if (newArgs[1].equalsIgnoreCase("bombs:baseY")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            if (newArgs[2].toLowerCase().equalsIgnoreCase("reset")) {
                                this.vent.bombs.resetBaseY();
                            } else {
                                this.vent.bombs.baseY = Integer.parseInt(newArgs[2]);
                            }
                        }
                        msg.info("bombs:baseY - " + this.vent.bombs.baseY);
                    }
                } else if (newArgs[1].equalsIgnoreCase("erupt:style")) {
                    if (newArgs.length >= 2) {
                        VolcanoEruptStyle style;
                        if (newArgs.length == 3 && (style = VolcanoEruptStyle.getVolcanoEruptStyle(newArgs[2])) != null) {
                            this.vent.erupt.setStyle(style);
                        }
                        msg.info("erupt:style - " + this.vent.erupt.getStyle().toString());
                    }
                } else if (newArgs[1].equalsIgnoreCase("erupt:autoconfig")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3 && newArgs[2].equalsIgnoreCase("confirm")) {
                            this.vent.erupt.autoConfig();
                            msg.info("erupt:autoconfig applied!");
                        } else {
                            msg.info("run erupt:autoconfig with confirm to apply autoconfig.");
                        }
                    }
                } else if (newArgs[1].equalsIgnoreCase("explosion:bombs:min")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.explosion.settings.minBombCount = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("explosion:bombs:min - " + this.vent.explosion.settings.minBombCount);
                    }
                } else if (newArgs[1].equalsIgnoreCase("explosion:bombs:max")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.explosion.settings.maxBombCount = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("explosion:bombs:max - " + this.vent.explosion.settings.maxBombCount);
                    }
                } else if (newArgs[1].equalsIgnoreCase("explosion:scheduler:size")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.explosion.settings.explosionSize = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("explosion:scheduler:size - " + this.vent.explosion.settings.explosionSize);
                    }
                } else if (newArgs[1].equalsIgnoreCase("explosion:scheduler:damagingSize")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.explosion.settings.damagingExplosionSize = Integer.parseInt(newArgs[2]);
                        }
                        msg.info("explosion:scheduler:damagingSize - " + this.vent.explosion.settings.damagingExplosionSize);
                    }
                } else if (newArgs[1].equalsIgnoreCase("vent:craterRadius")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.setRadius(Integer.parseInt(newArgs[2]));
                            this.vent.flushCache();
                        }
                        msg.info("vent:craterRadius - " + this.vent.craterRadius);
                    }
                } else if (newArgs[1].equalsIgnoreCase("vent:fissureAngle")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            if (newArgs[2].equalsIgnoreCase("get") || newArgs[2].equalsIgnoreCase("auto")) {
                                if (sender instanceof Player) {
                                    Player player = (Player)sender;
                                    float yaw = -1.0f * player.getLocation().getYaw();
                                    yaw = (yaw % 360.0f + 360.0f) % 360.0f;
                                    this.vent.fissureAngle = Math.toRadians(yaw);
                                }
                            } else {
                                this.vent.fissureAngle = Double.parseDouble(newArgs[2]);
                            }
                            this.vent.flushCache();
                        }
                        msg.info("vent:fissureAngle - " + this.vent.fissureAngle + " (" + Math.toDegrees(this.vent.fissureAngle) + " deg)");
                    }
                } else if (newArgs[1].equalsIgnoreCase("succession:enable")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.enableSuccession = Boolean.parseBoolean(newArgs[2]);
                        }
                        msg.info("succession:enable - " + this.vent.enableSuccession);
                    }
                } else if (newArgs[1].equalsIgnoreCase("succession:probability")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.successionProbability = Double.parseDouble(newArgs[2]);
                        }
                        msg.info("succession:probability - " + this.vent.successionProbability);
                    }
                } else if (newArgs[1].equalsIgnoreCase("succession:treeProbability")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.successionTreeProbability = Double.parseDouble(newArgs[2]);
                        }
                        msg.info("succession:treeProbability - " + this.vent.successionTreeProbability);
                    }
                } else if (newArgs[1].equalsIgnoreCase("ash:fullPyroclasticFlowProbability")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.fullPyroclasticFlowProbability = Double.parseDouble(newArgs[2]);
                        }
                        msg.info("ash:fullPyroclasticFlowProbability - " + this.vent.fullPyroclasticFlowProbability);
                    }
                } else if (newArgs[1].equalsIgnoreCase("vent:fissureLength")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.fissureLength = Integer.parseInt(newArgs[2]);
                            this.vent.flushCache();
                        }
                        msg.info("vent:fissureLength - " + this.vent.fissureLength);
                    }
                } else if (newArgs[1].equalsIgnoreCase("vent:type")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            VolcanoVentType type = VolcanoVentType.fromString(newArgs[2]);
                            this.vent.setType(type);
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                float yaw = player.getLocation().getYaw();
                                yaw = (yaw % 360.0f + 360.0f) % 360.0f;
                                this.vent.fissureAngle = Math.toRadians(yaw);
                            }
                            this.vent.flushCache();
                        }
                        msg.info("vent:type - " + this.vent.getType().toString());
                    }
                } else if (newArgs[1].equalsIgnoreCase("vent:silicateLevel")) {
                    if (newArgs.length >= 2) {
                        if (newArgs.length == 3) {
                            this.vent.lavaFlow.settings.silicateLevel = Double.parseDouble(newArgs[2]);
                        }
                        msg.info("vent:silicateLevel - " + this.vent.lavaFlow.settings.silicateLevel);
                    }
                } else {
                    msg.error("Invalid config node!");
                    msg.error("Available config nodes: " + String.join((CharSequence)", ", this.configNodes));
                }
                this.vent.volcano.trySave(true);
                break;
            }
            case TELEPORT: {
                if (newArgs.length >= 2) {
                    Player player = Bukkit.getPlayer((String)newArgs[1]);
                    if (player != null) break;
                    this.vent.teleport((Entity)player);
                    msg.ok("Player " + player.getName() + " have been teleported to vent " + this.vent.getName() + " of Volcano " + this.vent.volcano.name);
                    break;
                }
                if (sender instanceof Entity) {
                    Entity senderEntity = (Entity)sender;
                    this.vent.teleport(senderEntity);
                    msg.ok("You have been teleported to vent " + this.vent.getName() + " of Volcano " + this.vent.volcano.name);
                    break;
                }
                msg.error("This command can not be used by console without specifying player name");
                break;
            }
            case PYROCLAST: {
                Player player;
                Location loc;
                String next;
                int count = 1;
                boolean isFull = false;
                VolcanoPyroclasticFlow flow = null;
                if (newArgs.length >= 2 && (next = newArgs[1]).equalsIgnoreCase("full")) {
                    isFull = true;
                    if (newArgs.length >= 3) {
                        String num = newArgs[2];
                        count = Integer.parseInt(num);
                    }
                }
                if (sender instanceof Player && this.vent.getTwoDimensionalDistance(loc = (player = (Player)sender).getLocation()) < (double)(this.vent.craterRadius * 2) && count == 1) {
                    msg.ok(String.valueOf(ChatColor.RED) + "Pyrocalstic flow just have spawned at your coords!");
                    flow = this.vent.ash.triggerPyroclasticFlow(loc.getBlock());
                }
                if (flow == null) {
                    msg.ok(String.valueOf(ChatColor.RED) + "Pyrocalstic flow just have spawned at the vent " + this.vent.getName() + "!");
                    for (int i = 0; i < count; ++i) {
                        flow = this.vent.caldera.isForming() ? this.vent.caldera.doEruptionPyroclasticFlows() : this.vent.ash.triggerPyroclasticFlow();
                        if (!isFull) continue;
                        flow.setFull(true);
                    }
                    break;
                }
                if (!isFull) break;
                flow.setFull(true);
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcano Vent Info");
                msg.info("Location: " + TyphonUtils.blockLocationTostring(this.vent.location.getBlock()));
                msg.info("Summit  : " + TyphonUtils.blockLocationTostring(this.vent.getSummitBlock()));
                msg.info("Eruption: " + (this.vent.erupt.isErupting() ? String.valueOf(ChatColor.RED) + "true" : String.valueOf(ChatColor.AQUA) + "false"));
                msg.info(" - Style: " + this.vent.erupt.getStyle().toString());
                msg.info(" - Lava : " + this.vent.isFlowingLava() + " @ " + String.format("%.2f", this.vent.longestFlowLength) + "m");
                msg.info("    Normal: " + String.format("%.2f", this.vent.longestNormalLavaFlowLength) + "m (now: " + String.format("%.2f", this.vent.currentNormalLavaFlowLength) + "m)");
                msg.info(" - Bomb : " + this.vent.isExploding() + " @ " + String.format("%.2f", this.vent.bombs.maxDistance) + "m");
                msg.info(" - Ash : " + String.format("%.2f", this.vent.longestAshNormalFlowLength) + "m (now: " + String.format("%.2f", this.vent.currentAshNormalFlowLength) + "m)");
                msg.info("Radius  : " + this.vent.getRadius());
                msg.info("Status  : " + String.valueOf(this.vent.volcano.manager.getVentChatColor(this.vent)) + this.vent.getStatus().toString());
                msg.info("C.Ejecta: " + this.vent.record.currentEjectaVolume + " blocks (VEI: " + TyphonUtils.getVEIScale(this.vent.record.currentEjectaVolume) + ")");
                msg.info("Ejecta  : " + this.vent.record.getTotalEjecta() + " blocks (VEI: " + TyphonUtils.getVEIScale(this.vent.record.getTotalEjecta()) + ")");
                msg.info("Ejecta/s: " + this.vent.lavaFlow.getProcessedBlocksPerSecond() + " blocks/s (Unhandled: " + this.vent.lavaFlow.unprocessedQueueBlocks() + ")");
                msg.info("Caldera  : " + String.valueOf(this.vent.isCaldera() ? Double.valueOf(this.vent.calderaRadius) : "None"));
                sender.sendMessage("type \"/" + label + " " + this.vent.volcano.name + " " + args[1] + (String)(args.length > 2 ? " " + args[2] : "") + " help\" for more commands.");
            }
        }
        return true;
    }
}

