/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.explosion;

import java.util.List;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.explosion.VolcanoExplosionSettings;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;

public class VolcanoExplosion {
    public VolcanoVent vent;
    public boolean enabled = true;
    public boolean running = false;
    public VolcanoExplosionSettings settings = new VolcanoExplosionSettings();
    public int scheduleID = -1;
    public int queueScheduleID = -1;
    public int queuedBombs = 0;

    public VolcanoExplosion(VolcanoVent vent) {
        this.vent = vent;
    }

    public void registerTask() {
        if (this.scheduleID < 0) {
            this.vent.volcano.logger.log(VolcanoLogClass.EXPLOSION, "Registering VolcanoExplosion for vent " + this.vent.getName());
            this.scheduleID = TyphonScheduler.registerGlobalTask(() -> {
                if (this.enabled) {
                    this.explodeQueued();
                }
            }, 1L);
        }
        if (this.queueScheduleID < 0) {
            this.queueScheduleID = TyphonScheduler.registerGlobalTask(() -> {
                if (this.enabled && this.running && !this.vent.erupt.getStyle().canFormCaldera) {
                    this.explode();
                }
            }, 5L);
        }
    }

    public void unregisterTask() {
        if (this.scheduleID >= 0) {
            this.vent.volcano.logger.log(VolcanoLogClass.EXPLOSION, "Unregistering VolcanoExplosion for vent " + this.vent.getName());
            TyphonScheduler.unregisterTask(this.scheduleID);
            TyphonScheduler.unregisterTask(this.queueScheduleID);
            this.scheduleID = -1;
            this.queueScheduleID = -1;
        }
    }

    public void initialize() {
        this.vent.volcano.logger.log(VolcanoLogClass.EXPLOSION, "Intializing VolcanoExplosion for vent " + this.vent.getName());
        this.registerTask();
    }

    public void shutdown() {
        this.vent.volcano.logger.log(VolcanoLogClass.EXPLOSION, "Shutting down VolcanoExplosion for vent " + this.vent.getName());
        this.unregisterTask();
    }

    public Location selectEruptionVent() {
        int theY = this.vent.getSummitBlock().getY();
        Location location = this.vent.location;
        if (this.vent.getType() == VolcanoVentType.FISSURE) {
            location = this.vent.selectCoreBlock().getLocation();
        }
        Block launchBlock = new Location(location.getWorld(), location.getX(), (double)theY, location.getZ()).getBlock();
        return launchBlock.getLocation();
    }

    public void explode() {
        VolcanoEruptStyle style = this.vent.erupt.getStyle();
        double bombMultiplier = style.bombMultiplier;
        int fissureLengthMultiplier = 1;
        if (this.vent.getType() == VolcanoVentType.FISSURE) {
            fissureLengthMultiplier = this.vent.fissureLength / this.vent.craterRadius;
        }
        int bombCount = (int)((Math.random() * (double)(this.settings.maxBombCount - this.settings.minBombCount) + (double)this.settings.minBombCount) * bombMultiplier * this.vent.lavaFlow.settings.gasContent * (double)fissureLengthMultiplier);
        this.explode(bombCount);
    }

    public void explode(int bombCount) {
        if (this.vent != null && this.vent.isKillSwitchActive()) {
            this.vent.kill();
            return;
        }
        this.queuedBombs += bombCount;
    }

    public void explodeQueued() {
        int bombCount = Math.min(this.settings.queueSize, this.queuedBombs);
        if (this.queuedBombs == 0) {
            return;
        }
        this.queuedBombs -= bombCount;
        boolean queueComplete = this.queuedBombs <= 0;
        Location targetVent = this.selectEruptionVent();
        this.vent.location.getWorld().createExplosion(targetVent, (float)this.settings.explosionSize, true, false);
        this.vent.location.getWorld().createExplosion(targetVent, (float)this.settings.damagingExplosionSize, false, true);
        for (int i = 0; i < bombCount; ++i) {
            this.vent.bombs.requestBombLaunch();
        }
        List<Player> players = this.vent.getPlayersInRange();
        for (Player player : players) {
            int sentientBombs;
            if (player.isFlying() || this.vent.isInVent(player.getLocation()) || (sentientBombs = (int)((double)bombCount * 0.1 * Math.random())) <= 0) continue;
            this.vent.volcano.logger.log(VolcanoLogClass.EXPLOSION, "Striking " + sentientBombs + " volcanic bombs to player " + player.getDisplayName());
            for (int i = 0; i < sentientBombs; ++i) {
                this.vent.bombs.launchBombToDestination(player.getLocation());
            }
        }
        Location targetLocation = this.vent.bombs.getLaunchLocation();
        float volume = 2.0f;
        TyphonSounds.STROMBOLIAN_ERUPTION.play(targetLocation, SoundCategory.BLOCKS, volume, 0.0f);
        if (this.vent.erupt.getStyle().bombMultiplier >= VolcanoEruptStyle.VULCANIAN.bombMultiplier) {
            TyphonSounds.VULCANIAN_ERUPTION.play(targetLocation, SoundCategory.BLOCKS, volume, 0.0f);
        }
        if (queueComplete) {
            this.vent.volcano.logger.debug(VolcanoLogClass.EXPLOSION, "bomb throwing Queue completed");
            this.runQueueComplete(targetVent);
        } else {
            this.vent.volcano.logger.debug(VolcanoLogClass.EXPLOSION, bombCount + " bombs thrown. Currently Queued: " + this.queuedBombs);
            this.vent.ash.createAshPlume();
        }
    }

    public void runQueueComplete(Location targetVent) {
        double pyroclast;
        if (this.vent != null && (pyroclast = this.vent.erupt.getStyle().getPyroclasticFlowMultiplier()) > 0.0) {
            int i = 0;
            while ((double)i < pyroclast) {
                if (Math.random() < 0.4) {
                    this.vent.ash.createAshPlume(targetVent);
                    this.vent.ash.triggerPyroclasticFlow();
                }
                ++i;
            }
        }
    }

    public void importConfig(JSONObject configData) {
        this.settings.importConfig(configData);
        this.enabled = (Boolean)configData.get("enabled");
        this.running = (Boolean)configData.get("running");
    }

    public JSONObject exportConfig() {
        JSONObject config = this.settings.exportConfig();
        config.put("enabled", this.enabled);
        config.put("running", this.running);
        return config;
    }
}

