/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoConstructionData;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoConstructionRaiseData;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoConstructionStatus;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class VolcanoConstruction {
    Volcano volcano;
    public static int blockUpdatesPerSecondsInNMS = -1;
    public static int blockUpdatesPerSecondsInBukkit = -1;

    public VolcanoConstruction(Volcano volcano) {
        this.volcano = volcano;
    }

    public static double estimateBlockUpdatesInSeconds(long blockCount, boolean useNMS) {
        if (useNMS && blockUpdatesPerSecondsInNMS < 0) {
            return (double)blockCount / (double)blockUpdatesPerSecondsInNMS;
        }
        if (!useNMS && blockUpdatesPerSecondsInBukkit < 0) {
            return (double)blockCount / (double)blockUpdatesPerSecondsInBukkit;
        }
        return -1.0;
    }

    public static int estimateConstructionProcessedBlocks(VolcanoConstructionData data) {
        int processingBlocks = data.getConstructionData().size();
        processingBlocks += data.getConstructionMaterialUpdateData().size();
        if (data instanceof VolcanoConstructionRaiseData) {
            processingBlocks += ((VolcanoConstructionRaiseData)data).raiseAmount;
        }
        return processingBlocks;
    }

    public static double estimateBlockUpdatesInSeconds(VolcanoConstructionData data, boolean useNMS) {
        return VolcanoConstruction.estimateBlockUpdatesInSeconds(VolcanoConstruction.estimateConstructionProcessedBlocks(data), useNMS);
    }

    public static <T extends VolcanoConstructionData> void runConstruction(T data, boolean useNMS) {
        boolean shouldUpdate;
        Block key;
        Map<Block, Block> constructionData = data.getConstructionData();
        Map<Block, Material> constructionMaterialData = data.getConstructionMaterialUpdateData();
        long blockUpdateInitTime = System.currentTimeMillis();
        int processingBlocks = constructionData.size() + constructionMaterialData.size();
        ArrayList<Block> entrySet = new ArrayList<Block>(constructionData.keySet());
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Block sourceBlock = key = (Block)iterator.next();
            Block destinationBlock = constructionData.get(key);
            boolean bl = shouldUpdate = destinationBlock.getY() % 16 == 0 && destinationBlock.getX() % 16 == 0 && destinationBlock.getZ() % 16 == 0;
            if (!TyphonUtils.isMaterialRocklikes(sourceBlock.getType()) && !sourceBlock.getType().isAir()) continue;
            Material replacementMaterial = Material.AIR;
            if (data instanceof VolcanoConstructionRaiseData) {
                VolcanoConstructionRaiseData raiseData = (VolcanoConstructionRaiseData)data;
                Block block = raiseData.baseBlock;
                while (block.getType() == Material.LAVA) {
                    block = block.getRelative(0, 1, 0);
                }
                if (sourceBlock.getY() <= raiseData.raiseAmount + block.getY()) {
                    replacementMaterial = Material.LAVA;
                }
            }
            BlockData blockData = sourceBlock.getBlockData();
            TyphonBlocks.setBlockType(destinationBlock, sourceBlock.getType());
            destinationBlock.setBlockData(blockData, true);
            TyphonBlocks.setBlockType(sourceBlock, replacementMaterial);
        }
        entrySet = new ArrayList<Block>(constructionMaterialData.keySet());
        iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Block destinationBlock = key = (Block)iterator.next();
            Material material = constructionMaterialData.get(key);
            shouldUpdate = destinationBlock.getY() % 16 == 0 && destinationBlock.getX() % 16 == 0 && destinationBlock.getZ() % 16 == 0;
            TyphonBlocks.setBlockType(destinationBlock, material);
        }
        long blockUpdateEndTime = System.currentTimeMillis();
        long processingInMilliseconds = blockUpdateEndTime - blockUpdateInitTime;
        double partOfSeconds = (double)processingInMilliseconds / 1000.0;
        if (partOfSeconds != 0.0) {
            if (useNMS) {
                blockUpdatesPerSecondsInNMS = (int)((double)processingBlocks / partOfSeconds);
            } else {
                blockUpdatesPerSecondsInBukkit = (int)((double)processingBlocks / partOfSeconds);
            }
        }
    }

    public static <T extends VolcanoConstructionData> void runConstructionAsync(T data, boolean useNMS, Runnable callback) {
        TyphonScheduler.run(null, () -> {
            VolcanoConstruction.runConstruction(data, useNMS);
            if (callback != null) {
                callback.run();
            }
        });
    }

    public static <T extends VolcanoConstructionData> void runConstructions(VolcanoConstructionStatus status, Iterator<T> iterator, boolean useNMS, Runnable callback, Runnable iterationCallback) {
        status.hasSubStage = false;
        if (iterator.hasNext()) {
            VolcanoConstructionData nextData = (VolcanoConstructionData)iterator.next();
            VolcanoConstruction.runConstructionAsync(nextData, useNMS, () -> {
                if (iterationCallback != null) {
                    iterationCallback.run();
                }
                if (nextData != null) {
                    TyphonScheduler.run(null, () -> {
                        status.stageComplete();
                        VolcanoConstruction.runConstructions(status, iterator, useNMS, callback, iterationCallback);
                    });
                }
            });
        } else if (callback != null) {
            callback.run();
        }
    }

    public static <T extends VolcanoConstructionData> void runConstructionGroups(VolcanoConstructionStatus status, Iterator<List<T>> iterator, boolean useNMS, Runnable callback, Runnable iterationCallback) {
        status.hasSubStage = true;
        if (iterator.hasNext()) {
            List<T> nextData = iterator.next();
            status.currentSubStage = 0;
            status.totalSubStage = nextData.size();
            for (VolcanoConstructionData data : nextData) {
                VolcanoConstruction.runConstruction(data, useNMS);
                status.subStageComplete();
            }
            TyphonScheduler.runDelayed(null, () -> {
                if (iterationCallback != null) {
                    iterationCallback.run();
                }
                status.stageComplete();
                VolcanoConstruction.runConstructionGroups(status, iterator, useNMS, callback, iterationCallback);
            }, 40L);
        } else if (callback != null) {
            callback.run();
        }
    }

    public static <T extends VolcanoConstructionData> List<List<T>> splitToGroups(Location baseLocation, List<T> data, boolean useNMS) {
        Block block = baseLocation.getBlock();
        Material material = block.getType();
        long blockUpdateStartTime = System.nanoTime();
        TyphonBlocks.setBlockType(baseLocation.getBlock(), Material.LAVA);
        long blockUpdateEndTime = System.nanoTime();
        long elapsedNanoSecondPerBlockUpdate = blockUpdateEndTime - blockUpdateStartTime;
        TyphonBlocks.setBlockType(block, material);
        long blockUpdatesPerMilliSecond = 1000000L / elapsedNanoSecondPerBlockUpdate;
        long blockUpdatesPerSecond = blockUpdatesPerMilliSecond * 1000L;
        TyphonPlugin.logger.log(VolcanoLogClass.CONSTRUCTION, "block update took:" + elapsedNanoSecondPerBlockUpdate + "ns.");
        TyphonPlugin.logger.log(VolcanoLogClass.CONSTRUCTION, blockUpdatesPerSecond + " block updates per second");
        ArrayList<List<T>> dataGroup = new ArrayList<List<T>>();
        int separatedBlocksPerGroup = (int)blockUpdatesPerSecond / 2;
        int separateGroupCount = (int)Math.ceil((double)data.size() / (double)separatedBlocksPerGroup);
        TyphonPlugin.logger.log(VolcanoLogClass.CONSTRUCTION, "Separated: " + separatedBlocksPerGroup + " block updates per second, " + separateGroupCount + " groups");
        for (int i = 0; i < separateGroupCount; ++i) {
            int max = Math.min((i + 1) * separatedBlocksPerGroup - 1, data.size());
            List<T> thisData = data.subList(i * separatedBlocksPerGroup, max);
            dataGroup.add(thisData);
        }
        return dataGroup;
    }
}

