/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class VolcanoTremor {
    public VolcanoVent vent;
    public boolean enable = true;
    public int scheduleID = -1;
    public int tremorCycleRate = 200;

    public VolcanoTremor(VolcanoVent vent) {
        this.vent = vent;
    }

    public Block getRandomTremorBlock() {
        Volcano volcano = this.vent.getVolcano();
        Random random = new Random();
        int x = this.vent.location.getBlockX() + (int)(random.nextGaussian() * (double)(this.vent.craterRadius * 2));
        int z = this.vent.location.getBlockZ() + (int)(random.nextGaussian() * (double)(this.vent.craterRadius * 2));
        Location loc = new Location(volcano.location.getWorld(), (double)x, (double)volcano.location.getWorld().getHighestBlockYAt(x, z), (double)z);
        return loc.getBlock();
    }

    public void registerTask() {
        if (this.scheduleID >= 0) {
            return;
        }
        TyphonScheduler.registerGlobalTask(() -> {
            if (!this.vent.isExploding()) {
                // empty if block
            }
        }, Math.max(1L, (long)(this.tremorCycleRate / 20) * this.vent.volcano.updateRate));
    }

    public void unregisterTask() {
        if (this.scheduleID < 0) {
            return;
        }
        TyphonScheduler.unregisterTask(this.scheduleID);
        this.scheduleID = -1;
    }

    public void initialize() {
        this.vent.volcano.logger.log(VolcanoLogClass.TREMOR, "Intializing Volcano Tremor...");
        this.registerTask();
    }

    public void shutdown() {
        this.vent.volcano.logger.log(VolcanoLogClass.TREMOR, "Shutting down Volcano Tremor...");
        this.unregisterTask();
    }

    public void runTremorCycle() {
        Volcano volcano = this.vent.getVolcano();
        if (this.shouldIDoIt()) {
            volcano.logger.debug(VolcanoLogClass.TREMOR, "Volcano Tremor Cycle Started.");
            Block block = this.getRandomTremorBlock();
            this.showTremorActivity(block, (Math.random() / 2.0 + 0.5) * this.getTremorPower());
        }
    }

    public void explosionTremor() {
        this.explosionTremor((Math.random() / 2.0 + 0.5) * this.getTremorPower(VolcanoVentStatus.ERUPTING));
    }

    public void explosionTremor(double power) {
        if (this.shouldIDoIt()) {
            this.showTremorActivity(this.getRandomTremorBlock(), power);
        }
    }

    public void tremorOnEntity(Entity entity, int tremorLength, double power) {
        Volcano volcano = this.vent.getVolcano();
        AtomicInteger loop = new AtomicInteger();
        AtomicInteger termorLength = new AtomicInteger(tremorLength * (int)volcano.updateRate);
        AtomicReference<Location> prevLocation = new AtomicReference<Location>(entity.getLocation());
        AtomicInteger scheduleID = new AtomicInteger();
        Runnable tremorRunnable = () -> {
            String name;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                name = player.getName();
            } else {
                name = entity.getType().name();
            }
            if (entity.isOnGround()) {
                float xDelta = (float)((Math.random() - 0.5) * 0.04 * power);
                float zDelta = (float)((Math.random() - 0.5) * 0.04 * power);
                float yawDelta = (float)((Math.random() - 0.5) * 0.4 * power);
                float pitchDelta = (float)((Math.random() - 0.5) * 0.4 * power);
                Location newLocation = entity.getLocation();
                if (newLocation.distance((Location)prevLocation.get()) != 0.0 && ((Location)prevLocation.get()).getYaw() != newLocation.getYaw() && ((Location)prevLocation.get()).getPitch() != newLocation.getPitch()) {
                    loop.getAndIncrement();
                } else {
                    Location location = new Location(entity.getWorld(), entity.getLocation().getX() + (double)xDelta, entity.getLocation().getY(), entity.getLocation().getZ() + (double)zDelta, entity.getLocation().getYaw() + yawDelta, entity.getLocation().getPitch() + pitchDelta);
                    if (location.getBlock().getType().isAir()) {
                        entity.teleport(location);
                    }
                }
            }
            loop.getAndIncrement();
            if (loop.get() > termorLength.get()) {
                volcano.logger.debug(VolcanoLogClass.TREMOR, name + " termor sequence Pass.");
                TyphonScheduler.unregisterTask(scheduleID.get());
            }
            prevLocation.set(entity.getLocation());
        };
        scheduleID.set(TyphonScheduler.registerGlobalTask(tremorRunnable, 1L));
    }

    public void showTremorActivity(Block block, double power) {
        Volcano volcano = this.vent.getVolcano();
        TyphonPlugin.plugin.getLogger().log(Level.FINEST, "[Volcano " + volcano.name + " Tremor] Running tremor for volcano " + volcano.name + " with power " + power + ".");
        for (Player player : Bukkit.getOnlinePlayers()) {
            int radius = (int)this.vent.longestFlowLength * 2;
            Location location = player.getLocation();
            double distance = Math.sqrt(Math.pow(location.getBlockX() - block.getX(), 2.0) + Math.pow(location.getBlockZ() - block.getZ(), 2.0));
            if (player.getWorld().getUID() != block.getWorld().getUID() || !(distance < (double)radius)) continue;
            double impactFactor = this.vent.getHeatValue(player.getLocation());
            Chunk chunk = player.getLocation().getChunk();
            Entity[] entities = chunk.getEntities();
            HashMap<Entity, Location> entityLocation = new HashMap<Entity, Location>();
            for (Entity entity : entities) {
                if (!entity.isOnGround() || !entity.getType().isAlive()) continue;
                entityLocation.put(entity, entity.getLocation());
            }
            TyphonScheduler.runDelayed(chunk, () -> {
                for (Entity entity : entities) {
                    Location prevLocation = (Location)entityLocation.get(entity);
                    if (entity == null) continue;
                    Location nowLocation = entity.getLocation();
                    if (prevLocation != null && impactFactor > 0.0 && prevLocation.distance(nowLocation) == 0.0 && prevLocation.getYaw() == nowLocation.getYaw() && prevLocation.getPitch() == nowLocation.getPitch()) {
                        this.tremorOnEntity(entity, (int)(2.0 + Math.max(Math.random() * impactFactor, 2.0)), power * impactFactor);
                    }
                    entityLocation.remove(entity);
                    entityLocation.put(entity, nowLocation);
                }
            }, 2L);
        }
    }

    public boolean shouldIDoIt() {
        Volcano volcano = this.vent.getVolcano();
        return Math.random() < this.vent.getStatus().getScaleFactor();
    }

    public double getTremorPower() {
        return this.getTremorPower(this.vent.getStatus());
    }

    public double getTremorPower(VolcanoVentStatus status) {
        switch (status) {
            case DORMANT: {
                return 0.001;
            }
            case MINOR_ACTIVITY: {
                return 0.1;
            }
            case MAJOR_ACTIVITY: {
                return 0.9;
            }
            case ERUPTING: {
                return 3.0;
            }
        }
        return 0.0;
    }
}

