/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.util.Map;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentBuilderType;

public class VolcanoVentBuilder {
    VolcanoVent vent;
    boolean isEnabled = false;
    private VolcanoVentBuilderType type;
    protected double yThreshold;
    private int taskId = -1;
    boolean autoStartEnabled = false;

    public VolcanoVentBuilder(VolcanoVent vent) {
        this.vent = vent;
    }

    public void initialize() {
        this.registerTask();
    }

    public void shutdown() {
        this.unregisterTask();
    }

    public void registerTask() {
        if (this.taskId < 0) {
            this.taskId = TyphonScheduler.registerGlobalTask(() -> {
                if (this.type != null && this.isEnabled && this.isPredicateMatch()) {
                    this.onPredicateMatch();
                }
            }, 20L);
        }
    }

    public void unregisterTask() {
        if (this.taskId >= 0) {
            TyphonScheduler.unregisterTask(this.taskId);
            this.taskId = -1;
        }
    }

    public void setType(VolcanoVentBuilderType type) {
        this.type = type;
    }

    public VolcanoVentBuilderType getType() {
        return this.type;
    }

    public boolean setArguments(String[] args) {
        return this.type.setArguments(this, args);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isRunning() {
        return this.vent != null && this.isEnabled;
    }

    private boolean isPredicateMatch() {
        return this.type.isPredicateMatch(this);
    }

    public void forcePredicateMatch() {
        this.onPredicateMatch();
    }

    private void onPredicateMatch() {
        this.type = null;
        this.isEnabled = false;
        this.vent.stop();
    }

    public Map<String, String> getArgumentMap() {
        if (this.type == null) {
            return null;
        }
        return this.type.getArgumentMap(this);
    }
}

