/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.util.HashMap;
import java.util.Map;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentBuilder;

public enum VolcanoVentBuilderType {
    Y_THRESHOLD("y_threshold");

    private String name;

    private VolcanoVentBuilderType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    boolean setArguments(VolcanoVentBuilder builder, String[] args) {
        if (this == Y_THRESHOLD && args.length > 0) {
            try {
                builder.yThreshold = Double.parseDouble(args[0]);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    Map<String, String> getArgumentMap(VolcanoVentBuilder builder) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this == Y_THRESHOLD) {
            map.put("y_threshold", String.valueOf(builder.yThreshold));
        }
        return map;
    }

    boolean isPredicateMatch(VolcanoVentBuilder builder) {
        if (this == Y_THRESHOLD) {
            return (double)builder.vent.getSummitBlock().getY() >= builder.yThreshold;
        }
        return false;
    }

    public static VolcanoVentBuilderType fromName(String name) {
        for (VolcanoVentBuilderType type : VolcanoVentBuilderType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

