/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBomb;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class VolcanoVentSurtseyan {
    VolcanoVent vent;
    int surtseyanRange = 5;

    public VolcanoVentSurtseyan(VolcanoVent vent) {
        this.vent = vent;
    }

    public boolean isBlockInSurtseyanRange(Block block) {
        return block.getY() <= block.getWorld().getSeaLevel() && block.getY() >= block.getWorld().getSeaLevel() - this.surtseyanRange && TyphonUtils.containsLiquidWater(block.getRelative(BlockFace.UP));
    }

    public boolean isCraterFilledWithSeaWater() {
        Block summitBlock = this.vent.getSummitBlock();
        Block lowestCoreOceanFloor = TyphonUtils.getHighestOceanFloor(this.vent.getLowestCoreBlock().getLocation()).getBlock();
        boolean summitIsIsland = summitBlock.getY() >= summitBlock.getWorld().getSeaLevel();
        boolean craterUnderWater = lowestCoreOceanFloor.getY() <= summitBlock.getWorld().getSeaLevel();
        boolean hasSeaWaterAbove = TyphonUtils.containsLiquidWater(lowestCoreOceanFloor.getRelative(BlockFace.UP));
        return summitIsIsland && craterUnderWater && hasSeaWaterAbove;
    }

    public boolean isSurtseyan() {
        Block summitBlock = this.vent.getSummitBlock();
        return this.isBlockInSurtseyanRange(summitBlock) || this.isCraterFilledWithSeaWater();
    }

    public boolean shouldRunSurseyan() {
        for (Block block : this.vent.getCoreBlocks()) {
            Block highest = block.getWorld().getHighestBlockAt(block.getLocation());
            Block highestRock = TyphonUtils.getHighestRocklikes(block.getLocation());
            if (highestRock.getY() < highest.getY() - 10 || block.getType() != Material.WATER || highest.getY() > block.getWorld().getSeaLevel()) continue;
            return true;
        }
        return false;
    }

    public void eruptSurtseyan(int count) {
        for (int i = 0; i < count; ++i) {
            VolcanoBomb bomb = this.vent.bombs.tryConeBuildingBomb();
            if (bomb == null) {
                bomb = this.vent.bombs.generateRandomBomb(this.vent.bombs.getLaunchLocation());
            }
            this.vent.bombs.launchSpecifiedBomb(bomb);
        }
    }
}

