/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonCommand;
import me.alex4386.plugin.typhon.TyphonDebugCommandAction;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class TyphonDebugCommand {
    public static boolean canRunDebug(CommandSender sender) {
        return sender.hasPermission("typhon.debug");
    }

    public static String[] convertToDebugNewArgs(String[] args) {
        ArrayList<String> newArgsList = new ArrayList<String>(Arrays.asList(args));
        newArgsList.remove(0);
        return newArgsList.toArray(new String[newArgsList.size()]);
    }

    public static List<String> onTabComplete(CommandSender sender, String[] newArgs) {
        if (newArgs.length == 1) {
            String searchQuery = newArgs[0];
            return TyphonCommand.search(searchQuery, TyphonDebugCommandAction.getCmdlineValues());
        }
        return null;
    }

    public static void sendMessage(CommandSender sender, String msg) {
        sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin: " + String.valueOf(ChatColor.YELLOW) + "DEBUG" + String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "]" + String.valueOf(ChatColor.RESET) + " " + msg);
    }

    public static boolean onCommand(CommandSender sender, String[] newArgs) {
        if (newArgs.length == 0) {
            sender.sendMessage(TyphonDebugCommandAction.getAllManual(sender, "/vol debug"));
            return true;
        }
        if (newArgs.length >= 1) {
            TyphonDebugCommandAction action = TyphonDebugCommandAction.getAction(newArgs[0]);
            Player player = sender instanceof Player ? (Player)sender : null;
            switch (action) {
                case TEST: {
                    TyphonDebugCommand.onTest(sender, newArgs);
                    return true;
                }
                case BLUEMAP_RERENDER: {
                    if (TyphonBlueMapUtils.getBlueMapAvailable()) {
                        if (newArgs.length >= 2) {
                            String volcanoName = newArgs[1];
                            if (TyphonPlugin.listVolcanoes.containsKey(volcanoName)) {
                                Volcano volcano = TyphonPlugin.listVolcanoes.get(volcanoName);
                                TyphonBlueMapUtils.reRenderVolcano(volcano);
                                TyphonDebugCommand.sendMessage(sender, "Rerender has queued for the volcano " + volcanoName);
                            } else {
                                TyphonDebugCommand.sendMessage(sender, "Volcano not found");
                            }
                        } else {
                            TyphonDebugCommand.sendMessage(sender, "Please specify the volcano name");
                        }
                        return true;
                    }
                    TyphonDebugCommand.sendMessage(sender, "BlueMap is not available");
                    return true;
                }
            }
            TyphonDebugCommand.sendMessage(sender, "Unknown Command");
            return true;
        }
        sender.sendMessage("Debug Command Failed: " + newArgs[0]);
        return true;
    }

    public static void onTest(CommandSender sender, String[] newArgs) {
        Player player = sender instanceof Player ? (Player)sender : null;
        TyphonDebugCommand.sendMessage(sender, "Test!");
        if (newArgs.length >= 4) {
            float powerX = Float.parseFloat(newArgs[1]);
            float powerY = Float.parseFloat(newArgs[2]);
            float powerZ = Float.parseFloat(newArgs[3]);
            if (player != null) {
                Location startLocation = player.getLocation();
                Location wantedDestination = player.getLocation().add((double)powerX, (double)powerY, (double)powerZ);
                FallingBlock block = (FallingBlock)player.getWorld().spawn(startLocation, FallingBlock.class, thisBlock -> {
                    thisBlock.getBlockState().setType(Material.GRAVEL);
                    thisBlock.setVelocity(TyphonUtils.calculateVelocity(new Vector(0, 0, 0), new Vector(powerX, powerY, powerZ), 5));
                    thisBlock.setGravity(true);
                    thisBlock.setInvulnerable(true);
                    thisBlock.setDropItem(false);
                });
                AtomicInteger i = new AtomicInteger();
                Location[] prevLocation = new Location[]{player.getLocation()};
                AtomicReference<Location> highestLocation = new AtomicReference<Location>(player.getLocation());
                boolean startup = false;
                if (newArgs.length == 5) {
                    startup = Boolean.parseBoolean(newArgs[4]);
                }
                boolean finalStartup = startup;
                i.set(TyphonScheduler.registerGlobalTask(() -> {
                    Location location = block.getLocation();
                    double offsetX = location.getX() - prevLocation[0].getX();
                    double offsetY = location.getY() - prevLocation[0].getY();
                    double offsetZ = location.getZ() - prevLocation[0].getZ();
                    if (block.isOnGround() || block.isDead() || offsetX == 0.0 && offsetY == 0.0 && offsetZ == 0.0 || location.getBlockY() == startLocation.getBlockY() && finalStartup && location.distance(startLocation) > 10.0) {
                        Location destination = block.getLocation();
                        TyphonDebugCommand.sendMessage(sender, "FINAL");
                        TyphonDebugCommand.sendMessage(sender, TyphonUtils.blockLocationTostring(destination.getBlock()));
                        TyphonDebugCommand.sendMessage(sender, "Distance Travelled");
                        TyphonDebugCommand.sendMessage(sender, "x: " + (destination.getX() - startLocation.getX()));
                        TyphonDebugCommand.sendMessage(sender, "y: " + (destination.getY() - startLocation.getY()));
                        TyphonDebugCommand.sendMessage(sender, "z: " + (destination.getZ() - startLocation.getZ()));
                        TyphonDebugCommand.sendMessage(sender, "Highest - height: " + (((Location)highestLocation.get()).getY() - startLocation.getY()));
                        TyphonDebugCommand.sendMessage(sender, TyphonUtils.blockLocationTostring(((Location)highestLocation.get()).getBlock()));
                        TyphonScheduler.unregisterTask(i.get());
                        block.getLocation().getBlock().setType(Material.AIR);
                    }
                    if (((Location)highestLocation.get()).getY() < location.getY()) {
                        highestLocation.set(location);
                    }
                    String data = TyphonUtils.blockLocationTostring(location.getBlock()) + (String)(prevLocation[0] != null ? " - x:" + String.format("%.2f", offsetX) + ", y:" + String.format("%.2f", offsetY) + ", z:" + String.format("%.2f", offsetZ) : "");
                    sender.sendMessage(data);
                    prevLocation[0] = location;
                }, 0L));
            }
        }
    }
}

