/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.gaia;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.gaia.GaiaChunkCoordIntPair;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoManager;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoNamer;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;

public class TyphonGaia {
    public static int bubbleRadius = 4000;
    public static List<World> enabledWorlds = new ArrayList<World>();
    public static int scheduleId = -1;
    public static long interval = 72000L;

    public static void initialize() {
        TyphonGaia.registerTask();
    }

    public static void shutdown() {
        TyphonGaia.unregisterTask();
    }

    public static void registerTask() {
        if (scheduleId == -1) {
            scheduleId = TyphonScheduler.registerGlobalTask(TyphonGaia::runVolcanoSpawn, interval);
        }
    }

    public static void unregisterTask() {
        if (scheduleId >= 0) {
            TyphonScheduler.unregisterTask(scheduleId);
            scheduleId = -1;
        }
    }

    public static void enableWorld(World world) {
        if (!enabledWorlds.contains(world)) {
            enabledWorlds.add(world);
        }
        TyphonGaia.saveConfig();
    }

    public static void disableWorld(World world) {
        if (enabledWorlds.contains(world)) {
            enabledWorlds.remove(world);
        }
        TyphonGaia.saveConfig();
    }

    public static void loadConfig(FileConfiguration config) {
        TyphonPlugin.logger.log(VolcanoLogClass.GAIA, "Loading gaia config....");
        List worldRawStrings = config.getStringList("gaia.worlds");
        enabledWorlds.clear();
        for (String worldString : worldRawStrings) {
            World world = Bukkit.getWorld((String)worldString);
            if (world == null) continue;
            enabledWorlds.add(world);
        }
        bubbleRadius = config.getInt("gaia.bubbleRadius", 4000);
        TyphonPlugin.logger.log(VolcanoLogClass.GAIA, "Loaded Gaia enabled worlds! " + enabledWorlds.size() + " worlds loaded.");
    }

    public static void saveConfig() {
        TyphonPlugin.logger.log(VolcanoLogClass.GAIA, "Saving gaia config....");
        ArrayList<String> worldRawStrings = new ArrayList<String>();
        for (World world : enabledWorlds) {
            worldRawStrings.add(world.getName());
        }
        TyphonPlugin.plugin.getConfig().set("gaia.worlds", worldRawStrings);
        TyphonPlugin.plugin.getConfig().set("gaia.bubbleRadius", (Object)bubbleRadius);
        TyphonPlugin.plugin.saveConfig();
    }

    public static long getAdequateVolcanoCount(World world) {
        long bubbleRectangle = bubbleRadius * bubbleRadius;
        long area = TyphonUtils.getWorldArea(world);
        return area / bubbleRectangle + 1L;
    }

    public static boolean isObstructingOtherVolcanosBubble(Location location) {
        for (Volcano volcano : TyphonPlugin.listVolcanoes.values()) {
            VolcanoVent nearestVent;
            if (!volcano.location.getWorld().equals((Object)location.getWorld()) || (nearestVent = volcano.manager.getNearestVent(location)) == null || !(TyphonUtils.getTwoDimensionalDistance(nearestVent.getNearestCoreBlock(location).getLocation(), location) < (double)bubbleRadius)) continue;
            return true;
        }
        return false;
    }

    public static int getRandomViewableDistance() {
        int baseRadius = 150;
        int viewableDistance = 16 * (4 + (int)(Math.random() * 3.0));
        return (baseRadius += (int)(Math.random() * 150.0)) + viewableDistance;
    }

    public static GaiaChunkCoordIntPair parseRegionFilename(String filename) {
        String extension = filename.substring(filename.lastIndexOf(".") + 1);
        if (extension.equalsIgnoreCase("mca")) {
            String name = filename.substring(0, filename.lastIndexOf("."));
            String[] parts = name.split("\\.");
            if (parts.length != 3) {
                return null;
            }
            if (!parts[0].equals("r")) {
                return null;
            }
            String xCoordRaw = parts[1];
            String zCoordRaw = parts[2];
            int xCoord = Integer.parseInt(xCoordRaw);
            int zCoord = Integer.parseInt(zCoordRaw);
            return new GaiaChunkCoordIntPair(xCoord, zCoord);
        }
        return null;
    }

    public static void runVolcanoSpawn() {
        for (World world : enabledWorlds) {
            int count = VolcanoManager.getActiveVolcanoesOnWorld(world).size();
            long adeqCount = TyphonGaia.getAdequateVolcanoCount(world);
            int diff = (int)(adeqCount - (long)count);
            if (diff <= 0) continue;
            for (int i = 0; i < diff; ++i) {
                Volcano volcano = TyphonGaia.spawnRandomVolcano(world);
                if (volcano == null) continue;
                volcano.autoStart.startVentWithGracePeriod(volcano.mainVent);
            }
        }
    }

    public static Volcano spawnRandomVolcano(World world) {
        TyphonPlugin.logger.log(VolcanoLogClass.GAIA, "Gaia is starting to create a new volcano in world " + world.getName() + "...");
        Volcano volcano = null;
        for (int i = 0; i < 999 && (volcano = TyphonGaia.trySpawnRandomVolcano(world)) == null; ++i) {
        }
        if (volcano == null) {
            return null;
        }
        TyphonPlugin.logger.log(VolcanoLogClass.GAIA, "Gaia has created a new volcano: " + volcano.name);
        return volcano;
    }

    public static Volcano spawnVolcano(Location target) {
        Block baseBlock = TyphonUtils.getHighestRocklikes(target);
        String name = VolcanoNamer.generate();
        File volcanoDir = new File(TyphonPlugin.volcanoDir, name);
        try {
            Volcano volcano = new Volcano(volcanoDir.toPath(), baseBlock.getLocation());
            VolcanoVentType type = VolcanoVentType.CRATER;
            volcano.mainVent.fissureAngle = Math.random() * 2.0 * Math.PI;
            VolcanoEruptStyle eruptStyle = VolcanoEruptStyle.HAWAIIAN;
            double silicateContent = Math.random() * 0.25 + 0.35;
            if (silicateContent >= 0.55) {
                eruptStyle = VolcanoEruptStyle.VULCANIAN;
            } else if (Math.random() < 0.2) {
                eruptStyle = VolcanoEruptStyle.STROMBOLIAN;
            }
            volcano.mainVent.setType(type);
            volcano.mainVent.erupt.setStyle(eruptStyle);
            volcano.mainVent.erupt.autoConfig(false);
            volcano.mainVent.setStatus(VolcanoVentStatus.MAJOR_ACTIVITY);
            volcano.trySave(true);
            TyphonPlugin.listVolcanoes.put(name, volcano);
            return volcano;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Volcano trySpawnRandomVolcano(World world) {
        List<File> regionFiles = TyphonUtils.getAllChunkFiles(world);
        if (regionFiles.size() == 0) {
            return null;
        }
        Collections.shuffle(regionFiles);
        GaiaChunkCoordIntPair region = TyphonGaia.parseRegionFilename(regionFiles.get(0).getName());
        if (region == null) {
            return null;
        }
        Chunk chunk = world.getChunkAt(region.x, region.z);
        int distance = TyphonGaia.getRandomViewableDistance();
        Block chunkCenter = chunk.getBlock(8, 0, 8);
        Block target = TyphonUtils.getFairRandomBlockInRange(chunkCenter, distance, distance);
        if (TyphonGaia.isObstructingOtherVolcanosBubble(target.getLocation())) {
            return null;
        }
        return TyphonGaia.spawnVolcano(target.getLocation());
    }
}

