/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import me.alex4386.plugin.typhon.TyphonCache;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonQueuedHashMap;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Animals;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.json.simple.JSONObject;

public class VolcanoGeoThermal
implements Listener {
    public Volcano volcano;
    public boolean enable = true;
    public int scheduleID = -1;
    public int geoThermalUpdateRate = 10;
    public boolean registeredEvent = false;
    public TyphonQueuedHashMap<Block, TyphonCache<Set<Block>>> undergroundBlockCache = new TyphonQueuedHashMap(500000);
    public static long undergroundBlockCacheValidity = 1000L;
    public boolean deterMobSpawn = true;
    public boolean doEvaporation = true;
    public boolean doFireTicks = true;

    public VolcanoGeoThermal(Volcano volcano) {
        this.volcano = volcano;
        this.registerEvent();
        this.registerTask();
    }

    public void registerEvent() {
        if (!this.registeredEvent) {
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)this, TyphonPlugin.plugin);
            this.registeredEvent = true;
        }
    }

    public void unregisterEvent() {
        if (this.registeredEvent) {
            PlayerDropItemEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            PlayerBucketEmptyEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            EntitySpawnEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            this.registeredEvent = false;
        }
    }

    public void runCraterGeothermal(VolcanoVent vent) {
        this.runCraterGeothermal(vent, this.getBlockToRunCraterCycle(vent));
    }

    public void runOuterCraterGeothermal(VolcanoVent vent) {
        this.runCraterGeothermal(vent, this.getBlockToRunOuterCraterCycle(vent));
    }

    public void runCraterGeothermal(VolcanoVent vent, Block block) {
        this.runCraterGeothermal(vent, block, true);
    }

    public void runCraterGeothermal(VolcanoVent vent, Block block, boolean onTop) {
        double scaleFactor = vent.getStatus().getScaleFactor();
        Location targetLoc = block.getLocation().add(0.0, 1.0, 0.0);
        scaleFactor *= 0.8 + 0.8 * Math.random();
        scaleFactor = Math.min(1.0, scaleFactor);
        boolean letOffSteam = false;
        boolean runPoison = false;
        if (vent.getStatus().isActive()) {
            if (vent.getStatus().hasElevatedActivity()) {
                if (this.doFireTicks) {
                    this.burnNearbyEntities(targetLoc, 3.0);
                }
                letOffSteam = true;
            } else {
                if (this.doFireTicks) {
                    this.burnNearbyEntities(targetLoc, 1.0);
                }
                boolean bl = letOffSteam = Math.random() < 0.3;
                if (letOffSteam) {
                    boolean bl2 = runPoison = Math.random() < 0.5;
                }
            }
        }
        if (letOffSteam) {
            this.playLavaGasReleasing(targetLoc);
            if (runPoison) {
                this.runVolcanicGas(block.getLocation());
            }
        }
        if (vent.getStatus().hasElevatedActivity()) {
            Block upperBlock = block.getRelative(BlockFace.UP);
            if (letOffSteam) {
                if (onTop) {
                    this.triggerUndergroundsCraterGeothermal(vent, block);
                }
                if ((runPoison || Math.random() < scaleFactor) && this.doEvaporation) {
                    vent.volcano.metamorphism.evaporateBlock(block);
                    vent.volcano.metamorphism.evaporateBlock(upperBlock);
                }
            }
            if (!VolcanoComposition.isVolcanicRock(block.getType())) {
                vent.volcano.metamorphism.metamorphoseBlock(block, true);
            }
            if (TyphonUtils.isMaterialTree(upperBlock.getType())) {
                if (vent.isInVent(upperBlock.getLocation())) {
                    vent.volcano.metamorphism.removeTree(upperBlock);
                } else {
                    vent.volcano.metamorphism.killTree(upperBlock);
                }
            } else if (TyphonUtils.isMaterialPlant(upperBlock.getType())) {
                vent.volcano.metamorphism.removePlant(upperBlock);
            }
        }
    }

    public void runGeoThermalCycle(VolcanoVent vent) {
        if (vent.enabled) {
            this.runCraterGeoThermalCycle(vent);
            this.runVolcanoGeoThermalCycle(vent);
        }
    }

    public double getCraterCycleCount(VolcanoVent vent) {
        double circumference = vent.getType() == VolcanoVentType.CRATER ? (double)vent.craterRadius * Math.PI * 2.0 : (double)vent.fissureLength;
        double cyclesPerTick = 20.0 / (double)this.geoThermalUpdateRate;
        double maxCount = Math.min(Math.max(1.0, circumference / 5.0), 1000.0 / cyclesPerTick);
        return maxCount;
    }

    public void runCraterGeoThermalCycle(VolcanoVent vent) {
        double thermalScale = vent.getStatus().getThermalScaleFactor();
        double maxCount = this.getCraterCycleCount(vent);
        double cycleCount = thermalScale * maxCount * Math.random();
        this.volcano.logger.debug(VolcanoLogClass.GEOTHERMAL, "Triggering " + cycleCount + " cycles on crater");
        int i = 0;
        while ((double)i < cycleCount) {
            this.runCraterGeothermal(vent);
            ++i;
        }
        int extraCount = (int)(cycleCount * vent.getStatus().getThermalScaleFactor());
        for (int i2 = 0; i2 < extraCount; ++i2) {
            this.runOuterCraterGeothermal(vent);
        }
    }

    public void runVolcanoGeoThermalCycle(VolcanoVent vent) {
        double volcanoRange = Math.PI * Math.pow(vent.getBasinLength(), 2.0);
        double radius = 10.0;
        if (vent.getType() == VolcanoVentType.CRATER) {
            radius = vent.craterRadius;
        }
        double craterRange = Math.PI * Math.pow(radius, 2.0);
        double volcanoMultiplier = Math.max(Math.min(1000.0, (volcanoRange -= Math.PI * Math.pow(vent.craterRadius, 2.0)) / craterRange), 1.0);
        double maxCount = this.getCraterCycleCount(vent) * volcanoMultiplier;
        double thermalScale = vent.getStatus().getThermalScaleFactor();
        double cycleCountPerSecond = thermalScale * maxCount * Math.random();
        double cycleCount = cycleCountPerSecond / 20.0 * (double)(20 / this.geoThermalUpdateRate);
        cycleCount = (int)cycleCount;
        this.volcano.logger.debug(VolcanoLogClass.GEOTHERMAL, "Triggering " + cycleCount + " cycles on volcano");
        if (vent.lavaFlow.hasAnyLavaFlowing()) {
            int lavaFlowCount = (int)(cycleCount / 2.0);
            List<Block> targets = vent.lavaFlow.getRandomLavaBlocks(lavaFlowCount);
            for (Block target : targets) {
                Block actualTarget = TyphonUtils.getRandomBlockInRange(target, 1, Math.max(2, (int)(2.0 + 4.0 * vent.getHeatValue(target.getLocation()))));
                this.runVolcanoGeoThermal(vent, actualTarget, false);
            }
            for (int i = 0; i < lavaFlowCount; ++i) {
                this.runVolcanoGeoThermal(vent, this.getVolcanoGeoThermalBlock(vent));
            }
        } else if (vent.isCaldera()) {
            int i = 0;
            while ((double)i < cycleCount) {
                this.runVolcanoGeoThermal(vent, this.getCalderaGeoThermalBlock(vent));
                ++i;
            }
        }
        int extraCount = (int)(cycleCount * thermalScale);
        for (int i = 0; i < extraCount; ++i) {
            this.runVolcanoGeoThermal(vent, this.getVolcanoGeoThermalBlock(vent));
        }
    }

    public Block getBlockToRunOuterCraterCycle(VolcanoVent vent) {
        double range = 50.0 * vent.getStatus().getThermalScaleFactor();
        int craterRadius = vent.getRadius();
        double offset = VolcanoMath.getZeroFocusedRandom() * range;
        Block block = TyphonUtils.getHighestRocklikes(TyphonUtils.getRandomBlockInRange(vent.getCoreBlock(), 0, (int)((double)craterRadius + offset)));
        return block;
    }

    public Block getBlockToRunCraterCycle(VolcanoVent vent) {
        return this.getBlockToRunCraterCycle(vent, this.getCraterGeoThermalRadius(vent));
    }

    public Block getBlockToRunCraterCycle(VolcanoVent vent, double geoThermalRadius) {
        int craterRadius = vent.craterRadius;
        double range = geoThermalRadius - (double)craterRadius;
        double offset = VolcanoMath.getZeroFocusedRandom() * range;
        Block block = TyphonUtils.getHighestRocklikes(TyphonUtils.getRandomBlockInRange(vent.getCoreBlock(), 0, (int)((double)craterRadius + offset)));
        return block;
    }

    public int getCraterGeoThermalRadius(VolcanoVent vent) {
        int geothermalRange = Math.min(100, (int)((double)vent.craterRadius * 2.5));
        return geothermalRange;
    }

    public Block getCalderaGeoThermalBlock(VolcanoVent vent) {
        if (!vent.isCaldera()) {
            return null;
        }
        int radius = 0;
        if (vent.getType() == VolcanoVentType.CRATER) {
            radius = vent.craterRadius;
        }
        Block block = TyphonUtils.getRandomBlockInRange(vent.getCoreBlock(), radius, (int)Math.floor(vent.calderaRadius));
        return block;
    }

    public Block getVolcanoGeoThermalBlock(VolcanoVent vent) {
        int radius = 0;
        if (vent.getType() == VolcanoVentType.CRATER) {
            radius = vent.craterRadius;
        }
        Block block = TyphonUtils.getRandomBlockInRange(vent.getCoreBlock(), radius, (int)Math.floor(vent.getBasinLength()));
        return block;
    }

    public void runVolcanoGeoThermal(VolcanoVent vent, Block block) {
        this.runVolcanoGeoThermal(vent, block, true);
    }

    public void runVolcanoGeoThermal(VolcanoVent vent, Block block, boolean allowSteam) {
        Block targetBlock = TyphonUtils.getHighestRocklikes(block);
        this.runGeothermalActivity(vent, targetBlock, allowSteam);
    }

    public void runGeothermalActivity(VolcanoVent vent, Block block, boolean allowSteam) {
        this.runGeothermalActivity(vent, block, allowSteam, true);
    }

    public void runGeothermalActivity(VolcanoVent vent, Block block, boolean allowSteam, boolean isTop) {
        double scaleFactor = vent.getStatus().getScaleFactor();
        double heatValue = this.volcano.manager.getHeatValue(block.getLocation());
        Location targetLoc = block.getLocation().add(0.0, 1.0, 0.0);
        boolean letOffSteam = false;
        boolean runPoison = false;
        boolean backToNormalBiome = false;
        if (vent.getStatus().hasElevatedActivity()) {
            letOffSteam = true;
            runPoison = Math.random() < Math.max(scaleFactor, Math.sqrt(scaleFactor) * Math.pow(Math.min(1.0, heatValue / 0.85), 2.0));
        } else if (vent.getStatus().isActive()) {
            letOffSteam = Math.random() < 0.5;
            runPoison = Math.random() < scaleFactor;
            backToNormalBiome = true;
        } else {
            backToNormalBiome = true;
        }
        if (Math.random() < heatValue && letOffSteam && allowSteam) {
            double burnRange = (double)((int)(Math.sqrt(vent.getStatus().getScaleFactor()) * 6.0)) * heatValue;
            if (isTop) {
                this.triggerUndergroundsVolcanoGeothermal(vent, block);
            }
            this.playLavaGasReleasing(targetLoc);
            if (burnRange > 0.0 && this.doFireTicks) {
                this.burnNearbyEntities(targetLoc, 3.0);
            }
            if (runPoison) {
                this.runVolcanicGas(targetLoc);
            }
            if (burnRange > 1.0) {
                Block upperBlock = block.getRelative(BlockFace.UP);
                if (this.doEvaporation) {
                    vent.volcano.metamorphism.evaporateBlock(block);
                    if (vent.isStarted()) {
                        vent.volcano.metamorphism.evaporateBlock(upperBlock);
                    }
                }
                Block treeBlock = TyphonUtils.getHighestLocation(block.getLocation()).getBlock();
                if (!VolcanoComposition.isVolcanicRock(block.getType())) {
                    vent.volcano.metamorphism.metamorphoseBlock(block, false);
                    if (TyphonUtils.isMaterialTree(upperBlock.getType())) {
                        vent.volcano.metamorphism.killTree(upperBlock);
                    } else if (TyphonUtils.isMaterialPlant(upperBlock.getType())) {
                        vent.volcano.metamorphism.removePlant(upperBlock);
                    }
                }
                double killTree = vent.getStatus().getThermalScaleFactor();
                if (Math.random() < killTree && TyphonUtils.isMaterialTree(treeBlock.getType())) {
                    vent.volcano.metamorphism.killTree(treeBlock);
                }
            }
        }
        if (backToNormalBiome && isTop) {
            this.volcano.succession.returnToNormalBiome(block);
        }
    }

    public void createTuffRing(Block block) {
        int radius = 2 + (int)(Math.random() * 3.0);
        int deep = Math.random() < 2.0 ? 1 : 2;
        double actualRadius = (Math.pow(radius, 2.0) + Math.pow(deep, 2.0)) / (double)(2 * deep);
        Block center = block.getRelative(0, radius - deep, 0);
        List<Block> tuffRingBlocks = VolcanoMath.getCylinder(block, radius, -deep);
        tuffRingBlocks.removeIf(block1 -> block.getLocation().distance(center.getLocation()) > actualRadius);
        block.getWorld().createExplosion(block.getLocation(), (float)radius, false, false);
        for (Block tuffRingBlock : tuffRingBlocks) {
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(tuffRingBlock, Material.AIR);
            Block bottomBlock = tuffRingBlock.getRelative(BlockFace.DOWN);
            if (bottomBlock.getType().isAir()) continue;
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(bottomBlock, Material.TUFF);
        }
    }

    public void triggerUndergroundsVolcanoGeothermal(VolcanoVent vent, Block block) {
        this.triggerUndergrounds(block, underBlock -> this.runUndergroundVolcanoGeothermalActivity(vent, (Block)underBlock));
    }

    public void triggerUndergroundsCraterGeothermal(VolcanoVent vent, Block block) {
        this.triggerUndergrounds(block, underBlock -> this.runUndergroundCraterGeothermalActivity(vent, (Block)underBlock));
    }

    public void triggerUndergrounds(Block block, Consumer<Block> blockConsumer) {
        Block baseBlock = block.getRelative(0, -block.getY(), 0);
        TyphonCache<Set<Object>> undergroundBlockCache = this.undergroundBlockCache.get(baseBlock);
        Set<Object> topEmptyBlocks = new HashSet();
        if (undergroundBlockCache == null || undergroundBlockCache.isExpired()) {
            Block topBlock;
            Block scanBlock = topBlock = TyphonUtils.getHighestRocklikes(block).getRelative(BlockFace.DOWN);
            while (scanBlock.getY() >= baseBlock.getY()) {
                Material type = scanBlock.getType();
                if (type != Material.AIR && TyphonUtils.isMaterialRocklikes(scanBlock.getType()) && scanBlock.getRelative(BlockFace.UP).getType().isAir()) {
                    topEmptyBlocks.add(scanBlock);
                }
                scanBlock = scanBlock.getRelative(BlockFace.DOWN);
            }
            undergroundBlockCache = new TyphonCache<Set<Object>>(topEmptyBlocks, undergroundBlockCacheValidity);
            this.undergroundBlockCache.put(baseBlock, undergroundBlockCache);
        } else {
            topEmptyBlocks = undergroundBlockCache.getTarget();
        }
        topEmptyBlocks.forEach(blockConsumer);
    }

    public void runUndergroundVolcanoGeothermalActivity(VolcanoVent vent, Block block) {
        this.runVolcanoGeoThermal(vent, block, false);
        int diggingInY = TyphonUtils.getHighestRocklikes(block).getY() - block.getY();
        if (block.getRelative(BlockFace.UP).getType().isAir()) {
            if (vent.isFlowingLava() && Math.random() < 0.25 && diggingInY > 15) {
                double distance = TyphonUtils.getTwoDimensionalDistance(block.getLocation(), vent.getNearestCoreBlock(block.getLocation()).getLocation());
                int summitY = vent.getSummitBlock().getY();
                double magmaConduitBase = (double)vent.getRadius() + (double)summitY / Math.sqrt(3.0);
                if (distance < magmaConduitBase + 10.0 * Math.random()) {
                    Block lavaTarget = block.getRelative(BlockFace.UP);
                    this.playLavaGasReleasing(lavaTarget.getLocation());
                    vent.lavaFlow.flowLava(lavaTarget);
                    return;
                }
            }
            if (diggingInY > 32) {
                double probability = (diggingInY - 32) / 32;
                if (Math.random() < probability) {
                    this.playLavaGasReleasing(block.getLocation());
                }
            }
        }
    }

    public void runUndergroundCraterGeothermalActivity(VolcanoVent vent, Block block) {
        this.runGeothermalActivity(vent, block, true, false);
        int diggingInY = TyphonUtils.getHighestRocklikes(block).getY() - block.getY();
        if (block.getRelative(BlockFace.UP).getType().isAir() && vent.isFlowingLava() && Math.random() < 0.5 && diggingInY > 15) {
            Block lavaTarget = block.getRelative(BlockFace.UP);
            vent.lavaFlow.flowLava(lavaTarget);
            return;
        }
    }

    public void playLavaGasReleasing(Location location) {
        if (Math.random() < 0.2) {
            TyphonSounds.EARTH_CRACKING.play(location, SoundCategory.BLOCKS, 0.5f, 1.0f);
        }
        location.getWorld().playSound(location, Sound.ENTITY_BREEZE_WIND_BURST, SoundCategory.BLOCKS, (float)(0.5 + Math.random() * 0.5), 0.0f);
        TyphonUtils.createRisingSteam(location, 1, 2);
    }

    public void burnNearbyEntities(Location location, double range) {
        Collection entities = location.getWorld().getNearbyEntities(location, range, range, range);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            double distance = entity.getLocation().distance(location);
            double fireTicks = Math.max(60.0, 600.0 * this.volcano.manager.getHeatValue(location) * (distance / range));
            if (!(distance < range) || entity.getMaxFireTicks() == 0) continue;
            if (location.getWorld().isClearWeather()) {
                entity.setFireTicks((int)fireTicks);
                continue;
            }
            if (!(entity instanceof LivingEntity) || TyphonUtils.hasFireProtection(livingEntity = (LivingEntity)entity) || !(fireTicks >= 1.0)) continue;
            livingEntity.damage(0.5, DamageSource.builder((DamageType)DamageType.ON_FIRE).build());
        }
    }

    public void runVolcanicGas(Location location) {
        VolcanoVent vent = this.volcano.manager.getNearestVent(location);
        if (vent == null) {
            return;
        }
        double scaleValue = Math.sqrt(vent.getStatus().getScaleFactor()) * 6.0;
        int range = (int)(scaleValue * Math.pow(vent.getHeatValue(location), 1.1));
        Collection entities = location.getWorld().getNearbyEntities(location, (double)range, (double)range, (double)range);
        for (Entity entity : entities) {
            double total;
            int acidLevel;
            double multiplier;
            double distance = entity.getLocation().distance(location);
            double intensity = distance / (double)range;
            double heatValue = this.volcano.manager.getHeatValue(location);
            double d = multiplier = Math.random() < vent.getStatus().getScaleFactor() ? 5.0 : 1.0 + Math.random() * 4.0;
            if (entity instanceof LivingEntity && distance <= (double)range) {
                EntityEquipment equipment;
                CopperGolem golem;
                CopperGolem.Oxidizing oxidizing;
                LivingEntity livingEntity = (LivingEntity)entity;
                int timespan = (int)(25.0 * scaleValue * Math.sqrt(1.0 - intensity));
                int poisonousLevel = 0;
                if (vent.getStatus().hasElevatedActivity()) {
                    double total2 = Math.min(Math.max(heatValue * multiplier, 1.0), 5.0);
                    poisonousLevel = (int)total2;
                } else if (vent.getStatus().isActive() && vent.isInVent(location)) {
                    int n = poisonousLevel = Math.random() > 0.15 ? 1 : 0;
                }
                if (poisonousLevel <= 0) continue;
                poisonousLevel = Math.max((int)((double)poisonousLevel * intensity), 1);
                PotionEffectType targetType = PotionEffectType.POISON;
                if (livingEntity.hasPotionEffect(targetType)) {
                    PotionEffect poisonEffect = livingEntity.getPotionEffect(targetType);
                    if (poisonEffect != null) {
                        int newPoisonLevel = Math.max(poisonEffect.getAmplifier(), poisonousLevel);
                        int newTimespan = poisonEffect.getDuration() + timespan;
                        livingEntity.addPotionEffect(new PotionEffect(targetType, newTimespan, newPoisonLevel));
                    }
                } else {
                    livingEntity.addPotionEffect(new PotionEffect(targetType, timespan, poisonousLevel));
                }
                if (TyphonUtils.isNotAffectedByPoisonEffect(entity.getType())) {
                    double calculateDamageWithTimespan = (double)poisonousLevel * ((double)timespan / 20.0);
                    livingEntity.damage(calculateDamageWithTimespan);
                }
                if (entity instanceof CopperGolem && !(oxidizing = (golem = (CopperGolem)entity).getOxidizing()).equals((Object)CopperGolem.Oxidizing.waxed()) && oxidizing instanceof CopperGolem.Oxidizing.AtTime) {
                    CopperGolem.Oxidizing.AtTime atTime = (CopperGolem.Oxidizing.AtTime)oxidizing;
                    long targetTime = atTime.time();
                    oxidizing = CopperGolem.Oxidizing.atTime((long)(targetTime - 5L));
                    golem.setOxidizing(oxidizing);
                }
                if ((equipment = livingEntity.getEquipment()) != null) {
                    this.doSOxDamage(equipment.getHelmet(), poisonousLevel);
                    this.doSOxDamage(equipment.getChestplate(), poisonousLevel);
                    this.doSOxDamage(equipment.getLeggings(), poisonousLevel);
                    this.doSOxDamage(equipment.getBoots(), poisonousLevel);
                    this.doSOxDamage(equipment.getItemInMainHand(), poisonousLevel);
                    this.doSOxDamage(equipment.getItemInOffHand(), poisonousLevel);
                }
                if (poisonousLevel <= 3 || !(Math.random() < (double)(poisonousLevel - 3) / 2.0)) continue;
                livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, timespan, 1));
                continue;
            }
            if (!(entity instanceof Item) || (acidLevel = (int)((total = Math.min(Math.max(heatValue * multiplier, 1.0), 5.0)) * intensity)) <= 0) continue;
            Item item = (Item)entity;
            ItemStack stack = item.getItemStack();
            this.doSOxDamage(stack, acidLevel);
        }
    }

    public void doSOxDamage(ItemStack stack, int level) {
        if (stack == null) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null && meta instanceof Damageable) {
            ((Damageable)meta).damage(this.getSOxDamageMultiplier(stack.getType()) * (double)level);
        }
    }

    public double getSOxDamageMultiplier(Material material) {
        String name = TyphonUtils.toLowerCaseDumbEdition(material.name());
        if (name.startsWith("wood")) {
            return 1.0;
        }
        if (name.startsWith("copper")) {
            return 1.25;
        }
        if (name.startsWith("iron")) {
            return 1.5;
        }
        return 0.0;
    }

    public void registerTask() {
        if (this.scheduleID == -1) {
            this.scheduleID = TyphonScheduler.registerGlobalTask(() -> {
                if (this.enable) {
                    for (VolcanoVent vent : this.volcano.manager.getVents()) {
                        this.runGeoThermalCycle(vent);
                    }
                }
            }, Math.min((long)((double)this.geoThermalUpdateRate / 20.0 * (double)this.volcano.updateRate), 1L));
        }
    }

    public void unregisterTask() {
        if (this.scheduleID != -1) {
            TyphonScheduler.unregisterTask(this.scheduleID);
            this.scheduleID = -1;
        }
    }

    public void initialize() {
        this.volcano.logger.log(VolcanoLogClass.GEOTHERMAL, "Intializing Volcano Geothermal...");
        this.registerEvent();
        this.registerTask();
    }

    public void shutdown() {
        this.volcano.logger.log(VolcanoLogClass.GEOTHERMAL, "Shutting down Volcano Geothermal...");
        this.unregisterEvent();
        this.unregisterTask();
    }

    public boolean shouldDoIt(VolcanoVent vent, Location location) {
        Random random = new Random();
        return this.enable && this.volcano.manager.getHeatValue(location) >= 1.0 - vent.getStatus().getScaleFactor() && random.nextDouble() < vent.getStatus().getScaleFactor();
    }

    @EventHandler
    public void onBlockForm(BlockFormEvent e) {
        List<VolcanoVent> vents = this.volcano.manager.getVents();
        for (VolcanoVent vent : vents) {
            String name;
            if (!this.shouldDoIt(vent, e.getBlock().getLocation()) || !(name = TyphonUtils.toLowerCaseDumbEdition(e.getBlock().getType().name())).contains("snow")) continue;
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void playerWaterFlow(PlayerBucketEmptyEvent event) {
        VolcanoVent vent;
        Material bucket = event.getBucket();
        Block clickedBlock = event.getBlockClicked();
        Block targetBlock = clickedBlock.getRelative(event.getBlockFace());
        Location loc = targetBlock.getLocation();
        if (this.volcano.manager.getHeatValue(loc) > 0.8 && (bucket == Material.WATER_BUCKET || bucket == Material.WATER || bucket == Material.POWDER_SNOW_BUCKET || bucket == Material.POWDER_SNOW)) {
            if (!this.doEvaporation) {
                return;
            }
            TyphonUtils.createRisingSteam(loc, 1, 5);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Heat of the volcano evaporated your water!");
            event.setCancelled(true);
            if (event.getPlayer().getInventory().getItemInMainHand().getType() == bucket) {
                event.getPlayer().getInventory().getItemInMainHand().setType(Material.BUCKET);
            }
        }
        if (bucket == Material.LAVA_BUCKET && (vent = this.volcano.manager.getNearestVent(targetBlock)) != null && vent.lavaFlow.settings.usePouredLava) {
            vent.lavaFlow.flowLava(targetBlock);
        }
    }

    public void importConfig(JSONObject configData) {
        this.doEvaporation = configData.getOrDefault("doEvaporation", true);
        this.doFireTicks = configData.getOrDefault("doFireTicks", true);
        this.deterMobSpawn = configData.getOrDefault("deterMobSpawn", true);
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        configData.put("doEvaporation", this.doEvaporation);
        configData.put("doFireTicks", this.doFireTicks);
        configData.put("deterMobSpawn", this.deterMobSpawn);
        return configData;
    }

    @EventHandler
    public void onEntitySpawn(EntitySpawnEvent e) {
        List<VolcanoVent> vents = this.volcano.manager.getVents();
        if (e.getEntity() instanceof Monster || e.getEntity() instanceof Animals) {
            for (VolcanoVent vent : vents) {
                if (!this.deterMobSpawn || !this.shouldDoIt(vent, e.getLocation())) continue;
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent e) {
        List<VolcanoVent> vents = this.volcano.manager.getVents();
        for (VolcanoVent vent : vents) {
            if (!this.shouldDoIt(vent, e.getPlayer().getLocation())) continue;
            switch (e.getItemDrop().getItemStack().getType()) {
                case PORKCHOP: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_PORKCHOP);
                    break;
                }
                case BEEF: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_BEEF);
                    break;
                }
                case RABBIT: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_RABBIT);
                    break;
                }
                case CHICKEN: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_CHICKEN);
                    break;
                }
                case COD: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_COD);
                    break;
                }
                case KELP: {
                    e.getItemDrop().getItemStack().setType(Material.DRIED_KELP);
                    break;
                }
                case POTATO: {
                    e.getItemDrop().getItemStack().setType(Material.BAKED_POTATO);
                    break;
                }
                case SALMON: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_SALMON);
                    break;
                }
                case LEGACY_RAW_FISH: {
                    e.getItemDrop().getItemStack().setType(Material.LEGACY_COOKED_FISH);
                    break;
                }
                case MUTTON: {
                    e.getItemDrop().getItemStack().setType(Material.COOKED_MUTTON);
                    break;
                }
            }
        }
    }
}

