/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class VolcanoManager {
    public Volcano volcano;

    VolcanoManager(Volcano volcano) {
        this.volcano = volcano;
    }

    public List<VolcanoVent> getVents() {
        ArrayList<VolcanoVent> vents = new ArrayList<VolcanoVent>();
        vents.add(this.volcano.mainVent);
        if (this.volcano.subVents != null) {
            vents.addAll(this.volcano.subVents.values());
        }
        return vents;
    }

    public boolean isInAnyVent(Block block) {
        return this.isInAnyVent(block.getLocation());
    }

    public boolean isInAnyVent(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.isInVent(loc)) continue;
            return true;
        }
        return false;
    }

    public boolean isInAnyCaldera(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.caldera.isInCalderaRange(loc)) continue;
            return true;
        }
        return false;
    }

    public boolean isInAnyFormingCaldera(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.caldera.isInCalderaRange(loc) || !vent.caldera.isForming()) continue;
            return true;
        }
        return false;
    }

    public List<Player> getAffectedPlayers() {
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        ArrayList<Player> targetPlayers = new ArrayList<Player>();
        for (Player player : onlinePlayers) {
            if (!(player instanceof Player) || !this.volcano.manager.isInAnyLavaFlowArea(player.getLocation())) continue;
            targetPlayers.add(player);
        }
        return targetPlayers;
    }

    public boolean isInAnyBombAffected(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.isBombAffected(loc)) continue;
            return true;
        }
        return false;
    }

    public long getCurrentEjecta() {
        long total = 0L;
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            total += (long)vent.record.currentEjectaVolume;
        }
        return total;
    }

    public long getTotalEjecta() {
        long total = 0L;
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            total += vent.record.getTotalEjecta();
        }
        return total;
    }

    public boolean isInAnyLavaFlow(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.isInLavaFlow(loc)) continue;
            return true;
        }
        return false;
    }

    public boolean isInAnyLavaFlowOffset(Location loc, double offset) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!(vent.getTwoDimensionalDistance(loc) <= vent.longestFlowLength + offset)) continue;
            return true;
        }
        return false;
    }

    public ChatColor getVolcanoChatColor() {
        boolean isErupting = this.volcano.manager.currentlyStartedVents().size() > 0;
        return isErupting ? ChatColor.RED : this.getVentChatColor(this.volcano.manager.getHighestStatusVent());
    }

    public ChatColor getVentChatColor(VolcanoVent vent) {
        return vent.getStatus() == VolcanoVentStatus.ERUPTING || vent.getStatus() == VolcanoVentStatus.ERUPTION_IMMINENT ? ChatColor.RED : (vent.getStatus() == VolcanoVentStatus.MAJOR_ACTIVITY ? ChatColor.GOLD : (vent.getStatus() == VolcanoVentStatus.MINOR_ACTIVITY ? ChatColor.YELLOW : (vent.getStatus() == VolcanoVentStatus.DORMANT ? ChatColor.GREEN : ChatColor.RESET)));
    }

    public VolcanoVent getNearestVent(Block block) {
        return this.getNearestVent(block.getLocation());
    }

    public VolcanoVent getNearestVent(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        VolcanoVent nearestVent = null;
        double shortestY = -1.0;
        for (VolcanoVent vent : vents) {
            double distance = TyphonUtils.getTwoDimensionalDistance(loc, vent.location);
            if (!(shortestY < 0.0) && !(distance < shortestY)) continue;
            shortestY = distance;
            nearestVent = vent;
        }
        return nearestVent;
    }

    public VolcanoVent getSummitVent() {
        int y = -1;
        VolcanoVent summitVent = null;
        for (VolcanoVent vent : this.volcano.subVents.values()) {
            Block block = vent.getSummitBlock();
            int blockY = block.getY();
            if (blockY < y) continue;
            y = blockY;
            summitVent = vent;
        }
        Block mainVentSummit = this.volcano.mainVent.getSummitBlock();
        if (mainVentSummit.getY() >= y) {
            summitVent = this.volcano.mainVent;
            y = mainVentSummit.getY();
        }
        return summitVent;
    }

    public Block getSummitBlock() {
        VolcanoVent summitVent = this.getSummitVent();
        return summitVent.getSummitBlock();
    }

    public boolean isInAnyLavaFlowArea(Location loc) {
        List<VolcanoVent> vents = this.getVents();
        for (VolcanoVent vent : vents) {
            if (!vent.isInLavaFlow(loc)) continue;
            return true;
        }
        return false;
    }

    public double getHeatValue(Location loc) {
        double accumulatedHeat = 0.0;
        for (VolcanoVent vent : this.volcano.manager.getVents()) {
            double heat = vent.getHeatValue(loc);
            if (!(accumulatedHeat < heat)) continue;
            accumulatedHeat = heat;
        }
        return Math.min(accumulatedHeat, 1.0);
    }

    public List<VolcanoVent> getVentsInRange(Location loc, double range) {
        ArrayList<VolcanoVent> list = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : this.volcano.manager.getVents()) {
            if (!(vent.getTwoDimensionalDistance(loc) <= range)) continue;
            list.add(vent);
        }
        return list;
    }

    public VolcanoVent getHighestStatusVent() {
        VolcanoVent highestVent = this.volcano.mainVent;
        VolcanoVentStatus status = VolcanoVentStatus.EXTINCT;
        for (VolcanoVent vent : this.getVents()) {
            if (!(status.getScaleFactor() < vent.getStatus().getScaleFactor())) continue;
            highestVent = vent;
            status = vent.getStatus();
        }
        return highestVent;
    }

    public List<VolcanoVent> getVentRadiusInRange(Location loc, double range) {
        ArrayList<VolcanoVent> list = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : this.volcano.manager.getVents()) {
            if (!(vent.getTwoDimensionalDistance(loc) <= range + (double)vent.craterRadius)) continue;
            list.add(vent);
        }
        return list;
    }

    public VolcanoVent getSubVentByVentName(String name) {
        return this.volcano.subVents.get(name);
    }

    public boolean getSubVentExist(String name) {
        return this.getSubVentByVentName(name) != null;
    }

    public List<VolcanoVent> currentlyStartedVents() {
        Volcano volcano = this.volcano;
        ArrayList<VolcanoVent> vents = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : volcano.subVents.values()) {
            if (!vent.isStarted()) continue;
            vents.add(vent);
        }
        if (volcano.mainVent.isStarted()) {
            vents.add(volcano.mainVent);
        }
        return vents;
    }

    public List<VolcanoVent> currentlyLavaFlowingVents() {
        Volcano volcano = this.volcano;
        ArrayList<VolcanoVent> vents = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : volcano.subVents.values()) {
            if (!vent.isFlowingLava()) continue;
            vents.add(vent);
        }
        if (volcano.mainVent.isFlowingLava()) {
            vents.add(volcano.mainVent);
        }
        return vents;
    }

    public List<VolcanoVent> currentlyExplodingVents() {
        Volcano volcano = this.volcano;
        ArrayList<VolcanoVent> vents = new ArrayList<VolcanoVent>();
        for (VolcanoVent vent : volcano.subVents.values()) {
            if (!vent.isExploding()) continue;
            vents.add(vent);
        }
        if (volcano.mainVent.isExploding()) {
            vents.add(volcano.mainVent);
        }
        return vents;
    }

    public VolcanoVent createFissureVent() {
        Volcano volcano = this.volcano;
        int number = -1;
        for (int tmp = 1; tmp < 10; ++tmp) {
            if (volcano.subVents.get("fissure" + tmp) != null) continue;
            number = tmp;
            break;
        }
        if (number == -1) {
            return null;
        }
        VolcanoVent vent = new VolcanoVent(volcano);
        vent.name = "fissure" + number;
        vent.fissureAngle = volcano.mainVent.getType() == VolcanoVentType.FISSURE ? volcano.mainVent.fissureAngle : Math.random() * 2.0 * Math.PI;
        volcano.addVolcanoVent(vent);
        return vent;
    }

    public static List<Volcano> getVolcanoesOnWorld(World world) {
        Collection<Volcano> volcanoes = TyphonPlugin.listVolcanoes.values();
        return volcanoes.stream().filter(volcano -> volcano.location.getWorld().equals((Object)world)).collect(Collectors.toList());
    }

    public static List<Volcano> getActiveVolcanoesOnWorld(World world) {
        Collection<Volcano> volcanoes = TyphonPlugin.listVolcanoes.values();
        return volcanoes.stream().filter(volcano -> volcano.location.getWorld().equals((Object)world) && volcano.manager.getHighestStatusVent().getStatus().isActive()).collect(Collectors.toList());
    }

    public static Volcano getNearestVolcano(Location loc) {
        List<Volcano> volcanoes = VolcanoManager.getVolcanoesOnWorld(loc.getWorld());
        Volcano nearestVolcano = null;
        double nearestDistance = -1.0;
        for (Volcano volcano : volcanoes) {
            double distance = TyphonUtils.getTwoDimensionalDistance(loc, volcano.location);
            if (!(nearestDistance < 0.0) && !(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestVolcano = volcano;
        }
        return nearestVolcano;
    }
}

