/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.ash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonCache;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoAshCloudData;
import me.alex4386.plugin.typhon.volcano.ash.VolcanoPyroclasticFlow;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;

public class VolcanoAsh {
    VolcanoVent vent;
    public static int ashCloudScheduleId = -1;
    public static int updatesPerSeconds = 4;
    List<VolcanoPyroclasticFlow> pyroclasticFlows = new ArrayList<VolcanoPyroclasticFlow>();
    List<VolcanoAshCloudData> ashBlockDisplays = new ArrayList<VolcanoAshCloudData>();
    private int queuedAshClouds = 0;
    private boolean shuttingDown = false;
    public static float ashCloudStep = 0.3f;
    public static float scalePerY = 1.1f;
    public static float life = 200.0f;
    Map<Block, TyphonCache<Block>> lowestCaches = new HashMap<Block, TyphonCache<Block>>();

    public void registerTask() {
        if (ashCloudScheduleId < 0) {
            ashCloudScheduleId = TyphonScheduler.registerGlobalTask(() -> {
                this.vent.ash.processQueuedAshPlume();
                this.vent.ash.processAshClouds();
            }, 1L);
        }
    }

    public void unregisterTask() {
        if (ashCloudScheduleId >= 0) {
            TyphonScheduler.unregisterTask(ashCloudScheduleId);
            ashCloudScheduleId = -1;
        }
    }

    public VolcanoAsh(VolcanoVent vent) {
        this.vent = vent;
    }

    public void initialize() {
        this.shuttingDown = false;
        this.vent.volcano.logger.log(VolcanoLogClass.ASH, "Initializing VolcanoAsh for vent " + this.vent.getName());
        this.registerTask();
    }

    public void shutdown() {
        this.vent.volcano.logger.log(VolcanoLogClass.ASH, "Shutting down VolcanoAsh for vent " + this.vent.getName());
        this.queuedAshClouds = 0;
        this.unregisterTask();
        this.shutdownPyroclasticFlows();
        this.clearOrphanedAshClouds();
    }

    public void shutdownPyroclasticFlows() {
        this.shuttingDown = true;
        for (VolcanoPyroclasticFlow pyroclasticFlow : this.pyroclasticFlows) {
            pyroclasticFlow.shutdown(false);
        }
    }

    public int getTargetY(Location location) {
        int heightY;
        Block coreBlock = this.vent.getNearestCoreBlock(location);
        int baseY = Math.max(coreBlock.getY(), this.vent.location.getWorld().getSeaLevel());
        int summitY = this.vent.getSummitBlock().getY();
        if (this.vent.caldera.isSettedUp()) {
            summitY = Math.max(summitY, TyphonUtils.getHighestRocklikes(coreBlock.getRelative(0, this.vent.caldera.radius, 0)).getY());
        }
        if ((heightY = Math.max(summitY - baseY, 0)) == 0) {
            return baseY;
        }
        int tmpSummit = heightY / 2;
        double distance = TyphonUtils.getTwoDimensionalDistance(coreBlock.getLocation(), location);
        double deductAmount = -(distance / 8.0);
        return (int)((double)(baseY + tmpSummit) + deductAmount);
    }

    public int maxTravelDistance() {
        int baseY = Math.max(this.vent.location.getBlockY(), this.vent.location.getWorld().getSeaLevel());
        int heightY = Math.max(this.vent.getSummitBlock().getY() - baseY, 0);
        if (heightY == 0) {
            return baseY;
        }
        int tmpSummit = heightY / 2;
        return tmpSummit * 12;
    }

    public void createAshPlume() {
        VolcanoEruptStyle style = this.vent.erupt.getStyle();
        Block targetBlock = TyphonUtils.getHighestRocklikes(this.vent.selectCoreBlock());
        if (this.vent.getType() == VolcanoVentType.CRATER) {
            double angle = Math.random() * Math.PI * 2.0;
            int xOffset = (int)(Math.pow(Math.random(), 2.0) * Math.sin(angle) * 5.0);
            int zOffset = (int)(Math.pow(Math.random(), 2.0) * Math.cos(angle) * 5.0);
            targetBlock = TyphonUtils.getHighestRocklikes(this.vent.getCoreBlock().getRelative(xOffset, 0, zOffset));
        }
        if (style.ashMultiplier > 0.0) {
            this.createAshPlume(targetBlock.getRelative(BlockFace.UP).getLocation());
        }
    }

    public VolcanoAshCloudData createAshCloud(Location loc, double ashMultiplier) {
        return this.createAshCloud(loc, ashMultiplier, 5.0f);
    }

    public VolcanoAshCloudData createPumiceCloud(Location loc, double ashMultiplier) {
        return this.createAshCloudBlockDisplay(loc, ashMultiplier, 5.0f, Material.NETHERRACK);
    }

    public VolcanoAshCloudData createAshCloud(Location loc, double ashMultiplier, float size) {
        return this.createAshCloudBlockDisplay(loc, ashMultiplier, size, Material.TUFF);
    }

    public VolcanoAshCloudData createAshCloudBlockDisplay(Location loc, double ashMultiplier, float size, Material material) {
        this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Created Ash Cloud @ " + TyphonUtils.blockLocationTostring(loc.getBlock()));
        float sizeHalf = size / 2.0f;
        BlockDisplay result = (BlockDisplay)loc.getWorld().spawn(loc, BlockDisplay.class, bd -> {
            bd.setBlock(material.createBlockData());
            bd.setTransformation(new Transformation(new Vector3f(-sizeHalf, -sizeHalf, -sizeHalf), new AxisAngle4f(), new Vector3f(size, size, size), new AxisAngle4f()));
            bd.setInvulnerable(true);
        });
        VolcanoAshCloudData data = new VolcanoAshCloudData(this, result, 1.0);
        this.ashBlockDisplays.add(data);
        return data;
    }

    public void processAshCloud(VolcanoAshCloudData data) {
        BlockDisplay bd = data.bd;
        int yLimit = bd.getLocation().getWorld().getMaxHeight() + 100;
        this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Processing Ash Cloud @ " + TyphonUtils.blockLocationTostring(bd.getLocation().getBlock()) + " (y: " + String.format("%.2f", bd.getLocation().getY()) + ", Lived: " + bd.getTicksLived() + ")");
        if ((double)bd.getTicksLived() > (double)life * data.multiplier) {
            this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Removing Ash Cloud for living too long @ " + TyphonUtils.blockLocationTostring(bd.getLocation().getBlock()) + " (y: " + String.format("%.2f", bd.getLocation().getY()) + ", Lived: " + bd.getTicksLived() + ")");
            bd.remove();
            return;
        }
        Transformation transformation = bd.getTransformation();
        Vector3f scale = transformation.getScale().mul((float)Math.pow(scalePerY, ashCloudStep));
        float half = scale.x() / 2.0f;
        Vector3f translation = new Vector3f(-half, -half, -half);
        double step = half * ashCloudStep;
        if (bd.getLocation().getWorld() != null) {
            if (bd.getLocation().getY() > (double)yLimit) {
                double angle = Math.random() * 2.0 * Math.PI;
                bd.teleport(new Location(bd.getWorld(), bd.getLocation().getX() + Math.sin(angle) * step, (double)yLimit, bd.getLocation().getZ() + Math.cos(angle) * step));
            } else {
                bd.teleport(bd.getLocation().add(0.0, step, 0.0));
            }
        }
        if (bd.getLocation().getY() >= (double)yLimit && scale.x() >= 20.0f) {
            scale.x = 20.0f;
            scale.y = 20.0f;
            scale.z = 20.0f;
        }
        bd.setTransformation(new Transformation(translation, transformation.getLeftRotation(), scale, transformation.getRightRotation()));
        this.processAshCloudHeat(bd);
    }

    public void processAshClouds() {
        this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Processing Ash Cloud...");
        for (VolcanoAshCloudData bd : this.ashBlockDisplays) {
            this.processAshCloud(bd);
        }
        if (this.ashBlockDisplays.size() > 0) {
            int count = 2 + (int)(Math.random() * 3.0);
            int i = 0;
            while ((double)i < (double)count * Math.floor(this.vent.erupt.getStyle().ashMultiplier)) {
                this.fallAsh();
                ++i;
            }
        }
        this.clearOrphanedAshClouds(false);
    }

    public Block getAshFallTarget() {
        double deadZone = (double)this.vent.getRadius() + (this.vent.getBasinLength() / 2.0 - (double)this.vent.getRadius());
        if (this.vent.caldera.isForming()) {
            deadZone = this.vent.caldera.radius + 7;
        }
        double flowLength = this.vent.getVolcanicRadius();
        double max = Math.max(this.vent.getBasinLength(), flowLength + 20.0);
        max = Math.max(max, this.vent.bombs.maxDistance);
        if (Math.random() < 0.3) {
            max = Math.max(max, this.vent.longestFlowLength);
        }
        double angle = Math.random() * 2.0 * Math.PI;
        double distance = (1.0 - VolcanoMath.getZeroFocusedRandom()) * (max - deadZone) + deadZone;
        double x = Math.cos(angle) * distance;
        double z = Math.sin(angle) * distance;
        return TyphonUtils.getHighestRocklikes(this.vent.getCoreBlock().getLocation().add(x, 0.0, z));
    }

    public void fallAsh() {
        Block target = this.getAshFallTarget();
        this.vent.volcano.logger.debug(VolcanoLogClass.ASH, "Falling Ash @ " + TyphonUtils.blockLocationTostring(target));
        int height = (int)Math.round(1.0 + Math.random() * 2.0);
        int radius = height * (2 + (int)(Math.random() * 2.0));
        List<Block> circleBlock = VolcanoMath.getCircle(target, radius);
        if (target.getY() > this.getTargetY(target.getLocation())) {
            return;
        }
        TyphonUtils.smoothBlockHeights(target, radius, Material.TUFF);
        for (Block circle : circleBlock) {
            Block circleTarget = TyphonUtils.getHighestRocklikes(circle);
            Block highest = TyphonUtils.getHighestLocation(circleTarget.getLocation()).getBlock();
            if (highest.getY() > circleTarget.getY()) {
                Block block = highest;
                while (block.getY() > circleTarget.getY()) {
                    if (!(TyphonUtils.isMaterialRocklikes(block.getType()) || block.isEmpty() || block.isLiquid())) {
                        this.vent.lavaFlow.queueBlockUpdate(block, Material.AIR);
                    }
                    block = block.getRelative(0, -1, 0);
                }
            }
            if (circleTarget.getY() + 1 > this.getTargetY(circleTarget.getLocation())) continue;
            double distance = TyphonUtils.getTwoDimensionalDistance(circle.getLocation(), target.getLocation());
            int thisHeight = (int)Math.round((1.0 - distance / (double)radius) * (double)height);
            for (int i = 0; i < thisHeight; ++i) {
                Block pileUp = circleTarget.getRelative(0, i, 0);
                this.vent.lavaFlow.queueBlockUpdate(pileUp, Material.TUFF);
                this.vent.record.addEjectaVolume(1);
            }
        }
    }

    public void clearOrphanedAshClouds() {
        this.clearOrphanedAshClouds(true);
    }

    public void clearOrphanedAshClouds(boolean removeAll) {
        this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Clearing Ash Cloud...");
        Iterator<VolcanoAshCloudData> bdI = this.ashBlockDisplays.iterator();
        while (bdI.hasNext()) {
            VolcanoAshCloudData data = bdI.next();
            BlockDisplay bd = data.bd;
            if (!removeAll && bd.isValid()) continue;
            this.vent.getVolcano().logger.debug(VolcanoLogClass.ASH, "Clearing Ash Cloud @ " + TyphonUtils.blockLocationTostring(bd.getLocation().getBlock()) + ", isValid: " + bd.isValid());
            bd.remove();
            bdI.remove();
        }
    }

    public void processQueuedAshPlume() {
        if (this.queuedAshClouds > 0) {
            this.createAshPlume();
            --this.queuedAshClouds;
        }
    }

    public void createAshPlume(Location loc) {
        this.createAshPlume(loc, this.vent.erupt.getStyle().ashMultiplier);
    }

    public void createAshPlume(Location loc, double ashMultiplier) {
        float size = 2.5f;
        int length = 10;
        this.createAshCloud(loc, ashMultiplier, size);
        TyphonSounds.ASH_PLUME.play(loc, SoundCategory.BLOCKS, 10.0f, 0.01f);
        Location tmp = loc.clone();
        float tmpSize = size;
        for (int i = 0; i < length; ++i) {
            tmp.add(0.0, -0.5, 0.0);
            this.createAshCloud(tmp.clone(), ashMultiplier, tmpSize /= (float)Math.sqrt(scalePerY));
        }
    }

    public Block getPyroclasticFlowTargetBlock(boolean evenFlow) {
        Block coreBlock = this.vent.getCoreBlock();
        Block target = null;
        double sum = 0.0;
        int count = 0;
        if (evenFlow) {
            TyphonCache<Block> lowestCache = this.lowestCaches.get(coreBlock);
            if (lowestCache != null && !lowestCache.isExpired()) {
                target = lowestCache.getTarget();
            } else {
                List<Block> blocks = VolcanoMath.getAccurateHollowCircle(coreBlock, this.vent.getRadius());
                for (Block block : blocks) {
                    Block highest = TyphonUtils.getHighestRocklikes(block);
                    Location direction = block.getLocation().subtract(coreBlock.getLocation()).multiply(1.0 / (double)this.vent.getRadius());
                    Block extended = TyphonUtils.getHighestRocklikes(coreBlock.getLocation().add(direction.clone().multiply((double)this.vent.getRadius() * 1.5)));
                    Block extendedHighest = TyphonUtils.getHighestRocklikes(extended);
                    double y = Math.max(highest.getY(), extendedHighest.getY());
                    if (target == null || (double)target.getY() > y) {
                        target = highest;
                    }
                    sum += y;
                    ++count;
                }
                if (target != null) {
                    double average = sum / (double)count;
                    if ((double)target.getY() < average - 5.0) {
                        target = null;
                    }
                    if (target != null) {
                        this.lowestCaches.put(coreBlock, new TyphonCache<Block>(target, 20L));
                    }
                }
            }
        }
        if (target == null) {
            double angle = Math.random() * Math.PI * 2.0;
            double x = (double)this.vent.getRadius() * Math.cos(angle);
            double z = (double)this.vent.getRadius() * Math.sin(angle);
            target = TyphonUtils.getHighestRocklikes(coreBlock.getRelative((int)x, 0, (int)z));
        }
        return target;
    }

    public VolcanoPyroclasticFlow triggerPyroclasticFlow() {
        return this.triggerPyroclasticFlow(this.getPyroclasticFlowTargetBlock(Math.random() < 0.1));
    }

    public VolcanoPyroclasticFlow triggerPyroclasticFlow(Block srcblock) {
        if (this.shuttingDown) {
            return null;
        }
        Location target = srcblock.getLocation();
        target.setY((double)srcblock.getWorld().getMaxHeight());
        Block block = TyphonUtils.getHighestRocklikes(target);
        this.vent.getVolcano().logger.log(VolcanoLogClass.ASH, "Triggering Pyroclastic Flows @ " + TyphonUtils.blockLocationTostring(block));
        VolcanoPyroclasticFlow flow = new VolcanoPyroclasticFlow(TyphonUtils.getHighestRocklikes(block).getLocation().add(0.0, 1.0, 0.0), this);
        this.pyroclasticFlows.add(flow);
        flow.initialize();
        return flow;
    }

    public int activePyroclasticFlows() {
        return this.pyroclasticFlows.size();
    }

    public void processAshCloudHeat(BlockDisplay bd) {
        if (bd.isValid()) {
            float radius = bd.getTransformation().getScale().x;
            int i = 0;
            while ((double)i < 8.0 * Math.random()) {
                double distance = Math.random() * (double)radius;
                double theta = Math.random() * 2.0 * Math.PI;
                double theta2 = Math.random() * 2.0 * Math.PI;
                double x = distance * Math.sin(theta);
                double twoDimBit = distance * Math.cos(theta);
                double y = twoDimBit * Math.sin(theta2);
                double z = twoDimBit * Math.cos(theta2);
                Location particleLoc = bd.getLocation().clone();
                particleLoc.add(x, y, z);
                bd.getWorld().spawnParticle(Particle.LAVA, particleLoc, 1);
                ++i;
            }
            Collection entities = bd.getWorld().getNearbyEntities(bd.getLocation(), (double)radius, (double)radius, (double)radius);
            for (Entity entity : entities) {
                Damageable target;
                if (!(entity instanceof Damageable) || (target = (Damageable)entity).isInvulnerable() || !(target.getHealth() > 0.0) || !target.isValid()) continue;
                EntityDamageEvent event = new EntityDamageEvent(entity, EntityDamageEvent.DamageCause.FIRE, DamageSource.builder((DamageType)DamageType.IN_FIRE).build(), target.getHealth());
                target.setHealth(0.1);
                target.setFireTicks(100);
                if (entity instanceof Player) continue;
                entity.remove();
            }
        }
    }
}

