/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.bomb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBomb;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.PluginManager;

public class VolcanoBombListener
implements Listener {
    public static Map<Block, VolcanoVent> lavaSplashExplosions = new HashMap<Block, VolcanoVent>();
    public static int bombTrackingScheduleId = -1;
    public static int updatesPerSeconds = 4;
    public static boolean registeredEvent = false;

    public void registerTask() {
        if (bombTrackingScheduleId < 0) {
            bombTrackingScheduleId = TyphonScheduler.registerGlobalTask(() -> {
                for (Map.Entry<String, Volcano> entry : TyphonPlugin.listVolcanoes.entrySet()) {
                    Volcano volcano = entry.getValue();
                    List<VolcanoVent> vents = volcano.manager.getVents();
                    for (VolcanoVent vent : vents) {
                        vent.bombs.trackAll();
                    }
                }
            }, 1L);
        }
    }

    public void unregisterTask() {
        if (bombTrackingScheduleId >= 0) {
            TyphonScheduler.unregisterTask(bombTrackingScheduleId);
            bombTrackingScheduleId = -1;
        }
    }

    public void registerEvent() {
        if (!registeredEvent) {
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)this, TyphonPlugin.plugin);
        }
    }

    public void unregisterEvent() {
        if (registeredEvent) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void initialize() {
        this.registerTask();
        this.registerEvent();
    }

    public void shutdown() {
        this.unregisterTask();
        this.unregisterEvent();
    }

    public static boolean groundChecker(Location location, int offset) {
        return location.getBlockY() - TyphonUtils.getHighestRocklikes(location).getY() <= offset;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        for (Entity entity : player.getLocation().getChunk().getEntities()) {
            if (!(entity instanceof FallingBlock)) continue;
            FallingBlock fallingBlock = (FallingBlock)entity;
            for (Map.Entry<String, Volcano> entry : TyphonPlugin.listVolcanoes.entrySet()) {
                Volcano volcano = entry.getValue();
                if (!volcano.location.getWorld().equals((Object)player.getWorld())) continue;
                for (VolcanoVent vent : volcano.manager.getVents()) {
                    VolcanoBomb bomb = vent.bombs.bombMap.get(fallingBlock);
                    if (bomb == null) continue;
                    bomb.startTrail();
                }
            }
        }
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
    }
}

