/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.commands;

import java.util.ArrayList;
import java.util.List;
import me.alex4386.plugin.typhon.TyphonCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public enum VolcanoVentCommandAction {
    START("start", "", "start this vent's eruption"),
    STOP("stop", "", "stop this vent's eruption"),
    HELP("help", "", "shows this help menu"),
    CONFIG("config", "<name> <?value>", "configure the vent"),
    INFO("info", "", "shows the information menu"),
    SUMMIT("summit", "", "get navigation to summit"),
    QUICK_COOL("quickcool", "", "cool all lava from this vent"),
    LAVA_DOME("lavadome", "<start/stop/explode>", "start/stop building or explode this lavadome"),
    GENESIS("genesis", "<monogenesis/polygenesis>", "setup genesis type for this vent"),
    TREMOR("tremor", "<? power>", "create volcano tremor"),
    PYROCLAST("pyroclast", "", "create pyroclastic flow from current location"),
    CALDERA("caldera", "<? radius/start> <? deep> <? oceanY>", "Create caldera via Plinian eruption"),
    STATUS("status", "<? status>", "get/set status of this vent"),
    TELEPORT("teleport", "", "teleport to this vent"),
    RESET("reset", "", "reset this vent's config for world reset"),
    DELETE("delete", "", "delete this vent"),
    LANDSLIDE("landslide", "<start/setAngle/config/clear>", "create landslide from this vent"),
    SWITCH("switch", "", "switch this vent to a mainvent"),
    BUILDER("builder", "<? type> <? value>", "get/set builder type for this vent"),
    STYLE("style", "<? hawaiian/strombolian/fissure/crater/etc.>", "get/set eruption style and type of this vent");

    String cmdline;
    String usage;
    String explanation;

    private VolcanoVentCommandAction(String cmdline, String usage, String explanation) {
        this.cmdline = cmdline;
        this.usage = usage;
        this.explanation = explanation;
    }

    public static List<String> listAll(CommandSender sender) {
        ArrayList<String> all = new ArrayList<String>();
        for (VolcanoVentCommandAction action : VolcanoVentCommandAction.values()) {
            if (!action.hasPermission(sender)) continue;
            all.add(action.getCommand());
        }
        return all;
    }

    public String getManual(String label, String name, String ventName) {
        Object commandType = "subVent";
        commandType = ventName == null ? "mainVent" : (ventName.equals("") || ventName.equals("main") ? "mainVent" : (String)commandType + " " + ventName);
        return String.valueOf(ChatColor.LIGHT_PURPLE) + "/" + label + " " + String.valueOf(ChatColor.AQUA) + name + " " + (String)commandType + " " + String.valueOf(ChatColor.YELLOW) + this.cmdline + " " + String.valueOf(ChatColor.GRAY) + this.usage + String.valueOf(ChatColor.RESET) + " : " + this.explanation;
    }

    public static String getAllManual(CommandSender sender, String label, String name, String ventName) {
        Object all = "";
        for (VolcanoVentCommandAction action : VolcanoVentCommandAction.values()) {
            if (!action.hasPermission(sender)) continue;
            all = (String)all + action.getManual(label, name, ventName) + "\n";
        }
        return all;
    }

    public String getCommand() {
        return this.cmdline;
    }

    public boolean hasPermission(CommandSender sender) {
        return TyphonCommand.hasPermission(sender, "vent." + this.cmdline);
    }

    public static VolcanoVentCommandAction getAction(String string) {
        for (VolcanoVentCommandAction action : VolcanoVentCommandAction.values()) {
            if (!action.getCommand().equalsIgnoreCase(string)) continue;
            return action;
        }
        return null;
    }
}

