/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.dome;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.dome.VolcanoLavaDomeLavaFlow;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentBuilderType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.json.simple.JSONObject;

public class VolcanoLavaDome {
    VolcanoVent vent;
    public static int domeScheduleId = -1;
    public int baseY = Integer.MIN_VALUE;
    Location baseLocation = null;
    long plumbedLava = 0L;
    static double shapeExponent = 0.8;
    List<VolcanoLavaDomeLavaFlow> domeFlows = new ArrayList<VolcanoLavaDomeLavaFlow>();
    static double sourceRange = 3.0;

    public VolcanoLavaDome(VolcanoVent vent) {
        this.vent = vent;
        this.baseLocation = null;
    }

    public Location getBaseLocation() {
        return this.baseLocation;
    }

    public long getPlumbedLava() {
        return this.plumbedLava;
    }

    public double getTargetDomeHeight() {
        double radius = this.getTargetBasin();
        return Math.pow(radius, shapeExponent);
    }

    public double getTargetHeightByDistance(double r) {
        double volume = this.plumbedLava;
        double radius = this.getTargetBasin();
        double exponent = shapeExponent;
        if (r > radius) {
            return 0.0;
        }
        double denom = Math.PI * 2 * radius * radius * (0.5 - 1.0 / (exponent + 2.0));
        if (denom <= 0.0) {
            return 0.0;
        }
        double height = volume / denom;
        double normalized = r / radius;
        double targetHeight = height * (1.0 - Math.pow(normalized, exponent));
        return Math.max(0.0, targetHeight);
    }

    public double getTargetYAt(Location loc) {
        double distance = TyphonUtils.getTwoDimensionalDistance(this.baseLocation, loc);
        return this.getTargetHeightByDistance(distance) + (double)this.getBaseY();
    }

    public boolean isConfigured() {
        return this.baseLocation != null && this.baseY != Integer.MIN_VALUE;
    }

    public void configure() {
        if (!this.isConfigured()) {
            this.postConeBuildHandler();
            this.baseLocation = this.vent.getCoreBlock().getLocation();
            this.getBaseY();
        }
    }

    public int getInitialBaseY() {
        if (this.vent.isCaldera()) {
            return TyphonUtils.getHighestRocklikes(this.baseLocation).getY();
        }
        return Math.max(this.vent.getSummitBlock().getY() - this.vent.getRadius(), (int)this.baseLocation.getY());
    }

    public int getBaseY() {
        if (this.baseY == Integer.MIN_VALUE) {
            this.baseY = this.getInitialBaseY();
        }
        return this.baseY;
    }

    public void resetAll() {
        this.baseY = Integer.MIN_VALUE;
        this.plumbedLava = 0L;
    }

    public void registerTask() {
        if (domeScheduleId < 0) {
            domeScheduleId = TyphonScheduler.registerGlobalTask(this::runDomeLavaTick, 1L);
        }
    }

    public void runDomeLavaTick() {
        Iterator<VolcanoLavaDomeLavaFlow> iterator = this.domeFlows.iterator();
        while (iterator.hasNext()) {
            VolcanoLavaDomeLavaFlow flow = iterator.next();
            flow.runTick();
            if (!flow.finished) continue;
            iterator.remove();
        }
    }

    public void postConeBuildHandler() {
        if (this.vent.erupt.getStyle() == VolcanoEruptStyle.LAVA_DOME) {
            return;
        }
        this.resetAll();
    }

    public void unregisterTask() {
        if (domeScheduleId >= 0) {
            TyphonScheduler.unregisterTask(domeScheduleId);
            domeScheduleId = -1;
        }
    }

    public void initialize() {
        this.registerTask();
    }

    public void shutdown() {
        this.coolDownAll();
        this.unregisterTask();
    }

    public void coolDownAll() {
        for (VolcanoLavaDomeLavaFlow flow : this.domeFlows) {
            flow.forceCoolDown();
        }
    }

    public Block getSourceBlock() {
        double angle = Math.random() * 2.0 * Math.PI;
        return this.getSourceBlock(angle);
    }

    public Block getSourceBlock(double angle) {
        Location locWithSourceRange = this.baseLocation.clone();
        double radius = sourceRange * (1.0 - Math.pow(Math.random(), 2.0));
        locWithSourceRange.add(Math.sin(angle) * radius, 0.0, Math.cos(angle) * radius);
        return TyphonUtils.getHighestRocklikes(locWithSourceRange).getRelative(BlockFace.UP);
    }

    public void preStartArgumentValidityCheck() {
        Block highestBlock = TyphonUtils.getHighestRocklikes(this.baseLocation);
        if (highestBlock.getY() < this.baseY) {
            this.baseY = highestBlock.getY();
        }
    }

    public int domeFlowCounts() {
        return this.domeFlows.size();
    }

    public double getTargetBasin() {
        double volume = this.plumbedLava;
        double exponent = shapeExponent;
        double shapeFactor = Math.PI * 2 * (0.5 - 1.0 / (exponent + 2.0));
        if (shapeFactor <= 0.0) {
            return 0.0;
        }
        return Math.pow(volume / shapeFactor, 1.0 / (exponent + 2.0));
    }

    public void flowLava() {
        String res;
        double targetBasin = this.getTargetBasin();
        int randomRange = (int)Math.max(0.0, Math.ceil(Math.max(10.0, targetBasin)) - sourceRange);
        double distance = (1.0 - Math.pow(Math.random(), 2.0)) * ((double)randomRange + sourceRange);
        double angle = Math.random() * 2.0 * Math.PI;
        Block srcBlock = this.getSourceBlock(angle);
        Block targetBlock = this.baseLocation.clone().add(Math.sin(angle) * distance, 0.0, Math.cos(angle) * distance).getBlock();
        if (srcBlock.getRelative(0, -1, 0).getType() == Material.MAGMA_BLOCK) {
            srcBlock = srcBlock.getRelative(0, -1, 0);
        }
        if (this.vent.builder.isRunning() && this.vent.builder.getType() == VolcanoVentBuilderType.Y_THRESHOLD && (res = this.vent.builder.getArgumentMap().get("y_threshold")) != null) {
            double value = Double.parseDouble(res);
            if ((double)srcBlock.getY() >= value) {
                this.vent.builder.forcePredicateMatch();
                return;
            }
        }
        this.domeFlows.add(new VolcanoLavaDomeLavaFlow(this, srcBlock, targetBlock));
        ++this.plumbedLava;
    }

    public boolean isDomeLargeEnough() {
        return this.getTargetBasin() > 10.0;
    }

    public Block getFractureTarget() {
        double targetBasin = this.getTargetBasin();
        double distance = (Math.pow(1.0 - Math.random(), 2.0) * 0.5 + 0.5) * targetBasin;
        return TyphonUtils.getFairRandomBlockInRange(this.baseLocation.getBlock(), (int)distance, (int)distance);
    }

    public void ooze() {
        Block target = this.getFractureTarget();
        this.vent.lavaFlow.flowLava(TyphonUtils.getHighestRocklikes(target).getRelative(BlockFace.UP));
        if (Math.random() < 1.0E-4) {
            TyphonSounds.getRandomLavaFragmenting().play(this.baseLocation.getBlock().getLocation(), SoundCategory.BLOCKS, 0.1f, 1.0f);
            TyphonUtils.smoothBlockHeights(target, 5, Material.TUFF);
        }
    }

    public void explode() {
        TyphonSounds.EARTH_CRACKING.play(this.baseLocation.getBlock().getLocation(), SoundCategory.BLOCKS, 2.0f, 0.0f);
        Block target = this.getFractureTarget();
        target = TyphonUtils.getHighestRocklikes(target);
        this.vent.ash.triggerPyroclasticFlow(target);
    }

    public JSONObject importConfig(JSONObject json) {
        this.plumbedLava = (Long)json.get("plumbedLava");
        this.baseY = (int)((Long)json.get("baseY")).longValue();
        JSONObject locationJSON = (JSONObject)json.get("baseLocation");
        if (locationJSON != null) {
            this.baseLocation = TyphonUtils.deserializeLocationForJSON((JSONObject)json.get("baseLocation"));
        }
        return json;
    }

    public JSONObject exportConfig() {
        JSONObject json = new JSONObject();
        if (this.baseLocation != null) {
            json.put("baseLocation", TyphonUtils.serializeLocationForJSON(this.baseLocation));
        }
        json.put("baseY", this.baseY);
        json.put("plumbedLava", this.plumbedLava);
        return json;
    }
}

