/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.erupt;

import java.util.ArrayList;
import java.util.Arrays;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptCauseType;

public enum VolcanoEruptStyle {
    HAWAIIAN("hawaiian", new String[]{"effusive"}, VolcanoEruptCauseType.MAGMATIC, 5.0, 0.2, 0.4),
    STROMBOLIAN("strombolian", new String[]{"stromboli"}, VolcanoEruptCauseType.MAGMATIC, 0.0, 1.0, 1.0),
    VULCANIAN("vulcanian", new String[0], VolcanoEruptCauseType.MAGMATIC, 3.0, 2.0, 2.0),
    PELEAN("pelean", new String[]{"pel\u00e8an"}, VolcanoEruptCauseType.MAGMATIC, 5.0, 4.0, 4.0),
    PLINIAN("plinian", new String[]{"vesuvian"}, VolcanoEruptCauseType.MAGMATIC, 0.0, 0.0, 5.0),
    LAVA_DOME("lava_dome", new String[]{"dome"}, VolcanoEruptCauseType.MAGMATIC, 0.2, 0.0, 0.0);

    String rawType;
    String[] aliases;
    VolcanoEruptCauseType causeType;
    public double lavaMultiplier;
    public double bombMultiplier;
    public double ashMultiplier;
    public boolean canFormCaldera = false;

    private VolcanoEruptStyle(String rawType, String[] aliases, VolcanoEruptCauseType causeType, double lavaMultiplier, double bombMultiplier, double ashMultiplier) {
        this.rawType = rawType;
        this.aliases = aliases;
        this.causeType = causeType;
        this.lavaMultiplier = lavaMultiplier;
        this.bombMultiplier = bombMultiplier;
        this.ashMultiplier = ashMultiplier;
    }

    private VolcanoEruptStyle(String rawType, String[] aliases, VolcanoEruptCauseType causeType, double lavaMultiplier, double bombMultiplier, double ashMultiplier, boolean canFormCaldera) {
        this(rawType, aliases, causeType, lavaMultiplier, bombMultiplier, ashMultiplier);
        this.canFormCaldera = canFormCaldera;
    }

    public double getPyroclasticFlowMultiplier() {
        if (this.ashMultiplier > 1.0) {
            return this.ashMultiplier - 1.0;
        }
        return 0.0;
    }

    public static VolcanoEruptStyle getVolcanoEruptStyle(String name) {
        for (VolcanoEruptStyle type : VolcanoEruptStyle.values()) {
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(type.aliases));
            names.add(type.rawType);
            if (!names.contains(TyphonUtils.toLowerCaseDumbEdition(name))) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.rawType;
    }

    public boolean isHydroVolcanic() {
        return this.causeType.isHydroVolcanic();
    }

    public boolean flowsLava() {
        return this.lavaMultiplier > 0.0 && this.causeType != VolcanoEruptCauseType.PHREATIC;
    }

    public boolean isExplosive() {
        return this.bombMultiplier > 0.0;
    }
}

