/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.explosion;

import me.alex4386.plugin.typhon.volcano.explosion.VolcanoExplosionDefaultSettings;
import org.json.simple.JSONObject;

public class VolcanoExplosionSettings {
    public int explosionSize = VolcanoExplosionDefaultSettings.explosionSize;
    public int damagingExplosionSize = VolcanoExplosionDefaultSettings.damagingExplosionSize;
    public int minBombCount = VolcanoExplosionDefaultSettings.minBombCount;
    public int maxBombCount = VolcanoExplosionDefaultSettings.maxBombCount;
    public int delayTicks = VolcanoExplosionDefaultSettings.delayTicks;
    public int queueSize = VolcanoExplosionDefaultSettings.queueSize;

    public void importConfig(JSONObject configData) {
        JSONObject explosionSchedulersData = (JSONObject)configData.get("scheduler");
        JSONObject explosionSizeData = (JSONObject)explosionSchedulersData.get("size");
        JSONObject bombCountData = (JSONObject)configData.get("bombCount");
        this.explosionSize = (int)((Long)explosionSizeData.get("withoutDamage")).longValue();
        this.damagingExplosionSize = (int)((Long)explosionSizeData.get("withDamage")).longValue();
        this.minBombCount = (int)((Long)bombCountData.get("min")).longValue();
        this.maxBombCount = (int)((Long)bombCountData.get("max")).longValue();
        this.delayTicks = (int)configData.getOrDefault("delay", Long.valueOf(VolcanoExplosionDefaultSettings.delayTicks)).longValue();
        this.queueSize = (int)configData.getOrDefault("queueSize", Long.valueOf(VolcanoExplosionDefaultSettings.queueSize)).longValue();
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        JSONObject explosionSizeData = new JSONObject();
        explosionSizeData.put("withoutDamage", this.explosionSize);
        explosionSizeData.put("withDamage", this.damagingExplosionSize);
        JSONObject explosionSchedulerData = new JSONObject();
        explosionSchedulerData.put("size", explosionSizeData);
        JSONObject bombCountData = new JSONObject();
        bombCountData.put("min", this.minBombCount);
        bombCountData.put("max", this.maxBombCount);
        configData.put("scheduler", explosionSchedulerData);
        configData.put("bombCount", bombCountData);
        configData.put("delay", this.delayTicks);
        configData.put("queueSize", this.queueSize);
        return configData;
    }
}

