/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.lavaflow;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonCache;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonSounds;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.bomb.VolcanoBomb;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.lavaflow.VolcanoLavaCoolData;
import me.alex4386.plugin.typhon.volcano.lavaflow.VolcanoLavaFlowSettings;
import me.alex4386.plugin.typhon.volcano.lavaflow.VolcanoPillowLavaData;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;
import org.json.simple.JSONObject;

public class VolcanoLavaFlow
implements Listener {
    public VolcanoVent vent = null;
    public static List<VolcanoVent> flowingVents = new ArrayList<VolcanoVent>();
    public List<Chunk> lavaFlowChunks = new ArrayList<Chunk>();
    public Map<Chunk, Map<Block, VolcanoLavaCoolData>> lavaCools = new HashMap<Chunk, Map<Block, VolcanoLavaCoolData>>();
    public Map<Chunk, Map<Block, VolcanoLavaCoolData>> cachedCools = new HashMap<Chunk, Map<Block, VolcanoLavaCoolData>>();
    public Map<Block, VolcanoPillowLavaData> pillowLavaMap = new HashMap<Block, VolcanoPillowLavaData>();
    public Map<Block, VolcanoPillowLavaData> cachedPillowLavaMap = new HashMap<Block, VolcanoPillowLavaData>();
    private int lavaFlowScheduleId = -1;
    private int lavaCoolScheduleId = -1;
    private int lavaInfluxScheduleId = -1;
    private int queueScheduleId = -1;
    public VolcanoLavaFlowSettings settings = new VolcanoLavaFlowSettings();
    public boolean registeredEvent = false;
    private int highestY = Integer.MIN_VALUE;
    private double hawaiianBaseY = Double.NEGATIVE_INFINITY;
    private double thisMaxFlowLength = 0.0;
    public long lastQueueUpdatesPerSecond = 0L;
    public long lastQueueUpdatedPerSecondAt = 0L;
    public long lastQueueUpdates = 0L;
    private double rootlessConeProbability = 0.0;
    private static Map<Chunk, Queue<Map.Entry<Block, Material>>> immediateBlockUpdateQueues = new HashMap<Chunk, Queue<Map.Entry<Block, Material>>>();
    private static Map<Chunk, Queue<Map.Entry<Block, Material>>> blockUpdateQueues = new HashMap<Chunk, Queue<Map.Entry<Block, Material>>>();
    private static Map<Block, Consumer<Block>> postUpdater = new HashMap<Block, Consumer<Block>>();
    private int configuredLavaInflux = -1;
    private double queuedLavaInflux = 0.0;
    private double prevQueuedLavaInflux = 0.0;
    private long previousRerender = 0L;
    private long rerenderInterval = 300000L;
    private Set<Chunk> rerenderTargets = new HashSet<Chunk>();
    private Map<Block, Long> lavaHaventSpreadEnoughYet = new HashMap<Block, Long>();
    private long spreadEnoughCacheLifeTime = 10000L;
    private boolean isShuttingDown = false;
    private List<TyphonCache<Block>> rootlessCones = new ArrayList<TyphonCache<Block>>();
    private long prevFlowTime = -1L;

    private double getSpreadEnoughThreshold() {
        double runniness = 1.0 - Math.min(1.0, Math.max(this.getLavaStickiness(), 0.0));
        double multiplier = 1.0 + runniness;
        if (this.vent.longestFlowLength < 100.0) {
            return Math.max(5.0, Math.sqrt(this.vent.longestFlowLength / 100.0) * 10.0) * multiplier;
        }
        return Math.min(Math.max(10.0, this.vent.longestFlowLength / 10.0), 20.0) * multiplier;
    }

    public VolcanoLavaFlow(VolcanoVent vent) {
        this.vent = vent;
        this.registerEvent();
    }

    public int getCurrentLavaInflux() {
        if (this.configuredLavaInflux < 0) {
            int lavaFlowableBlocks = this.vent.getVentBlocksScaffold().size();
            if (this.shouldFlowOverLeeve()) {
                lavaFlowableBlocks = (int)(Math.PI * Math.pow(Math.min(5, Math.max(2, this.vent.craterRadius)), 2.0));
            }
            double absoluteMax = Math.min(100.0, Math.pow(this.vent.craterRadius, 2.0) * Math.PI);
            int influxRate = (int)Math.max(1.0, Math.min((double)((int)((double)lavaFlowableBlocks * (0.5 + Math.random()))), absoluteMax));
            return influxRate;
        }
        return this.configuredLavaInflux;
    }

    public double getCurrentLavaInfluxPerTick() {
        return (double)this.getCurrentLavaInflux() / 20.0;
    }

    public void setLavaInflux(int currentLavaInflux) {
        this.configuredLavaInflux = currentLavaInflux;
    }

    public void queueBlockUpdate(Block block, Material material) {
        this.queueBlockUpdate(block, material, null);
    }

    public void queueBlockUpdate(Block block, Material material, Consumer<Block> callback) {
        Chunk chunk;
        if (this.queueScheduleId == -1) {
            this.registerQueueUpdate();
        }
        if (!blockUpdateQueues.containsKey(chunk = block.getChunk())) {
            blockUpdateQueues.put(chunk, new LinkedList());
        }
        Queue<Map.Entry<Block, Material>> blockUpdateQueue = blockUpdateQueues.get(chunk);
        blockUpdateQueue.add(new AbstractMap.SimpleEntry<Block, Material>(block, material));
        if (callback != null) {
            postUpdater.put(block, callback);
        }
    }

    public void queueImmediateBlockUpdate(Block block, Material material) {
        Chunk chunk = block.getChunk();
        if (!immediateBlockUpdateQueues.containsKey(chunk)) {
            immediateBlockUpdateQueues.put(chunk, new LinkedList());
        }
        Queue<Map.Entry<Block, Material>> blockUpdateQueue = immediateBlockUpdateQueues.get(chunk);
        blockUpdateQueue.add(new AbstractMap.SimpleEntry<Block, Material>(block, material));
    }

    public long unprocessedQueueBlocks() {
        long count = 0L;
        for (Queue<Map.Entry<Block, Material>> blockUpdateQueue : blockUpdateQueues.values()) {
            count += (long)blockUpdateQueue.size();
        }
        return count;
    }

    public long getProcessedBlocksPerSecond() {
        if (this.lastQueueUpdatedPerSecondAt == 0L) {
            return 0L;
        }
        long passedMs = System.currentTimeMillis() - this.lastQueueUpdatedPerSecondAt;
        if (passedMs < 50L) {
            return this.lastQueueUpdates * 20L;
        }
        return (long)((double)this.lastQueueUpdatesPerSecond / ((double)passedMs / 1000.0));
    }

    public Volcano getVolcano() {
        return this.vent.getVolcano();
    }

    public boolean shouldFlowOverLeeve() {
        double leeveY;
        double baseY = this.vent.averageVentHeight();
        return this.vent.getType() == VolcanoVentType.FISSURE && (leeveY = this.vent.averageLeeveHeight()) > baseY;
    }

    public void resetThisFlow() {
        double baseY = this.vent.averageVentHeight();
        double flowLength = 0.0;
        if (this.shouldFlowOverLeeve()) {
            double leeveY = this.vent.averageLeeveHeight();
            baseY = Math.round((leeveY + baseY) / 2.0);
            flowLength = this.vent.craterRadius * 2;
        }
        this.hawaiianBaseY = baseY;
        this.thisMaxFlowLength = flowLength;
        this.prevFlowTime = -1L;
    }

    public void registerEvent() {
        if (!this.registeredEvent) {
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)this, TyphonPlugin.plugin);
            this.registeredEvent = true;
        }
    }

    public void unregisterEvent() {
        if (this.registeredEvent) {
            BlockFromToEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            BlockFormEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            PlayerBucketFillEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            this.registeredEvent = false;
        }
    }

    public void registerTask() {
        if (this.lavaFlowScheduleId == -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Intializing lava flow scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            this.lavaFlowScheduleId = TyphonScheduler.registerGlobalTask(() -> {
                this.plumbLava();
                this.autoFlowLava();
            }, 1L);
        }
        if (this.lavaCoolScheduleId == -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Intializing lava cooldown scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            this.lavaCoolScheduleId = TyphonScheduler.registerGlobalTask(() -> {
                this.runCooldownTick();
                this.runPillowLavaTick();
            }, 1L);
        }
        this.registerQueueUpdate();
    }

    public void registerQueueUpdate() {
        if (this.queueScheduleId == -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Intializing lava cooldown scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            this.queueScheduleId = TyphonScheduler.registerGlobalTask(this::delegateQueue, 1L);
        }
    }

    public void delegateQueue() {
        for (Map.Entry<Chunk, Queue<Map.Entry<Block, Material>>> entry : immediateBlockUpdateQueues.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            TyphonScheduler.run(entry.getKey(), () -> this.runQueue((Queue)entry.getValue()));
            this.rerenderTargets.add(entry.getKey());
        }
        for (Map.Entry<Chunk, Queue<Map.Entry<Block, Material>>> entry : blockUpdateQueues.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            TyphonScheduler.run(entry.getKey(), () -> this.runBlockUpdateQueueWithinTick((Queue)entry.getValue()));
            this.rerenderTargets.add(entry.getKey());
        }
        if (TyphonBlueMapUtils.isInitialized && (this.previousRerender == 0L || System.currentTimeMillis() - this.previousRerender > this.rerenderInterval)) {
            TyphonBlueMapUtils.updateChunks(this.vent.location.getWorld(), this.rerenderTargets);
            this.previousRerender = System.currentTimeMillis();
            this.rerenderTargets.clear();
        }
    }

    public long runQueue(Queue<Map.Entry<Block, Material>> blockUpdateQueue) {
        Map.Entry<Block, Material> entry;
        long count = 1L;
        while ((entry = blockUpdateQueue.poll()) != null) {
            Block block = entry.getKey();
            Material material = entry.getValue();
            TyphonBlocks.setBlockType(block, material);
            ++count;
        }
        return count;
    }

    public long runBlockUpdateQueueWithinTick(Queue<Map.Entry<Block, Material>> blockUpdateQueue) {
        Map.Entry<Block, Material> entry;
        long startTime = System.currentTimeMillis();
        long count = 1L;
        while ((entry = blockUpdateQueue.poll()) != null) {
            Block block = entry.getKey();
            Material material = entry.getValue();
            TyphonBlocks.setBlockType(block, material);
            if (postUpdater.containsKey(block)) {
                Consumer<Block> callback = postUpdater.get(block);
                callback.accept(block);
                postUpdater.remove(block);
            }
            if (count % 1000L == 0L && System.currentTimeMillis() - startTime > 50L) break;
            ++count;
        }
        return count;
    }

    public void unregisterTask() {
        if (this.lavaFlowScheduleId != -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Shutting down lava flow scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            TyphonScheduler.unregisterTask(this.lavaFlowScheduleId);
            this.lavaFlowScheduleId = -1;
        }
        if (this.lavaInfluxScheduleId != -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Shutting down lava influx scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            TyphonScheduler.unregisterTask(this.lavaInfluxScheduleId);
            this.lavaInfluxScheduleId = -1;
        }
        if (this.lavaCoolScheduleId != -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Shutting down lava cooldown scheduler of VolcanoLavaFlow for vent " + this.vent.getName());
            TyphonScheduler.unregisterTask(this.lavaCoolScheduleId);
            this.lavaCoolScheduleId = -1;
        }
        if (this.queueScheduleId != -1) {
            this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Shutting down lava cooldown queue handler of VolcanoLavaFlow for vent " + this.vent.getName());
            TyphonScheduler.unregisterTask(this.queueScheduleId);
            this.lavaCoolScheduleId = -1;
        }
    }

    public void initialize() {
        this.isShuttingDown = false;
        this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Intializing VolcanoLavaFlow for vent " + this.vent.getName());
        this.registerEvent();
        this.registerTask();
    }

    public void shutdown() {
        this.isShuttingDown = true;
        this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Shutting down VolcanoLavaFlow for vent " + this.vent.getName());
        this.unregisterEvent();
        this.unregisterTask();
    }

    public double getTickFactor() {
        return this.getVolcano().getTickFactor();
    }

    @EventHandler
    public void lavaFlowPickupEvent(PlayerBucketFillEvent event) {
        Material bucket = event.getBucket();
        Block clickedBlock = event.getBlockClicked();
        Block targetBlock = clickedBlock.getRelative(event.getBlockFace());
        Location loc = targetBlock.getLocation();
        if (targetBlock.getType() == Material.LAVA) {
            Volcano volcano = this.getVolcano();
            VolcanoLavaCoolData data = this.getLavaCoolData(targetBlock);
            if (data != null || volcano.manager.isInAnyLavaFlowArea(loc)) {
                boolean allowPickUp;
                VolcanoVent targetVent;
                if (data != null && (targetVent = data.flowedFromVent) != null && (allowPickUp = targetVent.lavaFlow.settings.allowPickUp)) {
                    data.isProcessed = true;
                    data.ticks = 0;
                    return;
                }
                TyphonUtils.createRisingSteam(loc, 1, 5);
                event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Volcano is erupting and you can't stop lava! Run!");
                event.setCancelled(true);
                if (event.getPlayer().getInventory().getItemInMainHand().getType() == bucket) {
                    event.getPlayer().getInventory().getItemInMainHand().setType(Material.LAVA_BUCKET);
                }
            }
        }
    }

    public void createEffectOnLavaSeaEntry(Block block) {
        if (Math.random() < 0.2) {
            if (!block.getWorld().getNearbyEntities(block.getLocation(), 16.0, 16.0, 16.0).stream().anyMatch(e -> e instanceof Player)) {
                return;
            }
            block.getWorld().playSound(block.getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 0.0f);
            TyphonUtils.createRisingSteam(block.getLocation(), 1, 2);
        }
    }

    @EventHandler
    public void lavaCollisionDetector(BlockFormEvent event) {
        Block block = event.getBlock();
        if (block.getType() == Material.COBBLESTONE || block.getType() == Material.STONE || block.getType() == Material.OBSIDIAN) {
            BlockFace[] faces;
            for (BlockFace face : faces = new BlockFace[]{BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}) {
                VolcanoLavaCoolData data;
                Block fromBlock = block.getRelative(face);
                if (fromBlock.getType() != Material.LAVA || (data = this.getLavaCoolData(fromBlock)) == null) continue;
                this.createEffectOnLavaSeaEntry(block);
                this.cachedPillowLavaMap.put(block, new VolcanoPillowLavaData(data.flowedFromVent, data.source, data.fromBlock, data.runExtensionCount));
                this.queueImmediateBlockUpdate(block, VolcanoComposition.getExtrusiveRock(data.flowedFromVent.lavaFlow.settings.silicateLevel));
                break;
            }
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getBlock();
        Block toBlock = event.getToBlock();
        BlockFace face = event.getFace();
        VolcanoLavaCoolData data = this.getLavaCoolData(block);
        int level = -1;
        BlockData bd = block.getBlockData();
        if (bd instanceof Levelled) {
            level = ((Levelled)bd).getLevel();
        }
        if (toBlock.getType() == Material.LAVA && data != null) {
            if (data.fromBlock != block) {
                data.forceCoolDown();
            }
            return;
        }
        if (data != null) {
            Object obj;
            Block targetBlock;
            BlockFace[] nearByFaces;
            double silicaRatio;
            double silicateLevel;
            Chunk toBlockChunk;
            BlockFace fromFace;
            boolean isPrimary = true;
            if (data.fromBlock != null && (fromFace = data.fromBlock.getFace(block)) != BlockFace.DOWN && fromFace != null) {
                isPrimary = face.getDirection().equals((Object)fromFace.getDirection());
            }
            if (face == BlockFace.DOWN) {
                isPrimary = true;
            }
            int decrementAmount = block.getWorld().isUltraWarm() ? 1 : 2;
            int levelConverted = level >= 8 ? 8 : 8 - level;
            int levelT = isPrimary ? levelConverted : levelConverted - decrementAmount;
            double ratio = Math.min(1.0, Math.max(0.0, (double)levelT / (8.0 - (double)decrementAmount)));
            double levelProbability = Math.pow(ratio, 2.0);
            if (isPrimary) {
                levelProbability = Math.pow(ratio, 1.25);
            }
            if (Math.random() < this.getLavaStickiness() && Math.random() > levelProbability) {
                this.vent.volcano.logger.log(VolcanoLogClass.LAVA_FLOW, "Lava stickiness match! levelProbability: " + levelProbability);
                event.setCancelled(true);
                return;
            }
            if (Math.random() < this.rootlessConeProbability) {
                this.doPlumbingToRootlessCone();
            }
            if (this.vent != null && !data.isBomb && data.source != null) {
                double distance = TyphonUtils.getTwoDimensionalDistance(data.source.getLocation(), block.getLocation());
                boolean trySave = false;
                if (distance > this.vent.longestFlowLength) {
                    this.vent.longestFlowLength = distance;
                    trySave = true;
                }
                if (distance > this.vent.currentFlowLength) {
                    this.vent.currentFlowLength = distance;
                    trySave = true;
                }
                if (distance > this.thisMaxFlowLength) {
                    this.thisMaxFlowLength = distance;
                }
                if (!data.skipNormalLavaFlowLengthCheck) {
                    if (distance > this.vent.longestNormalLavaFlowLength) {
                        this.vent.longestNormalLavaFlowLength = distance;
                        trySave = true;
                    }
                    if (distance > this.vent.currentNormalLavaFlowLength) {
                        this.vent.currentNormalLavaFlowLength = distance;
                        trySave = true;
                    }
                    if (this.vent.calderaRadius < distance) {
                        this.vent.calderaRadius = -1.0;
                        trySave = true;
                    }
                }
                if (trySave) {
                    this.vent.getVolcano().trySave(false);
                }
                this.vent.record.addEjectaVolume(1);
                if (!this.vent.location.getChunk().isLoaded()) {
                    this.vent.location.getChunk().load();
                }
            } else if (data.isBomb && this.vent != null && data.source != null && !this.vent.isInVent(toBlock.getLocation()) && data.flowLimit >= 0 && TyphonUtils.getTwoDimensionalDistance(data.source.getLocation(), toBlock.getLocation()) > (double)data.flowLimit && this.vent != null && !this.vent.isInVent(toBlock.getLocation())) {
                event.setCancelled(true);
                return;
            }
            Block underToBlock = toBlock.getRelative(BlockFace.DOWN);
            if (!this.lavaFlowChunks.contains(toBlock.getChunk())) {
                this.lavaFlowChunks.add(toBlock.getLocation().getChunk());
                toBlock.getLocation().getChunk().setForceLoaded(true);
            }
            if (!(toBlockChunk = toBlock.getLocation().getChunk()).isLoaded()) {
                toBlockChunk.load();
            }
            Block underUnderToBlock = underToBlock.getRelative(BlockFace.DOWN);
            boolean underIsAir = underToBlock.getType().isAir();
            if (!underIsAir && underToBlock.getType() != Material.LAVA) {
                this.getVolcano().metamorphism.metamorphoseBlock(this.vent, underToBlock, true);
            }
            boolean fillUnderUnder = true;
            if (data.isBomb && data.flowLimit >= 0) {
                boolean bl = fillUnderUnder = Math.random() < 0.1;
            }
            if (data.flowedFromVent != null && fillUnderUnder && (silicateLevel = data.flowedFromVent.lavaFlow.settings.silicateLevel) > 0.5 && (silicaRatio = Math.min(0.57, silicateLevel) - 7.142857142857142) > 1.0 - Math.pow(silicaRatio, 2.0)) {
                boolean bl = fillUnderUnder = Math.random() > 0.5;
            }
            if (underIsAir && underUnderToBlock.getType().isAir() && fillUnderUnder) {
                this.queueImmediateBlockUpdate(underToBlock, data.material);
                if (!data.isBomb) {
                    this.registerLavaCoolData(data.source, underToBlock, underUnderToBlock, data.isBomb, -1, false, true);
                } else {
                    this.flowLavaFromBomb(underUnderToBlock);
                }
                this.queueBlockUpdate(underUnderToBlock, Material.LAVA);
            }
            for (BlockFace nearByFace : nearByFaces = new BlockFace[]{BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}) {
                targetBlock = toBlock.getRelative(nearByFace);
                this.getVolcano().metamorphism.metamorphoseBlock(this.vent, targetBlock, data.isBomb);
            }
            int extensionCount = data.runExtensionCount;
            if (data.fromBlock != null) {
                Location flowVector = block.getLocation().subtract(data.fromBlock.getLocation());
                if (!data.isBomb && flowVector.getBlockY() < 0) {
                    extensionCount = -1;
                }
            }
            if ((obj = this.registerLavaCoolData(data.source, block, toBlock, data.isBomb, extensionCount)) instanceof VolcanoLavaCoolData) {
                VolcanoLavaCoolData coolData = (VolcanoLavaCoolData)obj;
                if (data.skipNormalLavaFlowLengthCheck) {
                    coolData.skipNormalLavaFlowLengthCheck = true;
                }
                if (data.isBomb) {
                    coolData.flowLimit = data.flowLimit;
                }
            } else if (obj instanceof VolcanoPillowLavaData) {
                VolcanoPillowLavaData pillowData = (VolcanoPillowLavaData)obj;
                targetBlock = TyphonUtils.getHighestRocklikes(pillowData.fromBlock);
                this.createEffectOnLavaSeaEntry(targetBlock);
            }
        }
    }

    private VolcanoLavaCoolData getLavaCoolData(Block block) {
        Map<Block, VolcanoLavaCoolData> lavaCoolHashMap = this.lavaCools.get(block.getChunk());
        if (lavaCoolHashMap == null) {
            return this.getCachedLavaCoolData(block);
        }
        VolcanoLavaCoolData data = lavaCoolHashMap.get(block);
        if (data == null) {
            return this.getCachedLavaCoolData(block);
        }
        return data;
    }

    private VolcanoLavaCoolData getCachedLavaCoolData(Block block) {
        Map<Block, VolcanoLavaCoolData> lavaCoolHashMap = this.cachedCools.get(block.getChunk());
        if (lavaCoolHashMap == null) {
            return null;
        }
        return lavaCoolHashMap.get(block);
    }

    private VolcanoPillowLavaData getPillowLavaCoolData(Block block) {
        VolcanoPillowLavaData coolData = this.pillowLavaMap.get(block);
        if (coolData == null) {
            coolData = this.cachedPillowLavaMap.get(block);
        }
        return coolData;
    }

    private boolean isNormalLavaRegistered(Block block) {
        return this.getLavaCoolData(block) != null;
    }

    private boolean isPillowLavaRegistered(Block block) {
        return this.getPillowLavaCoolData(block) != null;
    }

    public boolean isLavaOKForFlow(Block block) {
        return !this.isLavaRegistered(block) && this.hasLavaSpreadEnough(block);
    }

    public boolean hasLavaSpreadEnough(Block block) {
        Long result = this.lavaHaventSpreadEnoughYet.get(block);
        if (result == null) {
            return true;
        }
        if (System.currentTimeMillis() - result > this.spreadEnoughCacheLifeTime) {
            this.lavaHaventSpreadEnoughYet.remove(block);
            return true;
        }
        return false;
    }

    public boolean isLavaRegistered(Block block) {
        return this.isNormalLavaRegistered(block) || this.isPillowLavaRegistered(block);
    }

    private Object registerLavaCoolData(Block block, boolean isBomb, int extension) {
        return this.registerLavaCoolData(block, block, block, isBomb, extension);
    }

    private Object registerLavaCoolData(Block source, Block fromBlock, Block block, boolean isBomb) {
        return this.registerLavaCoolData(source, fromBlock, block, isBomb, -1);
    }

    public Object registerLavaCoolData(Block source, Block fromBlock, Block block, boolean isBomb, int extension) {
        boolean isUnderWater;
        boolean bl = isUnderWater = block.getType() == Material.WATER;
        if (!isUnderWater) {
            BlockFace[] flowableFaces;
            boolean isSurroundedByWater = false;
            for (BlockFace face : flowableFaces = new BlockFace[]{BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.UP}) {
                Block flowBlock = block.getRelative(face);
                if (flowBlock.getType() != Material.WATER) continue;
                isSurroundedByWater = true;
                break;
            }
            if (isSurroundedByWater) {
                isUnderWater = true;
            }
        }
        return this.registerLavaCoolData(source, fromBlock, block, isBomb, extension, isUnderWater);
    }

    private Material getVolcanicPlugOre() {
        double random = Math.random();
        double silicateLevel = Math.min(Math.max(this.settings.silicateLevel, 0.43), 0.74);
        double silicateRange = 0.31;
        double ratio = 1.0 - (silicateLevel - 0.43) / silicateRange;
        double iron = this.getProbabilityOfIron() * 3.0;
        double copper = iron * 1.4;
        double gold = this.getProbabilityOfSeperation(0.011000000000000001) * 3.0;
        double emerald = this.getProbabilityOfEmerald() * (1.0 + 3.0 * ratio);
        double diamond = 8.46E-4 * (4.0 + 6.0 * ratio);
        double ancientDebris = 5.0E-5 * (8.0 + 8.0 * ratio);
        double base = 0.0;
        if (random < base + iron) {
            return Material.IRON_ORE;
        }
        if (random < (base += iron) + copper) {
            return Material.COPPER_ORE;
        }
        if (random < (base += copper) + diamond) {
            return Material.DIAMOND_ORE;
        }
        if (random < (base += diamond) + gold) {
            return Material.GOLD_ORE;
        }
        if (random < (base += gold) + emerald) {
            return Material.EMERALD_ORE;
        }
        if (random < (base += emerald) + ancientDebris) {
            return Material.ANCIENT_DEBRIS;
        }
        base += ancientDebris;
        return null;
    }

    private Material getRegularOre() {
        double random = Math.random();
        double iron = this.getProbabilityOfIron();
        double copper = iron * 1.4;
        double gold = this.getProbabilityOfSeperation(0.011000000000000001);
        double emerald = this.getProbabilityOfEmerald();
        double diamond = 8.46E-4;
        double ancientDebris = 5.0E-5;
        double base = 0.0;
        if (random < base + iron) {
            return Material.IRON_ORE;
        }
        if (random < (base += iron) + copper) {
            return Material.COPPER_ORE;
        }
        if (random < (base += copper) + diamond) {
            return Material.DIAMOND_ORE;
        }
        if (random < (base += diamond) + gold) {
            return Material.GOLD_ORE;
        }
        if (random < (base += gold) + emerald) {
            return Material.EMERALD_ORE;
        }
        if (random < (base += emerald) + ancientDebris) {
            return Material.ANCIENT_DEBRIS;
        }
        base += ancientDebris;
        return null;
    }

    private double getIronContentOfLava() {
        double silicateLevel = Math.min(Math.max(this.settings.silicateLevel, 0.43), 0.74);
        double silicateRange = 0.31;
        double ratio = 1.0 - (silicateLevel - 0.43) / silicateRange;
        return 0.04 + ratio * 0.06;
    }

    private double getProbabilityOfEmerald() {
        double silicateLevel = Math.min(Math.max(this.settings.silicateLevel, 0.0), 1.0);
        return this.getProbabilityOfSeperation(silicateLevel * 0.16 * 0.015);
    }

    private double getProbabilityOfIron() {
        return this.getProbabilityOfSeperation(this.getIronContentOfLava());
    }

    private double getProbabilityOfSeperation(double base) {
        double baseSeperated = 0.2 + (0.2 * Math.random() - 0.1);
        return base * baseSeperated;
    }

    private Material oreifyMaterial(Material material, Material source) {
        Material targetMaterial = source;
        if (source == Material.ANCIENT_DEBRIS) {
            return Material.ANCIENT_DEBRIS;
        }
        if (source == Material.GOLD_ORE && material == Material.NETHERRACK) {
            return Material.NETHER_GOLD_ORE;
        }
        if (source == Material.GOLD_ORE && (material == Material.DEEPSLATE || material == Material.BLACKSTONE)) {
            return Material.GILDED_BLACKSTONE;
        }
        switch (material) {
            case TUFF: {
                return Material.TUFF;
            }
            case DEEPSLATE: 
            case COBBLED_DEEPSLATE: 
            case BLACKSTONE: 
            case BASALT: 
            case POLISHED_BASALT: {
                targetMaterial = Material.getMaterial((String)("DEEPSLATE_" + source.name()));
                break;
            }
            default: {
                return source;
            }
        }
        if (targetMaterial == null) {
            return source;
        }
        return targetMaterial;
    }

    private Material getOre(double distance) {
        double killZone = this.vent.getType() == VolcanoVentType.CRATER ? (double)this.vent.craterRadius : 0.0;
        double ratio = distance / this.vent.longestFlowLength;
        if (distance < killZone) {
            return this.getVolcanicPlugOre();
        }
        if (ratio < 0.1) {
            return this.getVolcanicPlugOre();
        }
        if (ratio < 0.2) {
            if (Math.random() > (ratio - 0.1) * 10.0) {
                return this.getVolcanicPlugOre();
            }
            return this.getRegularOre();
        }
        return this.getRegularOre();
    }

    private Object registerLavaCoolData(Block source, Block fromBlock, Block block, boolean isBomb, int extension, boolean isUnderWater) {
        return this.registerLavaCoolData(source, fromBlock, block, isBomb, extension, isUnderWater, false);
    }

    private void registerToCacheCools(Block block, VolcanoLavaCoolData data) {
        Map<Block, VolcanoLavaCoolData> cachedLavaCoolHashMap = this.cachedCools.get(block.getChunk());
        if (cachedLavaCoolHashMap == null) {
            cachedLavaCoolHashMap = new HashMap<Block, VolcanoLavaCoolData>();
            this.cachedCools.put(block.getChunk(), cachedLavaCoolHashMap);
        }
        cachedLavaCoolHashMap.put(block, data);
    }

    private Object registerLavaCoolData(Block source, Block fromBlock, Block block, boolean isBomb, int extension, boolean isUnderWater, boolean skipLava) {
        double distanceFromSource;
        Material oreified;
        Object result = null;
        Material targetMaterial = isBomb && !isUnderWater ? VolcanoComposition.getBombRock(this.settings.silicateLevel, this.getDistanceRatio(block.getLocation())) : VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel);
        double distance = TyphonUtils.getTwoDimensionalDistance(source.getLocation(), block.getLocation());
        Material ore = this.getOre(distance);
        if (ore != null && (oreified = this.oreifyMaterial(targetMaterial, ore)) != null) {
            targetMaterial = oreified;
        }
        if (source == block && fromBlock == block) {
            this.lavaHaventSpreadEnoughYet.put(block, System.currentTimeMillis());
        } else if (this.lavaHaventSpreadEnoughYet.get(source) != null && (distanceFromSource = TyphonUtils.getTwoDimensionalDistance(source.getLocation(), block.getLocation())) > this.getSpreadEnoughThreshold()) {
            this.lavaHaventSpreadEnoughYet.remove(source);
        }
        if (!isUnderWater) {
            VolcanoLavaCoolData coolData;
            if (!skipLava) {
                TyphonBlocks.setBlockType(block, Material.LAVA);
            }
            int ticks = 30;
            if (extension < 0) {
                coolData = new VolcanoLavaCoolData(source, fromBlock, block, this.vent, targetMaterial, ticks * this.settings.flowed, isBomb);
                result = coolData;
            } else {
                coolData = new VolcanoLavaCoolData(source, fromBlock, block, this.vent, targetMaterial, ticks * this.settings.flowed, isBomb, extension);
                result = coolData;
            }
            this.registerToCacheCools(block, coolData);
        } else {
            VolcanoPillowLavaData lavaData = this.cachedPillowLavaMap.get(block);
            if (lavaData == null) {
                this.queueBlockUpdate(block, Material.MAGMA_BLOCK);
                VolcanoPillowLavaData coolData = new VolcanoPillowLavaData(this.vent, source, fromBlock, extension);
                this.cachedPillowLavaMap.put(block, coolData);
                result = coolData;
            }
        }
        if (this.vent != null) {
            this.vent.record.addEjectaVolume(1);
        }
        return result;
    }

    public Block getRandomLavaBlock() {
        List<Block> target = this.getRandomLavaBlocks(1);
        return target.get(0);
    }

    public boolean hasAnyLavaFlowing() {
        int counts = 0;
        for (Map<Block, VolcanoLavaCoolData> lavaCoolMap : this.lavaCools.values()) {
            counts += lavaCoolMap.size();
        }
        return (counts += this.pillowLavaMap.size()) > 0;
    }

    public List<Block> getRandomLavaBlocks(int count) {
        ArrayList lavaBlocks = new ArrayList(this.lavaCools.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toList()));
        ArrayList<Block> pillowBlocks = new ArrayList<Block>(this.pillowLavaMap.keySet());
        Collections.shuffle(lavaBlocks);
        Collections.shuffle(pillowBlocks);
        ArrayList<Block> targetBlocks = new ArrayList<Block>();
        for (int i = 0; i < count; ++i) {
            Block block = null;
            if (pillowBlocks.size() > 0) {
                block = (Block)pillowBlocks.get(0);
            }
            if ((Math.random() < 0.7 || block == null) && lavaBlocks.size() > 0) {
                block = (Block)lavaBlocks.get(0);
            }
            if (block == null) continue;
            targetBlocks.add(block);
        }
        return targetBlocks;
    }

    public boolean tryExtend() {
        return this.tryExtend(50);
    }

    public boolean tryExtend(int maxTrial) {
        for (int i = 0; i < maxTrial; ++i) {
            if (!this.extendLava()) continue;
            return true;
        }
        return false;
    }

    public void createLavaParticle(Block currentBlock) {
        World world = currentBlock.getWorld();
        world.spawnParticle(Particle.LAVA, currentBlock.getLocation(), 10);
    }

    public void flowLava(Block whereToFlow) {
        this.flowLava(whereToFlow, whereToFlow);
    }

    public void flowLava(Block source, Block currentBlock) {
        this.createLavaParticle(currentBlock);
        this.registerLavaCoolData(source, currentBlock, currentBlock, false);
        if (this.vent != null && this.vent.erupt != null) {
            this.vent.erupt.updateVentConfig();
        }
    }

    public void flowVentLavaFromBomb(Block bomb) {
        this.createLavaParticle(bomb);
        this.flowLavaFromBomb(bomb, -1);
    }

    public void flowLavaFromBomb(Block bomb) {
        if (this.vent.getTwoDimensionalDistance(bomb.getLocation()) <= 10.0) {
            this.flowVentLavaFromBomb(bomb);
            return;
        }
        this.flowLavaFromBomb(bomb, 0);
    }

    public void flowLavaFromBomb(Block bomb, int flowLimit) {
        Object data;
        if (TyphonUtils.containsLiquidWater(bomb)) {
            double multiplier = 1.0 - Math.pow(Math.random(), 2.0);
            double distance = 10.0 * multiplier;
            double angle = Math.random() * Math.PI * 2.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            Block targetBlock = bomb.getRelative((int)offsetX, 0, (int)offsetZ);
            bomb = TyphonUtils.getHighestRocklikes(targetBlock).getRelative(BlockFace.UP);
        }
        if ((data = this.registerLavaCoolData(bomb, true, 0)) instanceof VolcanoLavaCoolData) {
            VolcanoLavaCoolData coolData = (VolcanoLavaCoolData)data;
            coolData.flowLimit = flowLimit > 0 ? flowLimit : -1;
        }
    }

    public boolean doPlumbingToRootlessCone() {
        this.rootlessCones.removeIf(TyphonCache::isExpired);
        int limiter = (int)Math.pow(Math.max(0.0, this.vent.longestNormalLavaFlowLength - 100.0) / 90.0, 2.0);
        if (this.rootlessCones.isEmpty() || Math.random() < 0.25 && this.rootlessCones.size() < limiter) {
            return this.tryRootlessCone();
        }
        TyphonCache<Block> randomRootlessCone = this.rootlessCones.get((int)(Math.random() * (double)this.rootlessCones.size()));
        if (randomRootlessCone == null) {
            return false;
        }
        Block targetBlock = randomRootlessCone.getTarget();
        return this.doPlumbingToRootlessCone(targetBlock);
    }

    public boolean tryRootlessCone() {
        Block topOfIt;
        Location location;
        Location targetLocation;
        Block block;
        VolcanoVent nearVent;
        if (this.settings.silicateLevel > 0.53) {
            return false;
        }
        if (this.vent.erupt.getStyle() != VolcanoEruptStyle.HAWAIIAN) {
            return false;
        }
        int threshold = Math.max(70, this.vent.getRadius() + 30);
        double max = Math.max(this.vent.getBasinLength() + 10.0, this.vent.longestNormalLavaFlowLength);
        if ((max *= 0.2 * Math.random() + 0.8) < (double)threshold) {
            return false;
        }
        double distanceRatio = 1.0 - Math.pow(Math.random(), 2.0);
        double radius = (double)threshold + distanceRatio * (max - (double)threshold);
        double angle = Math.random() * Math.PI * 2.0;
        if (this.vent.isCaldera() && Math.random() < 0.8) {
            radius = Math.min(radius, this.vent.calderaRadius);
        }
        if ((nearVent = this.getVolcano().manager.getNearestVent((block = TyphonUtils.getHighestRocklikes(targetLocation = (location = this.vent.location).clone().add(Math.cos(angle) * radius, 0.0, Math.sin(angle) * radius))).getLocation())) != null) {
            double distance;
            double volcanoZone = Math.max(70.0, Math.min(100.0, nearVent.longestNormalLavaFlowLength)) + (double)nearVent.getRadius();
            double volcanoZoneGrace = volcanoZone + 100.0;
            if (volcanoZoneGrace > nearVent.longestNormalLavaFlowLength) {
                volcanoZoneGrace = nearVent.longestNormalLavaFlowLength + (double)nearVent.getRadius();
            }
            if ((distance = nearVent.getTwoDimensionalDistance(block.getLocation())) < volcanoZone) {
                return false;
            }
            if (distance < volcanoZoneGrace) {
                double probability = (distance - volcanoZone) / (volcanoZoneGrace - volcanoZone);
                if (Math.random() < Math.pow(probability, 2.0)) {
                    return false;
                }
            }
        }
        if (this.vent.erupt.isErupting()) {
            if (VolcanoComposition.isVolcanicRock(block.getType())) {
                this.addRootlessCone(targetLocation);
                return true;
            }
        } else if (this.vent.lavaFlow.hasAnyLavaFlowing() && (topOfIt = block.getRelative(BlockFace.UP)).getType() == Material.LAVA && this.getLavaCoolData(topOfIt) != null) {
            this.addRootlessCone(targetLocation);
            return true;
        }
        return false;
    }

    public int rootlessConeHeight(int height, double offset) {
        if (offset < (double)height) {
            return (int)offset;
        }
        double distance = offset - (double)height;
        double deduct = distance / Math.sqrt(3.0);
        return (int)Math.round((double)height - deduct);
    }

    public void addRootlessCone(Location location) {
        this.addRootlessCone(location, (int)(7.0 + Math.pow(Math.random(), 2.0) * 3.0));
    }

    public void addRootlessCone(Location location, int height) {
        Block baseBlock = TyphonUtils.getHighestRocklikes(location);
        boolean allowLavaFlow = !this.isShuttingDown;
        int summitThreshold = this.vent.getSummitBlock().getY() - 10;
        double rootlessConeRange = 70.0;
        if (!allowLavaFlow) {
            return;
        }
        if (this.rootlessCones != null && !this.rootlessCones.isEmpty()) {
            for (TyphonCache<Block> cache : this.rootlessCones) {
                if (!(TyphonUtils.getTwoDimensionalDistance(location, cache.getTarget().getLocation()) < rootlessConeRange)) continue;
                return;
            }
        }
        List<Block> craterBlock = VolcanoMath.getHollowCircle(baseBlock, height);
        double heightSum = 0.0;
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        for (Block block : craterBlock) {
            Block highestBlock = TyphonUtils.getHighestRocklikes(block);
            if (highestBlock.getY() + height > summitThreshold) {
                this.getVolcano().logger.log(VolcanoLogClass.LAVA_FLOW, "Rootless cone rejected due to passing summitThreshold " + TyphonUtils.blockLocationTostring(baseBlock));
                return;
            }
            heightSum += (double)highestBlock.getY();
            max = Math.max(max, highestBlock.getY());
            min = Math.min(min, highestBlock.getY());
        }
        TyphonCache<Block> cache = new TyphonCache<Block>(baseBlock);
        cache.cacheValidity = (long)(60000.0 * (1.0 + Math.random() * 3.0));
        this.getVolcano().logger.log(VolcanoLogClass.LAVA_FLOW, "Rootless cone created at " + TyphonUtils.blockLocationTostring(baseBlock));
        this.rootlessCones.add(cache);
    }

    private int getRootlessConeRadius() {
        return Math.min(20, Math.max(10, this.vent.getRadius() / 2));
    }

    private boolean doPlumbingToRootlessCone(Block baseBlock) {
        boolean doEvenFlow;
        boolean allowLavaFlow;
        Location target = TyphonUtils.getHighestRocklikes(baseBlock).getLocation().add(0.0, 1.0, 0.0);
        VolcanoBomb bomb = this.vent.bombs.generateBomb(target);
        bomb.launchLocation = target.add(0.0, 5.0, 0.0);
        boolean bl = allowLavaFlow = !this.isShuttingDown;
        if (!allowLavaFlow) {
            return true;
        }
        int radius = this.getRootlessConeRadius();
        List<Block> craterBlock = VolcanoMath.getHollowCircle(baseBlock, radius);
        double averageY = 0.0;
        int lowestY = Integer.MAX_VALUE;
        for (Block block2 : craterBlock) {
            Block highestBlock = TyphonUtils.getHighestRocklikes(block2);
            averageY += (double)highestBlock.getY();
            lowestY = Math.min(lowestY, highestBlock.getY());
        }
        averageY /= (double)craterBlock.size();
        int blocks = (int)(Math.random() * 5.0);
        VolcanoVent nearestVent = this.getVolcano().manager.getNearestVent(baseBlock.getLocation());
        int deduction = (int)Math.max(10.0, Math.max(0.0, nearestVent.getTwoDimensionalDistance(baseBlock.getLocation()) - (double)nearestVent.getRadius()) / 6.0);
        int summitY = this.vent.getSummitBlock().getY();
        int limitY = summitY - deduction + 5;
        craterBlock.removeIf(block -> {
            int y = TyphonUtils.getHighestRocklikes(block).getY();
            return y > limitY - 2;
        });
        if (craterBlock.isEmpty()) {
            return false;
        }
        boolean bl2 = doEvenFlow = Math.random() < 0.5 && (double)lowestY < averageY - 5.0;
        if (doEvenFlow) {
            double finalAverageY = averageY;
            craterBlock.removeIf(block -> {
                int y = TyphonUtils.getHighestRocklikes(block).getY();
                return (double)y > finalAverageY - 3.0;
            });
        }
        if (craterBlock.isEmpty()) {
            craterBlock = VolcanoMath.getHollowCircle(baseBlock, radius);
        }
        int randomIndex = (int)(Math.random() * (double)craterBlock.size());
        Block targetBlock = craterBlock.get(randomIndex);
        Block targetRandomBlock = TyphonUtils.getHighestRocklikes(targetBlock).getRelative(BlockFace.UP);
        if (Math.random() < 0.8) {
            if (targetRandomBlock.getType().isAir()) {
                this.flowVentLavaFromBomb(targetRandomBlock);
                VolcanoLavaCoolData volcanoLavaCoolData = this.vent.lavaFlow.getLavaCoolData(targetRandomBlock);
            } else if ((double)targetRandomBlock.getY() < averageY - 3.0) {
                VolcanoLavaCoolData data = this.vent.lavaFlow.getLavaCoolData(targetRandomBlock);
                if (data != null) {
                    data.coolDown();
                }
                this.flowVentLavaFromBomb(targetRandomBlock.getRelative(BlockFace.UP));
            }
        } else {
            Location diff = targetBlock.getLocation().subtract(baseBlock.getLocation());
            diff.setY(0.0);
            Vector direction = diff.toVector().normalize().multiply((0.2 + Math.random() * 0.8) * (double)radius);
            Block oozeOutTarget = TyphonUtils.getHighestRocklikes(targetBlock.getRelative(direction.getBlockX(), 0, direction.getBlockZ())).getRelative(BlockFace.UP);
            if (oozeOutTarget.getType().isAir()) {
                if (Math.random() < 0.1) {
                    this.flowLava(targetRandomBlock, oozeOutTarget);
                } else {
                    this.flowVentLavaFromBomb(oozeOutTarget);
                }
            }
        }
        return true;
    }

    public VolcanoVent generateFlankVent(Location location, String prefix, Consumer<VolcanoVent> setup) {
        Object name = prefix.isEmpty() ? "parasitic_" : prefix + "_";
        int i = 1;
        while (this.getVolcano().subVents.containsKey(String.format((String)name + "%03d", i))) {
            ++i;
        }
        VolcanoVent vent = new VolcanoVent(this.getVolcano(), location, String.format((String)name + "%03d", i));
        this.getVolcano().subVents.put(vent.getName(), vent);
        vent.enableKillSwitch = true;
        vent.killAt = System.currentTimeMillis() + (long)(60000.0 * (2.0 + Math.random() * 3.0));
        vent.lavaFlow.settings.silicateLevel = this.settings.silicateLevel;
        vent.erupt.setStyle(VolcanoEruptStyle.STROMBOLIAN);
        if (setup != null) {
            setup.accept(vent);
        }
        vent.start();
        return vent;
    }

    public double getDistanceRatio(Location dest) {
        if (dest == null || this.vent == null) {
            return 1.0;
        }
        double distance = TyphonUtils.getTwoDimensionalDistance(this.vent.location, dest);
        int radius = 0;
        if (this.vent != null) {
            radius = this.vent.getRadius();
        }
        assert (this.vent != null);
        double coneHeight = Math.max(1, this.vent.getSummitBlock().getY() - this.vent.bombs.baseY);
        double distanceFromVent = Math.max(0.0, Math.min(distance - (double)radius, coneHeight));
        double scaledDistance = distanceFromVent / coneHeight;
        return Math.min(scaledDistance, 1.0);
    }

    public boolean extendLava() {
        double stickiness = (this.settings.silicateLevel - 0.45) / 0.08000000000000002;
        double safeRange = Math.max(this.thisMaxFlowLength * 0.8, this.vent.longestFlowLength * 7.0 / 10.0);
        if (this.vent.calderaRadius >= 0.0) {
            if (Math.random() < this.vent.calderaRadius / safeRange) {
                safeRange = this.vent.calderaRadius * 7.0 / 10.0;
            } else {
                return false;
            }
        }
        double minimumSafeRange = this.vent.getType() == VolcanoVentType.CRATER ? (double)this.vent.craterRadius : 0.0;
        double minimumSafeOffset = 20.0;
        if (this.vent.getType() == VolcanoVentType.CRATER && this.vent.erupt.getStyle() == VolcanoEruptStyle.STROMBOLIAN && Math.random() > this.settings.gasContent && this.hawaiianBaseY >= (double)this.vent.location.getWorld().getMinHeight()) {
            double ratio = this.vent.bombs.distanceHeightRatio();
            double distance = ratio * ((double)this.vent.getSummitBlock().getY() - this.hawaiianBaseY) - minimumSafeOffset;
            minimumSafeRange = (int)(Math.max(distance, 0.0) + (double)this.vent.getRadius());
            safeRange = minimumSafeOffset + minimumSafeRange + (double)this.vent.getRadius();
        }
        double calculatedMinimum = minimumSafeRange + minimumSafeOffset;
        double calculatedRangeMax = calculatedMinimum + safeRange;
        if (safeRange > 0.0) {
            Block coreBlock = this.vent.getCoreBlock();
            Block highestBlock = null;
            if (stickiness < 1.0) {
                Block targetBlock = TyphonUtils.getFairRandomBlockInRange(coreBlock, (int)calculatedMinimum, (int)calculatedRangeMax);
                highestBlock = TyphonUtils.getHighestRocklikes(targetBlock.getLocation()).getRelative(BlockFace.UP);
                double distance = TyphonUtils.getTwoDimensionalDistance(coreBlock.getLocation(), targetBlock.getLocation());
                int coreY = TyphonUtils.getHighestRocklikes(coreBlock).getY();
                double stepLength = (1.0 - stickiness) * 20.0;
                double targetYOffset = distance / stepLength;
                double targetY = (double)coreY - targetYOffset;
                int roundedTargetY = (int)Math.round(targetY);
                if (highestBlock.getY() <= roundedTargetY) {
                    this.extendLava(highestBlock);
                }
            } else if (Math.random() < 0.7) {
                if (this.vent.longestNormalLavaFlowLength > 50.0) {
                    Block targetBlock = TyphonUtils.getFairRandomBlockInRange(coreBlock, (int)calculatedMinimum, (int)this.vent.longestFlowLength);
                    highestBlock = TyphonUtils.getHighestRocklikes(targetBlock.getLocation()).getRelative(BlockFace.UP);
                    this.extendLava(highestBlock);
                }
            } else if (this.vent.longestFlowLength > 50.0) {
                Block targetBlock = TyphonUtils.getFairRandomBlockInRange(coreBlock, (int)calculatedMinimum, (int)this.vent.longestFlowLength);
                highestBlock = TyphonUtils.getHighestRocklikes(targetBlock.getLocation()).getRelative(BlockFace.UP);
                this.extendLava(highestBlock);
            }
            if (highestBlock != null) {
                return true;
            }
        }
        return false;
    }

    public void extendLava(Block block) {
        if (this.vent.caldera.isForming() && this.vent.caldera.isInCalderaRange(block.getLocation())) {
            return;
        }
        Block fromVent = TyphonUtils.getHighestRocklikes(this.vent.getNearestVentBlock(block.getLocation()));
        if (fromVent.getType().isAir()) {
            this.flowLava(fromVent, block);
        } else if (TyphonUtils.containsLiquidWater(fromVent)) {
            // empty if block
        }
    }

    public double getLavaStickiness() {
        return this.settings.silicateLevel - 0.7619047619047619 - 0.48;
    }

    public boolean extensionCapable(Location location) {
        return this.vent == null || this.vent.getType() != VolcanoVentType.CRATER || !this.vent.isInVent(location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runPillowLavaTick() {
        Iterator<Map.Entry<Block, VolcanoPillowLavaData>> iterator = this.pillowLavaMap.entrySet().iterator();
        ArrayList<Block> flowedBlocks = new ArrayList<Block>();
        boolean ranTick = false;
        try {
            while (iterator.hasNext()) {
                BlockFace[] flowableFaces;
                VolcanoPillowLavaData lavaData;
                Block block;
                block23: {
                    Map.Entry<Block, VolcanoPillowLavaData> data = iterator.next();
                    ranTick = true;
                    block = data.getKey();
                    lavaData = data.getValue();
                    if (this.vent.caldera.isForming() && this.vent.caldera.isInCalderaRange(block.getLocation())) {
                        this.queueBlockUpdate(block, Material.WATER);
                        flowedBlocks.add(block);
                        continue;
                    }
                    if (Math.random() < 0.2) continue;
                    lavaData.runTick();
                    if (!lavaData.canCooldown() || lavaData.hasFlowed()) continue;
                    flowedBlocks.add(block);
                    lavaData.markAsFlowed();
                    Block fromBlock = lavaData.fromBlock;
                    Block sourceBlock = lavaData.sourceBlock;
                    double distance = TyphonUtils.getTwoDimensionalDistance(sourceBlock.getLocation(), block.getLocation());
                    if (fromBlock != null) {
                        Material material = this.getOre(distance);
                        material = material == null ? VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel) : material;
                        this.queueBlockUpdate(block, material, TyphonUtils.getBlockFaceUpdater(fromBlock, block));
                        this.vent.flushSummitCacheByLocation(block);
                        BlockFace f = block.getFace(lavaData.fromBlock);
                        TyphonUtils.getBlockFaceUpdater(f).accept(block);
                    }
                    Block underBlock = block.getRelative(BlockFace.DOWN);
                    distance = TyphonUtils.getTwoDimensionalDistance(sourceBlock.getLocation(), underBlock.getLocation());
                    Material material = this.getOre(distance);
                    Material material2 = material = material == null ? VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel) : material;
                    if (underBlock.getType() == Material.MAGMA_BLOCK) {
                        VolcanoPillowLavaData underLavaData = this.pillowLavaMap.get(underBlock);
                        if (underLavaData != null) {
                            int underFluidlevel = underLavaData.fluidLevel;
                            int level = lavaData.fluidLevel;
                            int levelSum = underFluidlevel + level;
                            if (levelSum > 8) {
                                flowedBlocks.add(underBlock);
                                lavaData.fluidLevel = levelSum - 8;
                                break block23;
                            } else {
                                underLavaData.fluidLevel += level;
                                underLavaData.extensionCount += lavaData.extensionCount;
                                continue;
                            }
                        }
                        this.queueBlockUpdate(underBlock, material);
                    } else if (underBlock.isEmpty() || TyphonUtils.containsLiquidWater(underBlock)) {
                        if (!this.isPillowLavaRegistered(underBlock)) {
                            this.registerLavaCoolData(lavaData.sourceBlock, lavaData.fromBlock, underBlock, false);
                            if (!(Math.random() < 0.1)) continue;
                            TyphonUtils.createRisingSteam(lavaData.fromBlock.getLocation().add(0.0, 1.0, 0.0), 1, 2);
                            continue;
                        }
                        this.queueBlockUpdate(underBlock, material);
                        flowedBlocks.add(underBlock);
                    }
                }
                int extension = lavaData.extensionCount;
                int level = lavaData.fluidLevel;
                int levelDeductionRate = this.settings.silicateLevel < 0.63 ? (Math.random() > this.getLavaStickiness() ? 1 : 2) : 2;
                level -= levelDeductionRate;
                if (!this.extensionCapable(block.getLocation())) {
                    extension = 0;
                }
                if (level <= 0) {
                    int deductionCount = 1;
                    if (this.vent.isFlowingLava()) {
                        deductionCount += (int)(Math.random() * 2.0);
                    }
                    if ((extension -= deductionCount) < 0) continue;
                    level = 8;
                }
                BlockFace primaryFlow = null;
                if (lavaData.fromBlock != null && (primaryFlow = lavaData.fromBlock.getFace(block)) != BlockFace.DOWN) {
                    primaryFlow = null;
                }
                for (BlockFace flowableFace : flowableFaces = new BlockFace[]{BlockFace.NORTH, BlockFace.WEST, BlockFace.EAST, BlockFace.SOUTH}) {
                    int levelT;
                    Block flowTarget = block.getRelative(flowableFace);
                    boolean isPrimary = false;
                    int n = levelT = primaryFlow != null ? level - levelDeductionRate : level;
                    if (primaryFlow != null) {
                        isPrimary = primaryFlow.getDirection().equals((Object)flowableFace.getDirection());
                        int n2 = levelT = isPrimary ? level : levelT;
                    }
                    if (level <= 0) continue;
                    double ratio = Math.min(1.0, Math.max(0.0, (double)levelT / 6.0));
                    double levelProbability = Math.pow(ratio, 2.0);
                    if (isPrimary) {
                        levelProbability = Math.pow(ratio, 1.25);
                    }
                    if (Math.random() > levelProbability || !flowTarget.getType().isAir() && !TyphonUtils.containsLiquidWater(flowTarget)) continue;
                    TyphonUtils.removeSeaGrass(flowTarget);
                    if (this.isPillowLavaRegistered(flowTarget)) continue;
                    Object obj = this.vent.getType() == VolcanoVentType.CRATER && this.vent.getTwoDimensionalDistance(flowTarget.getLocation()) == (double)this.vent.getRadius() ? this.registerLavaCoolData(flowTarget, flowTarget, flowTarget, false, extension) : this.registerLavaCoolData(lavaData.sourceBlock, lavaData.fromBlock, flowTarget, false, extension);
                    if (obj instanceof VolcanoLavaCoolData) {
                        VolcanoLavaCoolData coolData = (VolcanoLavaCoolData)obj;
                        coolData.skipNormalLavaFlowLengthCheck = true;
                        continue;
                    }
                    if (!(obj instanceof VolcanoPillowLavaData)) continue;
                    VolcanoPillowLavaData pillowData = (VolcanoPillowLavaData)obj;
                    pillowData.fluidLevel = levelT;
                }
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
        for (Block flowedBlock : flowedBlocks) {
            this.pillowLavaMap.remove(flowedBlock);
        }
        Map<Block, VolcanoPillowLavaData> cache = this.cachedPillowLavaMap;
        Iterator<Map.Entry<Block, VolcanoPillowLavaData>> iteratorCache = cache.entrySet().iterator();
        while (iteratorCache.hasNext()) {
            Map.Entry<Block, VolcanoPillowLavaData> entry = iteratorCache.next();
            Block block = entry.getKey();
            VolcanoPillowLavaData data = entry.getValue();
            this.pillowLavaMap.put(block, data);
            iteratorCache.remove();
        }
        return;
    }

    private float getCurrentTPS() {
        try {
            return Bukkit.getServer().getServerTickManager().getTickRate();
        }
        catch (Exception e) {
            return 20.0f;
        }
    }

    private void plumbLava() {
        if (this.vent != null && this.vent.isKillSwitchActive()) {
            this.vent.kill();
            return;
        }
        if (this.prevFlowTime < 0L) {
            this.prevFlowTime = System.currentTimeMillis();
            return;
        }
        if (!this.settings.flowing) {
            return;
        }
        double msPerTick = 1000.0f / this.getCurrentTPS();
        long deltaTime = System.currentTimeMillis() - this.prevFlowTime;
        double passedTicks = (double)deltaTime / msPerTick;
        double plumbingAmount = this.getCurrentLavaInfluxPerTick() * passedTicks;
        this.queuedLavaInflux += plumbingAmount;
        this.prevFlowTime = System.currentTimeMillis();
    }

    private void autoFlowLava() {
        int i;
        if (this.vent.caldera.isForming()) {
            return;
        }
        List<Block> ventBlocks = this.vent.getVentBlocks();
        int flowAmount = (int)Math.min(Math.floor(this.queuedLavaInflux), (double)ventBlocks.size());
        if (flowAmount <= 0) {
            return;
        }
        int actualFlowMax = (int)Math.min((double)flowAmount, (double)ventBlocks.size() / 3.0);
        int flowRequests = Math.min(flowAmount, ventBlocks.size());
        List<Block> whereToFlows = this.vent.requestFlows(flowRequests);
        int flowedBlocks = 0;
        if (this.vent.erupt.getStyle() == VolcanoEruptStyle.LAVA_DOME) {
            int count = whereToFlows.size();
            for (i = 0; i < count; ++i) {
                this.vent.lavadome.flowLava();
                ++flowedBlocks;
            }
            if (this.vent.lavadome.isDomeLargeEnough()) {
                if (Math.random() < 1.0E-4) {
                    int queuedAmount = flowAmount - flowedBlocks + (int)this.prevQueuedLavaInflux;
                    if (queuedAmount > 100) {
                        this.vent.lavadome.explode();
                    }
                } else if (Math.random() < 0.01) {
                    this.vent.lavadome.ooze();
                }
            }
        } else if (this.vent.erupt.getStyle().lavaMultiplier > 0.0) {
            int flowableCounts = 0;
            for (Block block : whereToFlows) {
                if (!TyphonUtils.isBlockFlowable(block) || block.getType() == Material.LAVA) continue;
                ++flowableCounts;
            }
            int actaualFlowable = Math.min(actualFlowMax, flowableCounts);
            for (Block whereToFlow : whereToFlows) {
                if (flowedBlocks >= actaualFlowable) break;
                Block underBlock = whereToFlow.getRelative(BlockFace.DOWN);
                if (underBlock.getType() == Material.LAVA || underBlock.getType() == Material.MAGMA_BLOCK) continue;
                if (!TyphonUtils.isBlockFlowable(whereToFlow)) {
                    TyphonBlocks.setBlockType(whereToFlow, VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel));
                    if (this.isPillowLavaRegistered(underBlock)) {
                        VolcanoPillowLavaData pillowData = this.getPillowLavaCoolData(underBlock);
                        if (pillowData != null && !pillowData.canCooldown()) {
                            continue;
                        }
                    } else if (this.isNormalLavaRegistered(underBlock)) {
                        VolcanoLavaCoolData coolData;
                        boolean canFlow = TyphonUtils.isBlockFlowable(underBlock);
                        if (canFlow || (coolData = this.getLavaCoolData(underBlock)) == null) continue;
                        if (!coolData.tickPassed()) {
                            this.extendLava();
                            continue;
                        }
                        coolData.coolDown();
                        continue;
                    }
                    if (Math.random() > 0.01) {
                        if (!this.vent.erupt.getStyle().flowsLava()) continue;
                        this.extendLava();
                        continue;
                    }
                    whereToFlow = whereToFlow.getRelative(BlockFace.UP);
                }
                ++flowedBlocks;
                this.flowLava(whereToFlow);
                if (whereToFlow.getY() <= this.highestY) continue;
                this.highestY = whereToFlow.getY();
                if (!TyphonBlueMapUtils.getBlueMapAvailable()) continue;
                TyphonBlueMapUtils.updateVolcanoVentMarkerHeight(this.vent);
            }
            if (flowedBlocks > 0) {
                TyphonSounds.getRandomLavaThroat().play(ventBlocks.get(0).getLocation(), SoundCategory.BLOCKS, 2.0f, 1.0f);
            }
        }
        if (flowAmount - flowedBlocks > 0) {
            int leftOvers = flowAmount - flowedBlocks;
            leftOvers = Math.min(10, leftOvers);
            for (i = 0; i < leftOvers; ++i) {
                if (Math.random() < 0.1) {
                    VolcanoBomb volcanoBomb;
                    if (this.vent.surtseyan.isSurtseyan()) {
                        this.handleSurtseyan();
                    } else if (this.vent.erupt.getStyle().bombMultiplier > 0.0 && Math.random() > 1.0 / this.vent.erupt.getStyle().bombMultiplier && (volcanoBomb = this.vent.bombs.tryConeBuildingBomb()) != null) {
                        volcanoBomb.land();
                    }
                    if (Math.random() < this.rootlessConeProbability) {
                        if (!this.doPlumbingToRootlessCone()) continue;
                        continue;
                    }
                    this.extendLava();
                    continue;
                }
                this.extendLava();
            }
        }
        this.prevQueuedLavaInflux = this.queuedLavaInflux;
        this.queuedLavaInflux = 0.0;
    }

    public boolean consumeLavaInflux(double amount) {
        double realQueuedLavaInflux = Math.max(this.queuedLavaInflux, this.prevQueuedLavaInflux);
        if (realQueuedLavaInflux < amount) {
            return false;
        }
        this.prevQueuedLavaInflux = realQueuedLavaInflux -= amount;
        return true;
    }

    public void handleSurtseyan() {
        this.handleSurtseyan(Math.min(this.vent.craterRadius / 2, 10));
    }

    public void handleSurtseyan(int count) {
        if (this.vent.surtseyan.isSurtseyan()) {
            this.vent.surtseyan.eruptSurtseyan(count);
        }
    }

    private void runChunkCooldownTick(Map<Block, VolcanoLavaCoolData> lavaCoolMap) {
        ArrayList<Block> removeTargets = new ArrayList<Block>();
        for (Map.Entry<Block, VolcanoLavaCoolData> entry : lavaCoolMap.entrySet()) {
            Block block = entry.getKey();
            VolcanoLavaCoolData coolData = entry.getValue();
            if (coolData.tickPassed()) {
                coolData.coolDown();
                removeTargets.add(block);
                continue;
            }
            coolData.tickPass();
        }
        for (Block removeTarget : removeTargets) {
            lavaCoolMap.remove(removeTarget);
        }
    }

    private Map<Block, VolcanoLavaCoolData> addCacheToLavaCoolMap(Chunk chunk) {
        Map<Block, VolcanoLavaCoolData> cache;
        Map<Block, VolcanoLavaCoolData> lavaCoolMap = this.lavaCools.get(chunk);
        if (lavaCoolMap == null) {
            lavaCoolMap = new HashMap<Block, VolcanoLavaCoolData>();
            this.lavaCools.put(chunk, lavaCoolMap);
        }
        if ((cache = this.cachedCools.get(chunk)) == null) {
            return lavaCoolMap;
        }
        for (Map.Entry<Block, VolcanoLavaCoolData> entry : cache.entrySet()) {
            Block block = entry.getKey();
            VolcanoLavaCoolData coolData = entry.getValue();
            lavaCoolMap.put(block, coolData);
        }
        cache.clear();
        return lavaCoolMap;
    }

    private void runCooldownTick() {
        for (Map.Entry<Chunk, Map<Block, VolcanoLavaCoolData>> entry : this.cachedCools.entrySet()) {
            this.addCacheToLavaCoolMap(entry.getKey());
        }
        boolean isEmpty = true;
        for (Map.Entry<Chunk, Map<Block, VolcanoLavaCoolData>> entry : this.lavaCools.entrySet()) {
            if (!entry.getValue().isEmpty()) {
                isEmpty = false;
            }
            TyphonScheduler.run(entry.getKey(), () -> this.runChunkCooldownTick((Map)entry.getValue()));
        }
        if (isEmpty) {
            flowingVents.remove(this.vent);
        } else if (!flowingVents.contains(this.vent)) {
            flowingVents.add(this.vent);
        }
    }

    public void cooldownAll() {
        Block block;
        VolcanoLavaCoolData coolData;
        for (Map.Entry<Chunk, Map<Block, VolcanoLavaCoolData>> entry : this.lavaCools.entrySet()) {
            for (Map.Entry<Block, VolcanoLavaCoolData> entry2 : entry.getValue().entrySet()) {
                Block block2 = entry2.getKey();
                coolData = entry2.getValue();
                TyphonBlocks.setBlockType(block2, coolData.material);
            }
            entry.getValue().clear();
        }
        this.lavaCools.clear();
        for (Map.Entry<Chunk, Map<Block, VolcanoLavaCoolData>> entry : this.cachedCools.entrySet()) {
            for (Map.Entry<Block, VolcanoLavaCoolData> entry2 : entry.getValue().entrySet()) {
                Block block2 = entry2.getKey();
                coolData = entry2.getValue();
                TyphonBlocks.setBlockType(block2, coolData.material);
            }
            entry.getValue().clear();
        }
        this.cachedCools.clear();
        for (Map.Entry<Object, Object> entry : this.pillowLavaMap.entrySet()) {
            block = (Block)entry.getKey();
            TyphonBlocks.setBlockType(block, VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel));
        }
        this.pillowLavaMap.clear();
        for (Map.Entry<Object, Object> entry : this.cachedPillowLavaMap.entrySet()) {
            block = (Block)entry.getKey();
            TyphonBlocks.setBlockType(block, VolcanoComposition.getExtrusiveRock(this.settings.silicateLevel));
        }
        this.cachedPillowLavaMap.clear();
    }

    public void importConfig(JSONObject configData) {
        this.settings.importConfig(configData);
    }

    public JSONObject exportConfig() {
        return this.settings.exportConfig();
    }
}

