/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.succession;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.alex4386.plugin.typhon.TyphonCache;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.VolcanoComposition;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoMath;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.json.simple.JSONObject;

public class VolcanoSuccession {
    Volcano volcano;
    boolean isEnabled = true;
    double cyclesPerTick = 1.0;
    public int snowYAxis = 170;
    public int peakThreshold = 220;
    public int successionScheduleId = -1;
    private final Map<Integer, TyphonCache<Integer>> rangeCache = new HashMap<Integer, TyphonCache<Integer>>();

    public VolcanoSuccession(Volcano volcano) {
        this.volcano = volcano;
    }

    public void initialize() {
        this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Registering VolcanoSuccession for Primary Succession");
        this.registerTask();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void shutdown() {
        this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Unregistering VolcanoSuccession for Primary Succession");
        this.unregisterTask();
    }

    public void registerTask() {
        if (this.successionScheduleId < 0) {
            this.successionScheduleId = TyphonScheduler.registerGlobalTask(() -> this.runSuccessionCycle(), (long)((double)TyphonPlugin.minecraftTicksPerSeconds * this.cyclesPerTick));
        }
    }

    public void unregisterTask() {
        if (this.successionScheduleId >= 0) {
            TyphonScheduler.unregisterTask(this.successionScheduleId);
            this.successionScheduleId = -1;
        }
    }

    public void runSuccessionCycle() {
        if (this.isEnabled) {
            for (VolcanoVent vent : this.volcano.manager.getVents()) {
                if (!vent.enableSuccession) continue;
                this.runSuccessionCycle(vent);
            }
        }
    }

    public void runSuccessionCycle(VolcanoVent vent) {
        int successionCount = 0;
        if (vent.getStatus() == VolcanoVentStatus.ERUPTING || vent.getStatus() == VolcanoVentStatus.ERUPTION_IMMINENT || vent.lavaFlow.hasAnyLavaFlowing()) {
            successionCount = (int)(Math.random() * 2.0);
        } else if (Math.random() > vent.getStatus().getScaleFactor()) {
            double circumference = vent.getVolcanicRadius() * Math.PI * 2.0;
            double successionScale = Math.pow(1.0 - vent.getStatus().getScaleFactor(), 2.0);
            double maxCount = Math.min(Math.max(0.0, circumference / 20.0), 2000.0 / this.cyclesPerTick);
            double cycleCount = successionScale * maxCount;
            successionCount = (int)cycleCount;
        }
        for (int i = 0; i < successionCount; ++i) {
            this.runSuccession(vent);
        }
    }

    public boolean checkAmethystGeodeCriteria(Block block) {
        List<Block> cylinderChecker = VolcanoMath.getCylinder(block, 8, 1);
        for (Block cylinderChk : cylinderChecker) {
            int chkY = TyphonUtils.getHighestRocklikes(cylinderChk).getY();
            if (chkY > block.getY() + 8) continue;
            return false;
        }
        return true;
    }

    public void generateAmethystGeode(Block block) {
        if (!this.checkAmethystGeodeCriteria(block)) {
            return;
        }
        List<Block> blocks = VolcanoMath.getSphere(block, 7, 6);
        for (Block calBlock : blocks) {
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(calBlock, Material.CALCITE);
        }
        blocks = VolcanoMath.getSphere(block, 6, 5);
        for (Block calBlock : blocks) {
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(calBlock, Material.AMETHYST_BLOCK);
        }
    }

    public void runSuccession(VolcanoVent vent) {
        Block coreBlock = vent.getCoreBlock();
        double longestFlow = Math.max(vent.getBasinLength(), vent.getVolcanicRadius());
        if (Math.random() < 0.2) {
            longestFlow = Math.max(longestFlow, vent.bombs.maxDistance);
        } else if (Math.random() < 0.1) {
            longestFlow = Math.max(longestFlow, vent.longestFlowLength);
        }
        double skipZone = vent.getType() == VolcanoVentType.CRATER ? vent.craterRadius : 0;
        if (skipZone > 0.0 && !vent.getStatus().hasElevatedActivity() && Math.random() < 0.5) {
            skipZone = 0.0;
        }
        double random = (longestFlow - skipZone) * (1.0 - VolcanoMath.getZeroFocusedRandom()) + skipZone;
        for (int i = 0; i < 1000; ++i) {
            double z;
            double angle = Math.random() * Math.PI * 2.0;
            double x = Math.sin(angle) * random;
            Block block = coreBlock.getRelative((int)x, 0, (int)(z = Math.cos(angle) * random));
            if (!this.isValidSuccessionBlock(block)) {
                random -= 1.0;
                continue;
            }
            this.runSuccession(vent, block);
            break;
        }
    }

    public boolean shouldCheckHeat(Block block) {
        boolean shouldCheckHeat = false;
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        if (vent != null && vent.getStatus().getScaleFactor() > 0.1) {
            shouldCheckHeat = true;
        }
        return shouldCheckHeat;
    }

    public void returnToNormalBiome(Block block) {
    }

    public boolean isValidSuccessionBlock(Block block) {
        Block targetBlock = TyphonUtils.getHighestRocklikes(block);
        return targetBlock.getY() >= block.getWorld().getSeaLevel() - 1;
    }

    public void runSuccession(Block block, boolean force) {
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        this.runSuccession(vent, block, force);
    }

    public void runSuccession(VolcanoVent vent, Block block) {
        this.runSuccession(vent, block, false);
    }

    public void runSuccession(VolcanoVent vent, Block block, boolean force) {
        boolean isDebug = false;
        Block targetBlock = TyphonUtils.getHighestRocklikes(block);
        double rawHeatValue = this.volcano.manager.getHeatValue(block.getLocation());
        double heatValue = Math.sqrt(rawHeatValue);
        if (targetBlock.getY() < block.getWorld().getSeaLevel() - 1) {
            if (isDebug) {
                this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(targetBlock) + " / skipped due to sea level.");
            }
            return;
        }
        if (isDebug) {
            this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(targetBlock) + " ACTIVE! / heatValue: " + heatValue + " / rawHeatValue: " + rawHeatValue);
        }
        this.removeOre(targetBlock);
        if (!this.volcano.manager.isInAnyVent(block)) {
            if (rawHeatValue < 0.5) {
                boolean isEroded;
                boolean isGrass;
                boolean bl = isGrass = targetBlock.getType() == Material.GRASS_BLOCK || targetBlock.getType() == Material.PODZOL || targetBlock.getType() == Material.COARSE_DIRT;
                if (isGrass) {
                    boolean isHot = false;
                    if (vent.getStatus().hasElevatedActivity() && heatValue > 0.4) {
                        double scaled = 1.0 - Math.min(1.0, (heatValue - 0.4) / 0.2);
                        double result = Math.pow(scaled, 2.0);
                        isHot = Math.random() < result;
                    }
                    double growProbability = vent.successionTreeProbability;
                    if (!block.getWorld().isClearWeather()) {
                        growProbability *= 1.5;
                    }
                    if (isHot) {
                        growProbability = 0.0;
                    }
                    if (force) {
                        growProbability = 1.0;
                    }
                    if (Math.random() < growProbability) {
                        int yAxis = targetBlock.getY();
                        if (yAxis < this.snowYAxis) {
                            boolean treeGenerated = this.createTree(targetBlock);
                            if (isDebug) {
                                this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Creating Tree on block " + TyphonUtils.blockLocationTostring(targetBlock) + " / result: " + treeGenerated);
                            }
                            if (treeGenerated) {
                                return;
                            }
                        } else if (yAxis < this.peakThreshold && this.shouldCheckHeat(block) && (heatValue > 0.6 || force)) {
                            targetBlock.applyBoneMeal(BlockFace.UP);
                            this.spreadSoil(targetBlock);
                            return;
                        }
                    }
                    if (Math.random() < 0.6) {
                        this.spreadSoil(targetBlock);
                    }
                    return;
                }
                if (isDebug) {
                    this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(block) + " / is not grass.");
                }
                if (isEroded = this.isConsideredErodedRockType(targetBlock.getType())) {
                    double random = Math.random();
                    double erodeProb = vent.successionProbability;
                    if (!block.getWorld().isClearWeather()) {
                        erodeProb *= 1.5;
                    }
                    if (force) {
                        erodeProb = 1.0;
                    }
                    if (random < erodeProb) {
                        if (isDebug) {
                            this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Creating Soil on block " + TyphonUtils.blockLocationTostring(targetBlock));
                        }
                        this.runSoilGeneration(targetBlock);
                        this.spreadSoil(targetBlock);
                    }
                    return;
                }
                if (isDebug) {
                    this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(block) + " / is not eroded");
                }
                double erodeProb = vent.successionProbability;
                if (!block.getWorld().isClearWeather()) {
                    erodeProb *= 1.5;
                }
                if (force) {
                    erodeProb = 1.0;
                }
                if (Math.random() < erodeProb) {
                    this.erodeBlock(targetBlock);
                    if (isDebug) {
                        this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Eroding rock on block " + TyphonUtils.blockLocationTostring(targetBlock));
                    }
                    return;
                }
                if (isDebug) {
                    this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(block) + " / try erosion failed");
                }
            } else if (rawHeatValue < 0.7) {
                if (Math.random() < Math.pow(0.1, 3.0) * 0.5) {
                    return;
                }
                double firstHeat = Math.min(0.7, rawHeatValue);
                double amount = 1.0 - Math.min(1.0, Math.max(0.0, (firstHeat - 0.5) / 0.2));
                if (isDebug) {
                    this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Succession on block " + TyphonUtils.blockLocationTostring(block) + " / amount: " + amount);
                }
                if (Math.random() < Math.pow(amount, 2.0)) {
                    targetBlock.applyBoneMeal(BlockFace.UP);
                }
                this.spreadSoil(targetBlock, (int)(amount * 5.0), false);
                return;
            }
        }
    }

    private void removeOre(Block targetBlock) {
        VolcanoVent vent = this.volcano.manager.getNearestVent(targetBlock);
        this.removeOre(vent, targetBlock);
    }

    public void removeOre(VolcanoVent vent, Block targetBlock) {
        if (this.isTypeOfVolcanicOre(targetBlock.getType())) {
            vent.lavaFlow.queueImmediateBlockUpdate(targetBlock, VolcanoComposition.getExtrusiveRock(vent.lavaFlow.settings.silicateLevel));
        } else if (targetBlock.getType() == Material.BLACKSTONE) {
            if (Math.random() < 0.01) {
                vent.lavaFlow.queueImmediateBlockUpdate(targetBlock, Material.NETHERRACK);
            }
        } else if (targetBlock.getType() == Material.NETHERRACK && Math.random() < 1.0E-4) {
            vent.lavaFlow.queueImmediateBlockUpdate(targetBlock, Material.TUFF);
        }
    }

    public void erodeBlock(Block targetBlock) {
        if (targetBlock.getType() == Material.DEEPSLATE || targetBlock.getType() == Material.BLACKSTONE || TyphonUtils.toLowerCaseDumbEdition(targetBlock.getType().name()).contains("basalt")) {
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(targetBlock, Material.COBBLED_DEEPSLATE);
        } else if (VolcanoComposition.isVolcanicRock(targetBlock.getType())) {
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(targetBlock, Material.COBBLESTONE);
        } else {
            return;
        }
    }

    public boolean isNaturalized(Material material) {
        if (material == Material.GRASS_BLOCK) {
            return true;
        }
        String materialName = material.name().toLowerCase();
        return materialName.contains("dirt") || materialName.contains("gravel") || materialName.contains("sand");
    }

    public boolean isConsideredErodedRockType(Material material) {
        switch (material) {
            case COBBLED_DEEPSLATE: 
            case COBBLED_DEEPSLATE_SLAB: 
            case COBBLED_DEEPSLATE_STAIRS: 
            case COBBLED_DEEPSLATE_WALL: 
            case COBBLESTONE: 
            case COBBLESTONE_SLAB: 
            case COBBLESTONE_STAIRS: 
            case COBBLESTONE_WALL: 
            case NETHERRACK: 
            case BLACKSTONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTypeOfVolcanicOre(Material material) {
        return material == Material.ANCIENT_DEBRIS || TyphonUtils.toLowerCaseDumbEdition(material.name()).contains("ore");
    }

    public void spreadSoil(Block block) {
        int spreadRange = (int)(Math.pow(Math.random(), 1.5) * 10.0) + 5;
        this.spreadSoil(block, spreadRange, false);
    }

    public void spreadSoil(Block block, int spreadRange, boolean withExtension) {
        int extension = withExtension ? spreadRange / 3 : 0;
        List<Block> treeRange = VolcanoMath.getCircle(block, spreadRange + extension);
        this.returnToNormalBiome(block);
        TyphonUtils.smoothBlockHeights(block, spreadRange + extension, Material.DIRT);
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        for (Block rockRange : treeRange) {
            double distance = TyphonUtils.getTwoDimensionalDistance(rockRange.getLocation(), block.getLocation());
            double probability = 1.0;
            if (distance > (double)spreadRange) {
                probability = (distance - (double)spreadRange) / (double)extension;
            }
            if (probability != 1.0 && !(Math.random() < probability) || vent.isInVent(rockRange.getLocation()) && (vent.getStatus().hasElevatedActivity() || vent.getStatus().isActive() && Math.random() < 0.001)) continue;
            this.runSoilGeneration(rockRange);
        }
    }

    public boolean runSoilGeneration(Block block) {
        return this.runSoilGeneration(block, true);
    }

    public boolean runSoilGeneration(Block block, boolean isSurface) {
        Block surfaceBlock = TyphonUtils.getHighestRocklikes(block);
        Block rockBlock = isSurface ? surfaceBlock : block;
        VolcanoVent vent = this.volcano.manager.getNearestVent(block);
        double scaleFactor = vent.getStatus().getScaleFactor();
        double heatValue = this.volcano.manager.getHeatValue(block.getLocation());
        if (scaleFactor >= 0.8 && heatValue > 0.9) {
            if (this.isTypeOfVolcanicOre(rockBlock.getType()) && vent != null) {
                vent.lavaFlow.queueBlockUpdate(rockBlock, VolcanoComposition.getExtrusiveRock(vent.lavaFlow.settings.silicateLevel));
            }
            return false;
        }
        if (heatValue > 0.97) {
            if (this.isTypeOfVolcanicOre(rockBlock.getType()) && vent != null) {
                vent.lavaFlow.queueBlockUpdate(rockBlock, VolcanoComposition.getExtrusiveRock(vent.lavaFlow.settings.silicateLevel));
            }
            return false;
        }
        if (vent.getStatus().hasElevatedActivity() && Math.random() < scaleFactor) {
            return false;
        }
        if (surfaceBlock.getY() - block.getY() > 3) {
            return true;
        }
        if (!this.isFertilizedSoil(rockBlock.getType())) {
            if (surfaceBlock.getY() == block.getY()) {
                this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(rockBlock, Material.GRASS_BLOCK);
            } else {
                this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(rockBlock, Material.DIRT);
            }
        } else {
            Block underlyingSoil = rockBlock.getRelative(BlockFace.DOWN);
            this.runSoilGeneration(underlyingSoil, false);
            return true;
        }
        return true;
    }

    public boolean isFertilizedSoil(Material material) {
        if (material == Material.GRASS_BLOCK) {
            return true;
        }
        if (material == Material.COARSE_DIRT) {
            return false;
        }
        String materialName = TyphonUtils.toLowerCaseDumbEdition(material.name());
        if (materialName.contains("dirt")) {
            return true;
        }
        return !this.isConsideredErodedRockType(material) && !this.isTypeOfVolcanicOre(material) && !VolcanoComposition.isVolcanicRock(material);
    }

    public boolean isObstructedByTree(Block block) {
        Block treeBlock = TyphonUtils.getHighestLocation(block.getLocation()).getBlock();
        Block rockBlock = TyphonUtils.getHighestRocklikes(block);
        if (treeBlock.getType().name().contains("leaves")) {
            return true;
        }
        return rockBlock.getY() < block.getWorld().getSeaLevel();
    }

    public TreeType randomTreeType() {
        boolean isSecondary;
        double random = Math.random();
        boolean bl = isSecondary = Math.random() < 0.1;
        if (isSecondary) {
            if (random < 0.5) {
                return TreeType.CHERRY;
            }
            if (random < 0.7) {
                return TreeType.REDWOOD;
            }
            return Math.random() < 0.5 ? TreeType.TREE : TreeType.DARK_OAK;
        }
        if (random < 0.7) {
            return TreeType.BIRCH;
        }
        return TreeType.ACACIA;
    }

    public boolean createTree(Block block) {
        boolean isCreated;
        boolean isDebug = false;
        Block rockBlock = TyphonUtils.getHighestRocklikes(block);
        if (this.isObstructedByTree(rockBlock)) {
            if (isDebug) {
                this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Creating Tree failed on block " + TyphonUtils.blockLocationTostring(rockBlock) + " due to obstruction.");
            }
            return false;
        }
        this.spreadSoil(block);
        int radius = 6;
        if (this.shouldCheckHeat(block)) {
            double heatValue = this.volcano.manager.getHeatValue(block.getLocation());
            Object status = this.volcano.manager.getNearestVent(block).getStatus();
            if (((VolcanoVentStatus)((Object)status)).getScaleFactor() >= 0.8) {
                if (heatValue > 0.6) {
                    return false;
                }
            } else if (((VolcanoVentStatus)((Object)status)).hasElevatedActivity()) {
                if (heatValue > 0.8) {
                    return false;
                }
            } else if (((VolcanoVentStatus)((Object)status)).isActive() && heatValue > 0.9) {
                return Math.random() < 0.001;
            }
            radius = (int)(Math.pow(3.0, heatValue) * 6.0);
        }
        Block scanBaseBlock = rockBlock.getRelative(BlockFace.UP);
        List<Block> treeScan = VolcanoMath.getSphere(scanBaseBlock, radius);
        for (Block block2 : treeScan) {
            String materialName = block2.getType().name().toLowerCase();
            if (!materialName.contains("log") && !materialName.contains("leaves")) continue;
            if (isDebug) {
                this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Creating Tree failed on block " + TyphonUtils.blockLocationTostring(rockBlock) + " due to obstruction of nearby tree.");
            }
            return false;
        }
        List<Block> requirementToGrow = VolcanoMath.getCylinder(scanBaseBlock, 1, 3);
        for (Block toRemove : requirementToGrow) {
            if (toRemove.getType() == Material.AIR || toRemove.isPassable() && !TyphonUtils.isMaterialRocklikes(toRemove.getType()) && toRemove.getType() != Material.TALL_GRASS) continue;
            this.volcano.mainVent.lavaFlow.queueImmediateBlockUpdate(toRemove, Material.AIR);
        }
        Biome biome = scanBaseBlock.getBiome();
        TreeType type = TyphonUtils.getAdequateTreeTypeForBiome(biome);
        if (type == null) {
            type = this.randomTreeType();
        }
        if (Math.random() < 0.05) {
            type = TreeType.CHERRY;
        }
        if (!(isCreated = block.getWorld().generateTree(scanBaseBlock.getLocation(), type)) && isDebug) {
            this.volcano.logger.log(VolcanoLogClass.SUCCESSION, "Creating " + type.name() + " Tree failed on block " + TyphonUtils.blockLocationTostring(rockBlock) + " due to bukkit internal issue.");
        }
        return isCreated;
    }

    public void importConfig(JSONObject configData) {
        this.isEnabled = (Boolean)configData.get("enabled");
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        configData.put("enabled", this.isEnabled);
        return configData;
    }
}

