/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.utils;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import me.alex4386.plugin.typhon.TyphonBlocks;
import me.alex4386.plugin.typhon.TyphonUtils;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoCircleOffsetXZ;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class VolcanoMath {
    public static double volcanoPdfVariance = 0.1;

    public static double pdf(double x) {
        return VolcanoMath.pdf(1.0, x);
    }

    public static double pdf(double variance, double x) {
        return VolcanoMath.pdf(0.0, variance, x);
    }

    public static double pdf(double mean, double variance, double x) {
        double base = 1.0 / Math.sqrt(Math.PI * 2 * variance);
        double pow = -(Math.pow(x - mean, 2.0) / (2.0 * variance));
        return Math.pow(Math.E, pow) * base;
    }

    public static List<Vector3d> getSmoothedOut(Block centerBlock, int radius) {
        List<Block> smoothedOutTargetBlocks = VolcanoMath.getCircle(centerBlock, radius);
        ArrayList<Block> highestBlocks = new ArrayList<Block>();
        long ySum = 0L;
        for (Block block : smoothedOutTargetBlocks) {
            Block highest = TyphonUtils.getHighestRocklikes(block);
            highestBlocks.add(highest);
            int highestY = highest.getY();
            ySum += (long)highestY;
        }
        double diffDivisor = 2.0;
        ArrayList<Vector3d> smoothedOut = new ArrayList<Vector3d>();
        double yAverage = (double)ySum / (double)smoothedOutTargetBlocks.size();
        for (Block block : highestBlocks) {
            double diff = (double)block.getY() - yAverage;
            double modAmount = diff / diffDivisor;
            modAmount = Math.max((double)(-radius), Math.min((double)radius, modAmount));
            double newY = (double)block.getY() - modAmount;
            smoothedOut.add(new Vector3d((double)block.getX(), newY, (double)block.getZ()));
        }
        return smoothedOut;
    }

    public static void smoothOutRadius(Block centerBlock, int radius, Material fillMaterial) {
        List<Vector3d> smoothedOut = VolcanoMath.getSmoothedOut(centerBlock, radius);
        for (Vector3d vector : smoothedOut) {
            Block currentBlock;
            int y;
            Block block = centerBlock.getWorld().getBlockAt((int)vector.getX(), (int)vector.getY(), (int)vector.getZ());
            Block highestBlock = TyphonUtils.getHighestRocklikes(block);
            if (highestBlock.getY() < block.getY()) {
                for (y = highestBlock.getY(); y <= block.getY(); ++y) {
                    currentBlock = block.getWorld().getBlockAt(block.getX(), y, block.getZ());
                    TyphonBlocks.setBlockType(currentBlock, fillMaterial);
                }
                continue;
            }
            if (highestBlock.getY() <= block.getY()) continue;
            for (y = block.getY(); y > highestBlock.getY(); --y) {
                currentBlock = block.getWorld().getBlockAt(block.getX(), y, block.getZ());
                TyphonBlocks.setBlockType(currentBlock, Material.AIR);
            }
        }
    }

    public static double pdfMaxLimiter(double x, double max) {
        return VolcanoMath.pdfMaxLimiter(1.0, x, max);
    }

    public static double pdfMaxLimiter(double variance, double x, double max) {
        return VolcanoMath.pdfMaxLimiter(0.0, variance, x, max);
    }

    public static double pdfMaxLimiter(double mean, double variance, double x, double max) {
        return VolcanoMath.pdf(mean, variance, x) / VolcanoMath.pdf(mean, variance, mean) * max;
    }

    public static double volcanoPdf(double x) {
        return VolcanoMath.pdf(volcanoPdfVariance, x);
    }

    public static double volcanoPdfHeight(double x) {
        return VolcanoMath.pdfMaxLimiter(volcanoPdfVariance, x, 1.0);
    }

    public static double magmaPdfHeight(double x) {
        return VolcanoMath.pdfMaxLimiter(0.0, 1.0, x, 1.0);
    }

    public static double getZeroFocusedRandom(double variance) {
        Random random = new Random();
        return Math.pow(random.nextDouble(), 2.0 + Math.random() * variance);
    }

    public static double getZeroFocusedRandom() {
        return VolcanoMath.getZeroFocusedRandom(1.0);
    }

    public static double stratoConePdf(double steepness, double x) {
        double mean = -0.6;
        double steepVariance = steepness * 0.1;
        double variance = 0.1 + steepVariance;
        double base = 1.0 / Math.sqrt(Math.PI * 2 * variance);
        double pow = -(Math.pow(x - mean, 2.0) / (2.0 * variance));
        return Math.pow(Math.E, pow) * base;
    }

    public static double stratoConePdfHeight(double steepness, double x) {
        return VolcanoMath.stratoConePdf(steepness, x) / VolcanoMath.stratoConePdf(steepness, 0.0);
    }

    public static List<Block> getAccurateHollowCircle(Block centerBlock, double radius) {
        HashSet<Block> blocks = new HashSet<Block>();
        double circumference = radius * 2.0 * Math.PI;
        double step = Math.PI * 2 / circumference;
        int i = 0;
        while ((double)i < Math.ceil(circumference)) {
            double x = Math.sin(step * (double)i) * radius;
            double z = Math.cos(step * (double)i) * radius;
            Block block = centerBlock.getRelative((int)x, 0, (int)z);
            blocks.add(block);
            ++i;
        }
        return new ArrayList<Block>(blocks);
    }

    public static List<Block> getCircle(Block centerBlock, int radius) {
        return VolcanoMath.getCircle(centerBlock, radius, -1.0);
    }

    public static List<Block> getHollowCircle(Block centerBlock, int radius) {
        return VolcanoMath.getCircle(centerBlock, radius, (double)radius - 0.5);
    }

    public static List<Block> getCircle(Block centerBlock, double radius, double hollowRadius) {
        ArrayList<Block> circleBlocks = new ArrayList<Block>();
        double radiusSquared = Math.pow(radius, 2.0);
        double hollowRadiusSquared = hollowRadius > 0.0 ? Math.pow(hollowRadius, 2.0) : -1.0;
        int x = (int)Math.floor(-radius);
        while ((double)x <= Math.ceil(radius)) {
            int z = (int)Math.floor(-radius);
            while ((double)z <= Math.ceil(radius)) {
                double distanceSquared = Math.pow(x, 2.0) + Math.pow(z, 2.0);
                if (distanceSquared <= radiusSquared && distanceSquared > hollowRadiusSquared) {
                    circleBlocks.add(centerBlock.getRelative(x, 0, z));
                }
                ++z;
            }
            ++x;
        }
        return circleBlocks;
    }

    public static List<Block> getLine(Block centerBlock, double angle, int length) {
        ArrayList<Block> lineBlocks = new ArrayList<Block>();
        for (double i = 0.0; i <= (double)(length / 2); i += 1.0) {
            Block block;
            double z;
            double x = Math.sin(angle) * i;
            Block negativeBlock = centerBlock.getRelative((int)(-x), 0, (int)(-(z = Math.cos(angle) * i)));
            if (!lineBlocks.contains(negativeBlock)) {
                lineBlocks.add(negativeBlock);
            }
            if (lineBlocks.contains(block = centerBlock.getRelative((int)x, 0, (int)z))) continue;
            lineBlocks.add(block);
        }
        return lineBlocks;
    }

    public static List<Block> getCylinder(Block centerBlock, int radius, int height) {
        ArrayList<Block> cylinderBlocks = new ArrayList<Block>();
        for (int i = 0; i < height; ++i) {
            Block cylinderCenterBlock = centerBlock.getRelative(0, i, 0);
            cylinderBlocks.addAll(VolcanoMath.getCircle(cylinderCenterBlock, radius));
        }
        return cylinderBlocks;
    }

    public static List<Block> getCylinder(Block centerBlock, int radius, int height, int hollowRadius) {
        ArrayList<Block> cylinderBlocks = new ArrayList<Block>();
        for (int i = 0; i < height; ++i) {
            Block cylinderCenterBlock = centerBlock.getRelative(0, i, 0);
            cylinderBlocks.addAll(VolcanoMath.getCircle(cylinderCenterBlock, radius, hollowRadius));
        }
        return cylinderBlocks;
    }

    public static List<Block> getCube(Block centerBlock, int radius) {
        return VolcanoMath.getCube(centerBlock, radius, -1);
    }

    public static List<Block> getCube(Block centerBlock, int radius, int hollowRadius) {
        ArrayList<Block> sphereBlocks = new ArrayList<Block>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) <= hollowRadius || Math.abs(y) <= hollowRadius || Math.abs(z) <= hollowRadius) continue;
                    sphereBlocks.add(centerBlock.getRelative(x, y, z));
                }
            }
        }
        return sphereBlocks;
    }

    public static List<Block> getSphere(Block centerBlock, int radius) {
        return VolcanoMath.getSphere(centerBlock, radius, -1);
    }

    public static List<Block> getSphere(Block centerBlock, int radius, int hollowRadius) {
        ArrayList<Block> sphereBlocks = new ArrayList<Block>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double hollowRadiusSquared;
                    double distanceSquared = Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0);
                    double radiusSquared = 3.0 * Math.pow(radius - 1, 2.0);
                    double d = hollowRadiusSquared = hollowRadius > 0 ? 3.0 * Math.pow(hollowRadius - 1, 2.0) : -1.0;
                    if (!(distanceSquared <= radiusSquared) || !(distanceSquared > hollowRadiusSquared)) continue;
                    sphereBlocks.add(centerBlock.getRelative(x, y, z));
                }
            }
        }
        return sphereBlocks;
    }

    public static VolcanoCircleOffsetXZ getCenterFocusedCircleOffset(Block centerBlock, int radius) {
        return VolcanoMath.getCenterFocusedCircleOffset(centerBlock, radius, 0);
    }

    public static VolcanoCircleOffsetXZ getCenterFocusedCircleOffset(Block centerBlock, int radius, int hollowRadius) {
        double launchRadius = (double)hollowRadius + VolcanoMath.getZeroFocusedRandom() * (double)(radius - hollowRadius);
        double randomAngle = Math.random() * 2.0 * Math.PI;
        double x = Math.cos(randomAngle) * launchRadius;
        double z = Math.sin(randomAngle) * launchRadius;
        return new VolcanoCircleOffsetXZ(x, z);
    }

    public static double[][] generateWhiteNoise(int width, int height, Random random) {
        double[][] noise = new double[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                noise[i][j] = random.nextDouble() % 1.0;
            }
        }
        return noise;
    }

    private static double perlinNoiseFade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private static double perlinNoiseLinearInterpolate(double w, double x, double y) {
        return x + w * (y - x);
    }

    private static double perlinNoiseGradientVector(int directionHash, double x, double y, double z) {
        double u;
        int direction = directionHash & 0xF;
        double d = u = direction < 8 ? x : y;
        double v = direction < 4 ? y : (direction == 12 || direction == 14 ? x : z);
        return ((direction & 1) == 0 ? u : -u) + ((direction & 2) == 0 ? v : -v);
    }

    private static int[] generatePerlinNoisePermutation() {
        int i;
        int[] permutation = new int[512];
        int[] p = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            p[i2] = i2;
        }
        Random random = new Random();
        for (i = 255; i > 0; --i) {
            int index = random.nextInt(i + 1);
            int temp = p[index];
            p[index] = p[i];
            p[i] = temp;
        }
        for (i = 0; i < 512; ++i) {
            permutation[i] = p[i & 0xFF];
        }
        return permutation;
    }

    private static double generatePerlinNoiseAt(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = VolcanoMath.perlinNoiseFade(x);
        double v = VolcanoMath.perlinNoiseFade(y);
        double w = VolcanoMath.perlinNoiseFade(z);
        int[] permutation = VolcanoMath.generatePerlinNoisePermutation();
        int A = permutation[X] + Y;
        int AA = permutation[A] + Z;
        int AB = permutation[A + 1] + Z;
        int B = permutation[X + 1] + Y;
        int BA = permutation[B] + Z;
        int BB = permutation[B + 1] + Z;
        return VolcanoMath.perlinNoiseLinearInterpolate(w, VolcanoMath.perlinNoiseLinearInterpolate(v, VolcanoMath.perlinNoiseLinearInterpolate(u, VolcanoMath.perlinNoiseGradientVector(permutation[AA], x, y, z), VolcanoMath.perlinNoiseGradientVector(permutation[BA], x - 1.0, y, z)), VolcanoMath.perlinNoiseLinearInterpolate(u, VolcanoMath.perlinNoiseGradientVector(permutation[AB], x, y - 1.0, z), VolcanoMath.perlinNoiseGradientVector(permutation[BB], x - 1.0, y - 1.0, z))), VolcanoMath.perlinNoiseLinearInterpolate(v, VolcanoMath.perlinNoiseLinearInterpolate(u, VolcanoMath.perlinNoiseGradientVector(permutation[AA + 1], x, y, z - 1.0), VolcanoMath.perlinNoiseGradientVector(permutation[BA + 1], x - 1.0, y, z - 1.0)), VolcanoMath.perlinNoiseLinearInterpolate(u, VolcanoMath.perlinNoiseGradientVector(permutation[AB + 1], x, y - 1.0, z - 1.0), VolcanoMath.perlinNoiseGradientVector(permutation[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    public static double[][] generatePerlinNoise(int width, int height, double cellSize) {
        double[][] noiseArray = new double[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double nx = (double)x / cellSize;
                double ny = (double)y / cellSize;
                double rawNoise = VolcanoMath.generatePerlinNoiseAt(nx, ny, 0.0);
                noiseArray[x][y] = (rawNoise + 1.0) / 2.0;
                if (noiseArray[x][y] > 1.0) {
                    noiseArray[x][y] = 1.0;
                }
                if (!(noiseArray[x][y] < 0.0)) continue;
                noiseArray[x][y] = 0.0;
            }
        }
        return noiseArray;
    }

    public static Vector getOrthogonal(Vector v) {
        if (Math.abs(v.getX()) < 1.0E-6 && Math.abs(v.getY()) < 1.0E-6) {
            return new Vector(0, 1, 0);
        }
        return new Vector(-v.getY(), v.getX(), 0.0).normalize();
    }

    public static Vector rotateVectorToYAxis(Vector vectorToAlign, Vector vectorToRotate) {
        double angle;
        Vector U = vectorToAlign.clone().normalize();
        Vector YAxis = new Vector(0, 1, 0);
        Vector axis = U.clone().crossProduct(YAxis);
        double axisLengthSquared = axis.lengthSquared();
        if (axisLengthSquared < 1.0E-8) {
            double dot = U.dot(YAxis);
            if (dot > 0.0) {
                return vectorToRotate.clone();
            }
            axis = VolcanoMath.getOrthogonal(U);
            angle = Math.PI;
        } else {
            axis.normalize();
            angle = Math.acos(U.dot(YAxis));
        }
        return VolcanoMath.rotateAroundAxis(vectorToRotate, axis, angle);
    }

    public static Vector rotateAroundAxis(Vector v, Vector axis, double angle) {
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        Vector term1 = v.clone().multiply(cosTheta);
        Vector term2 = axis.clone().crossProduct(v).multiply(sinTheta);
        Vector term3 = axis.clone().multiply(axis.clone().dot(v) * (1.0 - cosTheta));
        return term1.add(term2).add(term3);
    }
}

