/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon.volcano.vent;

import java.io.IOException;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonScheduler;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.log.VolcanoLogClass;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoAutoStartProbability;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.plugin.PluginManager;
import org.json.simple.JSONObject;

public class VolcanoAutoStart
implements Listener {
    public Volcano volcano;
    public static boolean defaultCanAutoStart = false;
    public boolean canAutoStart = defaultCanAutoStart;
    public boolean pourLavaStart = true;
    public boolean createSubVent = true;
    public VolcanoAutoStartProbability probability = new VolcanoAutoStartProbability();
    public long statusCheckInterval = VolcanoAutoStart.getMinutes(60L);
    public long flankEruptionGracePeriod = VolcanoAutoStart.getMinutes(5L);
    public long eruptionTimer = 36000L;
    public int scheduleID = -1;
    public int styleChangeId = -1;
    public boolean registeredEvent = false;

    public static long getSeconds(long seconds) {
        return seconds * 20L;
    }

    public static long getMinutes(long minutes) {
        return VolcanoAutoStart.getSeconds(minutes * 60L);
    }

    public VolcanoAutoStart(Volcano volcano) {
        this.volcano = volcano;
    }

    public void registerTask() {
        if (this.scheduleID >= 0 || this.styleChangeId >= 0) {
            return;
        }
        this.scheduleID = TyphonScheduler.registerTask(null, () -> this.updateStatus(), Math.max(1L, this.statusCheckInterval / 20L * this.volcano.updateRate));
        this.styleChangeId = TyphonScheduler.registerTask(null, () -> this.updateStyles(), Math.max(1L, this.statusCheckInterval / 20L * this.volcano.updateRate));
    }

    public void unregisterTask() {
        if (this.scheduleID >= 0) {
            TyphonScheduler.unregisterTask(this.scheduleID);
            this.scheduleID = -1;
        }
        if (this.styleChangeId >= 0) {
            TyphonScheduler.unregisterTask(this.styleChangeId);
            this.styleChangeId = -1;
        }
    }

    public void registerEvent() {
        if (!this.registeredEvent) {
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)this, TyphonPlugin.plugin);
            this.registeredEvent = true;
        }
    }

    public void unregisterEvent() {
        if (this.registeredEvent) {
            BlockFromToEvent.getHandlerList();
            HandlerList.unregisterAll((Listener)this);
            this.registeredEvent = false;
        }
    }

    public void initialize() {
        this.volcano.logger.log(VolcanoLogClass.AUTOSTART, "Intializing Volcano Autostart...");
        this.registerTask();
        this.registerEvent();
    }

    public void shutdown() {
        this.volcano.logger.log(VolcanoLogClass.AUTOSTART, "Shutting down Volcano Autostart...");
        this.unregisterTask();
        this.unregisterEvent();
    }

    public void updateStyles() {
        for (VolcanoVent vent : this.volcano.manager.getVents()) {
            if (vent.builder.isRunning() || !vent.autoStyleUpdate) continue;
            if (vent.getType() == VolcanoVentType.FISSURE) {
                if (vent.record.getTotalEjecta() < 100000L || !(Math.random() < 0.7) && !(vent.lavaFlow.settings.silicateLevel > 0.5)) continue;
                vent.setType(VolcanoVentType.CRATER);
                continue;
            }
            double random = Math.random();
            if (random < 0.002) {
                vent.lavaFlow.settings.silicateLevel += 0.001;
            } else if (random < 0.003) {
                vent.lavaFlow.settings.silicateLevel -= 0.001;
            }
            if (vent.lavaFlow.settings.silicateLevel < 0.2) {
                vent.lavaFlow.settings.silicateLevel = 0.2;
            }
            VolcanoEruptStyle prevStyle = vent.erupt.getStyle();
            if (vent.lavaFlow.settings.silicateLevel > 0.75) {
                vent.erupt.setStyle(VolcanoEruptStyle.PLINIAN);
                vent.lavaFlow.settings.silicateLevel = 0.63;
            } else if (vent.lavaFlow.settings.silicateLevel > 0.57) {
                if (vent.erupt.getStyle() == VolcanoEruptStyle.PLINIAN) {
                    vent.erupt.setStyle(VolcanoEruptStyle.VULCANIAN);
                }
                if (Math.random() < 0.125) {
                    if (vent.erupt.getStyle() == VolcanoEruptStyle.VULCANIAN) {
                        vent.erupt.setStyle(VolcanoEruptStyle.PELEAN);
                    } else {
                        vent.erupt.setStyle(VolcanoEruptStyle.VULCANIAN);
                    }
                }
            } else {
                if (vent.erupt.getStyle() != VolcanoEruptStyle.HAWAIIAN && vent.erupt.getStyle() != VolcanoEruptStyle.STROMBOLIAN) {
                    vent.erupt.setStyle(Math.random() < 0.5 ? VolcanoEruptStyle.HAWAIIAN : VolcanoEruptStyle.STROMBOLIAN);
                }
                if (Math.random() < 0.25 && vent.erupt.getStyle() == VolcanoEruptStyle.HAWAIIAN) {
                    vent.erupt.setStyle(VolcanoEruptStyle.STROMBOLIAN);
                }
            }
            if (prevStyle == vent.erupt.getStyle()) continue;
            vent.erupt.autoConfig(false);
        }
    }

    public boolean canDoFlankEruption() {
        double silicateLevel = this.volcano.mainVent.lavaFlow.settings.silicateLevel;
        double basaltiness = (0.53 - silicateLevel) / 0.07;
        return basaltiness >= 0.0;
    }

    public void startVentWithGracePeriod(VolcanoVent vent) {
        this.startVentWithGracePeriod(vent, null);
    }

    public void startVentWithGracePeriod(VolcanoVent vent, Runnable callback) {
        vent.setStatus(VolcanoVentStatus.MAJOR_ACTIVITY);
        TyphonScheduler.runDelayed(vent.location.getChunk(), () -> {
            vent.start();
            if (callback != null) {
                callback.run();
            }
        }, this.flankEruptionGracePeriod / 20L * this.volcano.updateRate);
    }

    public void updateStatus() {
        if (this.volcano.autoStart.canAutoStart) {
            this.volcano.logger.debug(VolcanoLogClass.AUTOSTART, "Volcano AutoStart interval Checking...");
            for (VolcanoVent vent : this.volcano.manager.getVents()) {
                if (vent.builder.isRunning()) continue;
                boolean canEscalate = vent.genesis.canEruptAgain();
                VolcanoVentStatus status = vent.getStatus();
                double a = Math.random();
                switch (vent.getStatus()) {
                    case DORMANT: {
                        if (a <= this.probability.dormant.increase) {
                            if (!canEscalate) break;
                            vent.setStatus(vent.getStatus().increase());
                            break;
                        }
                        if (!(a <= this.probability.dormant.increase + this.probability.dormant.decrease) || canEscalate || vent.isMainVent()) break;
                        vent.setStatus(VolcanoVentStatus.EXTINCT);
                        break;
                    }
                    case MINOR_ACTIVITY: {
                        if (a <= this.probability.minor_activity.increase) {
                            if (!canEscalate) break;
                            vent.setStatus(vent.getStatus().increase());
                            break;
                        }
                        if (!(a <= this.probability.minor_activity.increase + this.probability.minor_activity.decrease)) break;
                        vent.setStatus(vent.getStatus().decrease());
                        break;
                    }
                    case MAJOR_ACTIVITY: {
                        if (a <= this.probability.major_activity.increase) {
                            boolean reachedWorldHeight;
                            if (!canEscalate) break;
                            boolean canTryFlank = (double)vent.getSummitBlock().getY() - vent.location.getY() > 60.0;
                            boolean bl = reachedWorldHeight = vent.getSummitBlock().getY() >= vent.location.getWorld().getMaxHeight() - 5;
                            if ((reachedWorldHeight || canTryFlank && Math.random() < 0.1) && vent.erupt.getStyle().flowsLava() && !vent.erupt.getStyle().canFormCaldera && this.canDoFlankEruption()) {
                                if (reachedWorldHeight) {
                                    if (!(Math.random() < 0.1)) break;
                                    vent.volcano.logger.log(VolcanoLogClass.AUTOSTART, "volcano starting caldera forming eruption since it has reached the world height");
                                    vent.caldera.autoSetup();
                                    vent.caldera.startErupt();
                                    break;
                                }
                                vent.volcano.logger.log(VolcanoLogClass.AUTOSTART, "volcano starting flank eruption due to increment from major_activity");
                                VolcanoVent flankVent = vent.erupt.openFissure();
                                if (flankVent != null) {
                                    this.startVentWithGracePeriod(flankVent, () -> TyphonScheduler.runDelayed(flankVent.location.getChunk(), () -> {
                                        flankVent.stop();
                                        flankVent.setStatus(flankVent.getStatus().decrease());
                                    }, this.volcano.autoStart.eruptionTimer));
                                }
                            }
                            vent.volcano.logger.log(VolcanoLogClass.AUTOSTART, "volcano starting due to increment from major_activity");
                            vent.setStatus(vent.getStatus().increase());
                            vent.start();
                            TyphonScheduler.runDelayed(vent.location.getChunk(), () -> {
                                vent.volcano.logger.log(VolcanoLogClass.AUTOSTART, "Volcano ended eruption session. back to MAJOR_ACTIVITY");
                                vent.stop();
                                vent.setStatus(vent.getStatus().decrease());
                            }, this.volcano.autoStart.eruptionTimer);
                            break;
                        }
                        if (!(a <= this.probability.major_activity.increase + this.probability.major_activity.decrease)) break;
                        vent.setStatus(vent.getStatus().decrease());
                        break;
                    }
                }
                if (vent.getStatus() == status) continue;
                this.volcano.logger.debug(VolcanoLogClass.AUTOSTART, "Volcano has changed status to" + vent.getStatus().toString());
            }
            try {
                this.volcano.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void importConfig(JSONObject configData) {
        this.canAutoStart = (Boolean)configData.get("canAutoStart");
        this.createSubVent = (Boolean)configData.get("createSubVent");
        this.pourLavaStart = (Boolean)configData.get("pourLavaStart");
        this.eruptionTimer = (Long)configData.get("eruptionTimer");
        this.statusCheckInterval = (Long)configData.get("statusCheckInterval");
        this.probability.importConfig((JSONObject)configData.get("probability"));
    }

    public JSONObject exportConfig() {
        JSONObject configData = new JSONObject();
        configData.put("canAutoStart", this.canAutoStart);
        configData.put("pourLavaStart", this.pourLavaStart);
        configData.put("createSubVent", this.createSubVent);
        configData.put("eruptionTimer", this.eruptionTimer);
        configData.put("statusCheckInterval", this.statusCheckInterval);
        configData.put("probability", this.probability.exportConfig());
        return configData;
    }
}

