/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.alex4386.plugin.typhon.TyphonBlueMapUtils;
import me.alex4386.plugin.typhon.TyphonCommandAction;
import me.alex4386.plugin.typhon.TyphonDebugCommand;
import me.alex4386.plugin.typhon.TyphonMessage;
import me.alex4386.plugin.typhon.TyphonPlugin;
import me.alex4386.plugin.typhon.TyphonToolEvents;
import me.alex4386.plugin.typhon.gaia.TyphonGaia;
import me.alex4386.plugin.typhon.gaia.TyphonGaiaCommand;
import me.alex4386.plugin.typhon.volcano.Volcano;
import me.alex4386.plugin.typhon.volcano.commands.VolcanoCommand;
import me.alex4386.plugin.typhon.volcano.erupt.VolcanoEruptStyle;
import me.alex4386.plugin.typhon.volcano.utils.VolcanoConstructionStatus;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVent;
import me.alex4386.plugin.typhon.volcano.vent.VolcanoVentType;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.json.simple.parser.ParseException;

public class TyphonCommand {
    public static void createVolcano(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("volcano.create")) {
            TyphonMessage.error(sender, "You don't have enough permission!");
            return;
        }
        if (!(sender instanceof Player)) {
            TyphonMessage.error(sender, "Unable to generate volcano from console!");
            return;
        }
        Location location = ((Player)sender).getLocation();
        if (args.length == 1) {
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Create Volcano]");
            sender.sendMessage("Gaia is generating adequate volcano at your location.");
            Volcano volcano = TyphonGaia.spawnVolcano(location);
            if (volcano == null) {
                TyphonMessage.error(sender, "Gaia has failed to generate adequate volcano!");
                return;
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "New volcano has been generated!");
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Name : " + volcano.name);
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Vent : " + volcano.mainVent.getType().toString());
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "Style: " + volcano.mainVent.erupt.getStyle().toString());
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + "SiO2%: " + String.format("%.2f", volcano.mainVent.lavaFlow.settings.silicateLevel) + "%");
        } else if (args.length >= 2) {
            String volcanoName = args[1];
            File volcanoDir = new File(TyphonPlugin.volcanoDir, volcanoName);
            if (TyphonPlugin.listVolcanoes.get(volcanoName) == null) {
                try {
                    Volcano volcano = new Volcano(volcanoDir.toPath(), location);
                    volcano.load();
                    if (args.length >= 3) {
                        VolcanoEruptStyle style = VolcanoEruptStyle.getVolcanoEruptStyle(args[2]);
                        if (style == null) {
                            TyphonMessage.warn(sender, "Erupt Style " + args[2] + " is not valid! skipping configuration.");
                        } else {
                            volcano.mainVent.erupt.setStyle(style);
                            volcano.mainVent.erupt.autoConfig();
                            if (style == VolcanoEruptStyle.HAWAIIAN) {
                                if (sender instanceof Player) {
                                    Player player = (Player)sender;
                                    float yaw = -1.0f * player.getLocation().getYaw();
                                    yaw = (yaw % 360.0f + 360.0f) % 360.0f;
                                    volcano.mainVent.fissureAngle = Math.toRadians(yaw);
                                    TyphonMessage.info(sender, "Fissure angle was setted to your current viewing direction");
                                } else {
                                    volcano.mainVent.fissureAngle = Math.random() * Math.PI * 2.0;
                                }
                                volcano.mainVent.setType(VolcanoVentType.FISSURE);
                            }
                        }
                    } else if (args.length == 2) {
                        volcano.mainVent.erupt.setStyle(VolcanoEruptStyle.HAWAIIAN);
                        volcano.mainVent.setType(VolcanoVentType.CRATER);
                    }
                    volcano.trySave();
                    TyphonPlugin.listVolcanoes.put(volcanoName, volcano);
                    TyphonMessage.info(sender, "Volcano " + volcanoName + " was generated!");
                    TyphonBlueMapUtils.addVolcanoOnMap(volcano);
                }
                catch (IOException e) {
                    TyphonMessage.error(sender, "I/O Exception was generated during creation of Volcano " + volcanoName + "!");
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    TyphonMessage.error(sender, "JSON Parsing Exception was generated during creation of Volcano " + volcanoName + "!");
                }
            } else {
                TyphonMessage.error(sender, "Volcano " + volcanoName + " already exists!");
            }
        }
    }

    public static void nearVolcano(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("volcano.near")) {
            TyphonMessage.error(sender, "You don't have enough permission!");
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location location = player.getLocation();
            ArrayList<Volcano> volcanoesNearYou = new ArrayList<Volcano>();
            ArrayList<VolcanoVent> ventsNearYou = new ArrayList<VolcanoVent>();
            for (Volcano volcano : TyphonPlugin.listVolcanoes.values()) {
                if (!volcano.manager.isInAnyBombAffected(location) && !volcano.manager.isInAnyLavaFlow(location)) continue;
                volcanoesNearYou.add(volcano);
            }
            for (Volcano volcano : volcanoesNearYou) {
                for (VolcanoVent vent : volcano.manager.getVents()) {
                    if (!(vent.getTwoDimensionalDistance(location) <= (double)vent.craterRadius + vent.longestFlowLength + 100.0) || !vent.isBombAffected(location) && !vent.isInLavaFlow(location)) continue;
                    ventsNearYou.add(vent);
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Near-by Volcanoes]");
            if (volcanoesNearYou.size() != 0) {
                for (Volcano volcano : volcanoesNearYou) {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + " - " + String.valueOf(volcano.manager.getVolcanoChatColor()) + volcano.name);
                }
            }
            sender.sendMessage("");
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Near-by Vents]");
            if (volcanoesNearYou.size() != 0) {
                for (VolcanoVent vent : ventsNearYou) {
                    sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + " - " + String.valueOf(vent.volcano.manager.getVentChatColor(vent)) + (vent.name == null ? "main" : vent.name) + " from " + vent.volcano.name + " : " + String.format("%.2f", vent.getTwoDimensionalDistance(location)) + "m");
                    if (!vent.isBombAffected(location)) continue;
                    sender.sendMessage("   -> Bombs Affected   : " + String.format("%.2f", vent.bombs.maxDistance) + "m");
                    sender.sendMessage("   -> LavaFlow Affected: " + String.format("%.2f", vent.longestFlowLength) + "m");
                }
            }
            sender.sendMessage("");
        } else {
            TyphonMessage.error(sender, "This command can not be triggered from console.");
        }
    }

    public static String[] getDebugCommands(CommandSender sender) {
        String[] blank = new String[]{};
        if (sender.hasPermission("typhon.debug")) {
            String[] commands = new String[]{};
            return commands;
        }
        return blank;
    }

    public static void showConstructions(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("volcano.constructions")) {
            TyphonMessage.error(sender, "You don't have enough permission!");
            return;
        }
        Volcano volcano = null;
        if (args.length == 2) {
            String volcanoName = args[1];
            volcano = TyphonPlugin.listVolcanoes.get(volcanoName);
        }
        List<Object> statuses = new ArrayList();
        if (volcano != null) {
            for (VolcanoConstructionStatus volcanoConstructionStatus : TyphonPlugin.constructionStatuses) {
                if (!volcanoConstructionStatus.volcano.name.equals(volcano.name)) continue;
                statuses.add(volcanoConstructionStatus);
            }
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Constructions of Volcano " + volcano.name + "]");
        } else {
            statuses = TyphonPlugin.constructionStatuses;
            sender.sendMessage(String.valueOf(ChatColor.DARK_RED) + String.valueOf(ChatColor.BOLD) + "[Volcano Constructions]");
        }
        for (VolcanoConstructionStatus volcanoConstructionStatus : statuses) {
            if (volcano == null) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Volcano " + volcanoConstructionStatus.volcano.name);
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + volcanoConstructionStatus.jobName + String.valueOf(ChatColor.GRAY) + ": " + volcanoConstructionStatus.currentStage + "/" + volcanoConstructionStatus.totalStages + " (" + String.format("%.2f", (double)(volcanoConstructionStatus.currentStage * 100) / (double)volcanoConstructionStatus.totalStages) + "%)");
            if (volcanoConstructionStatus.hasSubStage) {
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "SubStage: " + volcanoConstructionStatus.currentSubStage + "/" + volcanoConstructionStatus.totalSubStage + " (" + String.format("%.2f", (double)(volcanoConstructionStatus.currentSubStage * 100) / (double)volcanoConstructionStatus.totalSubStage) + "%)");
            }
            if (volcano != null) continue;
            sender.sendMessage("");
        }
    }

    public static List<String> search(String key, List<String> haystack) {
        ArrayList<String> searchResult = new ArrayList<String>();
        for (String word : haystack) {
            if (!word.startsWith(key)) continue;
            searchResult.add(word);
        }
        return searchResult;
    }

    public static List<String> search(String key, Set<String> haystack) {
        ArrayList<String> searchResult = new ArrayList<String>();
        for (String word : haystack) {
            if (!word.startsWith(key)) continue;
            searchResult.add(word);
        }
        return searchResult;
    }

    public static List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String commandName = label.toLowerCase();
        if (commandName.equals("typhon")) {
            if (args.length == 1) {
                return TyphonCommand.search(args[0], TyphonCommandAction.listAll(sender));
            }
            if (args.length >= 2) {
                TyphonCommandAction action = TyphonCommandAction.getAction(args[0]);
                if (action == null) {
                    return null;
                }
                if (args.length >= 2) {
                    if (action.equals((Object)TyphonCommandAction.CONSTRUCTIONS)) {
                        if (args.length == 2) {
                            return TyphonCommand.searchVolcano(args[1]);
                        }
                    } else if (action.equals((Object)TyphonCommandAction.CREATE)) {
                        if (args.length == 2) {
                            String[] str = new String[]{"<name>"};
                            return Arrays.asList(str);
                        }
                        if (args.length == 3) {
                            ArrayList<String> str = new ArrayList<String>();
                            for (VolcanoEruptStyle style : VolcanoEruptStyle.values()) {
                                str.add(style.toString());
                            }
                            return TyphonCommand.search(args[2], str);
                        }
                    } else if (action.equals((Object)TyphonCommandAction.DEBUG) && args.length == 2 && TyphonDebugCommand.canRunDebug(sender)) {
                        return TyphonDebugCommand.onTabComplete(sender, TyphonDebugCommand.convertToDebugNewArgs(args));
                    }
                }
            }
        } else if ((commandName.equals("volcano") || commandName.equals("vol")) && args.length > 0) {
            if (args.length == 1) {
                if (TyphonCommand.hasPermission(sender, "volcano.list")) {
                    return TyphonCommand.searchVolcano(args[0]);
                }
                return null;
            }
            Volcano volcano = TyphonPlugin.listVolcanoes.get(args[0]);
            if (volcano != null) {
                VolcanoCommand cmd = new VolcanoCommand(volcano);
                return cmd.onTabComplete(sender, command, label, args);
            }
        }
        return null;
    }

    public static boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block24: {
            String commandName;
            block22: {
                block23: {
                    commandName = label.toLowerCase();
                    if (!commandName.equals("typhon")) break block22;
                    if (args.length < 1) break block23;
                    TyphonCommandAction action = TyphonCommandAction.getAction(args[0]);
                    switch (action) {
                        case CREATE: {
                            TyphonCommand.createVolcano(sender, command, label, args);
                            break;
                        }
                        case NEAR: {
                            TyphonCommand.nearVolcano(sender, command, label, args);
                            break;
                        }
                        case CONSTRUCTIONS: {
                            TyphonCommand.showConstructions(sender, command, label, args);
                            break;
                        }
                        case GAIA: {
                            return TyphonGaiaCommand.onCommand(sender, command, label, args);
                        }
                        case DEBUG: {
                            if (!TyphonDebugCommand.canRunDebug(sender)) break;
                            return TyphonDebugCommand.onCommand(sender, TyphonDebugCommand.convertToDebugNewArgs(args));
                        }
                        case SUCCESSOR: {
                            if (!sender.hasPermission("typhon.successor")) {
                                TyphonMessage.error(sender, "You don't have enough permission!");
                                return true;
                            }
                            if (!(sender instanceof Player)) {
                                TyphonMessage.error(sender, "This command can not be triggered from console.");
                                return true;
                            }
                            Player player = (Player)sender;
                            if (args.length == 1) {
                                boolean isEnabled = TyphonToolEvents.successorEnabled.containsKey(sender);
                                TyphonMessage.info(sender, "Successor tool is " + (isEnabled ? "enabled" : "disabled") + " for you.");
                                break;
                            }
                            if (args.length != 2) break;
                            String subCommand = args[1];
                            if (subCommand.equalsIgnoreCase("enable")) {
                                ItemStack stack = new ItemStack(Material.WOODEN_SHOVEL);
                                ItemMeta meta = stack.getItemMeta();
                                if (meta != null) {
                                    meta.setItemName("Successor");
                                    meta.setRarity(ItemRarity.EPIC);
                                    meta.setDisplayName("Successor");
                                    meta.setLore(Arrays.asList("Primary Successor Tool", "Use this tool to run primary succession on the ground."));
                                    stack.setItemMeta(meta);
                                }
                                player.getInventory().addItem(new ItemStack[]{stack});
                                TyphonToolEvents.registerSuccessor(player);
                                TyphonMessage.info(sender, "Successor tool has been given to you.");
                                break;
                            }
                            if (subCommand.equalsIgnoreCase("disable")) {
                                TyphonToolEvents.unregisterSuccessor(player);
                                TyphonMessage.info(sender, "Successor tool has been disabled for you.");
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block24;
                }
                sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "v." + TyphonPlugin.version);
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Developed by Alex4386");
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Originally developed by diwaly");
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Distributed under GPLv3");
                sender.sendMessage("");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/typhon create <name> <?style>" + String.valueOf(ChatColor.GRAY) + " : Create a volcano");
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/typhon near" + String.valueOf(ChatColor.GRAY) + " : get near-by volcanoes");
                break block24;
            }
            if (commandName.equals("volcano") || commandName.equals("vol")) {
                if (args.length >= 1) {
                    Volcano volcano = TyphonPlugin.listVolcanoes.get(args[0]);
                    if (volcano != null) {
                        VolcanoCommand cmd = new VolcanoCommand(volcano);
                        return cmd.onCommand(sender, command, label, args);
                    }
                    TyphonMessage.error(sender, "Volcano " + args[0] + " was not found!");
                } else if (TyphonCommand.hasPermission(sender, "volcano.list")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "[Typhon Plugin] " + String.valueOf(ChatColor.GOLD) + "Volcanoes");
                    if (TyphonPlugin.listVolcanoes.size() == 0) {
                        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "No Volcano found");
                    } else {
                        for (Map.Entry<String, Volcano> entry : TyphonPlugin.listVolcanoes.entrySet()) {
                            String name = entry.getKey();
                            Volcano volcano = entry.getValue();
                            sender.sendMessage(" - " + String.valueOf(volcano.manager.getVolcanoChatColor()) + name);
                        }
                    }
                }
            }
        }
        return true;
    }

    public static boolean hasPermission(CommandSender sender, String actionName) {
        return sender.hasPermission("typhon." + actionName);
    }

    public static List<String> searchVolcano(String key) {
        return TyphonCommand.search(key, TyphonPlugin.listVolcanoes.keySet());
    }
}

