/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import java.util.List;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TyphonCoreProtectUtils {
    private static TyphonCoreProtectUtils instance;
    private final Plugin plugin;
    private CoreProtectAPI coreProtect;
    private boolean coreProtectEnabled = false;

    private TyphonCoreProtectUtils(Plugin plugin) {
        this.plugin = plugin;
        try {
            Plugin coreProtectPlugin = plugin.getServer().getPluginManager().getPlugin("CoreProtect");
            if (coreProtectPlugin instanceof CoreProtect && coreProtectPlugin.isEnabled()) {
                CoreProtectAPI coreProtectAPI = ((CoreProtect)coreProtectPlugin).getAPI();
                if (coreProtectAPI.isEnabled() && coreProtectAPI.APIVersion() >= 9) {
                    this.coreProtect = coreProtectAPI;
                    this.coreProtectEnabled = true;
                    plugin.getLogger().info("CoreProtect support enabled");
                } else {
                    plugin.getLogger().warning("CoreProtect API version is not compatible");
                }
            }
        }
        catch (Exception e) {
            plugin.getLogger().info("CoreProtect not found - block logging disabled");
        }
    }

    public static TyphonCoreProtectUtils getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new TyphonCoreProtectUtils(plugin);
        }
        return instance;
    }

    private static String getTyphonPluginName(Player player) {
        if (player == null) {
            return "#typhon";
        }
        return player.getName();
    }

    public boolean logTyphonBlockChange(Block block, Material oldMaterial, Material newMaterial) {
        return this.logBlockChange(null, block, oldMaterial, newMaterial);
    }

    public boolean logBlockChange(Player player, Block block, Material oldMaterial, Material newMaterial) {
        if (!this.coreProtectEnabled) {
            return false;
        }
        String name = TyphonCoreProtectUtils.getTyphonPluginName(player);
        this.coreProtect.logRemoval(name, block.getLocation(), oldMaterial, block.getBlockData());
        this.coreProtect.logPlacement(name, block.getLocation(), newMaterial, block.getBlockData());
        return true;
    }

    public boolean logTyphonBlockBreak(Block block) {
        return this.logBlockBreak(null, block);
    }

    public boolean logBlockBreak(Player player, Block block) {
        if (!this.coreProtectEnabled) {
            return false;
        }
        String name = TyphonCoreProtectUtils.getTyphonPluginName(player);
        BlockState state = block.getState();
        this.coreProtect.logRemoval(name, block.getLocation(), state.getType(), state.getBlockData());
        return true;
    }

    public boolean logTyphonBlockPlace(Block block) {
        return this.logBlockPlace(null, block);
    }

    public boolean logBlockPlace(Player player, Block block) {
        if (!this.coreProtectEnabled) {
            return false;
        }
        String name = TyphonCoreProtectUtils.getTyphonPluginName(player);
        BlockState state = block.getState();
        this.coreProtect.logPlacement(name, block.getLocation(), state.getType(), state.getBlockData());
        return true;
    }

    public String[] lookupBlockHistory(Location location, int time) {
        if (!this.coreProtectEnabled) {
            return new String[0];
        }
        List lookup = this.coreProtect.blockLookup(location.getBlock(), time);
        if (lookup != null) {
            return (String[])lookup.stream().map(record -> String.join((CharSequence)", ", record)).toArray(String[]::new);
        }
        return new String[0];
    }

    public boolean isCoreProtectEnabled() {
        return this.coreProtectEnabled;
    }
}

