/*
 * Decompiled with CFR 0.152.
 */
package me.alex4386.plugin.typhon;

import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;

public enum TyphonSounds {
    DISTANT_EXPLOSION(Sound.AMBIENT_BASALT_DELTAS_ADDITIONS, -3287258938051334000L),
    EARTH_CRUMBLING(Sound.AMBIENT_BASALT_DELTAS_MOOD, -1024108287340054000L),
    LAVA_THROAT_PLUMBING(Sound.AMBIENT_NETHER_WASTES_ADDITIONS, 4658029240925194000L),
    LAVA_THROAT_PLUMBING_2(Sound.AMBIENT_NETHER_WASTES_ADDITIONS, 7444321256524952000L),
    LAVA_FLOW_FRAGMENTING(Sound.AMBIENT_BASALT_DELTAS_ADDITIONS, 3454381265388597000L),
    LAVA_FLOW_FRAGMENTING_BIG(Sound.AMBIENT_NETHER_WASTES_ADDITIONS, 2288570984797137400L),
    LAVA_DEGASSING(Sound.AMBIENT_NETHER_WASTES_ADDITIONS, 3734215925758002700L),
    STROMBOLIAN_ERUPTION(Sound.AMBIENT_BASALT_DELTAS_ADDITIONS, -6462671831025799000L),
    VULCANIAN_ERUPTION(Sound.AMBIENT_BASALT_DELTAS_MOOD, -5459938781610518000L),
    EARTH_CRACKING(Sound.AMBIENT_UNDERWATER_LOOP_ADDITIONS_RARE, -4426276012234244600L),
    ASH_PLUME(Sound.AMBIENT_NETHER_WASTES_MOOD, 2747634031852321000L);

    Sound sound;
    long seed;

    private TyphonSounds(Sound sound, long seed) {
        this.sound = sound;
        this.seed = seed;
    }

    public void play(Location location, SoundCategory category, float volume, float pitch) {
        try {
            location.getWorld().playSound(location, this.sound, category, volume, pitch, this.seed);
        }
        catch (Exception e) {
            location.getWorld().playSound(location, this.sound, category, volume, pitch);
        }
    }

    public static TyphonSounds getRandomLavaThroat() {
        if (Math.random() < 0.5) {
            return LAVA_THROAT_PLUMBING;
        }
        return LAVA_THROAT_PLUMBING_2;
    }

    public static TyphonSounds getRandomLavaFragmenting() {
        if (Math.random() < 0.7) {
            return LAVA_FLOW_FRAGMENTING;
        }
        return LAVA_FLOW_FRAGMENTING_BIG;
    }
}

